/*
 * Decompiled with CFR 0.152.
 */
package org.idpf.epubcheck.util.css;

import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.idpf.epubcheck.util.css.CssErrorHandler;
import org.idpf.epubcheck.util.css.CssExceptions;
import org.idpf.epubcheck.util.css.CssLocation;
import org.idpf.epubcheck.util.css.CssReader;

final class CssToken {
    final Type type;
    final CssLocation location;
    final String chars;
    Optional<List<CssExceptions.CssScannerException>> errors = Optional.absent();

    CssToken(Type type, CssLocation location, String chars, List<CssExceptions.CssScannerException> errors) {
        this.type = type;
        this.location = location;
        this.chars = chars;
        if (errors != null) {
            this.errors = Optional.of(errors);
        }
    }

    CssToken(Type type, CssLocation location, char chr, List<CssExceptions.CssScannerException> errors) {
        this.type = type;
        this.location = location;
        this.chars = String.valueOf(chr);
        if (errors != null) {
            this.errors = Optional.of(errors);
        }
    }

    public Type getType() {
        return this.type;
    }

    public CssLocation getLocation() {
        return this.location;
    }

    public String getChars() {
        return this.chars;
    }

    public char getChar() {
        Preconditions.checkState((this.chars.length() == 1 ? 1 : 0) != 0);
        return this.chars.charAt(0);
    }

    boolean hasErrors() {
        return this.errors.isPresent();
    }

    public Optional<Iterator<CssExceptions.CssScannerException>> getErrors() {
        if (this.hasErrors()) {
            return Optional.of(((List)this.errors.get()).iterator());
        }
        return Optional.absent();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("type", (Object)this.type.name()).add("value", (Object)this.chars).add("errors", (Object)(this.errors.isPresent() ? Joiner.on((String)", ").join((Iterable)this.errors.get()) : "none")).toString();
    }

    public boolean equals(Object obj) {
        if (obj instanceof CssToken) {
            CssToken tk = (CssToken)obj;
            if (tk.type.equals((Object)this.type) && tk.chars.equals(this.chars) && tk.location.equals(this.location)) {
                return true;
            }
        }
        return false;
    }

    static interface CssTokenConsumer {
        public void add(CssToken var1);
    }

    static class TokenBuilder {
        Type type;
        final int line;
        final int col;
        final int offset;
        final String systemID;
        private final StringBuilder chars;
        final List<CssExceptions.CssScannerException> errors;
        private final boolean debug = false;
        private final CssErrorHandler errorListener;

        TokenBuilder(String systemID, int line, int col, int offset, CssErrorHandler errorListener) {
            this.systemID = systemID;
            this.line = line;
            this.col = col;
            this.offset = offset;
            this.chars = new StringBuilder();
            this.errors = Lists.newArrayList();
            this.errorListener = errorListener;
        }

        TokenBuilder(CssReader reader, CssErrorHandler errorListener) {
            this(reader.systemID, reader.line, reader.col, reader.offset, errorListener);
        }

        TokenBuilder append(int ch) {
            this.chars.append((char)ch);
            return this;
        }

        TokenBuilder append(CharSequence str) {
            this.chars.append(str);
            return this;
        }

        int getLength() {
            return this.chars.length();
        }

        char getLast() {
            return this.chars.charAt(this.chars.length() - 1);
        }

        TokenBuilder append(int[] chrs) {
            for (int chr : chrs) {
                this.append(chr);
            }
            return this;
        }

        void error(CssExceptions.CssErrorCode errorCode, CssReader reader, Object ... arguments) throws CssExceptions.CssException {
            CssExceptions.CssScannerException cse = new CssExceptions.CssScannerException(errorCode, CssLocation.create(reader), arguments);
            this.errors.add(cse);
            this.errorListener.error(cse);
        }

        CssToken asToken() {
            String value = this.chars.toString();
            return new CssToken(this.type, new CssLocation(this.line, this.col, this.offset, this.systemID), value, this.errors);
        }

        int[] toArray() {
            int[] arr = new int[this.chars.length()];
            for (int i = 0; i < this.chars.length(); ++i) {
                arr[i] = this.chars.charAt(i);
            }
            return arr;
        }

        public String toString() {
            return this.chars.toString();
        }
    }

    static final class Matchers {
        static final Predicate<CssToken> MATCH_SEMI_OPENBRACE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && (input.getChar() == ';' || input.getChar() == '{');
            }
        };
        static final Predicate<CssToken> MATCH_SEMI_CLOSEBRACE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && (input.getChar() == ';' || input.getChar() == '}');
            }
        };
        static final Predicate<CssToken> MATCH_COMMA_OPENBRACE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && (input.getChar() == ',' || input.getChar() == '{');
            }
        };
        static final Predicate<CssToken> MATCH_COLON = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == ':';
            }
        };
        static final Predicate<CssToken> MATCH_PIPE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '|';
            }
        };
        static final Predicate<CssToken> MATCH_CLOSEBRACE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '}';
            }
        };
        static final Predicate<CssToken> MATCH_OPENBRACE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '{';
            }
        };
        static final Predicate<CssToken> MATCH_COMBINATOR_CHAR = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && (input.getChar() == '>' || input.getChar() == '+' || input.getChar() == '~');
            }
        };
        static final Predicate<CssToken> MATCH_SEMI = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == ';';
            }
        };
        static final Predicate<CssToken> MATCH_COMMA = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == ',';
            }
        };
        static final Predicate<CssToken> MATCH_CLOSEPAREN = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == ')';
            }
        };
        static final Predicate<CssToken> MATCH_OPENPAREN = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '(';
            }
        };
        static final Predicate<CssToken> MATCH_STAR_PIPE = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && (input.getChar() == '*' || input.getChar() == '|');
            }
        };
        static final Predicate<CssToken> MATCH_STAR = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '*';
            }
        };
        static final Predicate<CssToken> MATCH_OPENSQUAREBRACKET = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '[';
            }
        };
        static final Predicate<CssToken> MATCH_CLOSESQUAREBRACKET = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == ']';
            }
        };
        static final Predicate<CssToken> MATCH_STRING_IDENT = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.IDENT || input.type == Type.STRING;
            }
        };
        static final Predicate<CssToken> MATCH_ATTRIBUTE_SELECTOR_MATCHERS = new Predicate<CssToken>(){

            public final boolean apply(CssToken input) {
                return input.type == Type.CHAR && input.getChar() == '=' || input.type == Type.INCLUDES || input.type == Type.DASHMATCH || input.type == Type.PREFIXMATCH || input.type == Type.SUFFIXMATCH || input.type == Type.SUBSTRINGMATCH;
            }
        };

        Matchers() {
        }
    }

    public static enum Type {
        S,
        COMMENT,
        CDO,
        CDC,
        IDENT,
        FUNCTION,
        ATKEYWORD,
        NUMBER,
        INTEGER,
        STRING,
        URI,
        HASHNAME,
        CLASSNAME,
        URANGE,
        INCLUDES,
        DASHMATCH,
        PREFIXMATCH,
        SUFFIXMATCH,
        SUBSTRINGMATCH,
        QNTY_DIMEN,
        QNTY_PERCENTAGE,
        QNTY_LENGTH,
        QNTY_EMS,
        QNTY_EXS,
        QNTY_ANGLE,
        QNTY_TIME,
        QNTY_FREQ,
        QNTY_RESOLUTION,
        QNTY_REMS,
        ONLY,
        NOT,
        AND,
        IMPORTANT,
        CHAR;

    }
}

