/*
 * Decompiled with CFR 0.152.
 */
package com.twelvemonkeys.imageio.plugins.jpeg;

import com.twelvemonkeys.imageio.plugins.jpeg.JPEGImageReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

class JFIFSegment {
    final int majorVersion;
    final int minorVersion;
    final int units;
    final int xDensity;
    final int yDensity;
    final int xThumbnail;
    final int yThumbnail;
    final byte[] thumbnail;

    private JFIFSegment(int n, int n2, int n3, int n4, int n5, int n6, int n7, byte[] byArray) {
        this.majorVersion = n;
        this.minorVersion = n2;
        this.units = n3;
        this.xDensity = n4;
        this.yDensity = n5;
        this.xThumbnail = n6;
        this.yThumbnail = n7;
        this.thumbnail = byArray;
    }

    public String toString() {
        return String.format("JFIF v%d.%02d %dx%d %s (%s)", this.majorVersion, this.minorVersion, this.xDensity, this.yDensity, this.unitsAsString(), this.thumbnailToString());
    }

    private String unitsAsString() {
        switch (this.units) {
            case 0: {
                return "(aspect only)";
            }
            case 1: {
                return "dpi";
            }
            case 2: {
                return "dpcm";
            }
        }
        return "(unknown unit)";
    }

    private String thumbnailToString() {
        if (this.xThumbnail == 0 || this.yThumbnail == 0) {
            return "no thumbnail";
        }
        return String.format("thumbnail: %dx%d", this.xThumbnail, this.yThumbnail);
    }

    public static JFIFSegment read(InputStream inputStream) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(inputStream);
        int n = dataInputStream.readUnsignedByte();
        int n2 = dataInputStream.readUnsignedByte();
        return new JFIFSegment(dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedByte(), dataInputStream.readUnsignedShort(), dataInputStream.readUnsignedShort(), n, n2, JPEGImageReader.readFully(dataInputStream, n * n2 * 3));
    }
}

