# modulo-starter

🏄️ Get ready to surf on your brand new Web Site on the World Wide Web!

---

_Tip:_ A "README" is for describing a project. That means you should replace
this template file with a README that talks about your project!

---

## How to use

This starter project provides example usage for Modulo.

- [**Read more about Modulo here (modulohtml.org)**](https://modulohtml.org/)

**No installs needed:** All HTML files are browser-friendly. Double-click on index.html to view!


## Running commands

1. Step 1: Bring up Dev tools (Right click, inspect, console)

2. Step 2: Do you see **`[ᵐ°dᵘ⁄o]`** logo and a list of management commands? If
   there are too many warnings, consider hiding them. Look for a little arrow
between `[MAIN THREAD]` and `Object { }`. Click on that arrow (and possibly a
`<prototype>` arrow), to expand the full command menu.

3. Step 3: Click the little arrow next to a command to run it, such as `build`
   or `edit`


## Files to explore

- Use files like `app-example.html` and `static/components/App.html` for
  examples of building single-page apps with Modulo

- Edit `static/index.html` and `static/components/` for _Component_ and
  templating examples


## Advanced

This template comes with Bash shell scripts and Node.js scripts so it's
ready-to-go for server-side rendering and static-site generation.

### Node.js

The template comes with a Node.js script, which can be used by using a shell
wrapper (top, easier) or by invoking Node.js directly (bottom):


```bash
$ npm run modulo
|      ᵐ°dᵘ⁄o build, buildvanish, buildlib, edit, newlib, newapp, newmd [CHILD THREAD] [NO OP]
$ node static/scripts/node-oludom.mjs _build/ *.* **/* index.html?
|      ᵐ°dᵘ⁄o build, buildvanish, buildlib, edit, newlib, newapp, newmd [CHILD THREAD] [NO OP]
```

Commands can be run as follows:

```bash
$ npm run modulo build
$ node static/scripts/node-oludom.mjs _build/ *.* **/* index.html?argv=build
```

### Browser automation _(requires install)_

Firefox or Chromium browser automation is also pre-configured with both GUI and
headless modes available, _but usage will incur additional installations_:

```bash
npm run install-browser firefox
npm run firefox-gui buildall
npm run firefox buildall
```

Available browsers for installation: `firefox` and `chromium` (via _Playwright_), and
`happy-dom` (DOM-only)

**Default build:** The default build command will install `firefox` and run `buildall`

Note that you can also use the browsers directly:

```bash
$ node static/scripts/node-oludom.mjs --firefox=gui _build/ *.* **/* index.html?argv=build
```
