/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.exceptions;

import java.util.HashMap;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;

public enum AmazonServiceExceptionType {
    INCOMPLETE_SIGNATURE(400, "IncompleteSignature", "The request signature does not conform to AWS standards.", AwsServiceException.class),
    INTERNAL_FAILURE(500, "InternalFailure", "The request processing has failed because of an unknown error, exception or failure.", AwsServiceException.class),
    INVALID_ACTION(400, "InvalidAction", "The action or operation requested is invalid. Verify that the action is typed correctly.", AwsServiceException.class),
    INVALID_CLIENT_TOKEN_ID(400, "InvalidClientTokenId", "The X.509 certificate or AWS access key ID provided does not exist in our records.", AwsServiceException.class),
    INVALID_PARAMETER_COMBINATION(400, "InvalidParameterCombination", "Parameters that must not be used together were used together.", AwsServiceException.class),
    INVALID_PARAMETER_VALUE(400, "InvalidParameterValue", "An invalid or out-of-range value was supplied for the input parameter.", AwsServiceException.class),
    INVALID_QUERY_PARAMETER(400, "InvalidQueryParameter", "AWS query string is malformed, does not adhere to AWS standards.", AwsServiceException.class),
    INVALID_VERSION(400, "InvalidAction", "DynamoDB Local does not support v1 API.", AwsServiceException.class),
    MALFORMED_QUERY_STRING(404, "MalformedQueryString", "The query string contains a syntax error.", AwsServiceException.class),
    MISSING_ACTION(400, "MissingAction", "The request is missing an action or a required parameter.", AwsServiceException.class),
    MISSING_AUTHENTICATION_TOKEN(400, "MissingAuthenticationToken", "Request must contain either a valid (registered) AWS access key ID or X.509 certificate.", AwsServiceException.class),
    MISSING_PARAMETER(400, "MissingParameter", "A required parameter for the specified action is not supplied.", AwsServiceException.class),
    OPT_IN_REQUIRED(400, "OptInRequired", "The AWS access key ID needs a subscription for the service.", AwsServiceException.class),
    REQUEST_EXPIRED(400, "RequestExpired", "The request reached the service more than 15 minutes after the date stamp on the request or more than 15 minutes after the request expiration date (such as for pre-signed URLs), or the date stamp on the request is more than 15 minutes in the future.", AwsServiceException.class),
    SERVICE_UNAVAILABLE(500, "ServiceUnavailable", "The request has failed due to a temporary failure of the server.", AwsServiceException.class),
    THROTTLING(400, "Throttling", "Request was denied due to request throttling.", AwsServiceException.class),
    ACCESS_DENIED_EXCEPTION(400, "AccessDeniedException", "Access denied.", AwsServiceException.class),
    CONDITIONAL_CHECK_FAILED_EXCEPTION(400, "ConditionalCheckFailedException", "The conditional request failed.", ConditionalCheckFailedException.class),
    INCOMPLETE_SIGNATURE_EXCEPTION(400, "IncompleteSignatureException", "The request signature does not conform to AWS standards.", AwsServiceException.class),
    INTERNAL_SERVER_ERROR(500, "InternalServerError", "The server encountered an internal error trying to fulfill the request.", InternalServerErrorException.class),
    ITEM_COLLECTION_SIZE_LIMIT_EXCEEDED_EXCEPTION(400, "ItemCollectionSizeLimitExceededException", "Item size has exceeded the maximum allowed size", ItemCollectionSizeLimitExceededException.class),
    LIMIT_EXCEEDED_EXCEPTION(400, "LimitExceededException", "Too many operations for a given subscriber.", LimitExceededException.class),
    MISSING_AUTHENTICATION_TOKEN_EXCEPTION(400, "MissingAuthenticationTokenException", "Request must contain a valid (registered) AWS Access Key ID.", AwsServiceException.class),
    PROVISIONED_THROUGHPUT_EXCEEDED_EXCEPTION(400, "ProvisionedThroughputExceededException", "You exceeded your maximum allowed provisioned throughput.", ProvisionedThroughputExceededException.class),
    REQUEST_TOO_LARGE(413, null, "", AwsServiceException.class),
    RESOURCE_IN_USE_EXCEPTION(400, "ResourceInUseException", "The resource which you are attempting to change is in use.", ResourceInUseException.class),
    RESOURCE_NOT_FOUND_EXCEPTION(400, "ResourceNotFoundException", "The resource which is being requested does not exist.", ResourceNotFoundException.class),
    SERVICE_UNAVAILABLE_EXCEPTION(500, "ServiceUnavailableException", "The service is currently unavailable or busy.", AwsServiceException.class),
    THROTTLING_EXCEPTION(400, "ThrottlingException", "Rate of requests exceeds the allowed throughput.", AwsServiceException.class),
    UNRECOGNIZED_CLIENT_EXCEPTION(400, "UnrecognizedClientException", "The Access Key ID or security token is invalid.", AwsServiceException.class),
    VALIDATION_EXCEPTION(400, "ValidationException", "One or more required parameter values were missing.", AwsServiceException.class),
    INVALID_PARAMETER_MAX_READ_EXCEPTION(400, "ValidationException", "One or more parameter values were invalid: Requested MaxReadRequestUnits for OnDemandThroughput for table is outside of valid range", AwsServiceException.class),
    INVALID_PARAMETER_MAX_WRITE_EXCEPTION(400, "ValidationException", "One or more parameter values were invalid: Requested MaxWriteRequestUnits for OnDemandThroughput for table is outside of valid range", AwsServiceException.class),
    TRANSACTION_CANCELED_EXCEPTION(400, "TransactionCanceledException", "", TransactionCanceledException.class),
    TRANSACTION_CONFLICT_EXCEPTION(400, "TransactionConflictException", "", TransactionConflictException.class),
    IDEMPOTENT_PARAMETER_MISMATCH_EXCEPTION(400, "IdempotentParameterMismatchException", "", IdempotentParameterMismatchException.class),
    DUPLICATE_ITEM_EXCEPTION(400, "DuplicateItem", "Duplicate primary key exists in table", DuplicateItemException.class),
    EXPIRED_SHARD_ITERATOR(400, "ExpiredIteratorException", "", AwsServiceException.class),
    TRIMMED_DATA_ACCESS_EXCEPTION(400, "TrimmedDataAccessException", "The operation attempted to read past the oldest stream record in a shard.", TrimmedDataAccessException.class),
    UNKNOWN_OPERATION_EXCEPTION(400, "UnknownOperationException", "An unknown operation was requested.", AwsServiceException.class);

    private static final Map<String, AmazonServiceExceptionType> TYPE_BY_CODE;
    private final int responseStatus;
    private final String errorCode;
    private final String message;
    private final Class<? extends AwsServiceException> clientClass;

    private <T extends AwsServiceException> AmazonServiceExceptionType(int responseStatus, String errorCode, String message, Class<T> clientClass) {
        this.responseStatus = responseStatus;
        this.errorCode = errorCode;
        this.message = message;
        this.clientClass = clientClass;
    }

    public static AmazonServiceExceptionType valueOfErrorCode(String errorCode) {
        return TYPE_BY_CODE.get(errorCode);
    }

    public int getResponseStatus() {
        return this.responseStatus;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getMessage() {
        return this.message;
    }

    public Class<? extends AwsServiceException> getClientClass() {
        return this.clientClass;
    }

    public String toString() {
        return this.responseStatus + ", " + this.errorCode + ", " + this.message;
    }

    static {
        TYPE_BY_CODE = new HashMap<String, AmazonServiceExceptionType>();
        for (AmazonServiceExceptionType type : AmazonServiceExceptionType.values()) {
            TYPE_BY_CODE.put(type.getErrorCode(), type);
        }
    }
}

