/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.exceptions;

import java.util.List;
import java.util.Map;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.services.dynamodb.model.CancellationReason;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class DynamoDBLocalServiceException
extends DynamoDbException {
    private final String localMessage;
    private final List<CancellationReason> cancellationReasons;
    private final Map<String, AttributeValue> item;

    public DynamoDBLocalServiceException(String message) {
        this(message, null, null);
    }

    public DynamoDBLocalServiceException(String message, List<CancellationReason> cancellationReasons, Map<String, AttributeValue> item) {
        this(message, cancellationReasons, item, 400, "DynamoDBLocalException");
    }

    public DynamoDBLocalServiceException(String message, List<CancellationReason> cancellationReasons, Map<String, AttributeValue> item, String errorCode) {
        this(message, cancellationReasons, item, 400, errorCode);
    }

    public DynamoDBLocalServiceException(String message, List<CancellationReason> cancellationReasons, Map<String, AttributeValue> item, int statusCode, String errorCode) {
        super(DynamoDBLocalServiceException.builder().message(message).statusCode(statusCode).awsErrorDetails(AwsErrorDetails.builder().errorCode(errorCode).errorMessage(message).serviceName("DynamoDBLocal").build()));
        this.localMessage = message;
        this.cancellationReasons = cancellationReasons;
        this.item = item;
    }

    public String getMessage() {
        return this.localMessage;
    }

    public String getErrorCode() {
        return this.awsErrorDetails().errorCode();
    }

    public String getErrorMessage() {
        return this.awsErrorDetails().errorMessage();
    }

    public List<CancellationReason> getCancellationReasons() {
        return this.cancellationReasons;
    }

    public Map<String, AttributeValue> getItem() {
        return this.item;
    }
}

