/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.embedded;

import com.google.common.annotations.VisibleForTesting;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.SdkBytes;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeValue;
import software.amazon.awssdk.services.dynamodb.model.ConditionalCheckFailedException;
import software.amazon.awssdk.services.dynamodb.model.DuplicateItemException;
import software.amazon.awssdk.services.dynamodb.model.DynamoDbException;
import software.amazon.awssdk.services.dynamodb.model.IdempotentParameterMismatchException;
import software.amazon.awssdk.services.dynamodb.model.InternalServerErrorException;
import software.amazon.awssdk.services.dynamodb.model.ItemCollectionSizeLimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.LimitExceededException;
import software.amazon.awssdk.services.dynamodb.model.ProvisionedThroughputExceededException;
import software.amazon.awssdk.services.dynamodb.model.ResourceInUseException;
import software.amazon.awssdk.services.dynamodb.model.ResourceNotFoundException;
import software.amazon.awssdk.services.dynamodb.model.TransactionCanceledException;
import software.amazon.awssdk.services.dynamodb.model.TransactionConflictException;
import software.amazon.awssdk.services.dynamodb.model.TrimmedDataAccessException;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.shared.access.LocalDBClient;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteDBAccessUtils;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class DDBExceptionMappingInvocationHandler
implements InvocationHandler {
    private final LocalDBClient impl;
    private final ReentrantReadWriteLock shutdownLock = new ReentrantReadWriteLock();
    private boolean isShutdown = false;

    DDBExceptionMappingInvocationHandler(LocalDBClient impl) {
        this.impl = impl;
    }

    @VisibleForTesting
    public static software.amazon.awssdk.services.dynamodb.model.AttributeValue convertAttributeValue(AttributeValue sourceAttributeValue) {
        AttributeValue.Builder targetAttributeValue = software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder();
        switch (sourceAttributeValue.getType()) {
            case S: {
                targetAttributeValue.s(sourceAttributeValue.getSValue());
                break;
            }
            case N: {
                targetAttributeValue.n(sourceAttributeValue.getNValue().toString());
                break;
            }
            case B: {
                targetAttributeValue.b(sourceAttributeValue.getB() == null ? null : SdkBytes.fromByteBuffer((ByteBuffer)sourceAttributeValue.getB()));
                break;
            }
            case SS: {
                targetAttributeValue.ss(sourceAttributeValue.getSS());
                break;
            }
            case NS: {
                targetAttributeValue.ns(sourceAttributeValue.getNS());
                break;
            }
            case BS: {
                targetAttributeValue.bs(sourceAttributeValue.getBsAsSDKBytes());
                break;
            }
            case M: {
                Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> m = sourceAttributeValue.getM().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SQLiteDBAccessUtils.convertLocalAttributeValue((AttributeValue)e.getValue())));
                targetAttributeValue.m(m);
                break;
            }
            case L: {
                List l = sourceAttributeValue.getL().stream().map(SQLiteDBAccessUtils::convertLocalAttributeValue).collect(Collectors.toList());
                targetAttributeValue.l(l);
                break;
            }
            case NULL: {
                targetAttributeValue.nul(sourceAttributeValue.getNULL());
                break;
            }
            case BOOL: {
                targetAttributeValue.bool(sourceAttributeValue.getBOOL());
                break;
            }
            default: {
                throw new RuntimeException("Unknown type: " + sourceAttributeValue.getType());
            }
        }
        return (software.amazon.awssdk.services.dynamodb.model.AttributeValue)targetAttributeValue.build();
    }

    public static void handleDynamoDBLocalServiceException(DynamoDBLocalServiceException localServiceException) throws Throwable {
        DynamoDBLocalServiceException awsServiceException;
        AmazonServiceExceptionType exceptionType = AmazonServiceExceptionType.valueOfErrorCode(localServiceException.getErrorCode());
        Class<? extends AwsServiceException> clientException = exceptionType.getClientClass();
        if (AwsServiceException.class.equals(clientException)) {
            awsServiceException = localServiceException;
        } else if (TransactionCanceledException.class.equals(clientException)) {
            TransactionCanceledException tce = (TransactionCanceledException)TransactionCanceledException.builder().message(localServiceException.getMessage()).cancellationReasons(localServiceException.getCancellationReasons()).awsErrorDetails(localServiceException.awsErrorDetails()).build();
            awsServiceException = tce;
        } else if (ConditionalCheckFailedException.class.equals(clientException)) {
            ConditionalCheckFailedException.Builder conditionalCheckFailedException = ConditionalCheckFailedException.builder().awsErrorDetails(localServiceException.awsErrorDetails()).message(localServiceException.getMessage());
            if (localServiceException.getItem() != null && !localServiceException.getItem().isEmpty()) {
                Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> items = localServiceException.getItem().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> DDBExceptionMappingInvocationHandler.convertAttributeValue((AttributeValue)e.getValue())));
                conditionalCheckFailedException.item(items);
            }
            awsServiceException = (AwsServiceException)conditionalCheckFailedException.build();
        } else {
            awsServiceException = DDBExceptionMappingInvocationHandler.convertLocalExceptionToAwsException((AwsServiceException)localServiceException, clientException);
        }
        awsServiceException = DDBExceptionMappingInvocationHandler.copyAwsServiceExceptionFields((AwsServiceException)awsServiceException, (AwsServiceException)localServiceException);
        throw awsServiceException;
    }

    public static AwsServiceException convertLocalExceptionToAwsException(AwsServiceException src, Class<? extends AwsServiceException> clientException) {
        HashMap<Class, Object> builderMapper = new HashMap<Class, Object>();
        builderMapper.put(ConditionalCheckFailedException.class, ConditionalCheckFailedException.builder());
        builderMapper.put(TransactionCanceledException.class, TransactionCanceledException.builder());
        builderMapper.put(InternalServerErrorException.class, InternalServerErrorException.builder());
        builderMapper.put(ItemCollectionSizeLimitExceededException.class, ItemCollectionSizeLimitExceededException.builder());
        builderMapper.put(LimitExceededException.class, LimitExceededException.builder());
        builderMapper.put(ProvisionedThroughputExceededException.class, ProvisionedThroughputExceededException.builder());
        builderMapper.put(ResourceInUseException.class, ResourceInUseException.builder());
        builderMapper.put(ResourceNotFoundException.class, ResourceNotFoundException.builder());
        builderMapper.put(TransactionConflictException.class, TransactionConflictException.builder());
        builderMapper.put(IdempotentParameterMismatchException.class, IdempotentParameterMismatchException.builder());
        builderMapper.put(TrimmedDataAccessException.class, TrimmedDataAccessException.builder());
        builderMapper.put(DuplicateItemException.class, DuplicateItemException.builder());
        AwsServiceException.Builder awsServiceExceptionBuilder = (AwsServiceException.Builder)builderMapper.getOrDefault(clientException, DynamoDbException.builder());
        return awsServiceExceptionBuilder.requestId(src.requestId()).statusCode(src.statusCode()).awsErrorDetails(AwsErrorDetails.builder().errorMessage(src.awsErrorDetails().errorMessage()).errorCode(src.awsErrorDetails().errorCode()).serviceName(src.awsErrorDetails().serviceName()).build()).build();
    }

    private static AwsServiceException copyAwsServiceExceptionFields(AwsServiceException dst, AwsServiceException src) {
        if (src == null || dst == null) {
            return dst;
        }
        return dst.toBuilder().awsErrorDetails(dst.toBuilder().awsErrorDetails().toBuilder().errorMessage(src.getMessage()).errorCode(src.awsErrorDetails().errorCode()).serviceName(src.awsErrorDetails().serviceName()).build()).statusCode(src.statusCode()).requestId(src.requestId()).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args2) throws Throwable {
        if (method.getName().equals("shutdown") || method.getName().equals("shutdownNow") || method.getName().equals("close")) {
            this.shutdownLock.writeLock().lock();
            try {
                List<Runnable> runnables = null;
                if (!this.isShutdown) {
                    if (method.getName().equals("shutdownNow")) {
                        runnables = this.impl.shutdownNow();
                    } else {
                        this.impl.shutdown();
                    }
                    this.isShutdown = true;
                }
                List<Runnable> list = runnables;
                return list;
            }
            finally {
                this.shutdownLock.writeLock().unlock();
            }
        }
        this.shutdownLock.readLock().lock();
        try {
            if (!this.isShutdown) {
                Object result = null;
                boolean isAWSSdkV2 = false;
                try {
                    if (DynamoDbClient.class.equals(method.getDeclaringClass())) {
                        isAWSSdkV2 = true;
                        result = method.invoke((Object)this.impl.dynamoDbClient(), args2);
                    } else if (DynamoDbAsyncClient.class.equals(method.getDeclaringClass())) {
                        isAWSSdkV2 = true;
                        result = method.invoke((Object)this.impl.dynamoDbAsyncClient(), args2);
                    } else if (DynamoDbStreamsClient.class.equals(method.getDeclaringClass())) {
                        isAWSSdkV2 = true;
                        result = method.invoke((Object)this.impl.dynamoDbStreamsClient(), args2);
                    } else if (DynamoDbStreamsAsyncClient.class.equals(method.getDeclaringClass())) {
                        isAWSSdkV2 = true;
                        result = method.invoke((Object)this.impl.dynamoDbAsyncClient(), args2);
                    } else {
                        result = method.invoke((Object)this.impl, args2);
                    }
                    Object object = result;
                    return object;
                }
                catch (InvocationTargetException ie) {
                    Throwable e = ie.getTargetException();
                    if (e.getClass().isAssignableFrom(DynamoDBLocalServiceException.class)) {
                        DDBExceptionMappingInvocationHandler.handleDynamoDBLocalServiceException((DynamoDBLocalServiceException)((Object)e));
                    }
                    throw e;
                }
            }
            throw AwsServiceException.builder().message("Embedded server is shut down").build();
        }
        finally {
            this.shutdownLock.readLock().unlock();
        }
    }
}

