/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.embedded;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jetbrains.annotations.NotNull;
import software.amazon.awssdk.services.dynamodb.DynamoDbAsyncClient;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsAsyncClient;
import software.amazon.awssdk.services.dynamodb.streams.DynamoDbStreamsClient;
import software.amazon.dynamodb.services.local.embedded.DDBExceptionMappingInvocationHandler;
import software.amazon.dynamodb.services.local.monitoring.Telemetry;
import software.amazon.dynamodb.services.local.monitoring.TelemetryUtil;
import software.amazon.dynamodb.services.local.shared.access.AmazonDynamoDBLocal;
import software.amazon.dynamodb.services.local.shared.access.LocalDBClient;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteDBAccess;
import software.amazon.dynamodb.services.local.shared.access.sqlite.SQLiteLibraryLoader;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;

public class DynamoDBEmbedded {
    public static final String SQLITE4JAVA_PKG = "com.almworks.sqlite4java";

    public static AmazonDynamoDBLocal create() {
        File file = null;
        return DynamoDBEmbedded.create(file, false);
    }

    public static AmazonDynamoDBLocal create(Boolean disableTelemetry) {
        return DynamoDBEmbedded.create(null, disableTelemetry);
    }

    public static AmazonDynamoDBLocal create(File file, Boolean disableTelemetry) {
        return DynamoDBEmbedded.createClient(file, disableTelemetry);
    }

    public static AmazonDynamoDBLocal create(File file) {
        return DynamoDBEmbedded.createClient(file, false);
    }

    private static void sendServerStartTelemetry(TelemetryUtil.EVENT_TYPE eventType, Boolean disableTelemetry) {
        Telemetry.configureTelemetry(TelemetryUtil.SETUP_TYPE.MAVEN.name(), TelemetryUtil.SETUP_MODE.EMBEDDED_MODE.name(), TelemetryUtil.isTelemetryEnabled(disableTelemetry));
        Optional<Telemetry> telemetry = Telemetry.getTelemetry();
        if (telemetry.isPresent()) {
            telemetry.get().emitEvent(eventType);
        }
    }

    @NotNull
    private static AmazonDynamoDBLocal createClient(File file, Boolean disableTelemetry) {
        JobsRegister jobs = new JobsRegister(Executors.newFixedThreadPool(10), false);
        SQLiteDBAccess dbAccess = file == null ? new SQLiteDBAccess() : new SQLiteDBAccess(file);
        LocalDBClient impl = new LocalDBClient(dbAccess, jobs);
        final DDBExceptionMappingInvocationHandler handler = new DDBExceptionMappingInvocationHandler(impl);
        DynamoDBEmbedded.sendServerStartTelemetry(TelemetryUtil.EVENT_TYPE.SERVER_STARTUP, disableTelemetry);
        return new AmazonDynamoDBLocal(){
            final AmazonDynamoDBLocal proxy;
            final DynamoDbClient dynamoDbClientProxy;
            final DynamoDbAsyncClient dynamoDbAsyncClientProxy;
            final DynamoDbStreamsClient dynamoDbStreamsClientProxy;
            final DynamoDbStreamsAsyncClient dynamoDbStreamsAsyncClientProxy;
            {
                this.proxy = (AmazonDynamoDBLocal)Proxy.newProxyInstance(AmazonDynamoDBLocal.class.getClassLoader(), new Class[]{AmazonDynamoDBLocal.class}, (InvocationHandler)handler);
                this.dynamoDbClientProxy = (DynamoDbClient)Proxy.newProxyInstance(DynamoDbClient.class.getClassLoader(), new Class[]{DynamoDbClient.class}, (InvocationHandler)handler);
                this.dynamoDbAsyncClientProxy = (DynamoDbAsyncClient)Proxy.newProxyInstance(DynamoDbAsyncClient.class.getClassLoader(), new Class[]{DynamoDbAsyncClient.class}, (InvocationHandler)handler);
                this.dynamoDbStreamsClientProxy = (DynamoDbStreamsClient)Proxy.newProxyInstance(DynamoDbStreamsClient.class.getClassLoader(), new Class[]{DynamoDbStreamsClient.class}, (InvocationHandler)handler);
                this.dynamoDbStreamsAsyncClientProxy = (DynamoDbStreamsAsyncClient)Proxy.newProxyInstance(DynamoDbStreamsAsyncClient.class.getClassLoader(), new Class[]{DynamoDbStreamsAsyncClient.class}, (InvocationHandler)handler);
            }

            @Override
            public void triggerShardRollovers() {
                this.proxy.triggerShardRollovers();
            }

            @Override
            public void shutdown() {
                this.proxy.shutdown();
            }

            @Override
            public List<Runnable> shutdownNow() {
                return this.proxy.shutdownNow();
            }

            @Override
            public void dilateEventTimes(long ms) {
                this.proxy.dilateEventTimes(ms);
            }

            @Override
            public DynamoDbClient dynamoDbClient() {
                return this.dynamoDbClientProxy;
            }

            @Override
            public DynamoDbAsyncClient dynamoDbAsyncClient() {
                return this.dynamoDbAsyncClientProxy;
            }

            @Override
            public DynamoDbStreamsClient dynamoDbStreamsClient() {
                return this.dynamoDbStreamsClientProxy;
            }

            @Override
            public DynamoDbStreamsAsyncClient dynamoDbStreamsAsyncClient() {
                return this.dynamoDbStreamsAsyncClientProxy;
            }
        };
    }

    static {
        try {
            SQLiteLibraryLoader.initialize();
            Logger.getLogger(SQLITE4JAVA_PKG).setLevel(Level.WARNING);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

