/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.monitoring;

import java.io.File;

public class TelemetryUtil {
    public static boolean isTelemetryEnabled(boolean disableTelemetry) {
        if (disableTelemetry) {
            return false;
        }
        String ddbLocalTelemetry = System.getenv("DDB_LOCAL_TELEMETRY");
        if (ddbLocalTelemetry != null) {
            return !ddbLocalTelemetry.equals("0");
        }
        return true;
    }

    public static boolean ifDocker(File dockerEnvfile) {
        return dockerEnvfile.exists();
    }

    public static boolean ifRunningAsMaven(File mavenPomfile) {
        if (System.out.getClass().getName().contains("maven")) {
            return true;
        }
        return mavenPomfile.exists();
    }

    public static boolean ifCloudShell() {
        String awsExecutionEnv = System.getenv("AWS_EXECUTION_ENV");
        return awsExecutionEnv != null && awsExecutionEnv.equals("CloudShell");
    }

    public static String getSetupType(File dockerEnvfile, File mavenPomfile) {
        if (TelemetryUtil.ifCloudShell()) {
            return SETUP_TYPE.CLOUD_SHELL.name();
        }
        if (TelemetryUtil.ifDocker(dockerEnvfile)) {
            return SETUP_TYPE.DOCKER.name();
        }
        if (TelemetryUtil.ifRunningAsMaven(mavenPomfile)) {
            return SETUP_TYPE.MAVEN.name();
        }
        return SETUP_TYPE.STAND_ALONE_JAR.name();
    }

    public static enum SETUP_TYPE {
        STAND_ALONE_JAR,
        DOCKER,
        MAVEN,
        CLOUD_SHELL;

    }

    public static enum SETUP_MODE {
        REGIONAL_DB,
        IN_MEMORY,
        IN_MEMORY_SHARED_DB,
        SHARED_DB,
        EMBEDDED_MODE;

    }

    public static enum EVENT_TYPE {
        SERVER_STARTUP,
        SERVER_SHUTDOWN,
        SERVER_RESTART,
        SERVER_ERROR;

    }
}

