/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import ddb.partiql.shared.dbenv.PartiQLDbEnv;
import java.util.List;
import org.partiql.lang.ast.DataManipulation;
import org.partiql.lang.ast.DataManipulationOperation;
import org.partiql.lang.ast.ExprNode;
import org.partiql.lang.ast.NAry;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementRequest;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.processor.StatementProcessor;

public class ExecuteStatementFunction
extends PartiQLStatementFunction<ExecuteStatementRequest, ExecuteStatementResponse> {
    public ExecuteStatementFunction(LocalDBAccess dbAccess, PartiQLDbEnv partiQLDbEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, DocumentFactory documentFactory, TransactionsEnabledMode transactionsEnabledMode) {
        super(dbAccess, partiQLDbEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, documentFactory, transactionsEnabledMode);
    }

    @Override
    public ExecuteStatementResponse apply(ExecuteStatementRequest input) {
        ParsedPartiQLRequest<DataManipulation> parsedRequest = this.parse(input);
        DataManipulation parsedExprNode = parsedRequest.getExprNode();
        Class<?> opClass = parsedExprNode instanceof DataManipulation ? parsedExprNode.getDmlOperations().getOps().get(0).getClass() : parsedExprNode.getClass();
        return ((StatementProcessor)this.statementProcessors.get(opClass)).execute(parsedRequest);
    }

    public ParsedPartiQLRequest<DataManipulation> parse(ExecuteStatementRequest request) {
        String statement = request.statement();
        if (request.limit() != null) {
            LocalDBValidatorUtils.validateLimitValueExecuteStatement(request.limit(), this.awsExceptionFactory);
        }
        if (statement.getBytes().length > 8192) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "Member must have length less than or equal to 8192");
        }
        String returnValuesOnConditionCheckFailure = LocalDBValidatorUtils.validateReturnValuesOnConditionCheckFailure(request.returnValuesOnConditionCheckFailureAsString());
        ExprNode parsedExprNode = this.parseStatement(statement);
        if (parsedExprNode instanceof NAry) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, "EXISTS can only be used in ExecuteTransaction write requests.");
        }
        Class<?> opClass = parsedExprNode.getClass();
        if (parsedExprNode instanceof DataManipulation) {
            List<DataManipulationOperation> ops = ((DataManipulation)parsedExprNode).getDmlOperations().getOps();
            opClass = ops.get(0).getClass();
        }
        this.verifySupportedOperation(opClass);
        ParsedPartiQLRequest parsedRequest = ParsedPartiQLRequest.builder().exprNode(parsedExprNode).parameters(this.inputConverter.externalToInternalAttributeValues(request.parameters())).isConsistentRead(request.consistentRead() != null ? request.consistentRead() : false).continuationToken(request.nextToken()).returnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).limit(request.limit()).build();
        return parsedRequest;
    }
}

