/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.access.api.dp;

import com.amazonaws.services.dynamodbv2.datamodel.ProjectionExpression;
import com.amazonaws.services.dynamodbv2.dbenv.DbEnv;
import com.amazonaws.services.dynamodbv2.rr.ProjectionExpressionWrapper;
import java.util.Collections;
import java.util.Map;
import software.amazon.awssdk.services.dynamodb.model.ConsumedCapacity;
import software.amazon.awssdk.services.dynamodb.model.GetItemRequest;
import software.amazon.awssdk.services.dynamodb.model.GetItemResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnConsumedCapacity;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBOutputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.ReadDataPlaneFunction;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.helpers.ConsumedCapacityUtils;
import software.amazon.dynamodb.services.local.shared.helpers.TransactionsEnabledMode;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class GetItemFunction
extends ReadDataPlaneFunction<GetItemRequest, GetItemResponse> {
    public GetItemFunction(LocalDBAccess dbAccess, DbEnv localDBEnv, LocalDBInputConverter inputConverter, LocalDBOutputConverter localDBOutputConverter, AWSExceptionFactory awsExceptionFactory, TransactionsEnabledMode transactionsEnabledMode) {
        super(dbAccess, localDBEnv, inputConverter, localDBOutputConverter, awsExceptionFactory, transactionsEnabledMode);
    }

    @Override
    public GetItemResponse apply(GetItemRequest getItemRequest) {
        String unparsedTableName = getItemRequest.tableName();
        String tableName = this.getTableNameFromPossibleArn(unparsedTableName);
        this.validateTableName(tableName);
        if (getItemRequest.hasAttributesToGet()) {
            this.validateAttributesToGet(getItemRequest.attributesToGet());
        }
        LocalDBValidatorUtils.validateExpressions(getItemRequest, this.inputConverter);
        TableInfo tableInfo = this.validateTableExists(tableName);
        ProjectionExpressionWrapper projectionExpressionWrapper = this.inputConverter.externalToInternalProjectionExpression(getItemRequest.projectionExpression(), getItemRequest.hasExpressionAttributeNames() ? getItemRequest.expressionAttributeNames() : null);
        ProjectionExpression projectionExpression = projectionExpressionWrapper == null ? null : projectionExpressionWrapper.getProjection();
        LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, projectionExpressionWrapper, this.awsExceptionFactory);
        if (getItemRequest.key() == null || !getItemRequest.hasKey()) {
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.MISSING_KEY.getMessage());
        }
        Map primaryKey = (Map)this.inputConverter.externalToInternalAttributes(getItemRequest.key());
        this.validateGetKey(primaryKey, tableInfo);
        Map<String, AttributeValue> item = this.dbAccess.getRecord(tableName, primaryKey);
        Map<String, AttributeValue> filteredAttributes = null;
        filteredAttributes = getItemRequest.projectionExpression() != null ? LocalDBUtils.projectAttributes(item, projectionExpression) : LocalDBUtils.projectAttributes(item, getItemRequest.hasAttributesToGet() ? getItemRequest.attributesToGet() : null);
        ReturnConsumedCapacity returnConsumedCapacity = this.convertReturnConsumedCapacity(getItemRequest.returnConsumedCapacityAsString());
        ConsumedCapacity consumedCapacity = ConsumedCapacityUtils.computeConsumedCapacity(Collections.singletonList(item), false, false, tableName, null, true, getItemRequest.consistentRead() != null && getItemRequest.consistentRead() != false, this.transactionsMode, returnConsumedCapacity);
        return (GetItemResponse)GetItemResponse.builder().item(this.localDBOutputConverter.internalToExternalAttributes(filteredAttributes)).consumedCapacity(consumedCapacity).build();
    }
}

