/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.jobs;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import software.amazon.awssdk.services.dynamodb.DynamoDbClient;
import software.amazon.awssdk.services.dynamodb.model.AttributeDefinition;
import software.amazon.awssdk.services.dynamodb.model.ScanRequest;
import software.amazon.awssdk.services.dynamodb.model.ScanResponse;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBInputConverter;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.sqlite.TableSchemaInfo;
import software.amazon.dynamodb.services.local.shared.jobs.JobsRegister;
import software.amazon.dynamodb.services.local.shared.jobs.NamedJob;
import software.amazon.dynamodb.services.local.shared.logging.LogManager;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;

public class TimeToLiveDeletionJob
extends NamedJob {
    private static final int MIN_YEARS_FOR_ITEM_EXPIRY = 5;
    private static final int SCAN_LIMIT = 20;
    private static final String START_TIME_TOKEN = ":startValue";
    private static final String END_TIME_TOKEN = ":endValue";
    private static final String REPLACEMENT_TOKEN = "#IT";
    private static final String FILTER_EXPRESSION = "#IT BETWEEN :startValue AND :endValue";
    private static final Logger LOG = LogManager.getLogger(TimeToLiveDeletionJob.class);
    private final String tableName;
    private final String timeToLiveAttributeName;
    private final DynamoDbClient dynamoDbClient;
    private final LocalDBAccess dbAccess;
    private final TableSchemaInfo tableSchemaInfo;
    private final LocalDBInputConverter inputConverter;

    public TimeToLiveDeletionJob(String tableName, TableSchemaInfo tableSchemaInfo, String timeToLiveAttributeName, DynamoDbClient dynamoDbClient, LocalDBInputConverter inputConverter, LocalDBAccess dbAccess, JobsRegister jobs) {
        super(jobs);
        this.tableName = tableName;
        this.tableSchemaInfo = tableSchemaInfo;
        this.timeToLiveAttributeName = timeToLiveAttributeName;
        this.dynamoDbClient = dynamoDbClient;
        this.dbAccess = dbAccess;
        this.inputConverter = inputConverter;
    }

    public static String jobName(String tableName, String timeToLiveAttributeName) {
        return LocalDBUtils.getTimeToLiveThreadName(tableName, timeToLiveAttributeName);
    }

    private long getCurrentTimeInSeconds() {
        return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis());
    }

    private TimeToLiveExpression getTimeToLiveFiltersForScan() {
        HashMap<String, String> attributeNameMap = new HashMap<String, String>();
        attributeNameMap.put(REPLACEMENT_TOKEN, this.timeToLiveAttributeName);
        DateTime currentTimeDateTime = new DateTime(System.currentTimeMillis());
        long minTimeMillis = currentTimeDateTime.minusYears(5).getMillis();
        HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues = new HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>();
        expressionAttributeValues.put(START_TIME_TOKEN, (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().n(Long.toString(TimeUnit.MILLISECONDS.toSeconds(minTimeMillis))).build());
        expressionAttributeValues.put(END_TIME_TOKEN, (software.amazon.awssdk.services.dynamodb.model.AttributeValue)software.amazon.awssdk.services.dynamodb.model.AttributeValue.builder().n(Long.toString(this.getCurrentTimeInSeconds())).build());
        return new TimeToLiveExpression(FILTER_EXPRESSION, attributeNameMap, expressionAttributeValues);
    }

    private ScanRequest.Builder constructScanRequest() {
        ScanRequest.Builder scanRequest = ScanRequest.builder();
        scanRequest.tableName(this.tableName);
        TimeToLiveExpression timeToLiveExpression = this.getTimeToLiveFiltersForScan();
        scanRequest.filterExpression(timeToLiveExpression.getFilterExpression());
        scanRequest.expressionAttributeValues(timeToLiveExpression.getExpressionAttributeValues());
        scanRequest.expressionAttributeNames(timeToLiveExpression.getExpressionAttributeNames());
        scanRequest.limit(Integer.valueOf(20));
        return scanRequest;
    }

    private Map<String, AttributeValue> getKeyFromItem(Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> item) {
        HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> key = new HashMap<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue>();
        for (AttributeDefinition attributeDefinition : this.tableSchemaInfo.getAttributes()) {
            String attributeName = attributeDefinition.attributeName();
            key.put(attributeName, item.get(attributeName));
        }
        return (Map)this.inputConverter.externalToInternalAttributes(key);
    }

    @Override
    protected void doJob() {
        final ScanResultWrapper scanResultWrapper = new ScanResultWrapper();
        final AtomicBoolean shouldRepeat = new AtomicBoolean(true);
        do {
            final ScanRequest.Builder scanRequest = this.constructScanRequest();
            scanRequest.exclusiveStartKey(scanResultWrapper.exclusiveScanStartKey);
            new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(this.tableName), 10){

                @Override
                public void criticalSection() {
                    TableInfo tableInfo = TimeToLiveDeletionJob.this.dbAccess.getTableInfo(TimeToLiveDeletionJob.this.tableName);
                    if (tableInfo == null || tableInfo.getTimeToLiveSpecification() == null || !tableInfo.getTimeToLiveSpecification().enabled().booleanValue()) {
                        shouldRepeat.set(false);
                        return;
                    }
                    ScanResponse scanResult = null;
                    try {
                        scanResult = TimeToLiveDeletionJob.this.dynamoDbClient.scan((ScanRequest)scanRequest.build());
                    }
                    catch (Exception e) {
                        LOG.error("Error during scan in TimeToLiveDeletionJob", (Throwable)e);
                        return;
                    }
                    if (scanResult.items() != null && scanResult.hasItems()) {
                        for (Map item : scanResult.items()) {
                            boolean deleteSuccess = TimeToLiveDeletionJob.this.dbAccess.deleteRecord(TimeToLiveDeletionJob.this.tableName, TimeToLiveDeletionJob.this.getKeyFromItem(item), true);
                            if (deleteSuccess) continue;
                            LOG.error("Error during delete item in TimeToLiveDeletionJob");
                            shouldRepeat.set(false);
                            return;
                        }
                    }
                    scanResultWrapper.exclusiveScanStartKey = scanResult.lastEvaluatedKey();
                }
            }.execute();
            if (!shouldRepeat.get()) continue;
            this.sleepFor(LocalDBUtils.ITEM_EXPIRY_DELAY_BETWEEN_DELETION);
        } while (scanResultWrapper.exclusiveScanStartKey != null && shouldRepeat.get());
    }

    @Override
    public String name() {
        return LocalDBUtils.getTimeToLiveThreadName(this.tableName, this.timeToLiveAttributeName);
    }

    @Override
    public void cancel() {
    }

    private static class TimeToLiveExpression {
        private final String filterExpression;
        private final Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues;
        private final Map<String, String> expressionAttributeNames;

        TimeToLiveExpression(String filterExpression, Map<String, String> expressionAttributeNames, Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> expressionAttributeValues) {
            this.filterExpression = filterExpression;
            this.expressionAttributeNames = expressionAttributeNames;
            this.expressionAttributeValues = expressionAttributeValues;
        }

        String getFilterExpression() {
            return this.filterExpression;
        }

        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> getExpressionAttributeValues() {
            return this.expressionAttributeValues;
        }

        Map<String, String> getExpressionAttributeNames() {
            return this.expressionAttributeNames;
        }
    }

    private static class ScanResultWrapper {
        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> exclusiveScanStartKey;

        private ScanResultWrapper() {
        }
    }
}

