/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import ddb.partiql.shared.util.OperationName;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.partiql.lang.ast.AssignmentOp;
import org.partiql.lang.ast.DeleteOp;
import org.partiql.lang.ast.InsertValueOp;
import software.amazon.awssdk.services.dynamodb.model.BatchExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementError;
import software.amazon.awssdk.services.dynamodb.model.BatchStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.exceptions.DynamoDBLocalServiceException;
import software.amazon.dynamodb.services.local.google.Sets;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.api.dp.BatchExecuteStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBAccessException;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionType;
import software.amazon.dynamodb.services.local.shared.model.TableNameAndPrimaryKey;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.BatchProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.processor.DeleteStatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.processor.InsertStatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.processor.UpdateStatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.util.ObjectExceptionPair;

public class BatchWriteProcessor
extends BatchProcessor {
    public BatchWriteProcessor(LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, BatchExecuteStatementFunction batchExecuteStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, batchExecuteStatementFunction, documentFactory);
    }

    @Override
    public BatchExecuteStatementResponse execute(List<ObjectExceptionPair<ParsedPartiQLRequest>> parsedPartiQLRequestsExceptionPairs) {
        List<ObjectExceptionPair<TranslatedPartiQLOperation>> translatedPartiQLOperationExceptionPairs = this.performTranslations(parsedPartiQLRequestsExceptionPairs);
        List<BatchStatementResponse> batchStatementResponses = this.partiqlBatchWrite(translatedPartiQLOperationExceptionPairs);
        return (BatchExecuteStatementResponse)BatchExecuteStatementResponse.builder().responses(batchStatementResponses).build();
    }

    private List<BatchStatementResponse> partiqlBatchWrite(List<ObjectExceptionPair<TranslatedPartiQLOperation>> translatedPartiQLOperationExceptionPairs) {
        long totalRequestSize = 0L;
        Set<TableNameAndPrimaryKey> keysInvolved = Sets.newHashSet(new TableNameAndPrimaryKey[0]);
        final ArrayList<BatchStatementResponse> batchStatementResponses = new ArrayList<BatchStatementResponse>();
        for (ObjectExceptionPair<TranslatedPartiQLOperation> translatedPartiQLOperationExceptionPair : translatedPartiQLOperationExceptionPairs) {
            if (translatedPartiQLOperationExceptionPair.hasException()) {
                batchStatementResponses.add(BatchWriteProcessor.convertInternalExceptionToBatchStatementResponse(translatedPartiQLOperationExceptionPair.getException(), null));
                continue;
            }
            final TranslatedPartiQLOperation translatedPartiQLOperation = translatedPartiQLOperationExceptionPair.getObject();
            if ((totalRequestSize += this.getPartiQLOperationPayloadSize(translatedPartiQLOperation)) > 0x1000000L) {
                throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, String.format("BatchExecuteStatement payload size cannot exceed 16MB. Payload Size: %s", totalRequestSize));
            }
            final String tableName = translatedPartiQLOperation.getTableName();
            try {
                if (translatedPartiQLOperation.getOperationName().equals((Object)OperationName.INSERT)) {
                    this.partiQLStatementFunction.validatePutItem((Map)translatedPartiQLOperation.getItem(), this.partiQLStatementFunction.validateTableExists(tableName));
                } else {
                    this.partiQLStatementFunction.validateGetKey((Map)translatedPartiQLOperation.getItem(), this.partiQLStatementFunction.validateTableExists(tableName));
                }
            }
            catch (DynamoDBLocalServiceException e) {
                batchStatementResponses.add(BatchWriteProcessor.convertInternalExceptionToBatchStatementResponse(e, tableName));
                continue;
            }
            try {
                new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(translatedPartiQLOperation.getTableName()), 10){

                    @Override
                    public void criticalSection() {
                        ExecuteStatementResponse executeStatementResult = null;
                        switch (translatedPartiQLOperation.getOperationName()) {
                            case INSERT: {
                                executeStatementResult = ((InsertStatementProcessor)BatchWriteProcessor.this.partiQLStatementFunction.statementProcessors.get(InsertValueOp.class)).invokePartiqlInsertItem(translatedPartiQLOperation);
                                break;
                            }
                            case UPDATE: {
                                executeStatementResult = ((UpdateStatementProcessor)BatchWriteProcessor.this.partiQLStatementFunction.statementProcessors.get(AssignmentOp.class)).invokePartiqlUpdateItem(translatedPartiQLOperation);
                                break;
                            }
                            case DELETE: {
                                executeStatementResult = ((DeleteStatementProcessor)BatchWriteProcessor.this.partiQLStatementFunction.statementProcessors.get(DeleteOp.class)).invokePartiqlDeleteItem(translatedPartiQLOperation);
                                break;
                            }
                            default: {
                                LocalDBUtils.ldClientFail(LocalDBClientExceptionType.UNREACHABLE_CODE);
                            }
                        }
                        Map returnedAttributes = null;
                        if (!executeStatementResult.items().isEmpty()) {
                            returnedAttributes = (Map)executeStatementResult.items().get(0);
                        }
                        batchStatementResponses.add((BatchStatementResponse)BatchStatementResponse.builder().tableName(tableName).item(returnedAttributes).build());
                    }
                }.execute();
            }
            catch (LocalDBAccessException accessException) {
                if (accessException.getMessage().equals(LocalDBClientExceptionMessage.TIME_OUT_WHILE_ACQUIRING_LOCK.getMessage())) {
                    throw accessException;
                }
                batchStatementResponses.add((BatchStatementResponse)BatchStatementResponse.builder().error((BatchStatementError)BatchStatementError.builder().code(accessException.getType().getMessage()).message(accessException.getMessage()).build()).tableName(tableName).build());
            }
            catch (DynamoDBLocalServiceException localServiceException) {
                batchStatementResponses.add(BatchWriteProcessor.convertInternalExceptionToBatchStatementResponse(localServiceException, tableName));
            }
            if (keysInvolved.add(this.generateTableNameAndPrimaryKey(translatedPartiQLOperation))) continue;
            throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.DUPLICATE_ITEM_KEY.getMessage());
        }
        return batchStatementResponses;
    }
}

