/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.dynamodb.services.local.shared.partiql.processor;

import com.amazonaws.services.dynamodbv2.datamodel.DocumentFactory;
import com.amazonaws.services.dynamodbv2.datamodel.Expression;
import com.amazonaws.services.dynamodbv2.datamodel.UpdateExpression;
import com.amazonaws.services.dynamodbv2.rr.ExpressionWrapper;
import com.amazonaws.services.dynamodbv2.rr.UpdateExpressionWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.partiql.lang.ast.DataManipulation;
import software.amazon.awssdk.services.dynamodb.model.ExecuteStatementResponse;
import software.amazon.awssdk.services.dynamodb.model.ReturnValue;
import software.amazon.awssdk.services.dynamodb.model.ReturnValuesOnConditionCheckFailure;
import software.amazon.awssdk.services.dynamodb.model.UpdateItemResponse;
import software.amazon.dynamodb.services.exceptions.AWSExceptionFactory;
import software.amazon.dynamodb.services.exceptions.AmazonServiceExceptionType;
import software.amazon.dynamodb.services.local.shared.access.LocalDBAccess;
import software.amazon.dynamodb.services.local.shared.access.LocalDBUtils;
import software.amazon.dynamodb.services.local.shared.access.LocalDBValidatorUtils;
import software.amazon.dynamodb.services.local.shared.access.TableInfo;
import software.amazon.dynamodb.services.local.shared.access.api.dp.PartiQLStatementFunction;
import software.amazon.dynamodb.services.local.shared.env.LocalPartiQLDbEnv;
import software.amazon.dynamodb.services.local.shared.exceptions.LocalDBClientExceptionMessage;
import software.amazon.dynamodb.services.local.shared.model.AttributeValue;
import software.amazon.dynamodb.services.local.shared.partiql.ParsedPartiQLRequest;
import software.amazon.dynamodb.services.local.shared.partiql.model.TranslatedPartiQLOperation;
import software.amazon.dynamodb.services.local.shared.partiql.processor.StatementProcessor;
import software.amazon.dynamodb.services.local.shared.partiql.translator.UpdateStatementTranslator;

public class UpdateStatementProcessor
extends StatementProcessor<DataManipulation> {
    private final UpdateStatementTranslator translator;

    public UpdateStatementProcessor(UpdateStatementTranslator translator, LocalDBAccess dbAccess, LocalPartiQLDbEnv localPartiQLDbEnv, PartiQLStatementFunction partiQLStatementFunction, DocumentFactory documentFactory) {
        super(dbAccess, localPartiQLDbEnv, partiQLStatementFunction, documentFactory);
        this.translator = translator;
    }

    @Override
    public ExecuteStatementResponse execute(ParsedPartiQLRequest<DataManipulation> request) {
        TranslatedPartiQLOperation translatedPartiQLOperation = this.translator.translate(request);
        return this.invokePartiqlUpdateItem(translatedPartiQLOperation);
    }

    public ExecuteStatementResponse invokePartiqlUpdateItem(TranslatedPartiQLOperation translatedPartiQLOperation) {
        Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> returnedAttributes = this.partiqlUpdateItem(translatedPartiQLOperation.getTableName(), translatedPartiQLOperation.getReturnValue(), translatedPartiQLOperation.getItem(), translatedPartiQLOperation.getConditionExpressionWrapper(), translatedPartiQLOperation.getUpdateExpressionWrapper(), translatedPartiQLOperation.getReturnValuesOnConditionCheckFailure());
        return (ExecuteStatementResponse)ExecuteStatementResponse.builder().items(returnedAttributes == null || returnedAttributes.isEmpty() ? new ArrayList() : Collections.singletonList(returnedAttributes)).build();
    }

    public Map<String, software.amazon.awssdk.services.dynamodb.model.AttributeValue> partiqlUpdateItem(final String tableName, final ReturnValue returnVals, final Map<String, AttributeValue> key, final ExpressionWrapper conditionExpressionWrapper, final UpdateExpressionWrapper updateExpressionWrapper, final ReturnValuesOnConditionCheckFailure returnValuesOnConditionCheckFailure) {
        this.partiQLStatementFunction.validateTableName(tableName);
        final TableInfo tableInfo = this.partiQLStatementFunction.validateTableExists(tableName);
        this.partiQLStatementFunction.validateGetKey((Map)key, tableInfo);
        final UpdateItemResponse.Builder updateItemResponse = UpdateItemResponse.builder();
        new LocalDBAccess.WriteLockWithTimeout(this.dbAccess.getLockForTable(tableName), 10){

            @Override
            public void criticalSection() {
                HashMap<String, AttributeValue> oldItem;
                Map<String, AttributeValue> item = UpdateStatementProcessor.this.dbAccess.getRecord(tableName, key);
                if (item == null) {
                    oldItem = null;
                    item = new HashMap<String, AttributeValue>(key);
                } else {
                    oldItem = new HashMap<String, AttributeValue>();
                    for (Map.Entry<String, AttributeValue> entry : item.entrySet()) {
                        oldItem.put(entry.getKey(), entry.getValue());
                    }
                }
                Expression conditionExpression = conditionExpressionWrapper == null ? null : conditionExpressionWrapper.getExpression();
                LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, conditionExpressionWrapper, UpdateStatementProcessor.this.partiQLStatementFunction.awsExceptionFactory);
                if (!UpdateStatementProcessor.this.partiQLStatementFunction.doesItemMatchConditionExpression(oldItem, conditionExpression)) {
                    if (StatementProcessor.getReturnValuesOnConditionCheckFailure(returnValuesOnConditionCheckFailure).equals((Object)ReturnValuesOnConditionCheckFailure.ALL_OLD)) {
                        throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage(), oldItem);
                    }
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.CONDITIONAL_CHECK_FAILED_EXCEPTION, LocalDBClientExceptionMessage.CONDITIONAL_CHECK_FAILED.getMessage());
                }
                HashMap itemChangesForExpr = new HashMap();
                UpdateExpression updateExpression = updateExpressionWrapper == null ? null : updateExpressionWrapper.getUpdateExpr();
                LocalDBValidatorUtils.validateThatKeyAttributesNotUpdated(tableInfo, updateExpression, UpdateStatementProcessor.this.partiQLStatementFunction.awsExceptionFactory);
                LocalDBValidatorUtils.validateNoNestedAccessToKeyAttributeInExpression(tableInfo, updateExpressionWrapper, UpdateStatementProcessor.this.partiQLStatementFunction.awsExceptionFactory);
                UpdateStatementProcessor.this.partiQLStatementFunction.doUpdates(updateExpression, (Map)item, (Map)itemChangesForExpr, (ReturnValue)(ReturnValue.UPDATED_NEW.equals((Object)returnVals) || ReturnValue.UPDATED_OLD.equals((Object)returnVals) ? returnVals : null));
                if (LocalDBUtils.getItemSizeBytes(item) > 409600L) {
                    throw AWSExceptionFactory.buildAWSException(AmazonServiceExceptionType.VALIDATION_EXCEPTION, LocalDBClientExceptionMessage.ITEM_UPD_TOO_LARGE.getMessage());
                }
                AttributeValue rangeKey = null;
                if (tableInfo.hasRangeKey()) {
                    rangeKey = (AttributeValue)key.get(tableInfo.getRangeKey().attributeName());
                }
                UpdateStatementProcessor.this.partiQLStatementFunction.validateIndexKeyAttributeValuesBeforePuttingFinalRecordToDB(tableInfo, (Map)item, true);
                UpdateStatementProcessor.this.dbAccess.putRecord(tableName, item, (AttributeValue)key.get(tableInfo.getHashKey().attributeName()), rangeKey, true);
                updateItemResponse.attributes(UpdateStatementProcessor.this.partiQLStatementFunction.localDBOutputConverter.internalToExternalAttributes(UpdateStatementProcessor.this.partiQLStatementFunction.getReturnedValsFromUpdate(returnVals, (Map)itemChangesForExpr, oldItem, (Map)item)));
            }
        }.execute();
        return ((UpdateItemResponse)updateItemResponse.build()).attributes();
    }
}

