/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.CognitoIdentityProviderAuthSchemeParams;
import software.amazon.awssdk.services.cognitoidentityprovider.auth.scheme.CognitoIdentityProviderAuthSchemeProvider;

@SdkInternalApi
public final class DefaultCognitoIdentityProviderAuthSchemeProvider
implements CognitoIdentityProviderAuthSchemeProvider {
    private static final DefaultCognitoIdentityProviderAuthSchemeProvider DEFAULT = new DefaultCognitoIdentityProviderAuthSchemeProvider();

    private DefaultCognitoIdentityProviderAuthSchemeProvider() {
    }

    public static DefaultCognitoIdentityProviderAuthSchemeProvider create() {
        return DEFAULT;
    }

    @Override
    public List<AuthSchemeOption> resolveAuthScheme(CognitoIdentityProviderAuthSchemeParams params) {
        ArrayList<Object> options = new ArrayList<Object>();
        switch (params.operation()) {
            case "AssociateSoftwareToken": 
            case "ChangePassword": 
            case "CompleteWebAuthnRegistration": 
            case "ConfirmDevice": 
            case "ConfirmForgotPassword": 
            case "ConfirmSignUp": 
            case "DeleteUser": 
            case "DeleteUserAttributes": 
            case "DeleteWebAuthnCredential": 
            case "ForgetDevice": 
            case "ForgotPassword": 
            case "GetDevice": 
            case "GetUser": 
            case "GetUserAttributeVerificationCode": 
            case "GetUserAuthFactors": 
            case "GlobalSignOut": 
            case "InitiateAuth": 
            case "ListDevices": 
            case "ListWebAuthnCredentials": 
            case "ResendConfirmationCode": 
            case "RespondToAuthChallenge": 
            case "RevokeToken": 
            case "SetUserMFAPreference": 
            case "SetUserSettings": 
            case "SignUp": 
            case "StartWebAuthnRegistration": 
            case "UpdateAuthEventFeedback": 
            case "UpdateDeviceStatus": 
            case "UpdateUserAttributes": 
            case "VerifySoftwareToken": 
            case "VerifyUserAttribute": {
                options.add(AuthSchemeOption.builder().schemeId("smithy.api#noAuth").build());
                break;
            }
            default: {
                options.add(AuthSchemeOption.builder().schemeId("aws.auth#sigv4").putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)"cognito-idp").putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)params.region().id()).build());
            }
        }
        return Collections.unmodifiableList(options);
    }
}

