/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.cognitoidentityprovider.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum IdentityProviderTypeType {
    SAML("SAML"),
    FACEBOOK("Facebook"),
    GOOGLE("Google"),
    LOGIN_WITH_AMAZON("LoginWithAmazon"),
    SIGN_IN_WITH_APPLE("SignInWithApple"),
    OIDC("OIDC"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, IdentityProviderTypeType> VALUE_MAP;
    private final String value;

    private IdentityProviderTypeType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static IdentityProviderTypeType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<IdentityProviderTypeType> knownValues() {
        EnumSet<IdentityProviderTypeType> knownValues = EnumSet.allOf(IdentityProviderTypeType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(IdentityProviderTypeType.class, IdentityProviderTypeType::toString);
    }
}

