/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.exception;

import java.util.StringJoiner;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

@SdkProtectedApi
public class SdkDiagnostics
implements ToCopyableBuilder<Builder, SdkDiagnostics> {
    private final Integer numAttempts;

    private SdkDiagnostics(Builder builder) {
        this.numAttempts = builder.numAttempts();
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public String toString() {
        StringJoiner details = new StringJoiner(", ", "(", ")");
        if (this.numAttempts != null) {
            details.add("SDK Attempt Count: " + this.numAttempts);
            return details.toString();
        }
        return "";
    }

    public Builder toBuilder() {
        return new BuilderImpl().numAttempts(this.numAttempts);
    }

    private static class BuilderImpl
    implements Builder {
        private Integer numAttempts;

        private BuilderImpl() {
        }

        @Override
        public Builder numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public Integer numAttempts() {
            return this.numAttempts;
        }

        @Override
        public SdkDiagnostics build() {
            return new SdkDiagnostics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, SdkDiagnostics> {
        public Builder numAttempts(Integer var1);

        public SdkDiagnostics build();

        public Integer numAttempts();
    }
}

