/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.ClientEndpointProvider;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class StaticClientEndpointProvider
implements ClientEndpointProvider {
    private final URI clientEndpoint;
    private final boolean isEndpointOverridden;

    public StaticClientEndpointProvider(URI clientEndpoint, boolean isEndpointOverridden) {
        this.clientEndpoint = (URI)Validate.paramNotNull((Object)clientEndpoint, (String)"clientEndpoint");
        this.isEndpointOverridden = isEndpointOverridden;
        Validate.paramNotNull((Object)clientEndpoint.getScheme(), (String)"The URI scheme of endpointOverride");
    }

    @Override
    public URI clientEndpoint() {
        return this.clientEndpoint;
    }

    @Override
    public boolean isEndpointOverridden() {
        return this.isEndpointOverridden;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StaticClientEndpointProvider that = (StaticClientEndpointProvider)o;
        if (this.isEndpointOverridden != that.isEndpointOverridden) {
            return false;
        }
        return this.clientEndpoint.equals(that.clientEndpoint);
    }

    public int hashCode() {
        int result = this.clientEndpoint.hashCode();
        result = 31 * result + (this.isEndpointOverridden ? 1 : 0);
        return result;
    }

    public String toString() {
        return ToString.builder((String)"ClientEndpointProvider").add("clientEndpoint", (Object)this.clientEndpoint).add("isEndpointOverridden", (Object)this.isEndpointOverridden).build();
    }
}

