/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.core.async.AsyncRequestBody;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.checksums.Algorithm;
import software.amazon.awssdk.core.exception.SdkException;
import software.amazon.awssdk.core.internal.async.ChunkBuffer;
import software.amazon.awssdk.core.internal.util.ChunkContentUtils;
import software.amazon.awssdk.core.internal.util.HttpChecksumUtils;
import software.amazon.awssdk.utils.BinaryUtils;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.DelegatingSubscriber;
import software.amazon.awssdk.utils.builder.SdkBuilder;

@SdkInternalApi
public class ChecksumCalculatingAsyncRequestBody
implements AsyncRequestBody {
    private static final byte[] FINAL_BYTE = new byte[0];
    private final AsyncRequestBody wrapped;
    private final SdkChecksum sdkChecksum;
    private final ChecksumAlgorithm algorithm;
    private final String trailerHeader;
    private final long totalBytes;

    private ChecksumCalculatingAsyncRequestBody(DefaultBuilder builder) {
        Validate.notNull((Object)builder.asyncRequestBody, (String)"wrapped AsyncRequestBody cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)builder.algorithm, (String)"algorithm cannot be null", (Object[])new Object[0]);
        Validate.notNull((Object)builder.trailerHeader, (String)"trailerHeader cannot be null", (Object[])new Object[0]);
        this.wrapped = builder.asyncRequestBody;
        this.algorithm = builder.algorithm;
        this.sdkChecksum = builder.algorithm != null ? SdkChecksum.forAlgorithm((ChecksumAlgorithm)this.algorithm) : null;
        this.trailerHeader = builder.trailerHeader;
        this.totalBytes = ChecksumCalculatingAsyncRequestBody.initTotalBytes(this.wrapped, builder.contentLengthHeader);
    }

    static long initTotalBytes(AsyncRequestBody wrapped, Long contentLengthHeader) {
        if (contentLengthHeader != null) {
            return contentLengthHeader;
        }
        return wrapped.contentLength().orElseThrow(() -> new UnsupportedOperationException("Content length must be supplied."));
    }

    public static Builder builder() {
        return new DefaultBuilder();
    }

    @Override
    public Optional<Long> contentLength() {
        if (this.algorithm != null) {
            Algorithm legacyAlgo = HttpChecksumUtils.toLegacyChecksumAlgorithm(this.algorithm);
            return Optional.of(ChunkContentUtils.calculateChunkLength(this.totalBytes) + ChunkContentUtils.LAST_CHUNK_LEN + ChunkContentUtils.calculateChecksumTrailerLength(legacyAlgo, this.trailerHeader));
        }
        return Optional.of(this.totalBytes);
    }

    @Override
    public String contentType() {
        return this.wrapped.contentType();
    }

    public void subscribe(Subscriber<? super ByteBuffer> s) {
        Validate.notNull(s, (String)"Subscription MUST NOT be null.", (Object[])new Object[0]);
        if (this.sdkChecksum != null) {
            this.sdkChecksum.reset();
        }
        SynchronousChunkBuffer synchronousChunkBuffer = new SynchronousChunkBuffer(this.totalBytes);
        this.alwaysInvokeOnNext(this.wrapped.flatMapIterable(x$0 -> synchronousChunkBuffer.buffer(x$0))).subscribe(new ChecksumCalculatingSubscriber(s, this.sdkChecksum, this.trailerHeader, this.totalBytes));
    }

    private SdkPublisher<ByteBuffer> alwaysInvokeOnNext(SdkPublisher<ByteBuffer> source) {
        return subscriber -> source.subscribe((Subscriber)new OnNextGuaranteedSubscriber((Subscriber<? super ByteBuffer>)subscriber));
    }

    public static class OnNextGuaranteedSubscriber
    extends DelegatingSubscriber<ByteBuffer, ByteBuffer> {
        private volatile boolean onNextInvoked;

        public OnNextGuaranteedSubscriber(Subscriber<? super ByteBuffer> subscriber) {
            super(subscriber);
        }

        public void onNext(ByteBuffer t) {
            if (!this.onNextInvoked) {
                this.onNextInvoked = true;
            }
            this.subscriber.onNext((Object)t);
        }

        public void onComplete() {
            if (!this.onNextInvoked) {
                this.subscriber.onNext((Object)ByteBuffer.wrap(new byte[0]));
            }
            super.onComplete();
        }
    }

    private static final class SynchronousChunkBuffer {
        private final ChunkBuffer chunkBuffer;

        SynchronousChunkBuffer(long totalBytes) {
            this.chunkBuffer = (ChunkBuffer)ChunkBuffer.builder().bufferSize(16384).totalBytes(totalBytes).build();
        }

        private Iterable<ByteBuffer> buffer(ByteBuffer bytes) {
            return this.chunkBuffer.split(bytes);
        }
    }

    private static final class ChecksumCalculatingSubscriber
    implements Subscriber<ByteBuffer> {
        private final Subscriber<? super ByteBuffer> wrapped;
        private final SdkChecksum checksum;
        private final String trailerHeader;
        private byte[] checksumBytes;
        private final AtomicLong remainingBytes;
        private Subscription subscription;

        ChecksumCalculatingSubscriber(Subscriber<? super ByteBuffer> wrapped, SdkChecksum checksum, String trailerHeader, long totalBytes) {
            this.wrapped = wrapped;
            this.checksum = checksum;
            this.trailerHeader = trailerHeader;
            this.remainingBytes = new AtomicLong(totalBytes);
        }

        public void onSubscribe(Subscription subscription) {
            this.subscription = subscription;
            this.wrapped.onSubscribe(subscription);
        }

        public void onNext(ByteBuffer byteBuffer) {
            boolean lastByte = this.remainingBytes.addAndGet(-byteBuffer.remaining()) <= 0L;
            try {
                if (this.checksum != null) {
                    byteBuffer.mark();
                    this.checksum.update(byteBuffer);
                    byteBuffer.reset();
                }
                if (lastByte && this.checksumBytes == null && this.checksum != null) {
                    this.checksumBytes = this.checksum.getChecksumBytes();
                    ByteBuffer allocatedBuffer = this.getFinalChecksumAppendedChunk(byteBuffer);
                    this.wrapped.onNext((Object)allocatedBuffer);
                } else if (byteBuffer.hasRemaining()) {
                    ByteBuffer allocatedBuffer = ChunkContentUtils.createChunk(byteBuffer, false);
                    this.wrapped.onNext((Object)allocatedBuffer);
                } else {
                    this.wrapped.onNext((Object)byteBuffer);
                }
            }
            catch (SdkException sdkException) {
                this.subscription.cancel();
                this.onError(sdkException);
            }
        }

        private ByteBuffer getFinalChecksumAppendedChunk(ByteBuffer byteBuffer) {
            ByteBuffer finalChunkedByteBuffer = ChunkContentUtils.createChunk(ByteBuffer.wrap(FINAL_BYTE), true);
            ByteBuffer checksumTrailerByteBuffer = ChunkContentUtils.createChecksumTrailer(BinaryUtils.toBase64((byte[])this.checksumBytes), this.trailerHeader);
            ByteBuffer contentChunk = byteBuffer.hasRemaining() ? ChunkContentUtils.createChunk(byteBuffer, false) : byteBuffer;
            ByteBuffer checksumAppendedBuffer = ByteBuffer.allocate(contentChunk.remaining() + finalChunkedByteBuffer.remaining() + checksumTrailerByteBuffer.remaining());
            checksumAppendedBuffer.put(contentChunk).put(finalChunkedByteBuffer).put(checksumTrailerByteBuffer);
            checksumAppendedBuffer.flip();
            return checksumAppendedBuffer;
        }

        public void onError(Throwable t) {
            this.wrapped.onError(t);
        }

        public void onComplete() {
            this.wrapped.onComplete();
        }
    }

    private static final class DefaultBuilder
    implements Builder {
        private AsyncRequestBody asyncRequestBody;
        private ChecksumAlgorithm algorithm;
        private String trailerHeader;
        private Long contentLengthHeader;

        private DefaultBuilder() {
        }

        public ChecksumCalculatingAsyncRequestBody build() {
            return new ChecksumCalculatingAsyncRequestBody(this);
        }

        @Override
        public Builder asyncRequestBody(AsyncRequestBody asyncRequestBody) {
            this.asyncRequestBody = asyncRequestBody;
            return this;
        }

        @Override
        public Builder algorithm(ChecksumAlgorithm algorithm) {
            this.algorithm = algorithm;
            return this;
        }

        @Override
        public Builder trailerHeader(String trailerHeader) {
            this.trailerHeader = trailerHeader;
            return this;
        }

        @Override
        public Builder contentLengthHeader(Long contentLength) {
            this.contentLengthHeader = contentLength;
            return this;
        }
    }

    public static interface Builder
    extends SdkBuilder<Builder, ChecksumCalculatingAsyncRequestBody> {
        public Builder asyncRequestBody(AsyncRequestBody var1);

        public Builder algorithm(ChecksumAlgorithm var1);

        public Builder trailerHeader(String var1);

        public Builder contentLengthHeader(Long var1);
    }
}

