/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.async;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.async.AsyncResponseTransformer;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.utils.CompletableFutureUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.Validate;
import software.amazon.awssdk.utils.async.DelegatingBufferingSubscriber;
import software.amazon.awssdk.utils.async.SimplePublisher;

@SdkInternalApi
public class SplittingTransformer<ResponseT, ResultT>
implements SdkPublisher<AsyncResponseTransformer<ResponseT, ResponseT>> {
    private static final Logger log = Logger.loggerFor(SplittingTransformer.class);
    private final AsyncResponseTransformer<ResponseT, ResultT> upstreamResponseTransformer;
    private final AtomicBoolean preparedCalled = new AtomicBoolean(false);
    private final AtomicBoolean onResponseCalled = new AtomicBoolean(false);
    private final AtomicBoolean onStreamCalled = new AtomicBoolean(false);
    private final AtomicBoolean isCancelled = new AtomicBoolean(false);
    private final CompletableFuture<ResultT> resultFuture;
    private final long maximumBufferInBytes;
    private final SimplePublisher<ByteBuffer> publisherToUpstream = new SimplePublisher();
    private Subscriber<? super AsyncResponseTransformer<ResponseT, ResponseT>> downstreamSubscriber;
    private final AtomicLong outstandingDemand = new AtomicLong(0L);
    private final AtomicBoolean emitting = new AtomicBoolean(false);
    private final Object cancelLock = new Object();

    private SplittingTransformer(AsyncResponseTransformer<ResponseT, ResultT> upstreamResponseTransformer, Long maximumBufferSizeInBytes, CompletableFuture<ResultT> resultFuture) {
        this.upstreamResponseTransformer = (AsyncResponseTransformer)Validate.paramNotNull(upstreamResponseTransformer, (String)"upstreamResponseTransformer");
        this.resultFuture = (CompletableFuture)Validate.paramNotNull(resultFuture, (String)"resultFuture");
        Validate.notNull((Object)maximumBufferSizeInBytes, (String)"maximumBufferSizeInBytes", (Object[])new Object[0]);
        this.maximumBufferInBytes = Validate.isPositive((long)maximumBufferSizeInBytes, (String)"maximumBufferSizeInBytes");
        this.resultFuture.whenComplete((r, e) -> {
            if (e == null) {
                return;
            }
            if (this.isCancelled.compareAndSet(false, true)) {
                this.handleFutureCancel((Throwable)e);
            }
        });
    }

    public void subscribe(Subscriber<? super AsyncResponseTransformer<ResponseT, ResponseT>> downstreamSubscriber) {
        if (downstreamSubscriber == null) {
            throw new NullPointerException("downstreamSubscriber must not be null");
        }
        this.downstreamSubscriber = downstreamSubscriber;
        downstreamSubscriber.onSubscribe((Subscription)new DownstreamSubscription());
    }

    private void emit() {
        do {
            if (!this.emitting.compareAndSet(false, true)) {
                return;
            }
            try {
                if (this.doEmit()) {
                    return;
                }
            }
            finally {
                this.emitting.compareAndSet(true, false);
            }
        } while (this.outstandingDemand.get() > 0L);
    }

    private boolean doEmit() {
        long demand = this.outstandingDemand.get();
        while (demand > 0L) {
            if (this.isCancelled.get()) {
                return true;
            }
            if (this.outstandingDemand.get() <= 0L) continue;
            demand = this.outstandingDemand.decrementAndGet();
            this.downstreamSubscriber.onNext((Object)new IndividualTransformer());
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleSubscriptionCancel() {
        Object object = this.cancelLock;
        synchronized (object) {
            if (this.downstreamSubscriber == null) {
                log.trace(() -> "downstreamSubscriber already null, skipping downstreamSubscriber.onComplete()");
                return;
            }
            if (!this.onStreamCalled.get()) {
                this.downstreamSubscriber = null;
                return;
            }
            this.publisherToUpstream.complete().whenComplete((v, t) -> {
                if (this.downstreamSubscriber == null) {
                    return;
                }
                if (t != null) {
                    this.downstreamSubscriber.onError(t);
                } else {
                    log.trace(() -> "calling downstreamSubscriber.onComplete()");
                    this.downstreamSubscriber.onComplete();
                }
                this.downstreamSubscriber = null;
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFutureCancel(Throwable e) {
        Object object = this.cancelLock;
        synchronized (object) {
            this.publisherToUpstream.error(e);
            if (this.downstreamSubscriber != null) {
                this.downstreamSubscriber.onError(e);
                this.downstreamSubscriber = null;
            }
        }
    }

    public static <ResponseT, ResultT> Builder<ResponseT, ResultT> builder() {
        return new Builder();
    }

    public static final class Builder<ResponseT, ResultT> {
        private Long maximumBufferSize;
        private CompletableFuture<ResultT> returnFuture;
        private AsyncResponseTransformer<ResponseT, ResultT> upstreamResponseTransformer;

        private Builder() {
        }

        public Builder<ResponseT, ResultT> upstreamResponseTransformer(AsyncResponseTransformer<ResponseT, ResultT> upstreamResponseTransformer) {
            this.upstreamResponseTransformer = upstreamResponseTransformer;
            return this;
        }

        public Builder<ResponseT, ResultT> maximumBufferSizeInBytes(Long maximumBufferSize) {
            this.maximumBufferSize = maximumBufferSize;
            return this;
        }

        public Builder<ResponseT, ResultT> resultFuture(CompletableFuture<ResultT> returnFuture) {
            this.returnFuture = returnFuture;
            return this;
        }

        public SplittingTransformer<ResponseT, ResultT> build() {
            return new SplittingTransformer(this.upstreamResponseTransformer, this.maximumBufferSize, this.returnFuture);
        }
    }

    class IndividualPartSubscriber<T>
    implements Subscriber<ByteBuffer> {
        private final CompletableFuture<T> future;
        private final T response;
        private Subscription subscription;

        IndividualPartSubscriber(CompletableFuture<T> future, T response) {
            this.future = future;
            this.response = response;
        }

        public void onSubscribe(Subscription s) {
            if (this.subscription != null) {
                s.cancel();
                return;
            }
            this.subscription = s;
            s.request(1L);
        }

        public void onNext(ByteBuffer byteBuffer) {
            if (byteBuffer == null) {
                throw new NullPointerException("onNext must not be called with null byteBuffer");
            }
            SplittingTransformer.this.publisherToUpstream.send((Object)byteBuffer).whenComplete((r, t) -> {
                if (t != null) {
                    this.handleError((Throwable)t);
                    return;
                }
                if (!SplittingTransformer.this.isCancelled.get()) {
                    this.subscription.request(1L);
                }
            });
        }

        public void onError(Throwable t) {
            this.handleError(t);
        }

        public void onComplete() {
            this.future.complete(this.response);
        }

        private void handleError(Throwable t) {
            SplittingTransformer.this.publisherToUpstream.error(t);
            this.future.completeExceptionally(t);
        }
    }

    private class IndividualTransformer
    implements AsyncResponseTransformer<ResponseT, ResponseT> {
        private ResponseT response;
        private CompletableFuture<ResponseT> individualFuture;

        private IndividualTransformer() {
        }

        @Override
        public CompletableFuture<ResponseT> prepare() {
            this.individualFuture = new CompletableFuture();
            if (SplittingTransformer.this.preparedCalled.compareAndSet(false, true)) {
                if (SplittingTransformer.this.isCancelled.get()) {
                    return this.individualFuture;
                }
                log.trace(() -> "calling prepare on the upstream transformer");
                CompletableFuture upstreamFuture = SplittingTransformer.this.upstreamResponseTransformer.prepare();
                if (!SplittingTransformer.this.resultFuture.isDone()) {
                    CompletableFutureUtils.forwardResultTo(upstreamFuture, (CompletableFuture)SplittingTransformer.this.resultFuture);
                }
            }
            SplittingTransformer.this.resultFuture.whenComplete((r, e) -> {
                if (e == null) {
                    return;
                }
                this.individualFuture.completeExceptionally((Throwable)e);
            });
            this.individualFuture.whenComplete((r, e) -> {
                if (SplittingTransformer.this.isCancelled.get()) {
                    SplittingTransformer.this.handleSubscriptionCancel();
                }
            });
            return this.individualFuture;
        }

        @Override
        public void onResponse(ResponseT response) {
            if (SplittingTransformer.this.onResponseCalled.compareAndSet(false, true)) {
                log.trace(() -> "calling onResponse on the upstream transformer");
                SplittingTransformer.this.upstreamResponseTransformer.onResponse(response);
            }
            this.response = response;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onStream(SdkPublisher<ByteBuffer> publisher) {
            if (SplittingTransformer.this.downstreamSubscriber == null) {
                return;
            }
            Object object = SplittingTransformer.this.cancelLock;
            synchronized (object) {
                if (SplittingTransformer.this.onStreamCalled.compareAndSet(false, true)) {
                    log.trace(() -> "calling onStream on the upstream transformer");
                    SplittingTransformer.this.upstreamResponseTransformer.onStream(upstreamSubscriber -> SplittingTransformer.this.publisherToUpstream.subscribe((Subscriber)DelegatingBufferingSubscriber.builder().maximumBufferInBytes(Long.valueOf(SplittingTransformer.this.maximumBufferInBytes)).delegate(upstreamSubscriber).build()));
                }
            }
            publisher.subscribe(new IndividualPartSubscriber(this.individualFuture, this.response));
        }

        @Override
        public void exceptionOccurred(Throwable error) {
            SplittingTransformer.this.publisherToUpstream.error(error);
            log.trace(() -> "calling exceptionOccurred on the upstream transformer");
            SplittingTransformer.this.upstreamResponseTransformer.exceptionOccurred(error);
        }
    }

    private final class DownstreamSubscription
    implements Subscription {
        private DownstreamSubscription() {
        }

        public void request(long n) {
            if (n <= 0L) {
                SplittingTransformer.this.downstreamSubscriber.onError((Throwable)new IllegalArgumentException("Amount requested must be positive"));
                return;
            }
            long newDemand = SplittingTransformer.this.outstandingDemand.updateAndGet(current -> {
                if (Long.MAX_VALUE - current < n) {
                    return Long.MAX_VALUE;
                }
                return current + n;
            });
            log.trace(() -> String.format("new outstanding demand: %s", newDemand));
            SplittingTransformer.this.emit();
        }

        public void cancel() {
            log.trace(() -> String.format("received cancel signal. Current cancel state is 'isCancelled=%s'", SplittingTransformer.this.isCancelled.get()));
            if (SplittingTransformer.this.isCancelled.compareAndSet(false, true)) {
                SplittingTransformer.this.handleSubscriptionCancel();
            }
        }
    }
}

