/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.internal.util;

import java.io.IOException;
import java.io.InputStream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.Crc32MismatchException;
import software.amazon.awssdk.core.internal.util.Crc32ChecksumCalculatingInputStream;
import software.amazon.awssdk.core.io.SdkFilterInputStream;
import software.amazon.awssdk.utils.Logger;

@SdkInternalApi
public class Crc32ChecksumValidatingInputStream
extends SdkFilterInputStream {
    private static final Logger log = Logger.loggerFor(Crc32ChecksumValidatingInputStream.class);
    private final long expectedChecksum;
    private boolean shouldValidateChecksum = true;

    public Crc32ChecksumValidatingInputStream(InputStream in, long expectedChecksum) {
        super(new Crc32ChecksumCalculatingInputStream(in));
        this.expectedChecksum = expectedChecksum;
    }

    @Override
    public void close() throws IOException {
        try {
            this.validateChecksum();
        }
        finally {
            super.close();
        }
    }

    @Override
    public int read() throws IOException {
        try {
            return super.read();
        }
        catch (Throwable e) {
            this.shouldValidateChecksum = false;
            throw e;
        }
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            return super.read(b, off, len);
        }
        catch (Throwable e) {
            this.shouldValidateChecksum = false;
            throw e;
        }
    }

    private void validateChecksum() throws Crc32MismatchException {
        if (!this.shouldValidateChecksum) {
            log.debug(() -> "Skipping CRC32 validation due to error encountered while reading from input stream");
            return;
        }
        long actualChecksum = ((Crc32ChecksumCalculatingInputStream)this.in).getCrc32Checksum();
        if (this.expectedChecksum != actualChecksum) {
            throw Crc32MismatchException.builder().message(String.format("Expected %d as the Crc32 checksum but the actual calculated checksum was %d", this.expectedChecksum, actualChecksum)).build();
        }
    }
}

