/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.core.sync;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AccessDeniedException;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.Map;
import software.amazon.awssdk.annotations.SdkProtectedApi;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.ResponseBytes;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.RetryableException;
import software.amazon.awssdk.core.internal.http.InterruptMonitor;
import software.amazon.awssdk.http.AbortableInputStream;
import software.amazon.awssdk.utils.IoUtils;
import software.amazon.awssdk.utils.Logger;
import software.amazon.awssdk.utils.internal.EnumUtils;

@FunctionalInterface
@SdkPublicApi
public interface ResponseTransformer<ResponseT, ReturnT> {
    public ReturnT transform(ResponseT var1, AbortableInputStream var2) throws Exception;

    default public boolean needsConnectionLeftOpen() {
        return false;
    }

    default public String name() {
        return TransformerType.UNKNOWN.name();
    }

    public static <ResponseT> ResponseTransformer<ResponseT, ResponseT> toFile(final Path path) {
        return new ResponseTransformer<ResponseT, ResponseT>(){

            @Override
            public ResponseT transform(ResponseT response, AbortableInputStream inputStream) throws Exception {
                try {
                    InterruptMonitor.checkInterrupted();
                    Files.copy((InputStream)inputStream, path, new CopyOption[0]);
                    return response;
                }
                catch (IOException copyException) {
                    String copyError = "Failed to read response into file: " + path;
                    if (ResponseTransformer.shouldThrowIOException(copyException)) {
                        throw new IOException(copyError, copyException);
                    }
                    try {
                        Files.deleteIfExists(path);
                    }
                    catch (IOException deletionException) {
                        Logger.loggerFor(ResponseTransformer.class).error(() -> "Failed to delete destination file '" + path + "' after reading the service response failed.", (Throwable)deletionException);
                        throw new IOException(copyError + ". Additionally, the file could not be cleaned up (" + deletionException.getMessage() + "), so the request will not be retried.", copyException);
                    }
                    throw RetryableException.builder().message(copyError).cause(copyException).build();
                }
            }

            @Override
            public String name() {
                return TransformerType.FILE.getName();
            }
        };
    }

    public static boolean shouldThrowIOException(IOException copyException) {
        return copyException instanceof FileAlreadyExistsException || copyException instanceof DirectoryNotEmptyException || copyException instanceof NoSuchFileException || copyException instanceof AccessDeniedException;
    }

    public static <ResponseT> ResponseTransformer<ResponseT, ResponseT> toFile(File file) {
        return ResponseTransformer.toFile(file.toPath());
    }

    public static <ResponseT> ResponseTransformer<ResponseT, ResponseT> toOutputStream(final OutputStream outputStream) {
        return new ResponseTransformer<ResponseT, ResponseT>(){

            @Override
            public ResponseT transform(ResponseT response, AbortableInputStream inputStream) throws Exception {
                InterruptMonitor.checkInterrupted();
                IoUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
                return response;
            }

            @Override
            public String name() {
                return TransformerType.STREAM.getName();
            }
        };
    }

    public static <ResponseT> ResponseTransformer<ResponseT, ResponseBytes<ResponseT>> toBytes() {
        return new ResponseTransformer<ResponseT, ResponseBytes<ResponseT>>(){

            @Override
            public ResponseBytes<ResponseT> transform(ResponseT response, AbortableInputStream inputStream) throws Exception {
                try {
                    InterruptMonitor.checkInterrupted();
                    return ResponseBytes.fromByteArrayUnsafe(response, IoUtils.toByteArray((InputStream)inputStream));
                }
                catch (IOException e) {
                    throw RetryableException.builder().message("Failed to read response.").cause(e).build();
                }
            }

            @Override
            public String name() {
                return TransformerType.BYTES.getName();
            }
        };
    }

    public static <ResponseT> ResponseTransformer<ResponseT, ResponseInputStream<ResponseT>> toInputStream() {
        return ResponseTransformer.unmanaged(new ResponseTransformer<ResponseT, ResponseInputStream<ResponseT>>(){

            @Override
            public ResponseInputStream<ResponseT> transform(ResponseT response, AbortableInputStream inputStream) {
                return new ResponseInputStream(response, inputStream);
            }

            @Override
            public String name() {
                return TransformerType.STREAM.getName();
            }
        });
    }

    public static <ResponseT, ReturnT> ResponseTransformer<ResponseT, ReturnT> unmanaged(final ResponseTransformer<ResponseT, ReturnT> transformer) {
        return new ResponseTransformer<ResponseT, ReturnT>(){

            @Override
            public ReturnT transform(ResponseT response, AbortableInputStream inputStream) throws Exception {
                InterruptMonitor.checkInterrupted();
                return transformer.transform(response, inputStream);
            }

            @Override
            public boolean needsConnectionLeftOpen() {
                return true;
            }

            @Override
            public String name() {
                return transformer.name();
            }
        };
    }

    @SdkProtectedApi
    public static enum TransformerType {
        FILE("File", "f"),
        BYTES("Bytes", "b"),
        STREAM("Stream", "s"),
        UNKNOWN("Unknown", "u");

        private static final Map<String, TransformerType> VALUE_MAP;
        private final String name;
        private final String shortValue;

        private TransformerType(String name, String shortValue) {
            this.name = name;
            this.shortValue = shortValue;
        }

        public String getName() {
            return this.name;
        }

        public String getShortValue() {
            return this.shortValue;
        }

        public static String shortValueFromName(String name) {
            return VALUE_MAP.getOrDefault(name, UNKNOWN).getShortValue();
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(TransformerType.class, TransformerType::getName);
        }
    }
}

