/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.pinpoint.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.PayloadTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.pinpoint.model.PinpointRequest;
import software.amazon.awssdk.services.pinpoint.model.UpdateAttributesRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RemoveAttributesRequest
extends PinpointRequest
implements ToCopyableBuilder<Builder, RemoveAttributesRequest> {
    private static final SdkField<String> APPLICATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ApplicationId").getter(RemoveAttributesRequest.getter(RemoveAttributesRequest::applicationId)).setter(RemoveAttributesRequest.setter(Builder::applicationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("application-id").build()}).build();
    private static final SdkField<String> ATTRIBUTE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AttributeType").getter(RemoveAttributesRequest.getter(RemoveAttributesRequest::attributeType)).setter(RemoveAttributesRequest.setter(Builder::attributeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("attribute-type").build()}).build();
    private static final SdkField<UpdateAttributesRequest> UPDATE_ATTRIBUTES_REQUEST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("UpdateAttributesRequest").getter(RemoveAttributesRequest.getter(RemoveAttributesRequest::updateAttributesRequest)).setter(RemoveAttributesRequest.setter(Builder::updateAttributesRequest)).constructor(UpdateAttributesRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateAttributesRequest").build(), PayloadTrait.create()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APPLICATION_ID_FIELD, ATTRIBUTE_TYPE_FIELD, UPDATE_ATTRIBUTES_REQUEST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RemoveAttributesRequest.memberNameToFieldInitializer();
    private final String applicationId;
    private final String attributeType;
    private final UpdateAttributesRequest updateAttributesRequest;

    private RemoveAttributesRequest(BuilderImpl builder) {
        super(builder);
        this.applicationId = builder.applicationId;
        this.attributeType = builder.attributeType;
        this.updateAttributesRequest = builder.updateAttributesRequest;
    }

    public final String applicationId() {
        return this.applicationId;
    }

    public final String attributeType() {
        return this.attributeType;
    }

    public final UpdateAttributesRequest updateAttributesRequest() {
        return this.updateAttributesRequest;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.attributeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateAttributesRequest());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RemoveAttributesRequest)) {
            return false;
        }
        RemoveAttributesRequest other = (RemoveAttributesRequest)((Object)obj);
        return Objects.equals(this.applicationId(), other.applicationId()) && Objects.equals(this.attributeType(), other.attributeType()) && Objects.equals(this.updateAttributesRequest(), other.updateAttributesRequest());
    }

    public final String toString() {
        return ToString.builder((String)"RemoveAttributesRequest").add("ApplicationId", (Object)this.applicationId()).add("AttributeType", (Object)this.attributeType()).add("UpdateAttributesRequest", (Object)this.updateAttributesRequest()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationId": {
                return Optional.ofNullable(clazz.cast(this.applicationId()));
            }
            case "AttributeType": {
                return Optional.ofNullable(clazz.cast(this.attributeType()));
            }
            case "UpdateAttributesRequest": {
                return Optional.ofNullable(clazz.cast(this.updateAttributesRequest()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("application-id", APPLICATION_ID_FIELD);
        map.put("attribute-type", ATTRIBUTE_TYPE_FIELD);
        map.put("UpdateAttributesRequest", UPDATE_ATTRIBUTES_REQUEST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RemoveAttributesRequest, T> g) {
        return obj -> g.apply((RemoveAttributesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends PinpointRequest.BuilderImpl
    implements Builder {
        private String applicationId;
        private String attributeType;
        private UpdateAttributesRequest updateAttributesRequest;

        private BuilderImpl() {
        }

        private BuilderImpl(RemoveAttributesRequest model) {
            super(model);
            this.applicationId(model.applicationId);
            this.attributeType(model.attributeType);
            this.updateAttributesRequest(model.updateAttributesRequest);
        }

        public final String getApplicationId() {
            return this.applicationId;
        }

        public final void setApplicationId(String applicationId) {
            this.applicationId = applicationId;
        }

        @Override
        public final Builder applicationId(String applicationId) {
            this.applicationId = applicationId;
            return this;
        }

        public final String getAttributeType() {
            return this.attributeType;
        }

        public final void setAttributeType(String attributeType) {
            this.attributeType = attributeType;
        }

        @Override
        public final Builder attributeType(String attributeType) {
            this.attributeType = attributeType;
            return this;
        }

        public final UpdateAttributesRequest.Builder getUpdateAttributesRequest() {
            return this.updateAttributesRequest != null ? this.updateAttributesRequest.toBuilder() : null;
        }

        public final void setUpdateAttributesRequest(UpdateAttributesRequest.BuilderImpl updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest != null ? updateAttributesRequest.build() : null;
        }

        @Override
        public final Builder updateAttributesRequest(UpdateAttributesRequest updateAttributesRequest) {
            this.updateAttributesRequest = updateAttributesRequest;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public RemoveAttributesRequest build() {
            return new RemoveAttributesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends PinpointRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RemoveAttributesRequest> {
        public Builder applicationId(String var1);

        public Builder attributeType(String var1);

        public Builder updateAttributesRequest(UpdateAttributesRequest var1);

        default public Builder updateAttributesRequest(Consumer<UpdateAttributesRequest.Builder> updateAttributesRequest) {
            return this.updateAttributesRequest((UpdateAttributesRequest)((UpdateAttributesRequest.Builder)UpdateAttributesRequest.builder().applyMutation(updateAttributesRequest)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

