/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.SWIGTYPE_p_direct_buffer;
import java.io.IOException;
import java.nio.ByteBuffer;

final class DirectBuffer {
    static final int CONTROL_BYTES = 2;
    private final int mySize;
    private SWIGTYPE_p_direct_buffer myHandle;
    private ByteBuffer myControlBuffer;
    private ByteBuffer myDataBuffer;

    DirectBuffer(SWIGTYPE_p_direct_buffer handle, ByteBuffer controlBuffer, ByteBuffer dataBuffer, int size) {
        assert (size == controlBuffer.capacity() + dataBuffer.capacity()) : size + " " + controlBuffer.capacity() + " " + dataBuffer.capacity();
        assert (controlBuffer.capacity() == 2) : controlBuffer.capacity();
        assert (size > 2) : size;
        this.myHandle = handle;
        this.myControlBuffer = controlBuffer;
        this.myDataBuffer = dataBuffer;
        this.mySize = size;
    }

    public ByteBuffer data() throws IOException {
        if (!this.isValid()) {
            throw new IOException("buffer disposed");
        }
        return this.myDataBuffer;
    }

    public int getCapacity() {
        return this.mySize - 2;
    }

    public int getPosition() {
        ByteBuffer buffer = this.myDataBuffer;
        return buffer == null ? 0 : buffer.position();
    }

    public SWIGTYPE_p_direct_buffer getHandle() {
        return this.myHandle;
    }

    public boolean isValid() {
        ByteBuffer controlBuffer = this.myControlBuffer;
        if (controlBuffer == null || this.myDataBuffer == null || this.myHandle == null) {
            return false;
        }
        byte pendingRemove = controlBuffer.get(1);
        return pendingRemove == 0;
    }

    public boolean isUsed() {
        ByteBuffer controlBuffer = this.myControlBuffer;
        if (controlBuffer == null) {
            return false;
        }
        return controlBuffer.get(0) != 0;
    }

    public void incUsed() {
        ByteBuffer controlBuffer = this.myControlBuffer;
        if (controlBuffer != null) {
            controlBuffer.put(0, (byte)(controlBuffer.get(0) + 1));
        }
    }

    public void decUsed() {
        byte usage;
        ByteBuffer controlBuffer = this.myControlBuffer;
        if (controlBuffer != null && (usage = controlBuffer.get(0)) > 0) {
            controlBuffer.put(0, (byte)(usage - 1));
        }
    }

    void invalidate() {
        this.myControlBuffer = null;
        this.myDataBuffer = null;
        this.myHandle = null;
    }
}

