/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.DirectBuffer;
import com.almworks.sqlite4java.Internal;
import com.almworks.sqlite4java.ProgressHandler;
import com.almworks.sqlite4java.SQLParts;
import com.almworks.sqlite4java.SQLiteController;
import com.almworks.sqlite4java.SQLiteException;
import com.almworks.sqlite4java.SQLiteInterruptedException;
import com.almworks.sqlite4java.SQLiteProfiler;
import com.almworks.sqlite4java.SWIGTYPE_p_sqlite3_stmt;
import com.almworks.sqlite4java._SQLiteManual;
import com.almworks.sqlite4java._SQLiteSwigged;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public final class SQLiteStatement {
    public static final SQLiteStatement DISPOSED = new SQLiteStatement();
    private final SQLParts mySqlParts;
    private SQLiteProfiler myProfiler;
    private SQLiteController myController;
    private SWIGTYPE_p_sqlite3_stmt myHandle;
    private boolean myHasRow;
    private boolean myHasBindings;
    private boolean myStepped;
    private int myColumnCount = -1;
    private List<BindStream> myBindStreams;
    private List<ColumnStream> myColumnStreams;
    private ProgressHandler myProgressHandler;
    private boolean myCancelled;

    SQLiteStatement(SQLiteController controller, SWIGTYPE_p_sqlite3_stmt handle, SQLParts sqlParts, SQLiteProfiler profiler) {
        assert (handle != null);
        assert (sqlParts.isFixed()) : sqlParts;
        this.myController = controller;
        this.myHandle = handle;
        this.mySqlParts = sqlParts;
        this.myProfiler = profiler;
        Internal.logFine(this, "instantiated");
    }

    private SQLiteStatement() {
        this.myController = SQLiteController.getDisposed(null);
        this.myHandle = null;
        this.mySqlParts = new SQLParts().fix();
        this.myProfiler = null;
    }

    public boolean isDisposed() {
        return this.myHandle == null;
    }

    public SQLParts getSqlParts() {
        return this.mySqlParts;
    }

    public void dispose() {
        if (this.myHandle == null) {
            return;
        }
        try {
            this.myController.validate();
        }
        catch (SQLiteException e) {
            Internal.recoverableError(this, "invalid dispose: " + e, true);
            return;
        }
        Internal.logFine(this, "disposing");
        this.myController.dispose(this);
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SQLiteStatement reset(boolean clearBindings) throws SQLiteException {
        this.myController.validate();
        boolean fineLogging = Internal.isFineLogging();
        if (fineLogging) {
            Internal.logFine(this, "reset(" + clearBindings + ")");
        }
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.clearColumnStreams();
        if (this.myStepped) {
            if (fineLogging) {
                Internal.logFine(this, "resetting");
            }
            _SQLiteSwigged.sqlite3_reset(handle);
        }
        this.myHasRow = false;
        this.myStepped = false;
        this.myColumnCount = -1;
        if (clearBindings && this.myHasBindings) {
            if (fineLogging) {
                Internal.logFine(this, "clearing bindings");
            }
            int rc = _SQLiteSwigged.sqlite3_clear_bindings(handle);
            this.myController.throwResult(rc, "reset.clearBindings()", this);
            this.clearBindStreams(false);
            this.myHasBindings = false;
        }
        SQLiteStatement sQLiteStatement = this;
        synchronized (sQLiteStatement) {
            this.myCancelled = false;
        }
        return this;
    }

    public SQLiteStatement reset() throws SQLiteException {
        return this.reset(true);
    }

    public SQLiteStatement clearBindings() throws SQLiteException {
        this.myController.validate();
        Internal.logFine(this, "clearBindings");
        if (this.myHasBindings) {
            Internal.logFine(this, "clearing bindings");
            int rc = _SQLiteSwigged.sqlite3_clear_bindings(this.handle());
            this.myController.throwResult(rc, "clearBindings()", this);
            this.clearBindStreams(false);
        }
        this.myHasBindings = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean step() throws SQLiteException {
        int rc;
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "step");
        }
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        ProgressHandler ph = this.prepareStep();
        try {
            SQLiteProfiler profiler = this.myProfiler;
            long from = profiler == null ? 0L : System.nanoTime();
            rc = _SQLiteSwigged.sqlite3_step(handle);
            if (profiler != null) {
                profiler.reportStep(this.myStepped, this.mySqlParts.toString(), from, System.nanoTime(), rc);
            }
        }
        finally {
            this.finalizeStep(ph, "step");
        }
        this.stepResult(rc, "step");
        return this.myHasRow;
    }

    public SQLiteStatement stepThrough() throws SQLiteException {
        while (this.step()) {
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        ProgressHandler handler;
        SQLiteStatement sQLiteStatement = this;
        synchronized (sQLiteStatement) {
            this.myCancelled = true;
            handler = this.myProgressHandler;
        }
        if (handler != null) {
            handler.cancel();
        }
    }

    public boolean hasRow() {
        return this.myHasRow;
    }

    public boolean hasBindings() {
        return this.myHasBindings;
    }

    public boolean hasStepped() {
        return this.myStepped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadInts(int column, int[] buffer, int offset, int length) throws SQLiteException {
        int rc;
        int r;
        this.myController.validate();
        if (buffer == null || length <= 0 || offset < 0 || offset + length > buffer.length) {
            assert (false);
            return 0;
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "loadInts(" + column + "," + offset + "," + length + ")");
        }
        if (this.myStepped && !this.myHasRow) {
            return 0;
        }
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        ProgressHandler ph = this.prepareStep();
        try {
            _SQLiteManual manual = this.myController.getSQLiteManual();
            SQLiteProfiler profiler = this.myProfiler;
            long from = profiler == null ? 0L : System.nanoTime();
            r = manual.wrapper_load_ints(handle, column, buffer, offset, length);
            rc = manual.getLastReturnCode();
            if (profiler != null) {
                profiler.reportLoadInts(this.myStepped, this.mySqlParts.toString(), from, System.nanoTime(), rc, r);
            }
        }
        finally {
            this.finalizeStep(ph, "loadInts");
        }
        this.stepResult(rc, "loadInts");
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int loadLongs(int column, long[] buffer, int offset, int length) throws SQLiteException {
        int rc;
        int r;
        this.myController.validate();
        if (buffer == null || length <= 0 || offset < 0 || offset + length > buffer.length) {
            assert (false);
            return 0;
        }
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "loadLongs(" + column + "," + offset + "," + length + ")");
        }
        if (this.myStepped && !this.myHasRow) {
            return 0;
        }
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        ProgressHandler ph = this.prepareStep();
        try {
            _SQLiteManual manual = this.myController.getSQLiteManual();
            SQLiteProfiler profiler = this.myProfiler;
            long from = profiler == null ? 0L : System.nanoTime();
            r = manual.wrapper_load_longs(handle, column, buffer, offset, length);
            rc = manual.getLastReturnCode();
            if (profiler != null) {
                profiler.reportLoadLongs(this.myStepped, this.mySqlParts.toString(), from, System.nanoTime(), rc, r);
            }
        }
        finally {
            this.finalizeStep(ph, "loadLongs");
        }
        this.stepResult(rc, "loadLongs");
        return r;
    }

    public int getBindParameterCount() throws SQLiteException {
        this.myController.validate();
        return _SQLiteSwigged.sqlite3_bind_parameter_count(this.handle());
    }

    public String getBindParameterName(int index) throws SQLiteException {
        this.myController.validate();
        return _SQLiteSwigged.sqlite3_bind_parameter_name(this.handle(), index);
    }

    public int getBindParameterIndex(String name) throws SQLiteException {
        this.myController.validate();
        return _SQLiteSwigged.sqlite3_bind_parameter_index(this.handle(), name);
    }

    private int getValidBindParameterIndex(String name) throws SQLiteException {
        int index = this.getBindParameterIndex(name);
        if (index == 0) {
            throw new SQLiteException(-11, "failed to find parameter with specified name (" + name + ")");
        }
        return index;
    }

    public SQLiteStatement bind(int index, double value) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind(" + index + "," + value + ")");
        }
        int rc = _SQLiteSwigged.sqlite3_bind_double(this.handle(), index, value);
        this.myController.throwResult(rc, "bind(double)", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bind(String name, double value) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value);
    }

    public SQLiteStatement bind(int index, int value) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind(" + index + "," + value + ")");
        }
        int rc = _SQLiteSwigged.sqlite3_bind_int(this.handle(), index, value);
        this.myController.throwResult(rc, "bind(int)", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bind(String name, int value) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value);
    }

    public SQLiteStatement bind(int index, long value) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind(" + index + "," + value + ")");
        }
        int rc = _SQLiteSwigged.sqlite3_bind_int64(this.handle(), index, value);
        this.myController.throwResult(rc, "bind(long)", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bind(String name, long value) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value);
    }

    public SQLiteStatement bind(int index, String value) throws SQLiteException {
        if (value == null) {
            Internal.logFine(this, "bind(null string)");
            return this.bindNull(index);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            if (value.length() <= 20) {
                Internal.logFine(this, "bind(" + index + "," + value + ")");
            } else {
                Internal.logFine(this, "bind(" + index + "," + value.substring(0, 20) + "....)");
            }
        }
        int rc = _SQLiteManual.sqlite3_bind_text(this.handle(), index, value);
        this.myController.throwResult(rc, "bind(String)", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bind(String name, String value) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value);
    }

    public SQLiteStatement bind(int index, byte[] value) throws SQLiteException {
        return value == null ? this.bindNull(index) : this.bind(index, value, 0, value.length);
    }

    public SQLiteStatement bind(String name, byte[] value) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value);
    }

    public SQLiteStatement bind(int index, byte[] value, int offset, int length) throws SQLiteException {
        if (value == null) {
            Internal.logFine(this, "bind(null blob)");
            return this.bindNull(index);
        }
        if (offset < 0 || offset + length > value.length) {
            throw new ArrayIndexOutOfBoundsException(value.length + " " + offset + " " + length);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind(" + index + ",[" + length + "])");
        }
        int rc = _SQLiteManual.sqlite3_bind_blob(this.handle(), index, value, offset, length);
        this.myController.throwResult(rc, "bind(blob)", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bind(String name, byte[] value, int offset, int length) throws SQLiteException {
        return this.bind(this.getValidBindParameterIndex(name), value, offset, length);
    }

    public SQLiteStatement bindZeroBlob(int index, int length) throws SQLiteException {
        if (length < 0) {
            Internal.logFine(this, "bind(null zeroblob)");
            return this.bindNull(index);
        }
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bindZeroBlob(" + index + "," + length + ")");
        }
        int rc = _SQLiteSwigged.sqlite3_bind_zeroblob(this.handle(), index, length);
        this.myController.throwResult(rc, "bindZeroBlob()", this);
        this.myHasBindings = true;
        return this;
    }

    public SQLiteStatement bindZeroBlob(String name, int length) throws SQLiteException {
        return this.bindZeroBlob(this.getValidBindParameterIndex(name), length);
    }

    public SQLiteStatement bindNull(int index) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bind_null(" + index + ")");
        }
        int rc = _SQLiteSwigged.sqlite3_bind_null(this.handle(), index);
        this.myController.throwResult(rc, "bind(null)", this);
        return this;
    }

    public SQLiteStatement bindNull(String name) throws SQLiteException {
        return this.bindNull(this.getValidBindParameterIndex(name));
    }

    public OutputStream bindStream(int index) throws SQLiteException {
        return this.bindStream(index, 0);
    }

    public OutputStream bindStream(String name) throws SQLiteException {
        return this.bindStream(this.getValidBindParameterIndex(name), 0);
    }

    public OutputStream bindStream(int index, int bufferSize) throws SQLiteException {
        this.myController.validate();
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "bindStream(" + index + "," + bufferSize + ")");
        }
        try {
            DirectBuffer buffer = this.myController.allocateBuffer(bufferSize);
            BindStream out = new BindStream(index, buffer);
            List<BindStream> list = this.myBindStreams;
            if (list == null) {
                this.myBindStreams = list = new ArrayList<BindStream>(1);
            }
            list.add(out);
            this.myHasBindings = true;
            return out;
        }
        catch (IOException e) {
            throw new SQLiteException(-99, "cannot allocate buffer", e);
        }
    }

    public OutputStream bindStream(String name, int bufferSize) throws SQLiteException {
        return this.bindStream(this.getValidBindParameterIndex(name), bufferSize);
    }

    public String columnString(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnString(" + column + ")");
        }
        _SQLiteManual sqlite = this.myController.getSQLiteManual();
        String result = sqlite.sqlite3_column_text(handle, column);
        this.myController.throwResult(sqlite.getLastReturnCode(), "columnString()", this);
        if (Internal.isFineLogging()) {
            if (result == null) {
                Internal.logFine(this, "columnString(" + column + ") is null");
            } else if (result.length() <= 20) {
                Internal.logFine(this, "columnString(" + column + ")=" + result);
            } else {
                Internal.logFine(this, "columnString(" + column + ")=" + result.substring(0, 20) + "....");
            }
        }
        return result;
    }

    public int columnInt(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnInt(" + column + ")");
        }
        int r = _SQLiteSwigged.sqlite3_column_int(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnInt(" + column + ")=" + r);
        }
        return r;
    }

    public double columnDouble(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnDouble(" + column + ")");
        }
        double r = _SQLiteSwigged.sqlite3_column_double(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnDouble(" + column + ")=" + r);
        }
        return r;
    }

    public long columnLong(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnLong(" + column + ")");
        }
        long r = _SQLiteSwigged.sqlite3_column_int64(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnLong(" + column + ")=" + r);
        }
        return r;
    }

    public byte[] columnBlob(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnBytes(" + column + ")");
        }
        _SQLiteManual sqlite = this.myController.getSQLiteManual();
        byte[] r = sqlite.sqlite3_column_blob(handle, column);
        this.myController.throwResult(sqlite.getLastReturnCode(), "columnBytes", this);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnBytes(" + column + ")=[" + (r == null ? "null" : Integer.valueOf(r.length)) + "]");
        }
        return r;
    }

    public InputStream columnStream(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, true);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnStream(" + column + ")");
        }
        _SQLiteManual sqlite = this.myController.getSQLiteManual();
        ByteBuffer buffer = sqlite.wrapper_column_buffer(handle, column);
        this.myController.throwResult(sqlite.getLastReturnCode(), "columnStream", this);
        if (buffer == null) {
            return null;
        }
        ColumnStream in = new ColumnStream(buffer);
        List<ColumnStream> table = this.myColumnStreams;
        if (table == null) {
            this.myColumnStreams = table = new ArrayList<ColumnStream>(1);
        }
        table.add(in);
        return in;
    }

    public boolean columnNull(int column) throws SQLiteException {
        this.myController.validate();
        int valueType = this.getColumnType(column, this.handle());
        return valueType == 5;
    }

    public int columnCount() throws SQLiteException {
        this.myController.validate();
        return this.getColumnCount(this.handle());
    }

    public Object columnValue(int column) throws SQLiteException {
        this.myController.validate();
        int valueType = this.getColumnType(column, this.handle());
        switch (valueType) {
            case 5: {
                return null;
            }
            case 2: {
                return this.columnDouble(column);
            }
            case 1: {
                long value = this.columnLong(column);
                if (value == (long)((int)value)) {
                    return (int)value;
                }
                return value;
            }
            case 3: {
                return this.columnString(column);
            }
            case 4: {
                return this.columnBlob(column);
            }
        }
        Internal.recoverableError(this, "value type " + valueType + " not yet supported", true);
        return null;
    }

    public int columnType(int column) throws SQLiteException {
        this.myController.validate();
        return this.getColumnType(column, this.handle());
    }

    public String getColumnName(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, false);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnName(" + column + ")");
        }
        String r = _SQLiteSwigged.sqlite3_column_name(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnName(" + column + ")=" + r);
        }
        return r;
    }

    public String getColumnTableName(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, false);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnTableName(" + column + ")");
        }
        String r = _SQLiteSwigged.sqlite3_column_table_name(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnTableName(" + column + ")=" + r);
        }
        return r;
    }

    public String getColumnDatabaseName(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, false);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnDatabaseName(" + column + ")");
        }
        String r = _SQLiteSwigged.sqlite3_column_database_name(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnDatabaseName(" + column + ")=" + r);
        }
        return r;
    }

    public String getColumnOriginName(int column) throws SQLiteException {
        this.myController.validate();
        SWIGTYPE_p_sqlite3_stmt handle = this.handle();
        this.checkColumn(column, handle, false);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnOriginName(" + column + ")");
        }
        String r = _SQLiteSwigged.sqlite3_column_origin_name(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnOriginName(" + column + ")=" + r);
        }
        return r;
    }

    public boolean isReadOnly() throws SQLiteException {
        this.myController.validate();
        return _SQLiteSwigged.sqlite3_stmt_readonly(this.handle()) != 0;
    }

    void clear() {
        this.clearBindStreams(false);
        this.clearColumnStreams();
        this.myHandle = null;
        this.myHasRow = false;
        this.myColumnCount = -1;
        this.myHasBindings = false;
        this.myStepped = false;
        this.myController = SQLiteController.getDisposed(this.myController);
        this.myProfiler = null;
        Internal.logFine(this, "cleared");
    }

    private void clearColumnStreams() {
        List<ColumnStream> table = this.myColumnStreams;
        if (table != null) {
            this.myColumnStreams = null;
            for (ColumnStream stream : table) {
                try {
                    stream.close();
                }
                catch (IOException e) {
                    Internal.logFine(this, e.toString());
                }
            }
        }
    }

    private void clearBindStreams(boolean bind) {
        List<BindStream> table = this.myBindStreams;
        if (table != null) {
            this.myBindStreams = null;
            for (BindStream stream : table) {
                if (bind && !stream.isDisposed()) {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        Internal.logFine(this, e.toString());
                    }
                    continue;
                }
                stream.dispose();
            }
            table.clear();
        }
    }

    private SWIGTYPE_p_sqlite3_stmt handle() throws SQLiteException {
        SWIGTYPE_p_sqlite3_stmt handle = this.myHandle;
        if (handle == null) {
            throw new SQLiteException(-96, null);
        }
        return handle;
    }

    private int getColumnType(int column, SWIGTYPE_p_sqlite3_stmt handle) throws SQLiteException {
        this.checkColumn(column, handle, false);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnType(" + column + ")");
        }
        int valueType = _SQLiteSwigged.sqlite3_column_type(handle, column);
        if (Internal.isFineLogging()) {
            Internal.logFine(this, "columnType(" + column + ")=" + valueType);
        }
        return valueType;
    }

    private void checkColumn(int column, SWIGTYPE_p_sqlite3_stmt handle, boolean mustHaveRow) throws SQLiteException {
        if (mustHaveRow && !this.myHasRow) {
            throw new SQLiteException(-95, null);
        }
        if (column < 0) {
            throw new SQLiteException(-94, String.valueOf(column));
        }
        int columnCount = this.getColumnCount(handle);
        if (column >= columnCount) {
            throw new SQLiteException(-94, column + "(" + columnCount + ")");
        }
    }

    private int getColumnCount(SWIGTYPE_p_sqlite3_stmt handle) {
        int cc = this.myColumnCount;
        if (cc < 0) {
            Internal.logFine(this, "asking column count");
            this.myColumnCount = cc = _SQLiteSwigged.sqlite3_column_count(handle);
            if (cc < 0) {
                Internal.recoverableError(this, "columnsCount=" + cc, true);
                cc = 0;
            } else if (Internal.isFineLogging()) {
                Internal.logFine(this, "columnCount=" + cc);
            }
        }
        return cc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProgressHandler prepareStep() throws SQLiteException {
        this.clearBindStreams(true);
        this.clearColumnStreams();
        ProgressHandler ph = this.myController.getProgressHandler();
        ph.reset();
        SQLiteStatement sQLiteStatement = this;
        synchronized (sQLiteStatement) {
            if (this.myCancelled) {
                throw new SQLiteInterruptedException();
            }
            this.myProgressHandler = ph;
        }
        return ph;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finalizeStep(ProgressHandler ph, String methodName) {
        SQLiteStatement sQLiteStatement = this;
        synchronized (sQLiteStatement) {
            this.myProgressHandler = null;
        }
        if (ph != null) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, methodName + " " + ph.getSteps() + " steps");
            }
            ph.reset();
        }
    }

    private void stepResult(int rc, String methodName) throws SQLiteException {
        if (!this.myStepped) {
            this.myColumnCount = -1;
        }
        this.myStepped = true;
        if (rc == 100) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, methodName + " ROW");
            }
            this.myHasRow = true;
        } else if (rc == 101) {
            if (Internal.isFineLogging()) {
                Internal.logFine(this, methodName + " DONE");
            }
            this.myHasRow = false;
        } else {
            this.myController.throwResult(rc, methodName + "()", this);
        }
    }

    public String toString() {
        return "[" + this.mySqlParts + "]" + this.myController;
    }

    SWIGTYPE_p_sqlite3_stmt statementHandle() {
        return this.myHandle;
    }

    private class ColumnStream
    extends InputStream {
        private ByteBuffer myBuffer;

        public ColumnStream(ByteBuffer buffer) {
            assert (buffer != null);
            this.myBuffer = buffer;
        }

        public int read() throws IOException {
            ByteBuffer buffer = this.getBuffer();
            if (buffer.remaining() <= 0) {
                return -1;
            }
            byte b = 0;
            try {
                b = buffer.get();
            }
            catch (BufferUnderflowException e) {
                Internal.logWarn(this, "weird: " + e);
                return -1;
            }
            return b & 0xFF;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            ByteBuffer buffer = this.getBuffer();
            int rem = buffer.remaining();
            if (rem <= 0) {
                return -1;
            }
            try {
                if (rem < len) {
                    len = rem;
                }
                buffer.get(b, off, len);
                return len;
            }
            catch (BufferUnderflowException e) {
                Internal.logWarn(this, "weird: " + e);
                return -1;
            }
        }

        public void close() throws IOException {
            this.myBuffer = null;
            List table = SQLiteStatement.this.myColumnStreams;
            if (table != null) {
                table.remove(this);
            }
        }

        public ByteBuffer getBuffer() throws IOException {
            ByteBuffer buffer = this.myBuffer;
            if (buffer == null) {
                throw new IOException("stream closed");
            }
            return buffer;
        }
    }

    private final class BindStream
    extends OutputStream {
        private final int myIndex;
        private DirectBuffer myBuffer;

        public BindStream(int index, DirectBuffer buffer) throws IOException {
            this.myIndex = index;
            this.myBuffer = buffer;
            this.myBuffer.data().clear();
        }

        public void write(int b) throws IOException {
            try {
                SQLiteStatement.this.myController.validate();
                ByteBuffer data = this.buffer(1);
                data.put((byte)b);
            }
            catch (SQLiteException e) {
                this.dispose();
                throw new IOException("cannot write: " + e);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            try {
                SQLiteStatement.this.myController.validate();
                ByteBuffer data = this.buffer(len);
                data.put(b, off, len);
            }
            catch (SQLiteException e) {
                this.dispose();
                throw new IOException("cannot write: " + e);
            }
        }

        private ByteBuffer buffer(int len) throws IOException, SQLiteException {
            DirectBuffer buffer = this.getBuffer();
            ByteBuffer data = buffer.data();
            if (data.remaining() < len) {
                DirectBuffer newBuffer = null;
                try {
                    newBuffer = SQLiteStatement.this.myController.allocateBuffer(buffer.getCapacity() + len);
                }
                catch (IOException e) {
                    this.dispose();
                    throw e;
                }
                ByteBuffer newData = newBuffer.data();
                data.flip();
                newData.put(data);
                SQLiteStatement.this.myController.freeBuffer(buffer);
                data = newData;
                this.myBuffer = newBuffer;
                assert (data.remaining() >= len) : data.capacity();
            }
            return data;
        }

        public void close() throws IOException {
            try {
                SQLiteStatement.this.myController.validate();
                DirectBuffer buffer = this.myBuffer;
                if (buffer == null) {
                    return;
                }
                if (Internal.isFineLogging()) {
                    Internal.logFine(SQLiteStatement.this, "BindStream.close:bind([" + buffer.data().capacity() + "])");
                }
                int rc = _SQLiteManual.wrapper_bind_buffer(SQLiteStatement.this.handle(), this.myIndex, buffer);
                this.dispose();
                SQLiteStatement.this.myController.throwResult(rc, "bind(buffer)", SQLiteStatement.this);
            }
            catch (SQLiteException e) {
                throw new IOException("cannot write: " + e);
            }
        }

        public boolean isDisposed() {
            return this.myBuffer == null;
        }

        private DirectBuffer getBuffer() throws IOException {
            DirectBuffer buffer = this.myBuffer;
            if (buffer == null) {
                throw new IOException("stream discarded");
            }
            if (!buffer.isValid()) {
                throw new IOException("buffer discarded");
            }
            if (!buffer.isUsed()) {
                throw new IOException("buffer not used");
            }
            return buffer;
        }

        public void dispose() {
            List list;
            DirectBuffer buffer = this.myBuffer;
            if (buffer != null) {
                this.myBuffer = null;
                SQLiteStatement.this.myController.freeBuffer(buffer);
            }
            if ((list = SQLiteStatement.this.myBindStreams) != null) {
                list.remove(this);
            }
        }
    }
}

