/*
 * Decompiled with CFR 0.152.
 */
package javolution.util.stripped;

import java.io.ObjectStreamException;
import java.util.Comparator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FastComparator<T>
implements Comparator<T> {
    public static boolean _Rehash = FastComparator.isPoorSystemHash();
    public static final FastComparator<Object> DEFAULT = new Default<Object>();
    public static final FastComparator<Object> DIRECT = new Direct<Object>();
    public static final FastComparator<Object> REHASH = new Rehash<Object>();
    public static final FastComparator<String> STRING = new StringComparator();
    public static final FastComparator<Object> IDENTITY = new Identity();
    public static final FastComparator<CharSequence> LEXICAL = new Lexical();

    private static boolean isPoorSystemHash() {
        boolean[] dist = new boolean[64];
        for (int i = 0; i < dist.length; ++i) {
            dist[new Object().hashCode() & dist.length - 1] = true;
        }
        int occupied = 0;
        int i = 0;
        while (i < dist.length) {
            occupied += dist[i++] ? 1 : 0;
        }
        return occupied < dist.length >> 2;
    }

    public abstract int hashCodeOf(T var1);

    public abstract boolean areEqual(T var1, T var2);

    @Override
    public abstract int compare(T var1, T var2);

    private static final class Lexical
    extends FastComparator {
        private Lexical() {
        }

        public int hashCodeOf(Object obj) {
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return obj.hashCode();
            }
            CharSequence chars = (CharSequence)obj;
            int h = 0;
            int length = chars.length();
            int i = 0;
            while (i < length) {
                h = 31 * h + chars.charAt(i++);
            }
            return h;
        }

        public boolean areEqual(Object o1, Object o2) {
            if (o1 instanceof String && o2 instanceof String) {
                return o1.equals(o2);
            }
            if (o1 instanceof CharSequence && o2 instanceof String) {
                CharSequence csq = (CharSequence)o1;
                String str = (String)o2;
                int length = str.length();
                if (csq.length() != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (str.charAt(i) == csq.charAt(i++)) continue;
                    return false;
                }
                return true;
            }
            if (o1 instanceof String && o2 instanceof CharSequence) {
                CharSequence csq = (CharSequence)o2;
                String str = (String)o1;
                int length = str.length();
                if (csq.length() != length) {
                    return false;
                }
                int i = 0;
                while (i < length) {
                    if (str.charAt(i) == csq.charAt(i++)) continue;
                    return false;
                }
                return true;
            }
            if (o1 == null || o2 == null) {
                return o1 == o2;
            }
            CharSequence csq1 = (CharSequence)o1;
            CharSequence csq2 = (CharSequence)o2;
            int length = csq1.length();
            if (csq2.length() != length) {
                return false;
            }
            int i = 0;
            while (i < length) {
                if (csq1.charAt(i) == csq2.charAt(i++)) continue;
                return false;
            }
            return true;
        }

        public int compare(Object left, Object right) {
            if (left instanceof String) {
                if (right instanceof String) {
                    return ((String)left).compareTo((String)right);
                }
                String seq1 = (String)left;
                CharSequence seq2 = (CharSequence)right;
                int i = 0;
                int n = Math.min(seq1.length(), seq2.length());
                while (n-- != 0) {
                    char c2;
                    char c1 = seq1.charAt(i);
                    if (c1 == (c2 = seq2.charAt(i++))) continue;
                    return c1 - c2;
                }
                return seq1.length() - seq2.length();
            }
            if (right instanceof String) {
                return -this.compare(right, left);
            }
            CharSequence seq1 = (CharSequence)left;
            CharSequence seq2 = (CharSequence)right;
            int i = 0;
            int n = Math.min(seq1.length(), seq2.length());
            while (n-- != 0) {
                char c2;
                char c1 = seq1.charAt(i);
                if (c1 == (c2 = seq2.charAt(i++))) continue;
                return c1 - c2;
            }
            return seq1.length() - seq2.length();
        }

        public String toString() {
            return "Lexical";
        }

        public Object readResolve() throws ObjectStreamException {
            return LEXICAL;
        }
    }

    private static final class Identity
    extends FastComparator {
        private Identity() {
        }

        public int hashCodeOf(Object obj) {
            int h = System.identityHashCode(obj);
            if (!_Rehash) {
                return h;
            }
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            return h ^ h >>> 10;
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == o2;
        }

        public int compare(Object o1, Object o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "Identity";
        }

        public Object readResolve() throws ObjectStreamException {
            return IDENTITY;
        }
    }

    private static final class StringComparator
    extends FastComparator {
        private StringComparator() {
        }

        public int hashCodeOf(Object obj) {
            if (obj == null) {
                return 0;
            }
            String str = (String)obj;
            int length = str.length();
            if (length == 0) {
                return 0;
            }
            return str.charAt(0) + str.charAt(length - 1) * 31 + str.charAt(length >> 1) * 1009 + str.charAt(length >> 2) * 27583 + str.charAt(length - 1 - (length >> 2)) * 73408859;
        }

        public boolean areEqual(Object o1, Object o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        public int compare(Object o1, Object o2) {
            return ((String)o1).compareTo((String)o2);
        }

        public String toString() {
            return "String";
        }

        public Object readResolve() throws ObjectStreamException {
            return STRING;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Rehash<T>
    extends FastComparator<T> {
        private Rehash() {
        }

        @Override
        public int hashCodeOf(T obj) {
            if (obj == null) {
                return 0;
            }
            int h = obj.hashCode();
            h += ~(h << 9);
            h ^= h >>> 14;
            h += h << 4;
            return h ^ h >>> 10;
        }

        @Override
        public boolean areEqual(T o1, T o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "Rehash";
        }

        public Object readResolve() throws ObjectStreamException {
            return REHASH;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Direct<T>
    extends FastComparator<T> {
        private Direct() {
        }

        @Override
        public int hashCodeOf(T obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        @Override
        public boolean areEqual(T o1, T o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "Direct";
        }

        public Object readResolve() throws ObjectStreamException {
            return DIRECT;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Default<T>
    extends FastComparator<T> {
        private Default() {
        }

        @Override
        public int hashCodeOf(T obj) {
            return obj == null ? 0 : (_Rehash ? REHASH.hashCodeOf(obj) : obj.hashCode());
        }

        @Override
        public boolean areEqual(T o1, T o2) {
            return o1 == null ? o2 == null : o1 == o2 || o1.equals(o2);
        }

        @Override
        public int compare(T o1, T o2) {
            return ((Comparable)o1).compareTo(o2);
        }

        public String toString() {
            return "Default";
        }

        public Object readResolve() throws ObjectStreamException {
            return DEFAULT;
        }
    }
}

