/*
 * Decompiled with CFR 0.152.
 */
package com.almworks.sqlite4java;

import com.almworks.sqlite4java.SWIGTYPE_p_direct_buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.LongBuffer;

class ProgressHandler {
    public static final ProgressHandler DISPOSED = new ProgressHandler();
    private static final int OFFSET_STEPCOUNT = 1;
    private static final int OFFSET_CANCEL = 0;
    private final int myStepsPerCallback;
    private SWIGTYPE_p_direct_buffer myPointer;
    private ByteBuffer myBuffer;
    private LongBuffer myLongs;

    public ProgressHandler(SWIGTYPE_p_direct_buffer pointer, ByteBuffer buffer, int stepsPerCallback) {
        this.myStepsPerCallback = stepsPerCallback;
        assert (buffer.isDirect());
        assert (buffer.capacity() == 16) : buffer.capacity();
        this.myPointer = pointer;
        this.myBuffer = buffer;
        this.myLongs = buffer.order(ByteOrder.nativeOrder()).asLongBuffer();
        assert (this.myLongs.capacity() == 2);
    }

    private ProgressHandler() {
        this.myStepsPerCallback = 0;
    }

    public synchronized SWIGTYPE_p_direct_buffer dispose() {
        SWIGTYPE_p_direct_buffer ptr = this.myPointer;
        this.myBuffer = null;
        this.myPointer = null;
        this.myLongs = null;
        return ptr;
    }

    public synchronized void reset() {
        if (this.myLongs == null) {
            return;
        }
        this.myLongs.put(0, 0L);
        this.myLongs.put(1, 0L);
    }

    public synchronized void cancel() {
        if (this.myLongs == null) {
            return;
        }
        this.myLongs.put(0, 1L);
    }

    public synchronized long getSteps() {
        if (this.myLongs == null) {
            return -1L;
        }
        return this.myLongs.get(1) * (long)this.myStepsPerCallback;
    }
}

