/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.ICodeEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeChildDatatypeDefinition
extends BaseRuntimeDeclaredChildDefinition {
    private Class<? extends ICodeEnum> myCodeType;
    private Class<? extends IBase> myDatatype;
    private BaseRuntimeElementDefinition<?> myElementDefinition;

    public BaseRuntimeChildDatatypeDefinition(Field theField, String theElementName, Child theChildAnnotation, Description theDescriptionAnnotation, Class<? extends IBase> theDatatype) {
        super(theField, theChildAnnotation, theDescriptionAnnotation, theElementName);
        assert (!Modifier.isInterface(theDatatype.getModifiers())) : "Type of " + theDatatype + " shouldn't be here";
        this.myDatatype = theDatatype;
    }

    @Override
    public String getChildNameByDatatype(Class<? extends IBase> theDatatype) {
        Class<? extends IBase> nextType = theDatatype;
        while (!nextType.equals(Object.class)) {
            if (this.myDatatype.equals(nextType)) {
                return this.getElementName();
            }
            nextType = nextType.getSuperclass();
        }
        return null;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildElementDefinitionByDatatype(Class<? extends IBase> theDatatype) {
        Class<? extends IBase> nextType = theDatatype;
        while (!nextType.equals(Object.class)) {
            if (this.myDatatype.equals(nextType)) {
                return this.myElementDefinition;
            }
            nextType = nextType.getSuperclass();
        }
        return null;
    }

    @Override
    public BaseRuntimeElementDefinition<?> getChildByName(String theName) {
        if (this.getElementName().equals(theName)) {
            return this.myElementDefinition;
        }
        return null;
    }

    public Class<? extends ICodeEnum> getCodeType() {
        return this.myCodeType;
    }

    public Class<? extends IBase> getDatatype() {
        return this.myDatatype;
    }

    @Override
    public Set<String> getValidChildNames() {
        return Collections.singleton(this.getElementName());
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myElementDefinition = theClassToElementDefinitions.get(this.getDatatype());
        assert (this.myElementDefinition != null) : "Unknown type: " + this.getDatatype();
    }

    public void setCodeType(Class<? extends ICodeEnum> theType) {
        if (this.myElementDefinition != null) {
            throw new IllegalStateException("Can not set code type at runtime");
        }
        this.myCodeType = theType;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getElementName() + "]";
    }
}

