/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeDeclaredChildDefinition
extends BaseRuntimeChildDefinition {
    private final BaseRuntimeChildDefinition.IAccessor myAccessor;
    private final String myElementName;
    private final Field myField;
    private final String myFormalDefinition;
    private final int myMax;
    private final int myMin;
    private boolean myModifier;
    private final BaseRuntimeChildDefinition.IMutator myMutator;
    private final String myShortDefinition;
    private boolean mySummary;

    BaseRuntimeDeclaredChildDefinition(Field theField, Child theChildAnnotation, Description theDescriptionAnnotation, String theElementName) throws ConfigurationException {
        Validate.notNull((Object)theField, (String)"No field speficied", (Object[])new Object[0]);
        Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)theChildAnnotation.min(), (String)"Min must be >= 0");
        Validate.isTrue((theChildAnnotation.max() == -1 || theChildAnnotation.max() >= theChildAnnotation.min() ? 1 : 0) != 0, (String)"Max must be >= Min (unless it is -1 / unlimited)", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)theElementName, (String)"Element name must not be blank", (Object[])new Object[0]);
        this.myField = theField;
        this.myMin = theChildAnnotation.min();
        this.myMax = theChildAnnotation.max();
        this.mySummary = theChildAnnotation.summary();
        this.myModifier = theChildAnnotation.modifier();
        this.myElementName = theElementName;
        if (theDescriptionAnnotation != null) {
            this.myShortDefinition = theDescriptionAnnotation.shortDefinition();
            this.myFormalDefinition = theDescriptionAnnotation.formalDefinition();
        } else {
            this.myShortDefinition = null;
            this.myFormalDefinition = null;
        }
        this.myField.setAccessible(true);
        if (List.class.equals(this.myField.getType())) {
            this.myAccessor = new FieldListAccessor();
            this.myMutator = new FieldListMutator();
        } else {
            this.myAccessor = new FieldPlainAccessor();
            this.myMutator = new FieldPlainMutator();
        }
    }

    @Override
    public BaseRuntimeChildDefinition.IAccessor getAccessor() {
        return this.myAccessor;
    }

    @Override
    public String getElementName() {
        return this.myElementName;
    }

    public Field getField() {
        return this.myField;
    }

    public String getFormalDefinition() {
        return this.myFormalDefinition;
    }

    @Override
    public int getMax() {
        return this.myMax;
    }

    @Override
    public int getMin() {
        return this.myMin;
    }

    @Override
    public BaseRuntimeChildDefinition.IMutator getMutator() {
        return this.myMutator;
    }

    public String getShortDefinition() {
        return this.myShortDefinition;
    }

    public BaseRuntimeElementDefinition<?> getSingleChildOrThrow() {
        if (this.getValidChildNames().size() != 1) {
            throw new IllegalStateException("This child has " + this.getValidChildNames().size() + " children, expected 1. This is a HAPI bug. Found: " + this.getValidChildNames());
        }
        return this.getChildByName(this.getValidChildNames().iterator().next());
    }

    public boolean isModifier() {
        return this.myModifier;
    }

    @Override
    public boolean isSummary() {
        return this.mySummary;
    }

    protected final class FieldPlainMutator
    implements BaseRuntimeChildDefinition.IMutator {
        protected FieldPlainMutator() {
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            try {
                BaseRuntimeDeclaredChildDefinition.this.myField.set(theTarget, theValue);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to set value", e);
            }
        }

        @Override
        public void setValue(Object theTarget, IBase theValue) {
            this.addValue(theTarget, theValue);
        }
    }

    private final class FieldPlainAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldPlainAccessor() {
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            try {
                Object values = BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
                if (values == null) {
                    return Collections.emptyList();
                }
                List<IBase> retVal = Collections.singletonList((IBase)values);
                return retVal;
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to get value", e);
            }
        }
    }

    protected final class FieldListMutator
    implements BaseRuntimeChildDefinition.IMutator {
        protected FieldListMutator() {
        }

        @Override
        public void addValue(Object theTarget, IBase theValue) {
            this.addValue(theTarget, theValue, false);
        }

        private void addValue(Object theTarget, IBase theValue, boolean theClear) {
            try {
                ArrayList<IBase> existingList = (ArrayList<IBase>)BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
                if (existingList == null) {
                    existingList = new ArrayList<IBase>(2);
                    BaseRuntimeDeclaredChildDefinition.this.myField.set(theTarget, existingList);
                }
                if (theClear) {
                    existingList.clear();
                }
                existingList.add(theValue);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to set value", e);
            }
        }

        @Override
        public void setValue(Object theTarget, IBase theValue) {
            this.addValue(theTarget, theValue, true);
        }
    }

    private final class FieldListAccessor
    implements BaseRuntimeChildDefinition.IAccessor {
        private FieldListAccessor() {
        }

        @Override
        public List<IBase> getValues(Object theTarget) {
            List<IBase> retVal;
            try {
                retVal = (List<IBase>)BaseRuntimeDeclaredChildDefinition.this.myField.get(theTarget);
            }
            catch (Exception e) {
                throw new ConfigurationException("Failed to get value", e);
            }
            if (retVal == null) {
                retVal = Collections.emptyList();
            }
            return retVal;
        }
    }
}

