/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.parser.DataFormatException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeElementCompositeDefinition<T extends IBase>
extends BaseRuntimeElementDefinition<T> {
    private List<BaseRuntimeChildDefinition> myChildren = new ArrayList<BaseRuntimeChildDefinition>();
    private List<BaseRuntimeChildDefinition> myChildrenAndExtensions;
    private Map<String, BaseRuntimeChildDefinition> myNameToChild = new HashMap<String, BaseRuntimeChildDefinition>();

    public BaseRuntimeElementCompositeDefinition(String theName, Class<? extends T> theImplementingClass, boolean theStandardType) {
        super(theName, theImplementingClass, theStandardType);
    }

    void addChild(BaseRuntimeChildDefinition theNext) {
        if (theNext == null) {
            throw new NullPointerException();
        }
        if (theNext.getExtensionUrl() != null) {
            throw new IllegalArgumentException("Shouldn't haven an extension URL, use addExtension instead");
        }
        this.myChildren.add(theNext);
    }

    public BaseRuntimeChildDefinition getChildByNameOrThrowDataFormatException(String theName) throws DataFormatException {
        BaseRuntimeChildDefinition retVal = this.myNameToChild.get(theName);
        if (retVal == null) {
            throw new DataFormatException("Unknown child name '" + theName + "' in element " + this.getName() + " - Valid names are: " + new TreeSet<String>(this.myNameToChild.keySet()));
        }
        return retVal;
    }

    public BaseRuntimeChildDefinition getChildByName(String theName) {
        BaseRuntimeChildDefinition retVal = this.myNameToChild.get(theName);
        return retVal;
    }

    public List<BaseRuntimeChildDefinition> getChildren() {
        return this.myChildren;
    }

    public List<BaseRuntimeChildDefinition> getChildrenAndExtension() {
        return this.myChildrenAndExtensions;
    }

    @Override
    public void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
        for (BaseRuntimeChildDefinition next : this.myChildren) {
            next.sealAndInitialize(theContext, theClassToElementDefinitions);
        }
        this.myNameToChild = new HashMap<String, BaseRuntimeChildDefinition>();
        for (BaseRuntimeChildDefinition next : this.myChildren) {
            if (next instanceof RuntimeChildChoiceDefinition) {
                String key = ((RuntimeChildChoiceDefinition)next).getElementName() + "[x]";
                this.myNameToChild.put(key, next);
            }
            for (String nextName : next.getValidChildNames()) {
                if (this.myNameToChild.containsKey(nextName)) {
                    throw new ConfigurationException("Duplicate child name[" + nextName + "] in Element[" + this.getName() + "]");
                }
                this.myNameToChild.put(nextName, next);
            }
        }
        this.myChildren = Collections.unmodifiableList(this.myChildren);
        this.myNameToChild = Collections.unmodifiableMap(this.myNameToChild);
        ArrayList<BaseRuntimeChildDefinition> children = new ArrayList<BaseRuntimeChildDefinition>();
        children.addAll(this.myChildren);
        children.addAll(this.getExtensionsModifier());
        children.addAll(this.getExtensionsNonModifier());
        this.myChildrenAndExtensions = Collections.unmodifiableList(children);
    }
}

