/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;

public abstract class BaseRuntimeElementDefinition<T extends IBase> {
    private static final Class<Void> VOID_CLASS = Void.class;
    private final String myName;
    private final Class<? extends T> myImplementingClass;
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensions = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private Map<String, RuntimeChildDeclaredExtensionDefinition> myUrlToExtension = new HashMap<String, RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private List<RuntimeChildDeclaredExtensionDefinition> myExtensionsNonModifier = new ArrayList<RuntimeChildDeclaredExtensionDefinition>();
    private final boolean myStandardType;
    private Map<Class<?>, Constructor<T>> myConstructors = Collections.synchronizedMap(new HashMap());

    public BaseRuntimeElementDefinition(String theName, Class<? extends T> theImplementingClass, boolean theStandardType) {
        assert (StringUtils.isNotBlank((CharSequence)theName));
        assert (theImplementingClass != null);
        String name = theName;
        if (name.endsWith("Dt")) {
            name = name.substring(0, name.length() - 2);
        }
        this.myName = name;
        this.myStandardType = theStandardType;
        this.myImplementingClass = theImplementingClass;
    }

    public boolean isStandardType() {
        return this.myStandardType;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }

    public void addExtension(RuntimeChildDeclaredExtensionDefinition theExtension) {
        if (theExtension == null) {
            throw new NullPointerException();
        }
        this.myExtensions.add(theExtension);
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensions() {
        return this.myExtensions;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsModifier() {
        return this.myExtensionsModifier;
    }

    public List<RuntimeChildDeclaredExtensionDefinition> getExtensionsNonModifier() {
        return this.myExtensionsNonModifier;
    }

    public RuntimeChildDeclaredExtensionDefinition getDeclaredExtension(String theExtensionUrl) {
        return this.myUrlToExtension.get(theExtensionUrl);
    }

    public String getName() {
        return this.myName;
    }

    public T newInstance() {
        return this.newInstance(null);
    }

    public T newInstance(Object theArgument) {
        try {
            if (theArgument == null) {
                return (T)((IBase)this.getConstructor(null).newInstance(null));
            }
            return (T)((IBase)this.getConstructor(theArgument).newInstance(theArgument));
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (IllegalArgumentException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (InvocationTargetException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
        catch (SecurityException e) {
            throw new ConfigurationException("Failed to instantiate type:" + this.getImplementingClass().getName(), e);
        }
    }

    private Constructor<T> getConstructor(Object theArgument) {
        Class<Void> argumentType = theArgument == null ? VOID_CLASS : theArgument.getClass();
        Constructor<Object> retVal = this.myConstructors.get(argumentType);
        if (retVal == null) {
            for (Constructor<?> next : this.getImplementingClass().getConstructors()) {
                if (argumentType == VOID_CLASS) {
                    if (next.getParameterTypes().length != 0) continue;
                    retVal = next;
                    break;
                }
                if (next.getParameterTypes().length != 1 || !next.getParameterTypes()[0].isAssignableFrom(argumentType)) continue;
                retVal = next;
                break;
            }
            if (retVal == null) {
                throw new ConfigurationException("Class " + this.getImplementingClass() + " has no constructor with a single argument of type " + argumentType);
            }
            this.myConstructors.put(argumentType, retVal);
        }
        return retVal;
    }

    public Class<? extends T> getImplementingClass() {
        return this.myImplementingClass;
    }

    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        for (BaseRuntimeChildDefinition baseRuntimeChildDefinition : this.myExtensions) {
            baseRuntimeChildDefinition.sealAndInitialize(theContext, theClassToElementDefinitions);
        }
        for (RuntimeChildDeclaredExtensionDefinition runtimeChildDeclaredExtensionDefinition : this.myExtensions) {
            String extUrl = runtimeChildDeclaredExtensionDefinition.getExtensionUrl();
            if (this.myUrlToExtension.containsKey(extUrl)) {
                throw new ConfigurationException("Duplicate extension URL[" + extUrl + "] in Element[" + this.getName() + "]");
            }
            this.myUrlToExtension.put(extUrl, runtimeChildDeclaredExtensionDefinition);
            if (runtimeChildDeclaredExtensionDefinition.isModifier()) {
                this.myExtensionsModifier.add(runtimeChildDeclaredExtensionDefinition);
                continue;
            }
            this.myExtensionsNonModifier.add(runtimeChildDeclaredExtensionDefinition);
        }
        this.myExtensions = Collections.unmodifiableList(this.myExtensions);
    }

    public abstract ChildTypeEnum getChildType();

    public static enum ChildTypeEnum {
        COMPOSITE_DATATYPE,
        PRIMITIVE_DATATYPE,
        RESOURCE,
        RESOURCE_REF,
        RESOURCE_BLOCK,
        PRIMITIVE_XHTML,
        UNDECL_EXT,
        EXTENSION_DECLARED,
        CONTAINED_RESOURCES,
        ID_DATATYPE,
        CONTAINED_RESOURCE_LIST,
        PRIMITIVE_XHTML_HL7ORG;

    }
}

