/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.ModelScanner;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.i18n.HapiLocalizer;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.view.ViewGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.JsonParser;
import ca.uhn.fhir.parser.LenientErrorHandler;
import ca.uhn.fhir.parser.XmlParser;
import ca.uhn.fhir.rest.client.IGenericClient;
import ca.uhn.fhir.rest.client.IRestfulClientFactory;
import ca.uhn.fhir.rest.client.RestfulClientFactory;
import ca.uhn.fhir.rest.client.api.IRestfulClient;
import ca.uhn.fhir.rest.server.IVersionSpecificBundleFactory;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.validation.FhirValidator;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.text.WordUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirContext {
    private static final List<Class<? extends IBaseResource>> EMPTY_LIST = Collections.emptyList();
    private static final Logger ourLog = LoggerFactory.getLogger(FhirContext.class);
    private volatile Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> myClassToElementDefinition = Collections.emptyMap();
    private volatile Map<String, RuntimeResourceDefinition> myIdToResourceDefinition = Collections.emptyMap();
    private HapiLocalizer myLocalizer = new HapiLocalizer();
    private volatile Map<String, BaseRuntimeElementDefinition<?>> myNameToElementDefinition = Collections.emptyMap();
    private volatile Map<String, RuntimeResourceDefinition> myNameToResourceDefinition = Collections.emptyMap();
    private volatile Map<String, Class<? extends IBaseResource>> myNameToResourceType;
    private volatile INarrativeGenerator myNarrativeGenerator;
    private volatile IParserErrorHandler myParserErrorHandler = new LenientErrorHandler();
    private volatile IRestfulClientFactory myRestfulClientFactory;
    private volatile RuntimeChildUndeclaredExtensionDefinition myRuntimeChildUndeclaredExtensionDefinition;
    private final IFhirVersion myVersion;
    private Map<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>> myVersionToNameToResourceType = Collections.emptyMap();

    public FhirContext() {
        this(EMPTY_LIST);
    }

    public FhirContext(Class<? extends IBaseResource> theResourceType) {
        this(FhirContext.toCollection(theResourceType));
    }

    public FhirContext(Class<?> ... theResourceTypes) {
        this(FhirContext.toCollection(theResourceTypes));
    }

    public FhirContext(Collection<Class<? extends IBaseResource>> theResourceTypes) {
        this(null, theResourceTypes);
    }

    public FhirContext(FhirVersionEnum theVersion) {
        this(theVersion, null);
    }

    private FhirContext(FhirVersionEnum theVersion, Collection<Class<? extends IBaseResource>> theResourceTypes) {
        if (theVersion != null) {
            if (!theVersion.isPresentOnClasspath()) {
                throw new IllegalStateException(this.getLocalizer().getMessage(FhirContext.class, "noStructuresForSpecifiedVersion", theVersion.name()));
            }
            this.myVersion = theVersion.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU1.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU1.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU2.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU2.getVersionImplementation();
        } else if (FhirVersionEnum.DSTU2_HL7ORG.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DSTU2_HL7ORG.getVersionImplementation();
        } else if (FhirVersionEnum.DEV.isPresentOnClasspath()) {
            this.myVersion = FhirVersionEnum.DEV.getVersionImplementation();
        } else {
            throw new IllegalStateException(this.getLocalizer().getMessage(FhirContext.class, "noStructures", new Object[0]));
        }
        if (theVersion == null) {
            ourLog.info("Creating new FhirContext with auto-detected version [{}]. It is recommended to explicitly select a version for future compatibility by invoking FhirContext.forDstuX()", (Object)this.myVersion.getVersion().name());
        } else {
            ourLog.info("Creating new FHIR context for FHIR version [{}]", (Object)this.myVersion.getVersion().name());
        }
        this.scanResourceTypes(this.toElementList(theResourceTypes));
    }

    private String createUnknownResourceNameError(String theResourceName, FhirVersionEnum theVersion) {
        return this.getLocalizer().getMessage(FhirContext.class, "unknownResourceName", new Object[]{theResourceName, theVersion});
    }

    public BaseRuntimeElementDefinition<?> getElementDefinition(Class<? extends IBase> theElementType) {
        BaseRuntimeElementDefinition<?> retVal = this.myClassToElementDefinition.get(theElementType);
        if (retVal == null) {
            retVal = this.scanDatatype(theElementType);
        }
        return retVal;
    }

    public BaseRuntimeElementDefinition<?> getElementDefinition(String theElementName) {
        return this.myNameToElementDefinition.get(theElementName);
    }

    int getElementDefinitionCount() {
        return this.myClassToElementDefinition.size();
    }

    public Collection<BaseRuntimeElementDefinition<?>> getElementDefinitions() {
        return Collections.unmodifiableCollection(this.myClassToElementDefinition.values());
    }

    public HapiLocalizer getLocalizer() {
        if (this.myLocalizer == null) {
            this.myLocalizer = new HapiLocalizer();
        }
        return this.myLocalizer;
    }

    public INarrativeGenerator getNarrativeGenerator() {
        return this.myNarrativeGenerator;
    }

    public RuntimeResourceDefinition getResourceDefinition(Class<? extends IBaseResource> theResourceType) {
        if (theResourceType == null) {
            throw new NullPointerException("theResourceType can not be null");
        }
        if (Modifier.isAbstract(theResourceType.getModifiers())) {
            throw new IllegalArgumentException("Can not scan abstract or interface class (resource definitions must be concrete classes): " + theResourceType.getName());
        }
        RuntimeResourceDefinition retVal = (RuntimeResourceDefinition)this.myClassToElementDefinition.get(theResourceType);
        if (retVal == null) {
            retVal = this.scanResourceType(theResourceType);
        }
        return retVal;
    }

    public RuntimeResourceDefinition getResourceDefinition(FhirVersionEnum theVersion, String theResourceName) {
        Class<? extends IBaseResource> resourceType;
        Validate.notNull((Object)((Object)theVersion), (String)"theVersion can not be null", (Object[])new Object[0]);
        if (theVersion.equals((Object)this.myVersion.getVersion())) {
            return this.getResourceDefinition(theResourceName);
        }
        Map<String, Class<? extends IBaseResource>> nameToType = this.myVersionToNameToResourceType.get((Object)theVersion);
        if (nameToType == null) {
            nameToType = new HashMap<String, Class<? extends IBaseResource>>();
            ModelScanner.scanVersionPropertyFile(null, nameToType, theVersion);
            HashMap<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>> newVersionToNameToResourceType = new HashMap<FhirVersionEnum, Map<String, Class<? extends IBaseResource>>>();
            newVersionToNameToResourceType.putAll(this.myVersionToNameToResourceType);
            newVersionToNameToResourceType.put(theVersion, nameToType);
            this.myVersionToNameToResourceType = newVersionToNameToResourceType;
        }
        if ((resourceType = nameToType.get(theResourceName.toLowerCase())) == null) {
            throw new DataFormatException(this.createUnknownResourceNameError(theResourceName, theVersion));
        }
        return this.getResourceDefinition(resourceType);
    }

    public RuntimeResourceDefinition getResourceDefinition(IBaseResource theResource) {
        return this.getResourceDefinition(theResource.getClass());
    }

    public RuntimeResourceDefinition getResourceDefinition(String theResourceName) {
        Validate.notBlank((CharSequence)theResourceName, (String)"theResourceName must not be blank", (Object[])new Object[0]);
        String resourceName = theResourceName;
        if (Character.isLowerCase(resourceName.charAt(0))) {
            resourceName = WordUtils.capitalize((String)resourceName);
        }
        Validate.notBlank((CharSequence)resourceName, (String)"Resource name must not be blank", (Object[])new Object[0]);
        RuntimeResourceDefinition retVal = this.myNameToResourceDefinition.get(resourceName);
        if (retVal == null) {
            Class<? extends IBaseResource> clazz = this.myNameToResourceType.get(resourceName.toLowerCase());
            if (clazz == null) {
                throw new DataFormatException(this.createUnknownResourceNameError(resourceName, this.myVersion.getVersion()));
            }
            if (IBaseResource.class.isAssignableFrom(clazz)) {
                retVal = this.scanResourceType(clazz);
            }
        }
        return retVal;
    }

    public RuntimeResourceDefinition getResourceDefinitionById(String theId) {
        return this.myIdToResourceDefinition.get(theId);
    }

    public Collection<RuntimeResourceDefinition> getResourceDefinitions() {
        return this.myIdToResourceDefinition.values();
    }

    public IRestfulClientFactory getRestfulClientFactory() {
        if (this.myRestfulClientFactory == null) {
            this.myRestfulClientFactory = new RestfulClientFactory(this);
        }
        return this.myRestfulClientFactory;
    }

    public RuntimeChildUndeclaredExtensionDefinition getRuntimeChildUndeclaredExtensionDefinition() {
        return this.myRuntimeChildUndeclaredExtensionDefinition;
    }

    public IFhirVersion getVersion() {
        return this.myVersion;
    }

    public IVersionSpecificBundleFactory newBundleFactory() {
        return this.myVersion.newBundleFactory(this);
    }

    public IParser newJsonParser() {
        return new JsonParser(this, this.myParserErrorHandler);
    }

    public <T extends IRestfulClient> T newRestfulClient(Class<T> theClientType, String theServerBase) {
        return this.getRestfulClientFactory().newClient(theClientType, theServerBase);
    }

    public IGenericClient newRestfulGenericClient(String theServerBase) {
        return this.getRestfulClientFactory().newGenericClient(theServerBase);
    }

    public FhirTerser newTerser() {
        return new FhirTerser(this);
    }

    public FhirValidator newValidator() {
        return new FhirValidator(this);
    }

    public ViewGenerator newViewGenerator() {
        return new ViewGenerator(this);
    }

    public IParser newXmlParser() {
        return new XmlParser(this, this.myParserErrorHandler);
    }

    private BaseRuntimeElementDefinition<?> scanDatatype(Class<? extends IElement> theResourceType) {
        ArrayList<Class<? extends IElement>> resourceTypes = new ArrayList<Class<? extends IElement>>();
        resourceTypes.add(theResourceType);
        Map<Class<IBase>, BaseRuntimeElementDefinition<?>> defs = this.scanResourceTypes(resourceTypes);
        return defs.get(theResourceType);
    }

    private RuntimeResourceDefinition scanResourceType(Class<? extends IResource> theResourceType) {
        ArrayList<Class<? extends IElement>> resourceTypes = new ArrayList<Class<? extends IElement>>();
        resourceTypes.add(theResourceType);
        Map<Class<IBase>, BaseRuntimeElementDefinition<?>> defs = this.scanResourceTypes(resourceTypes);
        return (RuntimeResourceDefinition)defs.get(theResourceType);
    }

    private Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> scanResourceTypes(Collection<Class<? extends IElement>> theResourceTypes) {
        ModelScanner scanner = new ModelScanner(this, this.myVersion.getVersion(), this.myClassToElementDefinition, theResourceTypes);
        if (this.myRuntimeChildUndeclaredExtensionDefinition == null) {
            this.myRuntimeChildUndeclaredExtensionDefinition = scanner.getRuntimeChildUndeclaredExtensionDefinition();
        }
        HashMap nameToElementDefinition = new HashMap();
        nameToElementDefinition.putAll(this.myNameToElementDefinition);
        nameToElementDefinition.putAll(scanner.getNameToElementDefinitions());
        HashMap<String, RuntimeResourceDefinition> nameToResourceDefinition = new HashMap<String, RuntimeResourceDefinition>();
        nameToResourceDefinition.putAll(this.myNameToResourceDefinition);
        nameToResourceDefinition.putAll(scanner.getNameToResourceDefinition());
        HashMap classToElementDefinition = new HashMap();
        classToElementDefinition.putAll(this.myClassToElementDefinition);
        classToElementDefinition.putAll(scanner.getClassToElementDefinitions());
        HashMap<String, RuntimeResourceDefinition> idToElementDefinition = new HashMap<String, RuntimeResourceDefinition>();
        idToElementDefinition.putAll(this.myIdToResourceDefinition);
        idToElementDefinition.putAll(scanner.getIdToResourceDefinition());
        this.myNameToElementDefinition = nameToElementDefinition;
        this.myClassToElementDefinition = classToElementDefinition;
        this.myIdToResourceDefinition = idToElementDefinition;
        this.myNameToResourceDefinition = nameToResourceDefinition;
        this.myNameToResourceType = scanner.getNameToResourceType();
        return classToElementDefinition;
    }

    public void setLocalizer(HapiLocalizer theMessages) {
        this.myLocalizer = theMessages;
    }

    public void setNarrativeGenerator(INarrativeGenerator theNarrativeGenerator) {
        if (theNarrativeGenerator != null) {
            theNarrativeGenerator.setFhirContext(this);
        }
        this.myNarrativeGenerator = theNarrativeGenerator;
    }

    public void setParserErrorHandler(IParserErrorHandler theParserErrorHandler) {
        Validate.notNull((Object)theParserErrorHandler, (String)"theParserErrorHandler must not be null", (Object[])new Object[0]);
        this.myParserErrorHandler = theParserErrorHandler;
    }

    private List<Class<? extends IElement>> toElementList(Collection<Class<? extends IBaseResource>> theResourceTypes) {
        if (theResourceTypes == null) {
            return null;
        }
        ArrayList<Class<? extends IElement>> resTypes = new ArrayList<Class<? extends IElement>>();
        for (Class<? extends IBaseResource> next : theResourceTypes) {
            resTypes.add(next);
        }
        return resTypes;
    }

    @Deprecated
    public static FhirContext forDev() {
        return new FhirContext(FhirVersionEnum.DEV);
    }

    public static FhirContext forDstu1() {
        return new FhirContext(FhirVersionEnum.DSTU1);
    }

    public static FhirContext forDstu2() {
        return new FhirContext(FhirVersionEnum.DSTU2);
    }

    public static FhirContext forDstu2Hl7Org() {
        return new FhirContext(FhirVersionEnum.DSTU2_HL7ORG);
    }

    private static Collection<Class<? extends IBaseResource>> toCollection(Class<? extends IBaseResource> theResourceType) {
        ArrayList<Class<? extends IBaseResource>> retVal = new ArrayList<Class<? extends IBaseResource>>(1);
        retVal.add(theResourceType);
        return retVal;
    }

    private static List<Class<? extends IBaseResource>> toCollection(Class<?>[] theResourceTypes) {
        ArrayList<Class<? extends IBaseResource>> retVal = new ArrayList<Class<? extends IBaseResource>>(1);
        for (Class<?> clazz : theResourceTypes) {
            if (!IResource.class.isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz.getCanonicalName() + " is not an instance of " + IResource.class.getSimpleName());
            }
            retVal.add(clazz);
        }
        return retVal;
    }
}

