/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.IRuntimeDatatypeDefinition;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.ICompositeType;

public class RuntimeCompositeDatatypeDefinition
extends BaseRuntimeElementCompositeDefinition<ICompositeType>
implements IRuntimeDatatypeDefinition {
    private boolean mySpecialization;
    private Class<? extends IBaseDatatype> myProfileOfType;
    private BaseRuntimeElementDefinition<?> myProfileOf;

    public RuntimeCompositeDatatypeDefinition(DatatypeDef theDef, Class<? extends ICompositeType> theImplementingClass, boolean theStandardType) {
        super(theDef.name(), theImplementingClass, theStandardType);
        String resourceName = theDef.name();
        if (StringUtils.isBlank((CharSequence)resourceName)) {
            throw new ConfigurationException("Resource type @" + ResourceDef.class.getSimpleName() + " annotation contains no resource name: " + theImplementingClass.getCanonicalName());
        }
        this.mySpecialization = theDef.isSpecialization();
        this.myProfileOfType = theDef.profileOf();
        if (this.myProfileOfType.equals(IBaseDatatype.class)) {
            this.myProfileOfType = null;
        }
    }

    @Override
    public void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        super.sealAndInitialize(theContext, theClassToElementDefinitions);
        if (this.myProfileOfType != null) {
            this.myProfileOf = theClassToElementDefinitions.get(this.myProfileOfType);
            if (this.myProfileOf == null) {
                throw new ConfigurationException("Unknown profileOf value: " + this.myProfileOfType);
            }
        }
    }

    @Override
    public Class<? extends IBaseDatatype> getProfileOf() {
        return this.myProfileOfType;
    }

    @Override
    public boolean isSpecialization() {
        return this.mySpecialization;
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.COMPOSITE_DATATYPE;
    }

    @Override
    public boolean isProfileOf(Class<? extends IBaseDatatype> theType) {
        if (this.myProfileOfType != null) {
            if (this.myProfileOfType.equals(theType)) {
                return true;
            }
            if (this.myProfileOf instanceof IRuntimeDatatypeDefinition) {
                return ((IRuntimeDatatypeDefinition)((Object)this.myProfileOf)).isProfileOf(theType);
            }
        }
        return false;
    }
}

