/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.context;

import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseResource;

public class RuntimeResourceReferenceDefinition
extends BaseRuntimeElementDefinition<BaseResourceReferenceDt> {
    private final List<Class<? extends IBaseResource>> myResourceTypes;
    private HashMap<Class<? extends IBaseResource>, RuntimeResourceDefinition> myResourceTypeToDefinition;

    public RuntimeResourceReferenceDefinition(String theName, List<Class<? extends IBaseResource>> theResourceTypes, boolean theStandardType) {
        super(theName, BaseResourceReferenceDt.class, theStandardType);
        if (theResourceTypes == null || theResourceTypes.isEmpty()) {
            throw new ConfigurationException("Element '" + theName + "' has no resource types noted");
        }
        this.myResourceTypes = theResourceTypes;
    }

    public List<Class<? extends IBaseResource>> getResourceTypes() {
        return this.myResourceTypes;
    }

    @Override
    void sealAndInitialize(FhirContext theContext, Map<Class<? extends IBase>, BaseRuntimeElementDefinition<?>> theClassToElementDefinitions) {
        this.myResourceTypeToDefinition = new HashMap();
        for (Class<? extends IBaseResource> next : this.myResourceTypes) {
            if (next.equals(IResource.class) || next.equals(IAnyResource.class) || next.equals(IBaseResource.class)) continue;
            RuntimeResourceDefinition definition = (RuntimeResourceDefinition)theClassToElementDefinitions.get(next);
            if (definition == null) {
                throw new ConfigurationException("Couldn't find definition for: " + next.getCanonicalName());
            }
            this.myResourceTypeToDefinition.put(next, definition);
        }
    }

    @Override
    public BaseRuntimeElementDefinition.ChildTypeEnum getChildType() {
        return BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE_REF;
    }

    public RuntimeResourceDefinition getDefinitionForResourceType(Class<? extends IResource> theType) {
        RuntimeResourceDefinition retVal = this.myResourceTypeToDefinition.get(theType);
        if (retVal == null) {
            throw new ConfigurationException("Unknown type:  " + theType.getCanonicalName());
        }
        return retVal;
    }
}

