/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.i18n;

import java.text.MessageFormat;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;

public class HapiLocalizer {
    private ResourceBundle myBundle;
    private final Map<String, MessageFormat> myKeyToMessageFormat = new ConcurrentHashMap<String, MessageFormat>();

    public HapiLocalizer() {
        this.myBundle = ResourceBundle.getBundle(HapiLocalizer.class.getPackage().getName() + ".hapi-messages");
    }

    public String getMessage(Class<?> theType, String theKey, Object ... theParameters) {
        return this.getMessage(theType.getName() + '.' + theKey, theParameters);
    }

    public String getMessage(String theQualifiedKey, Object ... theParameters) {
        if (theParameters != null && theParameters.length > 0) {
            MessageFormat format = this.myKeyToMessageFormat.get(theQualifiedKey);
            if (format != null) {
                return format.format(theParameters).toString();
            }
            String formatString = this.myBundle.getString(theQualifiedKey);
            if (formatString == null) {
                formatString = "!MESSAGE!";
            }
            format = new MessageFormat(formatString);
            this.myKeyToMessageFormat.put(theQualifiedKey, format);
            return format.format(theParameters).toString();
        }
        String retVal = this.myBundle.getString(theQualifiedKey);
        if (retVal == null) {
            retVal = "!MESSAGE!";
        }
        return retVal;
    }
}

