/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBaseDatatype;

public abstract class BaseElement
implements IElement,
ISupportsUndeclaredExtensions {
    private List<ExtensionDt> myUndeclaredExtensions;
    private List<ExtensionDt> myUndeclaredModifierExtensions;

    @Override
    public ExtensionDt addUndeclaredExtension(boolean theIsModifier, String theUrl, IBaseDatatype theValue) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        Validate.notNull((Object)theValue, (String)"Value must not be null", (Object[])new Object[0]);
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl, theValue);
        if (theIsModifier) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(retVal);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(retVal);
        }
        return retVal;
    }

    @Override
    public ExtensionDt addUndeclaredExtension(boolean theIsModifier, String theUrl) {
        Validate.notEmpty((CharSequence)theUrl, (String)"URL must be populated", (Object[])new Object[0]);
        ExtensionDt retVal = new ExtensionDt(theIsModifier, theUrl);
        if (theIsModifier) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(retVal);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(retVal);
        }
        return retVal;
    }

    @Override
    public void addUndeclaredExtension(ExtensionDt theExtension) {
        Validate.notNull((Object)theExtension, (String)"Extension can not be null", (Object[])new Object[0]);
        if (theExtension.isModifier()) {
            this.getUndeclaredModifierExtensions();
            this.myUndeclaredModifierExtensions.add(theExtension);
        } else {
            this.getUndeclaredExtensions();
            this.myUndeclaredExtensions.add(theExtension);
        }
    }

    @Override
    public List<ExtensionDt> getAllUndeclaredExtensions() {
        ArrayList<ExtensionDt> retVal = new ArrayList<ExtensionDt>();
        if (this.myUndeclaredExtensions != null) {
            retVal.addAll(this.myUndeclaredExtensions);
        }
        if (this.myUndeclaredModifierExtensions != null) {
            retVal.addAll(this.myUndeclaredModifierExtensions);
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public List<ExtensionDt> getUndeclaredExtensions() {
        if (this.myUndeclaredExtensions == null) {
            this.myUndeclaredExtensions = new ArrayList<ExtensionDt>();
        }
        return this.myUndeclaredExtensions;
    }

    @Override
    public List<ExtensionDt> getUndeclaredExtensionsByUrl(String theUrl) {
        Validate.notNull((Object)theUrl, (String)"URL can not be null", (Object[])new Object[0]);
        ArrayList<ExtensionDt> retVal = new ArrayList<ExtensionDt>();
        for (ExtensionDt next : this.getAllUndeclaredExtensions()) {
            if (!theUrl.equals(next.getUrlAsString())) continue;
            retVal.add(next);
        }
        return Collections.unmodifiableList(retVal);
    }

    @Override
    public List<ExtensionDt> getUndeclaredModifierExtensions() {
        if (this.myUndeclaredModifierExtensions == null) {
            this.myUndeclaredModifierExtensions = new ArrayList<ExtensionDt>();
        }
        return this.myUndeclaredModifierExtensions;
    }

    protected boolean isBaseEmpty() {
        if (this.myUndeclaredExtensions != null) {
            for (ExtensionDt next : this.myUndeclaredExtensions) {
                if (next.isEmpty()) continue;
                return false;
            }
        }
        if (this.myUndeclaredModifierExtensions != null) {
            for (ExtensionDt next : this.myUndeclaredModifierExtensions) {
                if (next.isEmpty()) continue;
                return false;
            }
        }
        return true;
    }
}

