/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.parser.DataFormatException;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.hl7.fhir.instance.model.api.IPrimitiveType;

public abstract class BasePrimitive<T>
extends BaseIdentifiableElement
implements IPrimitiveDatatype<T>,
Externalizable {
    private T myCoercedValue;
    private String myStringValue;

    protected abstract String encode(T var1);

    public boolean equals(Object theObj) {
        if (theObj == null) {
            return false;
        }
        if (theObj.getClass() != this.getClass()) {
            return false;
        }
        BasePrimitive o = (BasePrimitive)theObj;
        EqualsBuilder b = new EqualsBuilder();
        b.append(this.getValue(), o.getValue());
        return b.isEquals();
    }

    @Override
    public T getValue() {
        return this.myCoercedValue;
    }

    @Override
    public String getValueAsString() throws DataFormatException {
        return this.myStringValue;
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.getValue()).toHashCode();
    }

    @Override
    public boolean isEmpty() {
        return super.isBaseEmpty() && this.getValue() == null;
    }

    protected abstract T parse(String var1);

    @Override
    public void readExternal(ObjectInput theIn) throws IOException, ClassNotFoundException {
        String object = (String)theIn.readObject();
        this.setValueAsString(object);
    }

    @Override
    public IPrimitiveType<T> setValue(T theValue) throws DataFormatException {
        this.myCoercedValue = theValue;
        this.updateStringValue();
        return this;
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        this.myCoercedValue = theValue == null ? null : this.parse(theValue);
        this.myStringValue = theValue;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getValueAsString() + "]";
    }

    protected void updateStringValue() {
        this.myStringValue = this.myCoercedValue == null ? null : this.encode(this.myCoercedValue);
    }

    @Override
    public void writeExternal(ObjectOutput theOut) throws IOException {
        theOut.writeObject(this.getValueAsString());
    }
}

