/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseBundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.valueset.BundleEntrySearchModeEnum;
import ca.uhn.fhir.model.valueset.BundleEntryTransactionMethodEnum;
import ca.uhn.fhir.model.valueset.BundleTypeEnum;
import ca.uhn.fhir.util.UrlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hl7.fhir.instance.model.api.IBase;

public class Bundle
extends BaseBundle
implements IBase {
    private ResourceMetadataMap myResourceMetadata;
    private BoundCodeDt<BundleTypeEnum> myType;
    private StringDt myBundleId;
    private TagList myCategories;
    private List<BundleEntry> myEntries;
    private volatile transient Map<IdDt, IResource> myIdToEntries;
    private StringDt myLinkBase;
    private StringDt myLinkFirst;
    private StringDt myLinkLast;
    private StringDt myLinkNext;
    private StringDt myLinkPrevious;
    private StringDt myLinkSelf;
    private StringDt myTitle;
    private IntegerDt myTotalResults;

    @Deprecated
    public Tag addCategory() {
        Tag retVal = new Tag();
        this.getCategories().add(retVal);
        return retVal;
    }

    public void addCategory(String theScheme, String theTerm, String theLabel) {
        this.getCategories().add(new Tag(theScheme, theTerm, theLabel));
    }

    public void addCategory(Tag theTag) {
        this.getCategories().add(theTag);
    }

    public BundleEntry addEntry() {
        BundleEntry retVal = new BundleEntry();
        this.getEntries().add(retVal);
        return retVal;
    }

    public void addEntry(BundleEntry theBundleEntry) {
        Validate.notNull((Object)theBundleEntry, (String)"theBundleEntry can not be null", (Object[])new Object[0]);
        this.getEntries().add(theBundleEntry);
    }

    public BundleEntry addResource(IResource theResource, FhirContext theContext, String theServerBase) {
        DecimalDt entryScore;
        BundleEntryTransactionMethodEnum entryTransactionOperation;
        BundleEntrySearchModeEnum entryStatus;
        String linkAlternate;
        String linkSearch;
        TagList tagList;
        IdDt previous;
        InstantDt deleted;
        InstantDt published;
        BundleEntry entry = this.addEntry();
        entry.setResource(theResource);
        RuntimeResourceDefinition def = theContext.getResourceDefinition(theResource);
        String title = ResourceMetadataKeyEnum.TITLE.get(theResource);
        if (title != null) {
            entry.getTitle().setValue(title);
        } else {
            entry.getTitle().setValue(def.getName() + " " + StringUtils.defaultString((String)theResource.getId().getValue(), (String)"(no ID)"));
        }
        if (theResource.getId() != null) {
            if (theResource.getId().isAbsolute()) {
                entry.getLinkSelf().setValue(theResource.getId().getValue());
                entry.getId().setValue(theResource.getId().toVersionless().getValue());
            } else if (StringUtils.isNotBlank((CharSequence)theResource.getId().getValue())) {
                StringBuilder b = new StringBuilder();
                b.append(theServerBase);
                if (b.length() > 0 && b.charAt(b.length() - 1) != '/') {
                    b.append('/');
                }
                b.append(def.getName());
                b.append('/');
                String resId = theResource.getId().getIdPart();
                b.append(resId);
                entry.getId().setValue(b.toString());
                if (StringUtils.isNotBlank((CharSequence)theResource.getId().getVersionIdPart())) {
                    b.append('/');
                    b.append("_history");
                    b.append('/');
                    b.append(theResource.getId().getVersionIdPart());
                } else {
                    IdDt versionId = ResourceMetadataKeyEnum.VERSION_ID.get(theResource);
                    if (versionId != null) {
                        b.append('/');
                        b.append("_history");
                        b.append('/');
                        b.append(versionId.getValue());
                    }
                }
                String qualifiedId = b.toString();
                entry.getLinkSelf().setValue(qualifiedId);
            }
        }
        if ((published = ResourceMetadataKeyEnum.PUBLISHED.get(theResource)) == null) {
            entry.getPublished().setToCurrentTimeInLocalTimeZone();
        } else {
            entry.setPublished(published);
        }
        InstantDt updated = ResourceMetadataKeyEnum.UPDATED.get(theResource);
        if (updated != null) {
            entry.setUpdated(updated);
        }
        if ((deleted = ResourceMetadataKeyEnum.DELETED_AT.get(theResource)) != null) {
            entry.setDeleted(deleted);
        }
        if ((previous = ResourceMetadataKeyEnum.PREVIOUS_ID.get(theResource)) != null) {
            entry.getLinkAlternate().setValue(previous.withServerBase(theServerBase, def.getName()).getValue());
        }
        if ((tagList = ResourceMetadataKeyEnum.TAG_LIST.get(theResource)) != null) {
            for (Tag nextTag : tagList) {
                entry.addCategory(nextTag);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)(linkSearch = ResourceMetadataKeyEnum.LINK_SEARCH.get(theResource)))) {
            if (!UrlUtil.isAbsolute(linkSearch)) {
                linkSearch = theServerBase + "/" + linkSearch;
            }
            entry.getLinkSearch().setValue(linkSearch);
        }
        if (StringUtils.isNotBlank((CharSequence)(linkAlternate = ResourceMetadataKeyEnum.LINK_ALTERNATE.get(theResource)))) {
            if (!UrlUtil.isAbsolute(linkAlternate)) {
                linkSearch = theServerBase + "/" + linkAlternate;
            }
            entry.getLinkAlternate().setValue(linkSearch);
        }
        if ((entryStatus = ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.get(theResource)) != null) {
            entry.getSearchMode().setValueAsEnum(entryStatus);
        }
        if ((entryTransactionOperation = ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.get(theResource)) != null) {
            entry.getTransactionMethod().setValueAsEnum(entryTransactionOperation);
        }
        if ((entryScore = ResourceMetadataKeyEnum.ENTRY_SCORE.get(theResource)) != null) {
            entry.setScore(entryScore);
        }
        return entry;
    }

    public StringDt getBundleId() {
        if (this.myBundleId == null) {
            this.myBundleId = new StringDt();
        }
        return this.myBundleId;
    }

    public TagList getCategories() {
        if (this.myCategories == null) {
            this.myCategories = new TagList();
        }
        return this.myCategories;
    }

    public List<BundleEntry> getEntries() {
        if (this.myEntries == null) {
            this.myEntries = new ArrayList<BundleEntry>();
        }
        return this.myEntries;
    }

    public StringDt getLinkBase() {
        if (this.myLinkBase == null) {
            this.myLinkBase = new StringDt();
        }
        return this.myLinkBase;
    }

    public StringDt getLinkFirst() {
        if (this.myLinkFirst == null) {
            this.myLinkFirst = new StringDt();
        }
        return this.myLinkFirst;
    }

    public StringDt getLinkLast() {
        if (this.myLinkLast == null) {
            this.myLinkLast = new StringDt();
        }
        return this.myLinkLast;
    }

    public StringDt getLinkNext() {
        if (this.myLinkNext == null) {
            this.myLinkNext = new StringDt();
        }
        return this.myLinkNext;
    }

    public StringDt getLinkPrevious() {
        if (this.myLinkPrevious == null) {
            this.myLinkPrevious = new StringDt();
        }
        return this.myLinkPrevious;
    }

    public StringDt getLinkSelf() {
        if (this.myLinkSelf == null) {
            this.myLinkSelf = new StringDt();
        }
        return this.myLinkSelf;
    }

    public IResource getResourceById(IdDt theId) {
        Map<IdDt, IResource> map = this.myIdToEntries;
        if (map == null) {
            map = new HashMap<IdDt, IResource>();
            for (BundleEntry next : this.getEntries()) {
                if (next.getId().isEmpty()) continue;
                map.put(next.getId().toUnqualified(), next.getResource());
            }
            this.myIdToEntries = map;
        }
        return map.get(theId.toUnqualified());
    }

    public ResourceMetadataMap getResourceMetadata() {
        if (this.myResourceMetadata == null) {
            this.myResourceMetadata = new ResourceMetadataMap();
        }
        return this.myResourceMetadata;
    }

    public <T extends IResource> List<T> getResources(Class<T> theClass) {
        ArrayList<IResource> retVal = new ArrayList<IResource>();
        for (BundleEntry next : this.getEntries()) {
            if (next.getResource() == null || !theClass.isAssignableFrom(next.getResource().getClass())) continue;
            IResource resource = next.getResource();
            retVal.add(resource);
        }
        return retVal;
    }

    public StringDt getTitle() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public IntegerDt getTotalResults() {
        if (this.myTotalResults == null) {
            this.myTotalResults = new IntegerDt();
        }
        return this.myTotalResults;
    }

    public BoundCodeDt<BundleTypeEnum> getType() {
        if (this.myType == null) {
            this.myType = new BoundCodeDt<BundleTypeEnum>(BundleTypeEnum.VALUESET_BINDER);
        }
        return this.myType;
    }

    public InstantDt getUpdated() {
        InstantDt retVal = (InstantDt)this.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
        if (retVal == null) {
            retVal = new InstantDt();
            this.getResourceMetadata().put(ResourceMetadataKeyEnum.UPDATED, retVal);
        }
        return retVal;
    }

    @Override
    public boolean isEmpty() {
        return this.getEntries().isEmpty();
    }

    public void setCategories(TagList theCategories) {
        this.myCategories = theCategories;
    }

    public int size() {
        return this.getEntries().size();
    }

    public List<IResource> toListOfResources() {
        ArrayList<IResource> retVal = new ArrayList<IResource>();
        for (BundleEntry next : this.getEntries()) {
            if (next.getResource() == null) continue;
            retVal.add(next.getResource());
        }
        return retVal;
    }

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append((Object)(this.getEntries().size() + " entries"));
        b.append("id", (Object)this.getId());
        return b.toString();
    }

    public static Bundle withResources(List<IResource> theResources, FhirContext theContext, String theServerBase) {
        Bundle retVal = new Bundle();
        for (IResource next : theResources) {
            retVal.addResource(next, theContext, theServerBase);
        }
        return retVal;
    }

    public static Bundle withSingleResource(IResource theResource) {
        Bundle retVal = new Bundle();
        retVal.addEntry().setResource(theResource);
        return retVal;
    }
}

