/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.api;

import org.apache.commons.lang3.builder.ToStringBuilder;

public class Include {
    private boolean myRecurse;
    private String myValue;
    private boolean myImmutable;

    public Include(String theValue) {
        this.myValue = theValue;
    }

    public Include(String theValue, boolean theRecurse) {
        this.myValue = theValue;
        this.myRecurse = theRecurse;
    }

    public Include asNonRecursive() {
        return new Include(this.myValue, false);
    }

    public Include asRecursive() {
        return new Include(this.myValue, true);
    }

    public String getValue() {
        return this.myValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myRecurse ? 1231 : 1237);
        result = 31 * result + (this.myValue == null ? 0 : this.myValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Include other = (Include)obj;
        if (this.myRecurse != other.myRecurse) {
            return false;
        }
        return !(this.myValue == null ? other.myValue != null : !this.myValue.equals(other.myValue));
    }

    public boolean isRecurse() {
        return this.myRecurse;
    }

    public void setRecurse(boolean theRecurse) {
        this.myRecurse = theRecurse;
    }

    public void setValue(String theValue) {
        if (this.myImmutable) {
            throw new IllegalStateException("Can not change the value of this include");
        }
        this.myValue = theValue;
    }

    public Include toLocked() {
        Include retVal = new Include(this.myValue, this.myRecurse);
        retVal.myImmutable = true;
        return retVal;
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder((Object)this);
        builder.append("value", (Object)this.myValue);
        builder.append("recurse", this.myRecurse);
        return builder.toString();
    }
}

