/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.base.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.DatatypeUtil;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

public abstract class BaseHumanNameDt
extends BaseIdentifiableElement {
    public abstract List<StringDt> getFamily();

    public String getFamilyAsSingleString() {
        return DatatypeUtil.joinStringsSpaceSeparated(this.getFamily());
    }

    public abstract List<StringDt> getGiven();

    public String getGivenAsSingleString() {
        return DatatypeUtil.joinStringsSpaceSeparated(this.getGiven());
    }

    public abstract List<StringDt> getPrefix();

    public String getPrefixAsSingleString() {
        return DatatypeUtil.joinStringsSpaceSeparated(this.getPrefix());
    }

    public abstract List<StringDt> getSuffix();

    public String getSuffixAsSingleString() {
        return DatatypeUtil.joinStringsSpaceSeparated(this.getSuffix());
    }

    public abstract StringDt getTextElement();

    public abstract BaseHumanNameDt setText(StringDt var1);

    public String toString() {
        ToStringBuilder b = new ToStringBuilder((Object)this, ToStringStyle.SHORT_PREFIX_STYLE);
        b.append("family", (Object)this.getFamilyAsSingleString());
        b.append("given", (Object)this.getGivenAsSingleString());
        return b.toString();
    }

    public String getNameAsSingleString() {
        ArrayList<StringDt> nameParts = new ArrayList<StringDt>();
        nameParts.addAll(this.getPrefix());
        nameParts.addAll(this.getGiven());
        nameParts.addAll(this.getFamily());
        nameParts.addAll(this.getSuffix());
        if (nameParts.size() > 0) {
            return DatatypeUtil.joinStringsSpaceSeparated(nameParts);
        }
        return (String)this.getTextElement().getValue();
    }
}

