/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;
import net.sourceforge.cobertura.CoverageIgnore;

@CoverageIgnore
public enum SecurityEventObjectTypeEnum {
    PERSON("1", "http://hl7.org/fhir/object-type"),
    SYSTEM_OBJECT("2", "http://hl7.org/fhir/object-type"),
    ORGANIZATION("3", "http://hl7.org/fhir/object-type"),
    OTHER("4", "http://hl7.org/fhir/object-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/object-type";
    public static final String VALUESET_NAME = "SecurityEventObjectType";
    private static Map<String, SecurityEventObjectTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SecurityEventObjectTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SecurityEventObjectTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SecurityEventObjectTypeEnum forCode(String theCode) {
        SecurityEventObjectTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SecurityEventObjectTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SecurityEventObjectTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SecurityEventObjectTypeEnum>>();
        for (SecurityEventObjectTypeEnum next : SecurityEventObjectTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SecurityEventObjectTypeEnum>(){

            @Override
            public String toCodeString(SecurityEventObjectTypeEnum theEnum) {
                return theEnum.getCode();
            }

            @Override
            public String toSystemString(SecurityEventObjectTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            @Override
            public SecurityEventObjectTypeEnum fromCodeString(String theCodeString) {
                return (SecurityEventObjectTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            @Override
            public SecurityEventObjectTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SecurityEventObjectTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

