/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.parser.DataFormatException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.lang3.time.FastDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseDateTimeDt
extends BasePrimitive<Date> {
    private static final List<FastDateFormat> ourFormatters;
    private static final Pattern ourYearDashMonthDashDayPattern;
    private static final Pattern ourYearDashMonthPattern;
    private static final FastDateFormat ourYearFormat;
    private static final FastDateFormat ourYearMonthDayFormat;
    private static final FastDateFormat ourYearMonthDayNoDashesFormat;
    private static final Pattern ourYearMonthDayPattern;
    private static final FastDateFormat ourYearMonthDayTimeFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliUTCZFormat;
    private static final FastDateFormat ourYearMonthDayTimeMilliZoneFormat;
    private static final FastDateFormat ourYearMonthDayTimeUTCZFormat;
    private static final FastDateFormat ourYearMonthDayTimeZoneFormat;
    private static final FastDateFormat ourYearMonthFormat;
    private static final FastDateFormat ourYearMonthNoDashesFormat;
    private static final FastDateFormat ourHumanDateTimeFormat;
    private static final FastDateFormat ourHumanDateFormat;
    private static final Pattern ourYearMonthPattern;
    private static final Pattern ourYearPattern;
    private TemporalPrecisionEnum myPrecision = TemporalPrecisionEnum.SECOND;
    private TimeZone myTimeZone;
    private boolean myTimeZoneZulu = false;
    private static final Logger ourLog;

    public String toHumanDisplay() {
        TimeZone tz = this.getTimeZone();
        Calendar value = tz != null ? Calendar.getInstance(tz) : Calendar.getInstance();
        value.setTime((Date)this.getValue());
        switch (this.getPrecision()) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return ourHumanDateFormat.format(value);
            }
        }
        return ourHumanDateTimeFormat.format(value);
    }

    public String toHumanDisplayLocalTimezone() {
        switch (this.getPrecision()) {
            case YEAR: 
            case MONTH: 
            case DAY: {
                return ourHumanDateFormat.format((Date)this.getValue());
            }
        }
        return ourHumanDateTimeFormat.format((Date)this.getValue());
    }

    public BaseDateTimeDt() {
    }

    public BaseDateTimeDt(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.setValue(theDate, thePrecision);
        if (!this.isPrecisionAllowed(thePrecision)) {
            throw new DataFormatException("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support " + (Object)((Object)thePrecision) + " precision): " + theDate);
        }
    }

    public BaseDateTimeDt(String theString) {
        this.setValueAsString(theString);
        if (!this.isPrecisionAllowed(this.getPrecision())) {
            throw new DataFormatException("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support " + (Object)((Object)this.getPrecision()) + " precision): " + theString);
        }
    }

    public BaseDateTimeDt(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimeZone) {
        this(theDate, thePrecision);
        this.setTimeZone(theTimeZone);
    }

    private void clearTimeZone() {
        this.myTimeZone = null;
        this.myTimeZoneZulu = false;
    }

    @Override
    protected String encode(Date theValue) {
        if (theValue == null) {
            return null;
        }
        switch (this.myPrecision) {
            case DAY: {
                return ourYearMonthDayFormat.format(theValue);
            }
            case MONTH: {
                return ourYearMonthFormat.format(theValue);
            }
            case YEAR: {
                return ourYearFormat.format(theValue);
            }
            case SECOND: {
                if (this.myTimeZoneZulu) {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeFormat.format((Calendar)cal) + "Z";
                }
                if (this.myTimeZone != null) {
                    GregorianCalendar cal = new GregorianCalendar(this.myTimeZone);
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeZoneFormat.format((Calendar)cal);
                }
                return ourYearMonthDayTimeFormat.format(theValue);
            }
            case MILLI: {
                if (this.myTimeZoneZulu) {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMilliFormat.format((Calendar)cal) + "Z";
                }
                if (this.myTimeZone != null) {
                    GregorianCalendar cal = new GregorianCalendar(this.myTimeZone);
                    cal.setTime(theValue);
                    return ourYearMonthDayTimeMilliZoneFormat.format((Calendar)cal);
                }
                return ourYearMonthDayTimeMilliFormat.format(theValue);
            }
        }
        throw new IllegalStateException("Invalid precision (this is a HAPI bug, shouldn't happen): " + (Object)((Object)this.myPrecision));
    }

    protected abstract TemporalPrecisionEnum getDefaultPrecisionForDatatype();

    public TemporalPrecisionEnum getPrecision() {
        if (this.myPrecision == null) {
            return this.getDefaultPrecisionForDatatype();
        }
        return this.myPrecision;
    }

    public TimeZone getTimeZone() {
        return this.myTimeZone;
    }

    private boolean hasOffset(String theValue) {
        boolean inTime = false;
        block4: for (int i = 0; i < theValue.length(); ++i) {
            switch (theValue.charAt(i)) {
                case 'T': {
                    inTime = true;
                    continue block4;
                }
                case '+': 
                case '-': {
                    if (!inTime) continue block4;
                    return true;
                }
            }
        }
        return false;
    }

    abstract boolean isPrecisionAllowed(TemporalPrecisionEnum var1);

    public boolean isTimeZoneZulu() {
        return this.myTimeZoneZulu;
    }

    public boolean isToday() {
        Validate.notNull(this.getValue(), (String)(this.getClass().getSimpleName() + " contains null value"), (Object[])new Object[0]);
        return DateUtils.isSameDay((Date)new Date(), (Date)((Date)this.getValue()));
    }

    @Override
    protected Date parse(String theValue) throws DataFormatException {
        try {
            if (theValue.length() == 4 && ourYearPattern.matcher(theValue).matches()) {
                if (!this.isPrecisionAllowed(TemporalPrecisionEnum.YEAR)) {
                    ourLog.debug("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support YEAR precision): " + theValue);
                }
                this.setPrecision(TemporalPrecisionEnum.YEAR);
                this.clearTimeZone();
                return ourYearFormat.parse(theValue);
            }
            if (theValue.length() == 6 && ourYearMonthPattern.matcher(theValue).matches()) {
                if (!this.isPrecisionAllowed(TemporalPrecisionEnum.MONTH)) {
                    ourLog.debug("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support DAY precision): " + theValue);
                }
                this.setPrecision(TemporalPrecisionEnum.MONTH);
                this.clearTimeZone();
                return ourYearMonthNoDashesFormat.parse(theValue);
            }
            if (theValue.length() == 7 && ourYearDashMonthPattern.matcher(theValue).matches()) {
                if (!this.isPrecisionAllowed(TemporalPrecisionEnum.MONTH)) {
                    ourLog.debug("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support MONTH precision): " + theValue);
                }
                this.setPrecision(TemporalPrecisionEnum.MONTH);
                this.clearTimeZone();
                return ourYearMonthFormat.parse(theValue);
            }
            if (theValue.length() == 8 && ourYearMonthDayPattern.matcher(theValue).matches()) {
                if (!this.isPrecisionAllowed(TemporalPrecisionEnum.DAY)) {
                    ourLog.debug("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support DAY precision): " + theValue);
                }
                this.setPrecision(TemporalPrecisionEnum.DAY);
                this.clearTimeZone();
                return ourYearMonthDayNoDashesFormat.parse(theValue);
            }
            if (theValue.length() == 10 && ourYearDashMonthDashDayPattern.matcher(theValue).matches()) {
                if (!this.isPrecisionAllowed(TemporalPrecisionEnum.DAY)) {
                    ourLog.debug("Invalid date/time string (datatype " + this.getClass().getSimpleName() + " does not support DAY precision): " + theValue);
                }
                this.setPrecision(TemporalPrecisionEnum.DAY);
                this.clearTimeZone();
                return ourYearMonthDayFormat.parse(theValue);
            }
            if (theValue.length() >= 18) {
                Date retVal;
                boolean hasMillis;
                int dotIndex = theValue.indexOf(46, 18);
                boolean bl = hasMillis = dotIndex > -1;
                if (!hasMillis && !this.isPrecisionAllowed(TemporalPrecisionEnum.SECOND)) {
                    ourLog.debug("Invalid date/time string (data type does not support SECONDS precision): " + theValue);
                } else if (hasMillis && !this.isPrecisionAllowed(TemporalPrecisionEnum.MILLI)) {
                    ourLog.debug("Invalid date/time string (data type " + this.getClass().getSimpleName() + " does not support MILLIS precision):" + theValue);
                }
                if (hasMillis) {
                    try {
                        retVal = this.hasOffset(theValue) ? ourYearMonthDayTimeMilliZoneFormat.parse(theValue) : (theValue.endsWith("Z") ? ourYearMonthDayTimeMilliUTCZFormat.parse(theValue) : ourYearMonthDayTimeMilliFormat.parse(theValue));
                    }
                    catch (ParseException p2) {
                        throw new DataFormatException("Invalid data/time string (" + p2.getMessage() + "): " + theValue);
                    }
                    this.setTimeZone(theValue, hasMillis);
                    this.setPrecision(TemporalPrecisionEnum.MILLI);
                } else {
                    try {
                        retVal = this.hasOffset(theValue) ? ourYearMonthDayTimeZoneFormat.parse(theValue) : (theValue.endsWith("Z") ? ourYearMonthDayTimeUTCZFormat.parse(theValue) : ourYearMonthDayTimeFormat.parse(theValue));
                    }
                    catch (ParseException p2) {
                        throw new DataFormatException("Invalid data/time string (" + p2.getMessage() + "): " + theValue);
                    }
                    this.setTimeZone(theValue, hasMillis);
                    this.setPrecision(TemporalPrecisionEnum.SECOND);
                }
                return retVal;
            }
            throw new DataFormatException("Invalid date/time string (invalid length): " + theValue);
        }
        catch (ParseException e) {
            throw new DataFormatException("Invalid date string (" + e.getMessage() + "): " + theValue);
        }
    }

    public void setPrecision(TemporalPrecisionEnum thePrecision) throws DataFormatException {
        if (thePrecision == null) {
            throw new NullPointerException("Precision may not be null");
        }
        this.myPrecision = thePrecision;
        this.updateStringValue();
    }

    private BaseDateTimeDt setTimeZone(String theValueString, boolean hasMillis) {
        this.clearTimeZone();
        int timeZoneStart = 19;
        if (hasMillis) {
            timeZoneStart += 4;
        }
        if (theValueString.endsWith("Z")) {
            this.setTimeZoneZulu(true);
        } else if (theValueString.indexOf("GMT", timeZoneStart) != -1) {
            this.setTimeZone(TimeZone.getTimeZone(theValueString.substring(timeZoneStart)));
        } else if (theValueString.indexOf(43, timeZoneStart) != -1 || theValueString.indexOf(45, timeZoneStart) != -1) {
            this.setTimeZone(TimeZone.getTimeZone("GMT" + theValueString.substring(timeZoneStart)));
        }
        return this;
    }

    public BaseDateTimeDt setTimeZone(TimeZone theTimeZone) {
        this.myTimeZone = theTimeZone;
        this.updateStringValue();
        return this;
    }

    public BaseDateTimeDt setTimeZoneZulu(boolean theTimeZoneZulu) {
        this.myTimeZoneZulu = theTimeZoneZulu;
        this.updateStringValue();
        return this;
    }

    public BaseDateTimeDt setValue(Date theValue) {
        this.setValue(theValue, this.getDefaultPrecisionForDatatype());
        return this;
    }

    public void setValue(Date theValue, TemporalPrecisionEnum thePrecision) throws DataFormatException {
        this.setTimeZone(TimeZone.getDefault());
        this.myPrecision = thePrecision;
        super.setValue(theValue);
    }

    @Override
    public void setValueAsString(String theValue) throws DataFormatException {
        this.clearTimeZone();
        super.setValueAsString(theValue);
    }

    static List<FastDateFormat> getFormatters() {
        return ourFormatters;
    }

    static {
        ourYearDashMonthDashDayPattern = Pattern.compile("[0-9]{4}-[0-9]{2}-[0-9]{2}");
        ourYearDashMonthPattern = Pattern.compile("[0-9]{4}-[0-9]{2}");
        ourYearFormat = FastDateFormat.getInstance((String)"yyyy");
        ourYearMonthDayFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd");
        ourYearMonthDayNoDashesFormat = FastDateFormat.getInstance((String)"yyyyMMdd");
        ourYearMonthDayPattern = Pattern.compile("[0-9]{4}[0-9]{2}[0-9]{2}");
        ourYearMonthDayTimeFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss");
        ourYearMonthDayTimeMilliFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
        ourYearMonthDayTimeMilliUTCZFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
        ourYearMonthDayTimeMilliZoneFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss.SSSZZ");
        ourYearMonthDayTimeUTCZFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ss'Z'", (TimeZone)TimeZone.getTimeZone("UTC"));
        ourYearMonthDayTimeZoneFormat = FastDateFormat.getInstance((String)"yyyy-MM-dd'T'HH:mm:ssZZ");
        ourYearMonthFormat = FastDateFormat.getInstance((String)"yyyy-MM");
        ourYearMonthNoDashesFormat = FastDateFormat.getInstance((String)"yyyyMM");
        ourHumanDateTimeFormat = FastDateFormat.getDateTimeInstance((int)2, (int)2);
        ourHumanDateFormat = FastDateFormat.getDateInstance((int)2);
        ourYearMonthPattern = Pattern.compile("[0-9]{4}[0-9]{2}");
        ourYearPattern = Pattern.compile("[0-9]{4}");
        ArrayList<FastDateFormat> formatters = new ArrayList<FastDateFormat>();
        formatters.add(ourYearFormat);
        formatters.add(ourYearMonthDayFormat);
        formatters.add(ourYearMonthDayNoDashesFormat);
        formatters.add(ourYearMonthDayTimeFormat);
        formatters.add(ourYearMonthDayTimeMilliFormat);
        formatters.add(ourYearMonthDayTimeUTCZFormat);
        formatters.add(ourYearMonthDayTimeMilliUTCZFormat);
        formatters.add(ourYearMonthDayTimeMilliZoneFormat);
        formatters.add(ourYearMonthDayTimeZoneFormat);
        formatters.add(ourYearMonthFormat);
        formatters.add(ourYearMonthNoDashesFormat);
        ourFormatters = Collections.unmodifiableList(formatters);
        ourLog = LoggerFactory.getLogger(BaseDateTimeDt.class);
    }
}

