/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.BasePrimitive;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import org.hl7.fhir.instance.model.api.IBaseDecimalDatatype;

@DatatypeDef(name="decimal")
public class DecimalDt
extends BasePrimitive<BigDecimal>
implements Comparable<DecimalDt>,
IBaseDecimalDatatype {
    public DecimalDt() {
    }

    @SimpleSetter
    public DecimalDt(@SimpleSetter.Parameter(name="theValue") BigDecimal theValue) {
        this.setValue(theValue);
    }

    @SimpleSetter
    public DecimalDt(@SimpleSetter.Parameter(name="theValue") double theValue) {
        this.setValue(BigDecimal.valueOf(theValue));
    }

    @SimpleSetter
    public DecimalDt(@SimpleSetter.Parameter(name="theValue") long theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    public DecimalDt(String theValue) {
        this.setValue(new BigDecimal(theValue));
    }

    @Override
    public int compareTo(DecimalDt theObj) {
        if (this.getValue() == null && theObj.getValue() == null) {
            return 0;
        }
        if (this.getValue() != null && theObj.getValue() == null) {
            return 1;
        }
        if (this.getValue() == null && theObj.getValue() != null) {
            return -1;
        }
        return ((BigDecimal)this.getValue()).compareTo((BigDecimal)theObj.getValue());
    }

    @Override
    protected String encode(BigDecimal theValue) {
        return ((BigDecimal)this.getValue()).toPlainString();
    }

    public int getValueAsInteger() {
        return ((BigDecimal)this.getValue()).intValue();
    }

    public Number getValueAsNumber() {
        return (Number)this.getValue();
    }

    @Override
    protected BigDecimal parse(String theValue) {
        return new BigDecimal(theValue);
    }

    public void round(int thePrecision) {
        if (this.getValue() != null) {
            BigDecimal newValue = ((BigDecimal)this.getValue()).round(new MathContext(thePrecision));
            this.setValue(newValue);
        }
    }

    public void round(int thePrecision, RoundingMode theRoundingMode) {
        if (this.getValue() != null) {
            BigDecimal newValue = ((BigDecimal)this.getValue()).round(new MathContext(thePrecision, theRoundingMode));
            this.setValue(newValue);
        }
    }

    public void setValueAsInteger(int theValue) {
        this.setValue(new BigDecimal(theValue));
    }
}

