/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.primitive;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.primitive.BaseDateTimeDt;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

@DatatypeDef(name="instant")
public class InstantDt
extends BaseDateTimeDt {
    public static final TemporalPrecisionEnum DEFAULT_PRECISION = TemporalPrecisionEnum.MILLI;

    public InstantDt() {
    }

    public InstantDt(Calendar theCalendar) {
        super(theCalendar.getTime(), DEFAULT_PRECISION, theCalendar.getTimeZone());
    }

    public InstantDt(Date theDate, TemporalPrecisionEnum thePrecision, TimeZone theTimezone) {
        super(theDate, thePrecision, theTimezone);
    }

    public InstantDt(BaseDateTimeDt theDateTime) {
        this.setValue((Date)theDateTime.getValue());
        this.setPrecision(DEFAULT_PRECISION);
        this.setTimeZone(theDateTime.getTimeZone());
    }

    @SimpleSetter(suffix="WithMillisPrecision")
    public InstantDt(@SimpleSetter.Parameter(name="theDate") Date theDate) {
        super(theDate, DEFAULT_PRECISION, TimeZone.getDefault());
    }

    @SimpleSetter
    public InstantDt(@SimpleSetter.Parameter(name="theDate") Date theDate, @SimpleSetter.Parameter(name="thePrecision") TemporalPrecisionEnum thePrecision) {
        this.setValue(theDate);
        this.setPrecision(thePrecision);
        this.setTimeZone(TimeZone.getDefault());
    }

    public InstantDt(String theString) {
        super(theString);
    }

    public boolean after(Date theDate) {
        return ((Date)this.getValue()).after(theDate);
    }

    public boolean before(Date theDate) {
        return ((Date)this.getValue()).before(theDate);
    }

    public void setToCurrentTimeInLocalTimeZone() {
        this.setValue(new Date());
        this.setTimeZone(TimeZone.getDefault());
    }

    @Override
    boolean isPrecisionAllowed(TemporalPrecisionEnum thePrecision) {
        switch (thePrecision) {
            case SECOND: 
            case MILLI: {
                return true;
            }
        }
        return false;
    }

    public static InstantDt withCurrentTime() {
        return new InstantDt(new Date(), TemporalPrecisionEnum.MILLI, TimeZone.getDefault());
    }

    @Override
    protected TemporalPrecisionEnum getDefaultPrecisionForDatatype() {
        return DEFAULT_PRECISION;
    }
}

