/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.view;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseElement;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IResource;
import java.util.List;
import org.hl7.fhir.instance.model.api.IBase;

public class ViewGenerator {
    private FhirContext myCtx;

    public ViewGenerator(FhirContext theFhirContext) {
        this.myCtx = theFhirContext;
    }

    public <T extends IResource> T newView(IResource theResource, Class<T> theTargetType) {
        IResource retVal;
        Class<?> sourceType = theResource.getClass();
        RuntimeResourceDefinition sourceDef = this.myCtx.getResourceDefinition(theResource);
        RuntimeResourceDefinition targetDef = this.myCtx.getResourceDefinition(theTargetType);
        if (sourceType.equals(theTargetType)) {
            IResource resource = theResource;
            return (T)resource;
        }
        try {
            retVal = (IResource)theTargetType.newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate " + theTargetType, e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate " + theTargetType, e);
        }
        this.copyChildren(sourceDef, (BaseElement)((Object)theResource), targetDef, (BaseElement)((Object)retVal));
        return (T)retVal;
    }

    private void copyChildren(BaseRuntimeElementCompositeDefinition<?> theSourceDef, BaseElement theSource, BaseRuntimeElementCompositeDefinition<?> theTargetDef, BaseElement theTarget) {
        if (!theSource.isEmpty()) {
            List<BaseRuntimeChildDefinition> targetChildren = theTargetDef.getChildren();
            for (BaseRuntimeChildDefinition nextChild : targetChildren) {
                BaseRuntimeChildDefinition sourceChildEquivalent;
                String elementName = nextChild.getElementName();
                if (nextChild.getValidChildNames().size() > 1) {
                    elementName = nextChild.getValidChildNames().iterator().next();
                }
                if ((sourceChildEquivalent = theSourceDef.getChildByNameOrThrowDataFormatException(elementName)) == null) continue;
                List<IBase> sourceValues = sourceChildEquivalent.getAccessor().getValues(theSource);
                for (IBase nextElement : sourceValues) {
                    nextChild.getMutator().addValue(theTarget, nextElement);
                }
            }
            List<RuntimeChildDeclaredExtensionDefinition> targetExts = theTargetDef.getExtensions();
            for (RuntimeChildDeclaredExtensionDefinition nextExt : targetExts) {
                String url = nextExt.getExtensionUrl();
                RuntimeChildDeclaredExtensionDefinition sourceDeclaredExt = theSourceDef.getDeclaredExtension(url);
                if (sourceDeclaredExt == null) {
                    for (ExtensionDt next : theSource.getAllUndeclaredExtensions()) {
                        if (!next.getUrlAsString().equals(url)) continue;
                        nextExt.getMutator().addValue(theTarget, next.getValue());
                    }
                    continue;
                }
                List<IBase> values = sourceDeclaredExt.getAccessor().getValues(theSource);
                for (IBase nextElement : values) {
                    nextExt.getMutator().addValue(theTarget, nextElement);
                }
            }
        }
    }
}

