/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.narrative;

import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.narrative.DefaultThymeleafNarrativeGenerator;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.DataFormatException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.thymeleaf.Arguments;
import org.thymeleaf.Configuration;
import org.thymeleaf.TemplateEngine;
import org.thymeleaf.TemplateProcessingParameters;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.context.IProcessingContext;
import org.thymeleaf.dialect.IDialect;
import org.thymeleaf.dom.Document;
import org.thymeleaf.dom.Element;
import org.thymeleaf.dom.Node;
import org.thymeleaf.dom.Text;
import org.thymeleaf.exceptions.TemplateInputException;
import org.thymeleaf.messageresolver.IMessageResolver;
import org.thymeleaf.messageresolver.StandardMessageResolver;
import org.thymeleaf.processor.ProcessorResult;
import org.thymeleaf.processor.attr.AbstractAttrProcessor;
import org.thymeleaf.resourceresolver.IResourceResolver;
import org.thymeleaf.standard.StandardDialect;
import org.thymeleaf.standard.expression.IStandardExpression;
import org.thymeleaf.standard.expression.IStandardExpressionParser;
import org.thymeleaf.standard.expression.StandardExpressions;
import org.thymeleaf.templatemode.StandardTemplateModeHandlers;
import org.thymeleaf.templateparser.xmlsax.XhtmlAndHtml5NonValidatingSAXTemplateParser;
import org.thymeleaf.templateresolver.ClassLoaderTemplateResolver;
import org.thymeleaf.templateresolver.ITemplateResolver;
import org.thymeleaf.templateresolver.TemplateResolver;

public abstract class BaseThymeleafNarrativeGenerator
implements INarrativeGenerator {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseThymeleafNarrativeGenerator.class);
    private static final XhtmlAndHtml5NonValidatingSAXTemplateParser PARSER = new XhtmlAndHtml5NonValidatingSAXTemplateParser(1);
    private Configuration myThymeleafConfig = new Configuration();
    private boolean myApplyDefaultDatatypeTemplates = true;
    private HashMap<Class<?>, String> myClassToName;
    private boolean myCleanWhitespace = true;
    private boolean myIgnoreFailures = true;
    private boolean myIgnoreMissingTemplates = true;
    private volatile boolean myInitialized;
    private HashMap<String, String> myNameToNarrativeTemplate;
    private HashMap<String, String> myNameToTitleTemplate;
    private TemplateEngine myProfileTemplateEngine;
    private HashMap<String, String> myProfileToName;
    private TemplateEngine myTitleTemplateEngine;
    private FhirContext myFhirContext;

    public BaseThymeleafNarrativeGenerator() {
        this.myThymeleafConfig.addTemplateResolver((ITemplateResolver)new ClassLoaderTemplateResolver());
        this.myThymeleafConfig.addMessageResolver((IMessageResolver)new StandardMessageResolver());
        this.myThymeleafConfig.setTemplateModeHandlers(StandardTemplateModeHandlers.ALL_TEMPLATE_MODE_HANDLERS);
        this.myThymeleafConfig.initialize();
    }

    @Override
    public void generateNarrative(IBaseResource theResource, BaseNarrativeDt<?> theNarrative) {
        this.generateNarrative(null, theResource, theNarrative);
    }

    @Override
    public void setFhirContext(FhirContext theFhirContext) {
        if (theFhirContext == null) {
            throw new NullPointerException("Can not set theFhirContext to null");
        }
        if (this.myFhirContext != null && this.myFhirContext != theFhirContext) {
            throw new IllegalStateException("Narrative generators may not be reused/shared across multiple FhirContext instances");
        }
        this.myFhirContext = theFhirContext;
    }

    @Override
    public void generateNarrative(String theProfile, IBaseResource theResource, BaseNarrativeDt<?> theNarrative) {
        if (!this.myInitialized) {
            this.initialize();
        }
        String name = null;
        if (StringUtils.isNotBlank((CharSequence)theProfile)) {
            name = this.myProfileToName.get(theProfile);
        }
        if (name == null) {
            name = this.myClassToName.get(theResource.getClass());
        }
        if (name == null) {
            name = this.myFhirContext.getResourceDefinition(theResource).getName().toLowerCase();
        }
        if (name == null) {
            if (this.myIgnoreMissingTemplates) {
                ourLog.debug("No narrative template available for profile: {}", (Object)theProfile);
                theNarrative.getDiv().setValueAsString("<div>No narrative template available for resource profile: " + theProfile + "</div>");
                theNarrative.getStatus().setValueAsString("empty");
                return;
            }
            throw new DataFormatException("No narrative template for class " + theResource.getClass().getCanonicalName());
        }
        try {
            Context context = new Context();
            context.setVariable("resource", (Object)theResource);
            context.setVariable("fhirVersion", (Object)this.myFhirContext.getVersion().getVersion().name());
            String result = this.myProfileTemplateEngine.process(name, (IContext)context);
            if (this.myCleanWhitespace) {
                ourLog.trace("Pre-whitespace cleaning: ", (Object)result);
                result = BaseThymeleafNarrativeGenerator.cleanWhitespace(result);
                ourLog.trace("Post-whitespace cleaning: ", (Object)result);
            }
            if (StringUtils.isBlank((CharSequence)result)) {
                return;
            }
            theNarrative.getDiv().setValueAsString(result);
            theNarrative.getStatus().setValueAsString("generated");
            return;
        }
        catch (Exception e) {
            if (this.myIgnoreFailures) {
                ourLog.error("Failed to generate narrative", (Throwable)e);
                theNarrative.getDiv().setValueAsString("<div>No narrative available - Error: " + e.getMessage() + "</div>");
                theNarrative.getStatus().setValueAsString("empty");
                return;
            }
            throw new DataFormatException(e);
        }
    }

    @Override
    public String generateTitle(IBaseResource theResource) {
        return this.generateTitle(null, theResource);
    }

    @Override
    public String generateTitle(String theProfile, IBaseResource theResource) {
        if (!this.myInitialized) {
            this.initialize();
        }
        ourLog.trace("Generating resource title {}", (Object)theResource);
        String name = null;
        if (StringUtils.isNotBlank((CharSequence)theProfile)) {
            name = this.myProfileToName.get(theProfile);
        }
        if (name == null) {
            name = this.myClassToName.get(theResource.getClass());
        }
        if (name == null) {
            name = this.myFhirContext.getResourceDefinition(theResource).getName().toLowerCase();
        }
        ourLog.trace("Template name is {}", (Object)name);
        if (name == null) {
            if (this.myIgnoreMissingTemplates) {
                ourLog.debug("No title template available for profile: {}", (Object)theProfile);
                return null;
            }
            throw new DataFormatException("No title template for class " + theResource.getClass().getCanonicalName());
        }
        try {
            Context context = new Context();
            context.setVariable("resource", (Object)theResource);
            context.setVariable("fhirVersion", (Object)this.myFhirContext.getVersion().getVersion().name());
            String result = this.myTitleTemplateEngine.process(name, (IContext)context);
            ourLog.trace("Produced {}", (Object)result);
            StringBuilder b = new StringBuilder();
            boolean inTag = false;
            for (int i = 0; i < result.length(); ++i) {
                int prevChar;
                char nextChar = result.charAt(i);
                int n = prevChar = i > 0 ? (int)result.charAt(i - 1) : 10;
                if (nextChar == '<') {
                    inTag = true;
                    continue;
                }
                if (inTag) {
                    if (nextChar != '>') continue;
                    inTag = false;
                    continue;
                }
                if (nextChar <= ' ') {
                    if (prevChar <= 32 || prevChar == 62) continue;
                    b.append(' ');
                    continue;
                }
                b.append(nextChar);
            }
            while (b.length() > 0 && b.charAt(b.length() - 1) == ' ') {
                b.setLength(b.length() - 1);
            }
            result = b.toString();
            if (result.startsWith("<") && result.contains(">")) {
                result = result.substring(result.indexOf(62) + 1);
            }
            if (result.endsWith(">") && result.contains("<")) {
                result = result.substring(0, result.lastIndexOf(60));
            }
            result = result.replace("&gt;", ">").replace("&lt;", "<").replace("&amp;", "&");
            return result;
        }
        catch (Exception e) {
            if (this.myIgnoreFailures) {
                ourLog.error("Failed to generate narrative", (Throwable)e);
                return "No title available - Error: " + e.getMessage();
            }
            throw new DataFormatException(e);
        }
    }

    protected abstract List<String> getPropertyFile();

    private Document getXhtmlDOMFor(Reader source) {
        Configuration configuration1 = this.myThymeleafConfig;
        try {
            return PARSER.parseTemplate(configuration1, "input", source);
        }
        catch (Exception e) {
            throw new TemplateInputException("Exception during parsing of source", (Throwable)e);
        }
    }

    private synchronized void initialize() {
        if (this.myInitialized) {
            return;
        }
        ourLog.info("Initializing narrative generator");
        this.myProfileToName = new HashMap();
        this.myClassToName = new HashMap();
        this.myNameToNarrativeTemplate = new HashMap();
        this.myNameToTitleTemplate = new HashMap();
        List<String> propFileName = this.getPropertyFile();
        try {
            if (this.myApplyDefaultDatatypeTemplates) {
                this.loadProperties("classpath:ca/uhn/fhir/narrative/narratives.properties");
            }
            for (String next : propFileName) {
                this.loadProperties(next);
            }
        }
        catch (IOException e) {
            ourLog.info("Failed to load property file " + propFileName, (Throwable)e);
            throw new ConfigurationException("Can not load property file " + propFileName, e);
        }
        this.myProfileTemplateEngine = new TemplateEngine();
        TemplateResolver resolver = new TemplateResolver();
        resolver.setResourceResolver((IResourceResolver)new ProfileResourceResolver());
        this.myProfileTemplateEngine.setTemplateResolver((ITemplateResolver)resolver);
        StandardDialect dialect = new StandardDialect();
        HashSet<NarrativeAttributeProcessor> additionalProcessors = new HashSet<NarrativeAttributeProcessor>();
        additionalProcessors.add(new NarrativeAttributeProcessor());
        dialect.setAdditionalProcessors(additionalProcessors);
        this.myProfileTemplateEngine.setDialect((IDialect)dialect);
        this.myProfileTemplateEngine.initialize();
        this.myTitleTemplateEngine = new TemplateEngine();
        resolver = new TemplateResolver();
        resolver.setResourceResolver((IResourceResolver)new TitleResourceResolver());
        this.myTitleTemplateEngine.setTemplateResolver((ITemplateResolver)resolver);
        dialect = new StandardDialect();
        additionalProcessors = new HashSet();
        additionalProcessors.add(new NarrativeAttributeProcessor());
        dialect.setAdditionalProcessors(additionalProcessors);
        this.myTitleTemplateEngine.setDialect((IDialect)dialect);
        this.myTitleTemplateEngine.initialize();
        this.myInitialized = true;
    }

    public boolean isCleanWhitespace() {
        return this.myCleanWhitespace;
    }

    public boolean isIgnoreFailures() {
        return this.myIgnoreFailures;
    }

    public boolean isIgnoreMissingTemplates() {
        return this.myIgnoreMissingTemplates;
    }

    private void loadProperties(String propFileName) throws IOException {
        ourLog.debug("Loading narrative properties file: {}", (Object)propFileName);
        Properties file = new Properties();
        InputStream resource = this.loadResource(propFileName);
        file.load(resource);
        for (Object nextKeyObj : file.keySet()) {
            String narrativeName;
            String narrativePropName;
            String name;
            String nextKey = (String)nextKeyObj;
            if (nextKey.endsWith(".profile")) {
                name = nextKey.substring(0, nextKey.indexOf(".profile"));
                if (StringUtils.isBlank((CharSequence)name)) continue;
                narrativePropName = name + ".narrative";
                narrativeName = file.getProperty(narrativePropName);
                String titlePropName = name + ".title";
                String titleName = file.getProperty(titlePropName);
                if (StringUtils.isBlank((CharSequence)narrativeName) && StringUtils.isBlank((CharSequence)titleName)) {
                    throw new ConfigurationException("Found property '" + nextKey + "' but no corresponding property '" + narrativePropName + "' or '" + titlePropName + "' in file " + propFileName);
                }
                this.myProfileToName.put(file.getProperty(nextKey), name);
                if (StringUtils.isNotBlank((CharSequence)narrativeName)) {
                    String narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName));
                    this.myNameToNarrativeTemplate.put(name, narrative);
                }
                if (!StringUtils.isNotBlank((CharSequence)titleName)) continue;
                String title = IOUtils.toString((InputStream)this.loadResource(titleName));
                this.myNameToTitleTemplate.put(name, title);
                continue;
            }
            if (nextKey.endsWith(".class")) {
                Class<?> clazz;
                name = nextKey.substring(0, nextKey.indexOf(".class"));
                if (StringUtils.isBlank((CharSequence)name)) continue;
                String className = file.getProperty(nextKey);
                try {
                    clazz = Class.forName(className);
                }
                catch (ClassNotFoundException e) {
                    ourLog.debug("Unknown datatype class '{}' identified in narrative file {}", (Object)name, (Object)propFileName);
                    clazz = null;
                }
                if (clazz == null) continue;
                this.myClassToName.put(clazz, name);
                continue;
            }
            if (nextKey.endsWith(".narrative")) {
                name = nextKey.substring(0, nextKey.indexOf(".narrative"));
                if (StringUtils.isBlank((CharSequence)name) || !StringUtils.isNotBlank((CharSequence)(narrativeName = file.getProperty(narrativePropName = name + ".narrative")))) continue;
                String narrative = IOUtils.toString((InputStream)this.loadResource(narrativeName));
                this.myNameToNarrativeTemplate.put(name, narrative);
                continue;
            }
            if (nextKey.endsWith(".title")) {
                String titlePropName;
                String titleName;
                name = nextKey.substring(0, nextKey.indexOf(".title"));
                if (StringUtils.isBlank((CharSequence)name) || !StringUtils.isNotBlank((CharSequence)(titleName = file.getProperty(titlePropName = name + ".title")))) continue;
                String title = IOUtils.toString((InputStream)this.loadResource(titleName));
                this.myNameToTitleTemplate.put(name, title);
                continue;
            }
            throw new ConfigurationException("Invalid property name: " + nextKey);
        }
    }

    private InputStream loadResource(String name) throws IOException {
        if (name.startsWith("classpath:")) {
            String cpName = name.substring("classpath:".length());
            InputStream resource = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream(cpName);
            if (resource == null && (resource = DefaultThymeleafNarrativeGenerator.class.getResourceAsStream("/" + cpName)) == null) {
                throw new IOException("Can not find '" + cpName + "' on classpath");
            }
            return resource;
        }
        if (name.startsWith("file:")) {
            File file = new File(name.substring("file:".length()));
            if (!file.exists()) {
                throw new IOException("File not found: " + file.getAbsolutePath());
            }
            return new FileInputStream(file);
        }
        throw new IOException("Invalid resource name: '" + name + "' (must start with classpath: or file: )");
    }

    public void setCleanWhitespace(boolean theCleanWhitespace) {
        this.myCleanWhitespace = theCleanWhitespace;
    }

    public void setIgnoreFailures(boolean theIgnoreFailures) {
        this.myIgnoreFailures = theIgnoreFailures;
    }

    public void setIgnoreMissingTemplates(boolean theIgnoreMissingTemplates) {
        this.myIgnoreMissingTemplates = theIgnoreMissingTemplates;
    }

    static String cleanWhitespace(String theResult) {
        StringBuilder b = new StringBuilder();
        boolean inWhitespace = false;
        boolean betweenTags = false;
        boolean lastNonWhitespaceCharWasTagEnd = false;
        boolean inPre = false;
        for (int i = 0; i < theResult.length(); ++i) {
            char nextChar = theResult.charAt(i);
            if (inPre) {
                b.append(nextChar);
                continue;
            }
            if (nextChar == '>') {
                b.append(nextChar);
                betweenTags = true;
                lastNonWhitespaceCharWasTagEnd = true;
                continue;
            }
            if (nextChar == '\n' || nextChar == '\r') continue;
            if (betweenTags) {
                if (Character.isWhitespace(nextChar)) {
                    inWhitespace = true;
                    continue;
                }
                if (nextChar == '<') {
                    if (inWhitespace && !lastNonWhitespaceCharWasTagEnd) {
                        b.append(' ');
                    }
                    inWhitespace = false;
                    b.append(nextChar);
                    inWhitespace = false;
                    betweenTags = false;
                    lastNonWhitespaceCharWasTagEnd = false;
                    if (i + 3 >= theResult.length()) continue;
                    char char1 = Character.toLowerCase(theResult.charAt(i + 1));
                    char char2 = Character.toLowerCase(theResult.charAt(i + 2));
                    char char3 = Character.toLowerCase(theResult.charAt(i + 3));
                    char char4 = Character.toLowerCase(i + 4 < theResult.length() ? theResult.charAt(i + 4) : (char)' ');
                    if (char1 == 'p' && char2 == 'r' && char3 == 'e') {
                        inPre = true;
                        continue;
                    }
                    if (char1 != '/' || char2 != 'p' || char3 != 'r' || char4 != 'e') continue;
                    inPre = false;
                    continue;
                }
                lastNonWhitespaceCharWasTagEnd = false;
                if (inWhitespace) {
                    b.append(' ');
                    inWhitespace = false;
                }
                b.append(nextChar);
                continue;
            }
            b.append(nextChar);
        }
        return b.toString();
    }

    private final class TitleResourceResolver
    implements IResourceResolver {
        private TitleResourceResolver() {
        }

        public String getName() {
            return this.getClass().getCanonicalName();
        }

        public InputStream getResourceAsStream(TemplateProcessingParameters theTemplateProcessingParameters, String theName) {
            String template = (String)BaseThymeleafNarrativeGenerator.this.myNameToTitleTemplate.get(theName);
            if (template == null) {
                ourLog.info("No narative template for resource profile: {}", (Object)theName);
                return new ReaderInputStream((Reader)new StringReader(""));
            }
            return new ReaderInputStream((Reader)new StringReader(template));
        }
    }

    private final class ProfileResourceResolver
    implements IResourceResolver {
        private ProfileResourceResolver() {
        }

        public String getName() {
            return this.getClass().getCanonicalName();
        }

        public InputStream getResourceAsStream(TemplateProcessingParameters theTemplateProcessingParameters, String theName) {
            String template = (String)BaseThymeleafNarrativeGenerator.this.myNameToNarrativeTemplate.get(theName);
            if (template == null) {
                ourLog.info("No narative template for resource profile: {}", (Object)theName);
                return new ReaderInputStream((Reader)new StringReader(""));
            }
            return new ReaderInputStream((Reader)new StringReader(template));
        }
    }

    public class NarrativeAttributeProcessor
    extends AbstractAttrProcessor {
        protected NarrativeAttributeProcessor() {
            super("narrative");
        }

        public int getPrecedence() {
            return 0;
        }

        protected ProcessorResult processAttribute(Arguments theArguments, Element theElement, String theAttributeName) {
            String attributeValue = theElement.getAttributeValue(theAttributeName);
            Configuration configuration = theArguments.getConfiguration();
            IStandardExpressionParser expressionParser = StandardExpressions.getExpressionParser((Configuration)configuration);
            IStandardExpression expression = expressionParser.parseExpression(configuration, (IProcessingContext)theArguments, attributeValue);
            Object value = expression.execute(configuration, (IProcessingContext)theArguments);
            theElement.removeAttribute(theAttributeName);
            theElement.clearChildren();
            if (value == null) {
                return ProcessorResult.ok();
            }
            Context context = new Context();
            context.setVariable("resource", value);
            String name = null;
            if (value != null) {
                Class<?> nextClass = value.getClass();
                do {
                    name = (String)BaseThymeleafNarrativeGenerator.this.myClassToName.get(nextClass);
                    nextClass = nextClass.getSuperclass();
                } while (name == null && !nextClass.equals(Object.class));
                if (name == null) {
                    if (value instanceof IBaseResource) {
                        name = BaseThymeleafNarrativeGenerator.this.myFhirContext.getResourceDefinition((IBaseResource)value).getName();
                    } else if (value instanceof IDatatype) {
                        name = value.getClass().getSimpleName();
                        name = name.substring(0, name.length() - 2);
                    } else {
                        throw new DataFormatException("Don't know how to determine name for type: " + value.getClass());
                    }
                    name = name.toLowerCase();
                    if (!BaseThymeleafNarrativeGenerator.this.myNameToNarrativeTemplate.containsKey(name)) {
                        name = null;
                    }
                }
            }
            if (name == null) {
                if (BaseThymeleafNarrativeGenerator.this.myIgnoreMissingTemplates) {
                    ourLog.debug("No narrative template available for type: {}", value.getClass());
                    return ProcessorResult.ok();
                }
                throw new DataFormatException("No narrative template for class " + value.getClass());
            }
            String result = BaseThymeleafNarrativeGenerator.this.myProfileTemplateEngine.process(name, (IContext)context);
            String trim = result.trim();
            if (!StringUtils.isBlank((CharSequence)(trim + "AAA"))) {
                Document dom = BaseThymeleafNarrativeGenerator.this.getXhtmlDOMFor(new StringReader(trim));
                Element firstChild = (Element)dom.getFirstChild();
                for (int i = 0; i < firstChild.getChildren().size(); ++i) {
                    Node next = (Node)firstChild.getChildren().get(i);
                    if (i == 0 && firstChild.getChildren().size() == 1 && next instanceof Text) {
                        Text nextText = (Text)next;
                        nextText.setContent(nextText.getContent().trim());
                    }
                    theElement.addChild(next);
                }
            }
            return ProcessorResult.ok();
        }
    }
}

