/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeDeclaredChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildChoiceDefinition;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseMetaType;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseParser
implements IParser {
    private static final Logger ourLog = LoggerFactory.getLogger(BaseParser.class);
    private ContainedResources myContainedResources;
    private FhirContext myContext;
    private Set<String> myEncodeElements;
    private Set<String> myEncodeElementsAppliesToResourceTypes;
    private boolean myEncodeElementsIncludesStars;
    private IParserErrorHandler myErrorHandler;
    private boolean myOmitResourceId;
    private String myServerBaseUrl;
    private boolean myStripVersionsFromReferences = true;
    private boolean mySummaryMode;
    private boolean mySuppressNarratives;

    public BaseParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        this.myContext = theContext;
        this.myErrorHandler = theParserErrorHandler;
    }

    protected Iterable<CompositeChildElement> compositeChildIterator(final List<? extends BaseRuntimeChildDefinition> theChildren, final boolean theContainedResource, final CompositeChildElement theParent) {
        return new Iterable<CompositeChildElement>(){

            @Override
            public Iterator<CompositeChildElement> iterator() {
                return new Iterator<CompositeChildElement>(){
                    private Iterator<? extends BaseRuntimeChildDefinition> myChildrenIter;
                    private Boolean myHasNext = null;
                    private CompositeChildElement myNext;
                    {
                        this.myChildrenIter = theChildren.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        if (this.myHasNext != null) {
                            return this.myHasNext;
                        }
                        this.myNext = null;
                        do {
                            if (!this.myChildrenIter.hasNext()) {
                                this.myHasNext = Boolean.FALSE;
                                return false;
                            }
                            this.myNext = new CompositeChildElement(theParent, this.myChildrenIter.next());
                            if (this.myNext.getDef().getElementName().equals("extension") || this.myNext.getDef().getElementName().equals("modifierExtension")) {
                                this.myNext = null;
                                continue;
                            }
                            if (this.myNext.getDef().getElementName().equals("id")) {
                                this.myNext = null;
                                continue;
                            }
                            if (!this.myNext.shouldBeEncoded()) {
                                this.myNext = null;
                                continue;
                            }
                            if (BaseParser.this.isSummaryMode() && !this.myNext.getDef().isSummary()) {
                                this.myNext = null;
                                continue;
                            }
                            if (this.myNext.getDef() instanceof RuntimeChildNarrativeDefinition) {
                                if (BaseParser.this.isSuppressNarratives() || BaseParser.this.isSummaryMode()) {
                                    this.myNext = null;
                                    continue;
                                }
                                if (!theContainedResource) continue;
                                this.myNext = null;
                                continue;
                            }
                            if (!(this.myNext.getDef() instanceof RuntimeChildContainedResources) || !theContainedResource) continue;
                            this.myNext = null;
                        } while (this.myNext == null);
                        this.myHasNext = true;
                        return true;
                    }

                    @Override
                    public CompositeChildElement next() {
                        if (this.myHasNext == null && !this.hasNext()) {
                            throw new IllegalStateException();
                        }
                        CompositeChildElement retVal = this.myNext;
                        this.myNext = null;
                        this.myHasNext = null;
                        return retVal;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private void containResourcesForEncoding(ContainedResources theContained, IBaseResource theResource, IBaseResource theTarget) {
        String nextId;
        List<IBaseResource> containedResources;
        HashSet<String> allIds = new HashSet<String>();
        HashMap<String, IBaseResource> existingIdToContainedResource = null;
        if (theTarget instanceof IResource) {
            containedResources = ((IResource)theTarget).getContained().getContainedResources();
            for (IResource iResource : containedResources) {
                nextId = iResource.getId().getValue();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                if (!nextId.startsWith("#")) {
                    nextId = '#' + nextId;
                }
                allIds.add(nextId);
                if (existingIdToContainedResource == null) {
                    existingIdToContainedResource = new HashMap<String, IBaseResource>();
                }
                existingIdToContainedResource.put(nextId, iResource);
            }
        } else if (theTarget instanceof IDomainResource) {
            containedResources = ((IDomainResource)theTarget).getContained();
            for (IAnyResource iAnyResource : containedResources) {
                nextId = iAnyResource.getIdElement().getValue();
                if (!StringUtils.isNotBlank((CharSequence)nextId)) continue;
                if (!nextId.startsWith("#")) {
                    nextId = '#' + nextId;
                }
                allIds.add(nextId);
                if (existingIdToContainedResource == null) {
                    existingIdToContainedResource = new HashMap();
                }
                existingIdToContainedResource.put(nextId, iAnyResource);
            }
        }
        List<IBaseReference> allElements = this.myContext.newTerser().getAllPopulatedChildElementsOfType(theResource, IBaseReference.class);
        for (IBaseReference iBaseReference : allElements) {
            IBaseResource potentialTarget;
            IBaseResource resource = iBaseReference.getResource();
            if (resource != null) {
                if (!resource.getIdElement().isEmpty() && !resource.getIdElement().isLocal() || theContained.getResourceId(resource) != null) continue;
                theContained.addContained(resource);
                this.containResourcesForEncoding(theContained, resource, theTarget);
                continue;
            }
            if (!iBaseReference.getReferenceElement().isLocal() || existingIdToContainedResource == null || (potentialTarget = (IBaseResource)existingIdToContainedResource.remove(iBaseReference.getReferenceElement().getValue())) == null) continue;
            theContained.addContained(iBaseReference.getReferenceElement(), potentialTarget);
            this.containResourcesForEncoding(theContained, potentialTarget, theTarget);
        }
    }

    protected void containResourcesForEncoding(IBaseResource theResource) {
        ContainedResources contained = new ContainedResources();
        this.containResourcesForEncoding(contained, theResource, theResource);
        this.myContainedResources = contained;
    }

    protected String determineReferenceText(IBaseReference theRef) {
        IIdType ref = theRef.getReferenceElement();
        if (StringUtils.isBlank((CharSequence)ref.getIdPart())) {
            String reference = ref.getValue();
            if (theRef.getResource() != null) {
                IIdType containedId = this.getContainedResources().getResourceId(theRef.getResource());
                if (containedId != null && !containedId.isEmpty()) {
                    reference = containedId.isLocal() ? containedId.getValue() : "#" + containedId.getValue();
                } else {
                    IIdType refId = theRef.getResource().getIdElement();
                    if (refId != null && refId.hasIdPart()) {
                        if (!refId.hasResourceType()) {
                            refId = refId.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
                        }
                        reference = this.isStripVersionsFromReferences() ? refId.toVersionless().getValue() : refId.getValue();
                    }
                }
            }
            return reference;
        }
        if (!ref.hasResourceType() && !ref.isLocal() && theRef.getResource() != null) {
            ref = ref.withResourceType(this.myContext.getResourceDefinition(theRef.getResource()).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)this.myServerBaseUrl) && StringUtils.equals((CharSequence)this.myServerBaseUrl, (CharSequence)ref.getBaseUrl())) {
            if (this.isStripVersionsFromReferences()) {
                return ref.toUnqualifiedVersionless().getValue();
            }
            return ref.toUnqualified().getValue();
        }
        if (this.isStripVersionsFromReferences()) {
            return ref.toVersionless().getValue();
        }
        return ref.getValue();
    }

    protected String determineResourceBaseUrl(String bundleBaseUrl, BundleEntry theEntry) {
        IResource resource = theEntry.getResource();
        if (resource == null) {
            return null;
        }
        String resourceBaseUrl = null;
        if (resource.getId() != null && resource.getId().hasBaseUrl() && !resource.getId().getBaseUrl().equals(bundleBaseUrl)) {
            resourceBaseUrl = resource.getId().getBaseUrl();
        }
        return resourceBaseUrl;
    }

    protected abstract void doEncodeBundleToWriter(Bundle var1, Writer var2) throws IOException, DataFormatException;

    protected abstract void doEncodeResourceToWriter(IBaseResource var1, Writer var2) throws IOException, DataFormatException;

    protected abstract <T extends IBaseResource> T doParseResource(Class<T> var1, Reader var2) throws DataFormatException;

    @Override
    public String encodeBundleToString(Bundle theBundle) throws DataFormatException {
        if (theBundle == null) {
            throw new NullPointerException("Bundle can not be null");
        }
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeBundleToWriter(theBundle, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return stringWriter.toString();
    }

    @Override
    public final void encodeBundleToWriter(Bundle theBundle, Writer theWriter) throws IOException, DataFormatException {
        Validate.notNull((Object)theBundle, (String)"theBundle must not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theWriter, (String)"theWriter must not be null", (Object[])new Object[0]);
        this.doEncodeBundleToWriter(theBundle, theWriter);
    }

    @Override
    public String encodeResourceToString(IBaseResource theResource) throws DataFormatException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeResourceToWriter(theResource, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public final void encodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws IOException, DataFormatException {
        Validate.notNull((Object)theResource, (String)"theResource can not be null", (Object[])new Object[0]);
        Validate.notNull((Object)theWriter, (String)"theWriter can not be null", (Object[])new Object[0]);
        this.doEncodeResourceToWriter(theResource, theWriter);
    }

    @Override
    public String encodeTagListToString(TagList theTagList) {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeTagListToWriter(theTagList, stringWriter);
        }
        catch (IOException e) {
            throw new Error("Encountered IOException during write to string - This should not happen!");
        }
        return ((Object)stringWriter).toString();
    }

    protected String fixContainedResourceId(String theValue) {
        if (StringUtils.isNotBlank((CharSequence)theValue) && theValue.charAt(0) == '#') {
            return theValue.substring(1);
        }
        return theValue;
    }

    ContainedResources getContainedResources() {
        return this.myContainedResources;
    }

    @Override
    public Set<String> getEncodeElements() {
        return this.myEncodeElements;
    }

    @Override
    public Set<String> getEncodeElementsAppliesToResourceTypes() {
        return this.myEncodeElementsAppliesToResourceTypes;
    }

    protected IParserErrorHandler getErrorHandler() {
        return this.myErrorHandler;
    }

    protected TagList getMetaTagsForEncoding(IResource theIResource) {
        TagList tags = ResourceMetadataKeyEnum.TAG_LIST.get(theIResource);
        if (this.shouldAddSubsettedTag()) {
            tags = new TagList(tags);
            tags.add(new Tag("http://hl7.org/fhir/v3/ObservationValue", "SUBSETTED", "Resource encoded in summary mode"));
        }
        return tags;
    }

    @Deprecated
    public boolean getSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    protected boolean isChildContained(BaseRuntimeElementDefinition<?> childDef, boolean theIncludedResource) {
        return (childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && !this.getContainedResources().isEmpty() && !theIncludedResource;
    }

    @Override
    public boolean isOmitResourceId() {
        return this.myOmitResourceId;
    }

    @Override
    public boolean isStripVersionsFromReferences() {
        return this.myStripVersionsFromReferences;
    }

    @Override
    public boolean isSummaryMode() {
        return this.mySummaryMode;
    }

    public boolean isSuppressNarratives() {
        return this.mySuppressNarratives;
    }

    @Override
    public Bundle parseBundle(Reader theReader) {
        if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU2_HL7ORG) {
            throw new IllegalStateException("Can't parse DSTU1 (Atom) bundle in HL7.org DSTU2 mode. Use parseResource(Bundle.class, foo) instead.");
        }
        return this.parseBundle(null, theReader);
    }

    @Override
    public Bundle parseBundle(String theXml) throws ConfigurationException, DataFormatException {
        StringReader reader = new StringReader(theXml);
        return this.parseBundle(reader);
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, Reader theReader) throws DataFormatException {
        T retVal = this.doParseResource(theResourceType, theReader);
        RuntimeResourceDefinition def = this.myContext.getResourceDefinition((IBaseResource)retVal);
        if ("Bundle".equals(def.getName())) {
            BaseRuntimeChildDefinition entryChild = def.getChildByName("entry");
            BaseRuntimeElementCompositeDefinition entryDef = (BaseRuntimeElementCompositeDefinition)entryChild.getChildByName("entry");
            List<IBase> entries = entryChild.getAccessor().getValues(retVal);
            if (entries != null) {
                for (IBase nextEntry : entries) {
                    List<IBase> entryResources;
                    IPrimitiveType value;
                    List<IBase> fullUrl;
                    BaseRuntimeChildDefinition fullUrlChild = entryDef.getChildByName("fullUrl");
                    if (fullUrlChild == null || (fullUrl = fullUrlChild.getAccessor().getValues(nextEntry)) == null || fullUrl.isEmpty() || (value = (IPrimitiveType)fullUrl.get(0)).isEmpty() || (entryResources = entryDef.getChildByName("resource").getAccessor().getValues(nextEntry)) == null || entryResources.size() <= 0) continue;
                    IBaseResource res = (IBaseResource)entryResources.get(0);
                    String versionId = res.getIdElement().getVersionIdPart();
                    res.setId(value.getValueAsString());
                    if (!StringUtils.isNotBlank((CharSequence)versionId) || res.getIdElement().hasVersionIdPart()) continue;
                    res.setId(res.getIdElement().withVersion(versionId));
                }
            }
        }
        return retVal;
    }

    @Override
    public <T extends IBaseResource> T parseResource(Class<T> theResourceType, String theMessageString) {
        StringReader reader = new StringReader(theMessageString);
        return this.parseResource(theResourceType, reader);
    }

    @Override
    public IBaseResource parseResource(Reader theReader) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theReader);
    }

    @Override
    public IBaseResource parseResource(String theMessageString) throws ConfigurationException, DataFormatException {
        return this.parseResource(null, theMessageString);
    }

    @Override
    public TagList parseTagList(String theString) {
        return this.parseTagList(new StringReader(theString));
    }

    protected List<? extends IBase> preProcessValues(BaseRuntimeChildDefinition metaChildUncast, List<? extends IBase> theValues) {
        BaseRuntimeElementCompositeDefinition metaChildUncast1;
        BaseRuntimeElementDefinition<?> childByName;
        if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2_HL7ORG) && this.shouldAddSubsettedTag() && metaChildUncast.getValidChildNames().contains("meta") && (childByName = metaChildUncast.getChildByName("meta")) instanceof BaseRuntimeElementCompositeDefinition && (metaChildUncast1 = (BaseRuntimeElementCompositeDefinition)childByName) != null && IBaseMetaType.class.isAssignableFrom(metaChildUncast1.getImplementingClass())) {
            IBaseMetaType metaValue;
            if (theValues != null && theValues.size() >= 1) {
                metaValue = (IBaseMetaType)theValues.iterator().next();
                try {
                    metaValue = (IBaseMetaType)metaValue.getClass().getMethod("copy", new Class[0]).invoke((Object)metaValue, new Object[0]);
                }
                catch (Exception e) {
                    throw new InternalErrorException("Failed to duplicate meta", (Throwable)e);
                }
            } else {
                metaValue = (IBaseMetaType)metaChildUncast1.newInstance();
            }
            ArrayList<IBaseMetaType> retVal = new ArrayList<IBaseMetaType>();
            retVal.add(metaValue);
            BaseRuntimeChildDefinition tagChild = metaChildUncast1.getChildByName("tag");
            BaseRuntimeElementCompositeDefinition codingDef = (BaseRuntimeElementCompositeDefinition)tagChild.getChildByName("tag");
            Object coding = codingDef.newInstance();
            tagChild.getMutator().addValue(metaValue, (IBase)coding);
            BaseRuntimeChildDefinition systemChild = codingDef.getChildByName("system");
            IPrimitiveType system = (IPrimitiveType)this.myContext.getElementDefinition("uri").newInstance();
            system.setValueAsString("http://hl7.org/fhir/v3/ObservationValue");
            systemChild.getMutator().addValue(coding, system);
            BaseRuntimeChildDefinition codeChild = codingDef.getChildByName("code");
            IPrimitiveType code = (IPrimitiveType)this.myContext.getElementDefinition("code").newInstance();
            code.setValueAsString("SUBSETTED");
            codeChild.getMutator().addValue(coding, code);
            BaseRuntimeChildDefinition displayChild = codingDef.getChildByName("display");
            IPrimitiveType display = (IPrimitiveType)this.myContext.getElementDefinition("string").newInstance();
            display.setValueAsString("Resource encoded in summary mode");
            displayChild.getMutator().addValue(coding, display);
            return retVal;
        }
        return theValues;
    }

    @Override
    public void setEncodeElements(Set<String> theEncodeElements) {
        this.myEncodeElementsIncludesStars = false;
        if (theEncodeElements == null || theEncodeElements.isEmpty()) {
            this.myEncodeElements = null;
        } else {
            this.myEncodeElements = theEncodeElements;
            for (String next : theEncodeElements) {
                if (!next.startsWith("*.")) continue;
                this.myEncodeElementsIncludesStars = true;
            }
        }
    }

    @Override
    public void setEncodeElementsAppliesToResourceTypes(Set<String> theEncodeElementsAppliesToResourceTypes) {
        this.myEncodeElementsAppliesToResourceTypes = theEncodeElementsAppliesToResourceTypes == null || theEncodeElementsAppliesToResourceTypes.isEmpty() ? null : theEncodeElementsAppliesToResourceTypes;
    }

    @Override
    public IParser setOmitResourceId(boolean theOmitResourceId) {
        this.myOmitResourceId = theOmitResourceId;
        return this;
    }

    @Override
    public IParser setParserErrorHandler(IParserErrorHandler theErrorHandler) {
        Validate.notNull((Object)theErrorHandler, (String)"theErrorHandler must not be null", (Object[])new Object[0]);
        this.myErrorHandler = theErrorHandler;
        return this;
    }

    @Override
    public IParser setServerBaseUrl(String theUrl) {
        this.myServerBaseUrl = StringUtils.isNotBlank((CharSequence)theUrl) ? theUrl : null;
        return this;
    }

    @Override
    public IParser setStripVersionsFromReferences(boolean theStripVersionsFromReferences) {
        this.myStripVersionsFromReferences = theStripVersionsFromReferences;
        return this;
    }

    @Override
    public IParser setSummaryMode(boolean theSummaryMode) {
        this.mySummaryMode = theSummaryMode;
        return this;
    }

    @Override
    public IParser setSuppressNarratives(boolean theSuppressNarratives) {
        this.mySuppressNarratives = theSuppressNarratives;
        return this;
    }

    protected boolean shouldAddSubsettedTag() {
        return this.isSummaryMode() || this.isSuppressNarratives();
    }

    protected void throwExceptionForUnknownChildType(BaseRuntimeChildDefinition nextChild, Class<? extends IBase> theType) {
        if (nextChild instanceof BaseRuntimeDeclaredChildDefinition) {
            StringBuilder b = new StringBuilder();
            b.append(((BaseRuntimeDeclaredChildDefinition)nextChild).getElementName());
            b.append(" has type ");
            b.append(theType.getName());
            b.append(" but this is not a valid type for this element");
            if (nextChild instanceof RuntimeChildChoiceDefinition) {
                RuntimeChildChoiceDefinition choice = (RuntimeChildChoiceDefinition)nextChild;
                b.append(" - Expected one of: " + choice.getValidChildTypes());
            }
            throw new DataFormatException(b.toString());
        }
        throw new DataFormatException(nextChild + " has no child of type " + theType);
    }

    protected static <T> List<T> extractMetadataListNotNull(IResource resource, ResourceMetadataKeyEnum<List<T>> key) {
        List<T> securityLabels = key.get(resource);
        if (securityLabels == null) {
            securityLabels = Collections.emptyList();
        }
        return securityLabels;
    }

    static class ContainedResources {
        private long myNextContainedId = 1L;
        private List<IBaseResource> myResources = new ArrayList<IBaseResource>();
        private IdentityHashMap<IBaseResource, IIdType> myResourceToId = new IdentityHashMap();

        ContainedResources() {
        }

        public void addContained(IBaseResource theResource) {
            if (this.myResourceToId.containsKey(theResource)) {
                return;
            }
            IIdType newId = theResource.getIdElement().isLocal() ? theResource.getIdElement() : new IdDt(this.myNextContainedId++);
            this.myResourceToId.put(theResource, newId);
            this.myResources.add(theResource);
        }

        public void addContained(IIdType theId, IBaseResource theResource) {
            this.myResourceToId.put(theResource, theId);
            this.myResources.add(theResource);
        }

        public List<IBaseResource> getContainedResources() {
            return this.myResources;
        }

        public IIdType getResourceId(IBaseResource theNext) {
            return this.myResourceToId.get(theNext);
        }

        public boolean isEmpty() {
            return this.myResourceToId.isEmpty();
        }
    }

    protected class CompositeChildElement {
        private final BaseRuntimeChildDefinition myDef;
        private final CompositeChildElement myParent;
        private final RuntimeResourceDefinition myResDef;

        public CompositeChildElement(CompositeChildElement theParent, BaseRuntimeChildDefinition theDef) {
            StringBuilder path;
            this.myDef = theDef;
            this.myParent = theParent;
            this.myResDef = null;
            if (ourLog.isTraceEnabled() && theParent != null && (path = theParent.buildPath()) != null) {
                path.append('.');
                path.append(this.myDef.getElementName());
                ourLog.trace(" * Next path: {}", (Object)path.toString());
            }
        }

        public CompositeChildElement(RuntimeResourceDefinition theResDef) {
            this.myResDef = theResDef;
            this.myDef = null;
            this.myParent = null;
        }

        private StringBuilder buildPath() {
            if (this.myResDef != null) {
                StringBuilder b = new StringBuilder();
                b.append(this.myResDef.getName());
                return b;
            }
            StringBuilder b = this.myParent.buildPath();
            if (b != null && this.myDef != null) {
                b.append('.');
                b.append(this.myDef.getElementName());
            }
            return b;
        }

        private boolean checkIfParentShouldBeEncodedAndBuildPath(StringBuilder theB, boolean theStarPass) {
            if (this.myResDef != null) {
                if (BaseParser.this.myEncodeElementsAppliesToResourceTypes != null && !BaseParser.this.myEncodeElementsAppliesToResourceTypes.contains(this.myResDef.getName())) {
                    return true;
                }
                if (theStarPass) {
                    theB.append('*');
                } else {
                    theB.append(this.myResDef.getName());
                }
                return BaseParser.this.myEncodeElements.contains(theB.toString());
            }
            if (this.myParent != null) {
                if (this.myParent.checkIfParentShouldBeEncodedAndBuildPath(theB, theStarPass)) {
                    return true;
                }
                if (this.myDef != null) {
                    theB.append('.');
                    theB.append(this.myDef.getElementName());
                    return BaseParser.this.myEncodeElements.contains(theB.toString());
                }
            }
            return true;
        }

        public BaseRuntimeChildDefinition getDef() {
            return this.myDef;
        }

        public CompositeChildElement getParent() {
            return this.myParent;
        }

        public RuntimeResourceDefinition getResDef() {
            return this.myResDef;
        }

        public boolean shouldBeEncoded() {
            if (BaseParser.this.myEncodeElements == null) {
                return true;
            }
            boolean retVal = this.checkIfParentShouldBeEncodedAndBuildPath(new StringBuilder(), false);
            if (!retVal && BaseParser.this.myEncodeElementsIncludesStars) {
                retVal = this.checkIfParentShouldBeEncodedAndBuildPath(new StringBuilder(), true);
            }
            return retVal;
        }
    }
}

