/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseBundle;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseContainedDt;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.util.ElementUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.stream.JsonGenerator;
import javax.json.stream.JsonGeneratorFactory;
import javax.json.stream.JsonParsingException;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseBooleanDatatype;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseDecimalDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseIntegerDatatype;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonParser
extends BaseParser
implements IParser {
    private static final Set<String> BUNDLE_TEXTNODE_CHILDREN_DSTU1;
    private static final Set<String> BUNDLE_TEXTNODE_CHILDREN_DSTU2;
    private static final Logger ourLog;
    private FhirContext myContext;
    private boolean myPrettyPrint;

    public JsonParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
    }

    private void addToHeldExtensions(int valueIdx, List<? extends IBaseExtension<?, ?>> ext, ArrayList<ArrayList<HeldExtension>> list, boolean theIsModifier) {
        if (ext.size() > 0) {
            list.ensureCapacity(valueIdx);
            while (list.size() <= valueIdx) {
                list.add(null);
            }
            if (list.get(valueIdx) == null) {
                list.set(valueIdx, new ArrayList());
            }
            for (IBaseExtension<?, ?> next : ext) {
                list.get(valueIdx).add(new HeldExtension(next, theIsModifier));
            }
        }
    }

    private void assertObjectOfType(JsonValue theResourceTypeObj, JsonValue.ValueType theValueType, String thePosition) {
        if (theResourceTypeObj == null) {
            throw new DataFormatException("Invalid JSON content detected, missing required element: '" + thePosition + "'");
        }
        if (theResourceTypeObj.getValueType() != theValueType) {
            throw new DataFormatException("Invalid content of element " + thePosition + ", expected " + theValueType);
        }
    }

    private JsonGenerator createJsonGenerator(Writer theWriter) {
        HashMap<String, Boolean> properties = new HashMap<String, Boolean>(1);
        if (this.myPrettyPrint) {
            properties.put("javax.json.stream.JsonGenerator.prettyPrinting", this.myPrettyPrint);
        }
        JsonGeneratorFactory jgf = Json.createGeneratorFactory(properties);
        JsonGenerator eventWriter = jgf.createGenerator(theWriter);
        return eventWriter;
    }

    @Override
    public void doEncodeBundleToWriter(Bundle theBundle, Writer theWriter) throws IOException {
        JsonGenerator eventWriter = this.createJsonGenerator(theWriter);
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            this.encodeBundleToWriterInDstu2Format(theBundle, eventWriter);
        } else {
            this.encodeBundleToWriterInDstu1Format(theBundle, eventWriter);
        }
        eventWriter.flush();
    }

    @Override
    protected void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws IOException {
        JsonGenerator eventWriter = this.createJsonGenerator(theWriter);
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        this.encodeResourceToJsonStreamWriter(resDef, theResource, eventWriter, null, false);
        eventWriter.flush();
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) {
        try {
            JsonReader reader = Json.createReader((Reader)theReader);
            JsonObject object = reader.readObject();
            JsonValue resourceTypeObj = (JsonValue)object.get((Object)"resourceType");
            this.assertObjectOfType(resourceTypeObj, JsonValue.ValueType.STRING, "resourceType");
            String resourceType = ((JsonString)resourceTypeObj).getString();
            ParserState<T> state = ParserState.getPreResourceInstance(theResourceType, this.myContext, true, this.getErrorHandler());
            state.enteringNewElement(null, resourceType);
            this.parseChildren(object, state);
            state.endingElement();
            IBaseResource retVal = (IBaseResource)state.getObject();
            return (T)retVal;
        }
        catch (JsonParsingException e) {
            throw new DataFormatException("Failed to parse JSON: " + e.getMessage(), e);
        }
    }

    private void encodeBundleToWriterInDstu1Format(Bundle theBundle, JsonGenerator eventWriter) throws IOException {
        eventWriter.writeStartObject();
        eventWriter.write("resourceType", "Bundle");
        this.writeTagWithTextNode(eventWriter, "title", theBundle.getTitle());
        this.writeTagWithTextNode(eventWriter, "id", theBundle.getBundleId());
        this.writeOptionalTagWithTextNode(eventWriter, "updated", theBundle.getUpdated());
        boolean linkStarted = false;
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "self", theBundle.getLinkSelf(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "first", theBundle.getLinkFirst(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "previous", theBundle.getLinkPrevious(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "next", theBundle.getLinkNext(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "last", theBundle.getLinkLast(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "fhir-base", theBundle.getLinkBase(), linkStarted);
        if (linkStarted) {
            eventWriter.writeEnd();
        }
        this.writeCategories(eventWriter, theBundle.getCategories());
        this.writeOptionalTagWithTextNode(eventWriter, "totalResults", theBundle.getTotalResults());
        this.writeAuthor(theBundle, eventWriter);
        eventWriter.writeStartArray("entry");
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            boolean deleted;
            eventWriter.writeStartObject();
            boolean bl = deleted = nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty();
            if (deleted) {
                this.writeTagWithTextNode(eventWriter, "deleted", nextEntry.getDeletedAt());
            }
            this.writeTagWithTextNode(eventWriter, "title", nextEntry.getTitle());
            this.writeTagWithTextNode(eventWriter, "id", nextEntry.getId());
            linkStarted = false;
            linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "self", nextEntry.getLinkSelf(), linkStarted);
            linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "alternate", nextEntry.getLinkAlternate(), linkStarted);
            linkStarted = this.writeAtomLinkInDstu1Format(eventWriter, "search", nextEntry.getLinkSearch(), linkStarted);
            if (linkStarted) {
                eventWriter.writeEnd();
            }
            this.writeOptionalTagWithTextNode(eventWriter, "updated", nextEntry.getUpdated());
            this.writeOptionalTagWithTextNode(eventWriter, "published", nextEntry.getPublished());
            this.writeCategories(eventWriter, nextEntry.getCategories());
            this.writeAuthor(nextEntry, eventWriter);
            IResource resource = nextEntry.getResource();
            if (resource != null && !resource.isEmpty() && !deleted) {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(resDef, resource, eventWriter, "content", false);
            }
            if (!nextEntry.getSummary().isEmpty()) {
                eventWriter.write("summary", nextEntry.getSummary().getValueAsString());
            }
            eventWriter.writeEnd();
        }
        eventWriter.writeEnd();
        eventWriter.writeEnd();
    }

    private void encodeBundleToWriterInDstu2Format(Bundle theBundle, JsonGenerator theEventWriter) throws IOException {
        theEventWriter.writeStartObject();
        theEventWriter.write("resourceType", "Bundle");
        this.writeOptionalTagWithTextNode(theEventWriter, "id", theBundle.getId().getIdPart());
        if (!ElementUtil.isEmpty(theBundle.getId().getVersionIdPart(), theBundle.getUpdated())) {
            theEventWriter.writeStartObject("meta");
            this.writeOptionalTagWithTextNode(theEventWriter, "versionId", theBundle.getId().getVersionIdPart());
            this.writeOptionalTagWithTextNode(theEventWriter, "lastUpdated", theBundle.getUpdated());
            theEventWriter.writeEnd();
        }
        this.writeOptionalTagWithTextNode(theEventWriter, "type", theBundle.getType());
        this.writeOptionalTagWithNumberNode(theEventWriter, "total", theBundle.getTotalResults());
        boolean linkStarted = false;
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "next", theBundle.getLinkNext(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "self", theBundle.getLinkSelf(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "first", theBundle.getLinkFirst(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "previous", theBundle.getLinkPrevious(), linkStarted);
        linkStarted = this.writeAtomLinkInDstu2Format(theEventWriter, "last", theBundle.getLinkLast(), linkStarted);
        if (linkStarted) {
            theEventWriter.writeEnd();
        }
        theEventWriter.writeStartArray("entry");
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            theEventWriter.writeStartObject();
            if (nextEntry.getResource() != null && nextEntry.getResource().getId().getBaseUrl() != null) {
                this.writeOptionalTagWithTextNode(theEventWriter, "fullUrl", nextEntry.getResource().getId().getValue());
            }
            boolean deleted = nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty();
            IResource resource = nextEntry.getResource();
            if (resource != null && !resource.isEmpty() && !deleted) {
                RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(resDef, resource, theEventWriter, "resource", false);
            }
            if (!nextEntry.getSearchMode().isEmpty() || !nextEntry.getScore().isEmpty()) {
                theEventWriter.writeStartObject("search");
                this.writeOptionalTagWithTextNode(theEventWriter, "mode", nextEntry.getSearchMode().getValueAsString());
                this.writeOptionalTagWithDecimalNode(theEventWriter, "score", nextEntry.getScore());
                theEventWriter.writeEnd();
            }
            if (!nextEntry.getTransactionMethod().isEmpty() || !nextEntry.getLinkSearch().isEmpty()) {
                theEventWriter.writeStartObject("request");
                this.writeOptionalTagWithTextNode(theEventWriter, "method", (String)nextEntry.getTransactionMethod().getValue());
                this.writeOptionalTagWithTextNode(theEventWriter, "url", (String)nextEntry.getLinkSearch().getValue());
                theEventWriter.writeEnd();
            }
            if (deleted) {
                theEventWriter.writeStartObject("deleted");
                if (nextEntry.getResource() != null) {
                    theEventWriter.write("type", this.myContext.getResourceDefinition(nextEntry.getResource()).getName());
                    this.writeOptionalTagWithTextNode(theEventWriter, "resourceId", nextEntry.getResource().getId().getIdPart());
                    this.writeOptionalTagWithTextNode(theEventWriter, "versionId", nextEntry.getResource().getId().getVersionIdPart());
                }
                this.writeTagWithTextNode(theEventWriter, "instant", nextEntry.getDeletedAt());
                theEventWriter.writeEnd();
            }
            if (!nextEntry.getSummary().isEmpty()) {
                theEventWriter.write("summary", nextEntry.getSummary().getValueAsString());
            }
            theEventWriter.writeEnd();
        }
        theEventWriter.writeEnd();
        theEventWriter.writeEnd();
    }

    private void encodeChildElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonGenerator theWriter, IBase theNextValue, BaseRuntimeElementDefinition<?> theChildDef, String theChildName, boolean theContainedResource, BaseParser.CompositeChildElement theChildElem) throws IOException {
        switch (theChildDef.getChildType()) {
            case ID_DATATYPE: {
                String encodedValue;
                IIdType value = (IIdType)((Object)theNextValue);
                String string = encodedValue = "id".equals(theChildName) ? value.getIdPart() : value.getValue();
                if (StringUtils.isBlank((CharSequence)encodedValue)) break;
                if (theChildName != null) {
                    theWriter.write(theChildName, encodedValue);
                    break;
                }
                theWriter.write(encodedValue);
                break;
            }
            case PRIMITIVE_DATATYPE: {
                IPrimitiveType value = (IPrimitiveType)theNextValue;
                if (StringUtils.isBlank((CharSequence)value.getValueAsString())) break;
                if (value instanceof IBaseIntegerDatatype) {
                    if (theChildName != null) {
                        theWriter.write(theChildName, ((Integer)((IBaseIntegerDatatype)value).getValue()).intValue());
                        break;
                    }
                    theWriter.write(((Integer)((IBaseIntegerDatatype)value).getValue()).intValue());
                    break;
                }
                if (value instanceof IBaseDecimalDatatype) {
                    if (theChildName != null) {
                        theWriter.write(theChildName, (BigDecimal)((IBaseDecimalDatatype)value).getValue());
                        break;
                    }
                    theWriter.write((BigDecimal)((IBaseDecimalDatatype)value).getValue());
                    break;
                }
                if (value instanceof IBaseBooleanDatatype) {
                    if (theChildName != null) {
                        theWriter.write(theChildName, ((Boolean)((IBaseBooleanDatatype)value).getValue()).booleanValue());
                        break;
                    }
                    theWriter.write(((Boolean)((IBaseBooleanDatatype)value).getValue()).booleanValue());
                    break;
                }
                String valueStr = value.getValueAsString();
                if (theChildName != null) {
                    theWriter.write(theChildName, valueStr);
                    break;
                }
                theWriter.write(valueStr);
                break;
            }
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                BaseRuntimeElementCompositeDefinition childCompositeDef = (BaseRuntimeElementCompositeDefinition)theChildDef;
                if (theChildName != null) {
                    theWriter.writeStartObject(theChildName);
                } else {
                    theWriter.writeStartObject();
                }
                if (theNextValue instanceof IBaseExtension) {
                    theWriter.write("url", ((IBaseExtension)theNextValue).getUrl());
                }
                this.encodeCompositeElementToStreamWriter(theResDef, theResource, theNextValue, theWriter, childCompositeDef, theContainedResource, theChildElem);
                theWriter.writeEnd();
                break;
            }
            case RESOURCE_REF: {
                IBaseReference referenceDt = (IBaseReference)theNextValue;
                if (theChildName != null) {
                    theWriter.writeStartObject(theChildName);
                } else {
                    theWriter.writeStartObject();
                }
                String reference = this.determineReferenceText(referenceDt);
                if (StringUtils.isNotBlank((CharSequence)reference)) {
                    theWriter.write("reference", reference);
                }
                if (!referenceDt.getDisplayElement().isEmpty()) {
                    theWriter.write("display", referenceDt.getDisplayElement().getValueAsString());
                }
                theWriter.writeEnd();
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case CONTAINED_RESOURCES: {
                List<IBaseResource> containedResources = this.getContainedResources().getContainedResources();
                if (containedResources.size() <= 0) break;
                theWriter.writeStartArray(theChildName);
                for (IBaseResource next : containedResources) {
                    IIdType resourceId = this.getContainedResources().getResourceId(next);
                    this.encodeResourceToJsonStreamWriter(theResDef, next, theWriter, null, true, this.fixContainedResourceId(resourceId.getValue()));
                }
                theWriter.writeEnd();
                break;
            }
            case PRIMITIVE_XHTML_HL7ORG: 
            case PRIMITIVE_XHTML: {
                if (!this.getSuppressNarratives()) {
                    IPrimitiveType dt = (IPrimitiveType)theNextValue;
                    if (theChildName != null) {
                        theWriter.write(theChildName, dt.getValueAsString());
                        break;
                    }
                    theWriter.write(dt.getValueAsString());
                    break;
                }
                if (theChildName != null) break;
                theWriter.writeNull();
                break;
            }
            case RESOURCE: {
                IBaseResource resource = (IBaseResource)theNextValue;
                RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resource);
                this.encodeResourceToJsonStreamWriter(def, resource, theWriter, theChildName, false);
                break;
            }
            default: {
                throw new IllegalStateException("Should not have this state here: " + theChildDef.getChildType().name());
            }
        }
    }

    private void encodeCompositeElementChildrenToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theNextValue, JsonGenerator theEventWriter, List<? extends BaseRuntimeChildDefinition> theChildren, boolean theContainedResource, BaseParser.CompositeChildElement theParent) throws IOException {
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(theChildren, theContainedResource, theParent)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                BaseNarrativeDt narr;
                INarrativeGenerator gen = this.myContext.getNarrativeGenerator();
                if (gen != null && (narr = ((IResource)theResource).getText()).getDiv().isEmpty()) {
                    gen.generateNarrative(theResDef.getResourceProfile(), theResource, narr);
                    if (narr != null && !narr.isEmpty()) {
                        RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                        String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                        BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, narr, type, childName, theContainedResource, nextChildElem);
                        continue;
                    }
                }
            } else if (nextChild instanceof RuntimeChildContainedResources) {
                String childName = nextChild.getValidChildNames().iterator().next();
                BaseRuntimeElementDefinition<?> child = nextChild.getChildByName(childName);
                this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, null, child, childName, theContainedResource, nextChildElem);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(theNextValue);
            if ((values = super.preProcessValues(nextChild, values)) == null || values.isEmpty()) continue;
            String currentChildName = null;
            boolean inArray = false;
            ArrayList<ArrayList<HeldExtension>> extensions = new ArrayList<ArrayList<HeldExtension>>(0);
            ArrayList<ArrayList<HeldExtension>> modifierExtensions = new ArrayList<ArrayList<HeldExtension>>(0);
            int valueIdx = 0;
            for (IBase nextValue : values) {
                boolean primitive;
                if (!(nextValue != null && !nextValue.isEmpty() || nextValue instanceof BaseContainedDt && !theContainedResource && !this.getContainedResources().isEmpty())) continue;
                Class<?> type = nextValue.getClass();
                String childName = nextChild.getChildNameByDatatype(type);
                BaseRuntimeElementDefinition<?> childDef = nextChild.getChildElementDefinitionByDatatype(type);
                if (childDef == null) {
                    super.throwExceptionForUnknownChildType(nextChild, type);
                }
                boolean bl = primitive = childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.PRIMITIVE_DATATYPE;
                if ((childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCES || childDef.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.CONTAINED_RESOURCE_LIST) && theContainedResource) continue;
                if (!(nextChild instanceof RuntimeChildDeclaredExtensionDefinition)) {
                    if (currentChildName == null || !currentChildName.equals(childName)) {
                        if (inArray) {
                            theEventWriter.writeEnd();
                        }
                        if (nextChild.getMax() > 1 || nextChild.getMax() == -1) {
                            theEventWriter.writeStartArray(childName);
                            inArray = true;
                            this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem);
                        } else if (!(nextChild instanceof RuntimeChildNarrativeDefinition) || !theContainedResource) {
                            this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, childName, theContainedResource, nextChildElem);
                        }
                        currentChildName = childName;
                    } else {
                        this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, nextValue, childDef, null, theContainedResource, nextChildElem);
                    }
                    if (primitive) {
                        if (nextValue instanceof ISupportsUndeclaredExtensions) {
                            List<ExtensionDt> ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredExtensions();
                            this.addToHeldExtensions(valueIdx, ext, extensions, false);
                            ext = ((ISupportsUndeclaredExtensions)nextValue).getUndeclaredModifierExtensions();
                            this.addToHeldExtensions(valueIdx, ext, modifierExtensions, true);
                        } else {
                            List<? extends IBaseExtension<?, ?>> ext;
                            Object element;
                            if (nextValue instanceof IBaseHasExtensions) {
                                element = (IBaseHasExtensions)((Object)nextValue);
                                ext = element.getExtension();
                                this.addToHeldExtensions(valueIdx, ext, extensions, false);
                            }
                            if (nextValue instanceof IBaseHasModifierExtensions) {
                                element = (IBaseHasModifierExtensions)((Object)nextValue);
                                ext = element.getModifierExtension();
                                this.addToHeldExtensions(valueIdx, ext, extensions, true);
                            }
                        }
                    }
                }
                ++valueIdx;
            }
            if (inArray) {
                theEventWriter.writeEnd();
            }
            if (extensions.size() <= 0 && modifierExtensions.size() <= 0) continue;
            if (inArray) {
                theEventWriter.writeStartArray('_' + currentChildName);
            } else {
                theEventWriter.writeStartObject('_' + currentChildName);
            }
            for (int i = 0; i < valueIdx; ++i) {
                boolean haveContent = false;
                List heldExts = Collections.emptyList();
                List heldModExts = Collections.emptyList();
                if (extensions.size() > i && extensions.get(i) != null && !((ArrayList)extensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldExts = (List)extensions.get(i);
                }
                if (modifierExtensions.size() > i && modifierExtensions.get(i) != null && !((ArrayList)modifierExtensions.get(i)).isEmpty()) {
                    haveContent = true;
                    heldModExts = (List)modifierExtensions.get(i);
                }
                if (!haveContent) {
                    theEventWriter.writeNull();
                    continue;
                }
                if (inArray) {
                    theEventWriter.writeStartObject();
                }
                this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, heldExts, heldModExts, null);
                if (!inArray) continue;
                theEventWriter.writeEnd();
            }
            theEventWriter.writeEnd();
        }
    }

    private void encodeCompositeElementToStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theNextValue, JsonGenerator theEventWriter, BaseRuntimeElementCompositeDefinition<?> resDef, boolean theContainedResource, BaseParser.CompositeChildElement theParent) throws IOException, DataFormatException {
        this.extractAndWriteExtensionsAsDirectChild(theNextValue, theEventWriter, resDef, theResDef, theResource, null);
        this.encodeCompositeElementChildrenToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, resDef.getExtensions(), theContainedResource, theParent);
        this.encodeCompositeElementChildrenToStreamWriter(theResDef, theResource, theNextValue, theEventWriter, resDef.getChildren(), theContainedResource, theParent);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonGenerator theEventWriter, String theObjectNameOrNull, boolean theContainedResource) throws IOException {
        String resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            resourceId = theResource.getIdElement().getIdPart();
            if (theResource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
            if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1)) {
                resourceId = null;
            }
        }
        if (this.isOmitResourceId() && !theContainedResource) {
            resourceId = null;
        }
        this.encodeResourceToJsonStreamWriter(theResDef, theResource, theEventWriter, theObjectNameOrNull, theContainedResource, resourceId);
    }

    private void encodeResourceToJsonStreamWriter(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonGenerator theEventWriter, String theObjectNameOrNull, boolean theContainedResource, String theResourceId) throws IOException {
        if (!theContainedResource) {
            super.containResourcesForEncoding(theResource);
        }
        RuntimeResourceDefinition resDef = this.myContext.getResourceDefinition(theResource);
        if (theObjectNameOrNull == null) {
            theEventWriter.writeStartObject();
        } else {
            theEventWriter.writeStartObject(theObjectNameOrNull);
        }
        theEventWriter.write("resourceType", resDef.getName());
        if (theResourceId != null) {
            theEventWriter.write("id", theResourceId);
        }
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1) && theResource instanceof IResource) {
            IResource resource = (IResource)theResource;
            List<BaseCodingDt> securityLabels = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.SECURITY_LABELS);
            List<IdDt> profiles = JsonParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.PROFILES);
            TagList tags = this.getMetaTagsForEncoding(resource);
            InstantDt updated = (InstantDt)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
            IdDt resourceId = resource.getId();
            String versionIdPart = resourceId.getVersionIdPart();
            if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                versionIdPart = ResourceMetadataKeyEnum.VERSION.get(resource);
            }
            if (!ElementUtil.isEmpty(versionIdPart, updated, securityLabels, tags, profiles)) {
                theEventWriter.writeStartObject("meta");
                this.writeOptionalTagWithTextNode(theEventWriter, "versionId", versionIdPart);
                this.writeOptionalTagWithTextNode(theEventWriter, "lastUpdated", updated);
                if (profiles != null && !profiles.isEmpty()) {
                    theEventWriter.writeStartArray("profile");
                    for (IdDt profile : profiles) {
                        if (profile == null || !StringUtils.isNotBlank((CharSequence)profile.getValue())) continue;
                        theEventWriter.write(profile.getValue());
                    }
                    theEventWriter.writeEnd();
                }
                if (!securityLabels.isEmpty()) {
                    theEventWriter.writeStartArray("security");
                    for (BaseCodingDt securityLabel : securityLabels) {
                        theEventWriter.writeStartObject();
                        BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(securityLabel.getClass());
                        this.encodeCompositeElementChildrenToStreamWriter(resDef, resource, securityLabel, theEventWriter, def.getChildren(), theContainedResource, null);
                        theEventWriter.writeEnd();
                    }
                    theEventWriter.writeEnd();
                }
                if (tags != null && !tags.isEmpty()) {
                    theEventWriter.writeStartArray("tag");
                    for (Tag tag : tags) {
                        if (tag.isEmpty()) continue;
                        theEventWriter.writeStartObject();
                        this.writeOptionalTagWithTextNode(theEventWriter, "system", tag.getScheme());
                        this.writeOptionalTagWithTextNode(theEventWriter, "code", tag.getTerm());
                        this.writeOptionalTagWithTextNode(theEventWriter, "display", tag.getLabel());
                        theEventWriter.writeEnd();
                    }
                    theEventWriter.writeEnd();
                }
                theEventWriter.writeEnd();
            }
        }
        if (theResource instanceof IBaseBinary) {
            String contentAsBase64;
            IBaseBinary bin = (IBaseBinary)theResource;
            String contentType = bin.getContentType();
            if (StringUtils.isNotBlank((CharSequence)contentType)) {
                theEventWriter.write("contentType", contentType);
            }
            if (StringUtils.isNotBlank((CharSequence)(contentAsBase64 = bin.getContentAsBase64()))) {
                theEventWriter.write("content", contentAsBase64);
            }
        } else {
            this.encodeCompositeElementToStreamWriter(theResDef, theResource, theResource, theEventWriter, resDef, theContainedResource, new BaseParser.CompositeChildElement(resDef));
        }
        theEventWriter.writeEnd();
    }

    @Override
    public void encodeTagListToWriter(TagList theTagList, Writer theWriter) throws IOException {
        JsonGenerator eventWriter = this.createJsonGenerator(theWriter);
        eventWriter.writeStartObject();
        eventWriter.write("resourceType", "TagList");
        eventWriter.writeStartArray("category");
        for (Tag next : theTagList) {
            eventWriter.writeStartObject();
            if (StringUtils.isNotBlank((CharSequence)next.getTerm())) {
                eventWriter.write("term", next.getTerm());
            }
            if (StringUtils.isNotBlank((CharSequence)next.getLabel())) {
                eventWriter.write("label", next.getLabel());
            }
            if (StringUtils.isNotBlank((CharSequence)next.getScheme())) {
                eventWriter.write("scheme", next.getScheme());
            }
            eventWriter.writeEnd();
        }
        eventWriter.writeEnd();
        eventWriter.writeEnd();
        eventWriter.flush();
    }

    private void extractAndWriteExtensionsAsDirectChild(IBase theElement, JsonGenerator theEventWriter, BaseRuntimeElementDefinition<?> theElementDef, RuntimeResourceDefinition theResDef, IBaseResource theResource, String theParentExtensionUrl) throws IOException {
        ArrayList<HeldExtension> extensions = new ArrayList<HeldExtension>(0);
        ArrayList<HeldExtension> modifierExtensions = new ArrayList<HeldExtension>(0);
        this.extractUndeclaredExtensions(theElement, extensions, modifierExtensions);
        if (theElementDef != null) {
            this.extractDeclaredExtensions(theElement, theElementDef, extensions, modifierExtensions);
        }
        this.writeExtensionsAsDirectChild(theResource, theEventWriter, theResDef, extensions, modifierExtensions, theParentExtensionUrl);
    }

    private void extractDeclaredExtensions(IBase theResource, BaseRuntimeElementDefinition<?> resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions) {
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsNonModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue == null || nextValue.isEmpty()) continue;
                extensions.add(new HeldExtension(nextDef, nextValue));
            }
        }
        for (RuntimeChildDeclaredExtensionDefinition nextDef : resDef.getExtensionsModifier()) {
            for (IBase nextValue : nextDef.getAccessor().getValues(theResource)) {
                if (nextValue == null || nextValue == null || nextValue.isEmpty()) continue;
                modifierExtensions.add(new HeldExtension(nextDef, nextValue));
            }
        }
    }

    private void extractUndeclaredExtensions(IBase theElement, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions) {
        block6: {
            List<IBaseExtension<?, ?>> ext;
            Object element;
            block5: {
                if (!(theElement instanceof ISupportsUndeclaredExtensions)) break block5;
                ISupportsUndeclaredExtensions element2 = (ISupportsUndeclaredExtensions)theElement;
                List<ExtensionDt> ext2 = element2.getUndeclaredExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    extensions.add(new HeldExtension(next, false));
                }
                ext2 = element2.getUndeclaredModifierExtensions();
                for (ExtensionDt next : ext2) {
                    if (next == null || next.isEmpty()) continue;
                    modifierExtensions.add(new HeldExtension(next, true));
                }
                break block6;
            }
            if (theElement instanceof IBaseHasExtensions) {
                element = (IBaseHasExtensions)((Object)theElement);
                ext = element.getExtension();
                for (IBaseExtension<?, ?> next : ext) {
                    if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
                    extensions.add(new HeldExtension(next, false));
                }
            }
            if (!(theElement instanceof IBaseHasModifierExtensions)) break block6;
            element = (IBaseHasModifierExtensions)((Object)theElement);
            ext = element.getModifierExtension();
            for (IBaseExtension<?, ?> next : ext) {
                if (next == null || next.isEmpty()) continue;
                modifierExtensions.add(new HeldExtension(next, true));
            }
        }
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.JSON;
    }

    private void parseAlternates(JsonValue theAlternateVal, ParserState<?> theState, String theElementName) {
        if (theAlternateVal == null || theAlternateVal.getValueType() == JsonValue.ValueType.NULL) {
            return;
        }
        if (theAlternateVal instanceof JsonArray) {
            JsonArray array = (JsonArray)theAlternateVal;
            if (array.size() > 1) {
                throw new DataFormatException("Unexpected array of length " + array.size() + " (expected 0 or 1) for element: " + theElementName);
            }
            if (array.size() == 0) {
                return;
            }
            this.parseAlternates((JsonValue)array.getJsonObject(0), theState, theElementName);
            return;
        }
        JsonObject alternate = (JsonObject)theAlternateVal;
        for (Map.Entry nextEntry : alternate.entrySet()) {
            JsonArray array;
            boolean isModifier;
            String nextKey = (String)nextEntry.getKey();
            JsonValue nextVal = (JsonValue)nextEntry.getValue();
            if ("extension".equals(nextKey)) {
                isModifier = false;
                array = (JsonArray)((JsonValue)nextEntry.getValue());
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if ("modifierExtension".equals(nextKey)) {
                isModifier = true;
                array = (JsonArray)((JsonValue)nextEntry.getValue());
                this.parseExtension(theState, array, isModifier);
                continue;
            }
            if (!"id".equals(nextKey)) continue;
            switch (nextVal.getValueType()) {
                case STRING: {
                    theState.attributeValue("id", ((JsonString)nextVal).getString());
                    break;
                }
                case NULL: {
                    break;
                }
            }
        }
    }

    @Override
    public <T extends IBaseResource> Bundle parseBundle(Class<T> theResourceType, Reader theReader) {
        JsonObject object;
        try {
            JsonReader reader = Json.createReader((Reader)theReader);
            object = reader.readObject();
        }
        catch (JsonParsingException e) {
            if (e.getMessage().startsWith("Unexpected char 39")) {
                throw new DataFormatException("Failed to parse JSON encoded FHIR content: " + e.getMessage() + " - This may indicate that single quotes are being used as JSON escapes where double quotes are required", e);
            }
            throw new DataFormatException("Failed to parse JSON encoded FHIR content: " + e.getMessage(), e);
        }
        JsonValue resourceTypeObj = (JsonValue)object.get((Object)"resourceType");
        this.assertObjectOfType(resourceTypeObj, JsonValue.ValueType.STRING, "resourceType");
        String resourceType = ((JsonString)resourceTypeObj).getString();
        if (!"Bundle".equals(resourceType)) {
            throw new DataFormatException("Trying to parse bundle but found resourceType other than 'Bundle'. Found: '" + resourceType + "'");
        }
        ParserState<Bundle> state = ParserState.getPreAtomInstance(this.myContext, theResourceType, true, this.getErrorHandler());
        if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            state.enteringNewElement(null, "Bundle");
        } else {
            state.enteringNewElement(null, "feed");
        }
        this.parseBundleChildren(object, state);
        state.endingElement();
        Bundle retVal = state.getObject();
        return retVal;
    }

    private void parseBundleChildren(JsonObject theObject, ParserState<?> theState) {
        for (String nextName : theObject.keySet()) {
            String href;
            String rel;
            JsonObject linkObj;
            JsonArray entries;
            if ("resourceType".equals(nextName)) continue;
            if ("entry".equals(nextName)) {
                entries = this.grabJsonArray(theObject, nextName, "entry");
                for (JsonValue jsonValue : entries) {
                    theState.enteringNewElement(null, "entry");
                    this.parseBundleChildren((JsonObject)jsonValue, theState);
                    theState.endingElement();
                }
                continue;
            }
            if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                if ("link".equals(nextName)) {
                    entries = this.grabJsonArray(theObject, nextName, "link");
                    for (JsonValue jsonValue : entries) {
                        theState.enteringNewElement(null, "link");
                        linkObj = (JsonObject)jsonValue;
                        rel = linkObj.getString("rel", null);
                        href = linkObj.getString("href", null);
                        theState.attributeValue("rel", rel);
                        theState.attributeValue("href", href);
                        theState.endingElement();
                    }
                    continue;
                }
                if (BUNDLE_TEXTNODE_CHILDREN_DSTU1.contains(nextName)) {
                    theState.enteringNewElement(null, nextName);
                    theState.string(theObject.getString(nextName, null));
                    theState.endingElement();
                    continue;
                }
            } else {
                if ("link".equals(nextName)) {
                    entries = this.grabJsonArray(theObject, nextName, "link");
                    for (JsonValue jsonValue : entries) {
                        theState.enteringNewElement(null, "link");
                        linkObj = (JsonObject)jsonValue;
                        rel = linkObj.getString("relation", null);
                        href = linkObj.getString("url", null);
                        theState.enteringNewElement(null, "relation");
                        theState.attributeValue("value", rel);
                        theState.endingElement();
                        theState.enteringNewElement(null, "url");
                        theState.attributeValue("value", href);
                        theState.endingElement();
                        theState.endingElement();
                    }
                    continue;
                }
                if (BUNDLE_TEXTNODE_CHILDREN_DSTU2.contains(nextName)) {
                    theState.enteringNewElement(null, nextName);
                    JsonValue obj = (JsonValue)theObject.get((Object)nextName);
                    if (obj == null) {
                        theState.attributeValue("value", null);
                    } else if (obj instanceof JsonString) {
                        theState.attributeValue("value", theObject.getString(nextName, null));
                    } else if (obj instanceof JsonNumber) {
                        theState.attributeValue("value", obj.toString());
                    } else {
                        throw new DataFormatException("Unexpected JSON object for entry '" + nextName + "'");
                    }
                    theState.endingElement();
                    continue;
                }
            }
            JsonValue nextVal = (JsonValue)theObject.get((Object)nextName);
            this.parseChildren(theState, nextName, nextVal, null, null);
        }
    }

    private void parseChildren(JsonObject theObject, ParserState<?> theState) {
        String elementId = null;
        for (String nextName : theObject.keySet()) {
            if ("resourceType".equals(nextName)) continue;
            if ("id".equals(nextName)) {
                if (theObject.isNull(nextName)) continue;
                elementId = theObject.getString(nextName);
                if (this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                    continue;
                }
            } else {
                JsonArray array;
                if ("_id".equals(nextName)) {
                    if (theObject.isNull(nextName) || ((JsonValue)theObject.get((Object)nextName)).getValueType() != JsonValue.ValueType.STRING) continue;
                    elementId = theObject.getString(nextName);
                    continue;
                }
                if ("extension".equals(nextName)) {
                    array = this.grabJsonArray(theObject, nextName, "extension");
                    this.parseExtension(theState, array, false);
                    continue;
                }
                if ("modifierExtension".equals(nextName)) {
                    array = this.grabJsonArray(theObject, nextName, "modifierExtension");
                    this.parseExtension(theState, array, true);
                    continue;
                }
                if (nextName.charAt(0) == '_') continue;
            }
            JsonValue nextVal = (JsonValue)theObject.get((Object)nextName);
            String alternateName = '_' + nextName;
            JsonValue alternateVal = (JsonValue)theObject.get((Object)alternateName);
            this.parseChildren(theState, nextName, nextVal, alternateVal, alternateName);
        }
        if (elementId != null) {
            IBase object = (IBase)theState.getObject();
            if (object instanceof IIdentifiableElement) {
                ((IIdentifiableElement)object).setElementSpecificId(elementId);
            } else if (object instanceof IBaseResource) {
                ((IBaseResource)object).getIdElement().setValue(elementId);
            }
        }
    }

    private JsonArray grabJsonArray(JsonObject theObject, String nextName, String thePosition) {
        JsonValue object = (JsonValue)theObject.get((Object)nextName);
        if (object == null) {
            return null;
        }
        if (object.getValueType() != JsonValue.ValueType.ARRAY) {
            throw new DataFormatException("Syntax error parsing JSON FHIR structure: Expected ARRAY at element '" + thePosition + "', found '" + object.getValueType().name() + "'");
        }
        return (JsonArray)object;
    }

    private void parseChildren(ParserState<?> theState, String theName, JsonValue theJsonVal, JsonValue theAlternateVal, String theAlternateName) {
        switch (theJsonVal.getValueType()) {
            case ARRAY: {
                JsonArray nextArray = (JsonArray)theJsonVal;
                JsonArray nextAlternateArray = (JsonArray)theAlternateVal;
                for (int i = 0; i < nextArray.size(); ++i) {
                    JsonValue nextObject = (JsonValue)nextArray.get(i);
                    JsonValue nextAlternate = null;
                    if (nextAlternateArray != null) {
                        nextAlternate = (JsonValue)nextAlternateArray.get(i);
                    }
                    this.parseChildren(theState, theName, nextObject, nextAlternate, theAlternateName);
                }
                break;
            }
            case OBJECT: {
                theState.enteringNewElement(null, theName);
                this.parseAlternates(theAlternateVal, theState, theAlternateName);
                JsonObject nextObject = (JsonObject)theJsonVal;
                boolean preResource = false;
                if (theState.isPreResource()) {
                    String resType = nextObject.getString("resourceType", null);
                    if (StringUtils.isBlank((CharSequence)resType)) {
                        throw new DataFormatException("Missing required element 'resourceType' from JSON resource object, unable to parse");
                    }
                    theState.enteringNewElement(null, resType);
                    preResource = true;
                }
                this.parseChildren(nextObject, theState);
                if (preResource) {
                    theState.endingElement();
                }
                theState.endingElement();
                break;
            }
            case STRING: {
                JsonString nextValStr = (JsonString)theJsonVal;
                theState.enteringNewElement(null, theName);
                theState.attributeValue("value", nextValStr.getString());
                this.parseAlternates(theAlternateVal, theState, theAlternateName);
                theState.endingElement();
                break;
            }
            case NUMBER: 
            case FALSE: 
            case TRUE: {
                theState.enteringNewElement(null, theName);
                theState.attributeValue("value", theJsonVal.toString());
                this.parseAlternates(theAlternateVal, theState, theAlternateName);
                theState.endingElement();
                break;
            }
        }
    }

    private void parseExtension(ParserState<?> theState, JsonArray theValues, boolean theIsModifier) {
        for (int i = 0; i < theValues.size(); ++i) {
            JsonObject nextExtObj = theValues.getJsonObject(i);
            String url = nextExtObj.getString("url");
            theState.enteringNewElementExtension(null, url, theIsModifier);
            for (String next : nextExtObj.keySet()) {
                JsonArray jsonVal;
                if ("url".equals(next)) continue;
                if ("extension".equals(next)) {
                    jsonVal = (JsonArray)((JsonValue)nextExtObj.get((Object)next));
                    this.parseExtension(theState, jsonVal, false);
                    continue;
                }
                if ("modifierExtension".equals(next)) {
                    jsonVal = (JsonArray)((JsonValue)nextExtObj.get((Object)next));
                    this.parseExtension(theState, jsonVal, true);
                    continue;
                }
                jsonVal = (JsonValue)nextExtObj.get((Object)next);
                this.parseChildren(theState, next, (JsonValue)jsonVal, null, null);
            }
            theState.endingElement();
        }
    }

    @Override
    public TagList parseTagList(Reader theReader) {
        JsonReader reader = Json.createReader((Reader)theReader);
        JsonObject object = reader.readObject();
        JsonValue resourceTypeObj = (JsonValue)object.get((Object)"resourceType");
        this.assertObjectOfType(resourceTypeObj, JsonValue.ValueType.STRING, "resourceType");
        String resourceType = ((JsonString)resourceTypeObj).getString();
        ParserState<TagList> state = ParserState.getPreTagListInstance(this.myContext, true, this.getErrorHandler());
        state.enteringNewElement(null, resourceType);
        this.parseChildren(object, state);
        state.endingElement();
        return state.getObject();
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
        return this;
    }

    private boolean writeAtomLinkInDstu1Format(JsonGenerator theEventWriter, String theRel, StringDt theLink, boolean theStarted) {
        boolean retVal = theStarted;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theLink.getValue()))) {
            if (!theStarted) {
                theEventWriter.writeStartArray("link");
                retVal = true;
            }
            theEventWriter.writeStartObject();
            theEventWriter.write("rel", theRel);
            theEventWriter.write("href", (String)theLink.getValue());
            theEventWriter.writeEnd();
        }
        return retVal;
    }

    private boolean writeAtomLinkInDstu2Format(JsonGenerator theEventWriter, String theRel, StringDt theLink, boolean theStarted) {
        boolean retVal = theStarted;
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theLink.getValue()))) {
            if (!theStarted) {
                theEventWriter.writeStartArray("link");
                retVal = true;
            }
            theEventWriter.writeStartObject();
            theEventWriter.write("relation", theRel);
            theEventWriter.write("url", (String)theLink.getValue());
            theEventWriter.writeEnd();
        }
        return retVal;
    }

    private void writeAuthor(BaseBundle theBundle, JsonGenerator eventWriter) {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theBundle.getAuthorName().getValue()))) {
            eventWriter.writeStartArray("author");
            eventWriter.writeStartObject();
            this.writeTagWithTextNode(eventWriter, "name", theBundle.getAuthorName());
            this.writeOptionalTagWithTextNode(eventWriter, "uri", theBundle.getAuthorUri());
            eventWriter.writeEnd();
            eventWriter.writeEnd();
        }
    }

    private void writeCategories(JsonGenerator eventWriter, TagList categories) {
        if (categories != null && categories.size() > 0) {
            eventWriter.writeStartArray("category");
            for (Tag next : categories) {
                eventWriter.writeStartObject();
                eventWriter.write("term", StringUtils.defaultString((String)next.getTerm()));
                eventWriter.write("label", StringUtils.defaultString((String)next.getLabel()));
                eventWriter.write("scheme", StringUtils.defaultString((String)next.getScheme()));
                eventWriter.writeEnd();
            }
            eventWriter.writeEnd();
        }
    }

    private void writeExtensionsAsDirectChild(IBaseResource theResource, JsonGenerator theEventWriter, RuntimeResourceDefinition resDef, List<HeldExtension> extensions, List<HeldExtension> modifierExtensions, String theParentExtensionUrl) throws IOException {
        if (!extensions.isEmpty()) {
            theEventWriter.writeStartArray("extension");
            for (HeldExtension next : extensions) {
                next.write(resDef, theResource, theEventWriter);
            }
            theEventWriter.writeEnd();
        }
        if (!modifierExtensions.isEmpty()) {
            theEventWriter.writeStartArray("modifierExtension");
            for (HeldExtension next : modifierExtensions) {
                next.write(resDef, theResource, theEventWriter);
            }
            theEventWriter.writeEnd();
        }
    }

    private void writeOptionalTagWithDecimalNode(JsonGenerator theEventWriter, String theElementName, DecimalDt theValue) {
        if (theValue != null && !theValue.isEmpty()) {
            theEventWriter.write(theElementName, (BigDecimal)theValue.getValue());
        }
    }

    private void writeOptionalTagWithNumberNode(JsonGenerator theEventWriter, String theElementName, IntegerDt theValue) {
        if (theValue != null && !theValue.isEmpty()) {
            theEventWriter.write(theElementName, ((Integer)theValue.getValue()).intValue());
        }
    }

    private void writeOptionalTagWithTextNode(JsonGenerator theEventWriter, String theElementName, IPrimitiveDatatype<?> thePrimitive) {
        if (thePrimitive == null) {
            return;
        }
        String str = thePrimitive.getValueAsString();
        this.writeOptionalTagWithTextNode(theEventWriter, theElementName, str);
    }

    private void writeOptionalTagWithTextNode(JsonGenerator theEventWriter, String theElementName, String theValue) {
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            theEventWriter.write(theElementName, theValue);
        }
    }

    private void writeTagWithTextNode(JsonGenerator theEventWriter, String theElementName, IPrimitiveDatatype<?> theIdDt) {
        if (theIdDt != null && !theIdDt.isEmpty()) {
            theEventWriter.write(theElementName, theIdDt.getValueAsString());
        } else {
            theEventWriter.writeNull(theElementName);
        }
    }

    private void writeTagWithTextNode(JsonGenerator theEventWriter, String theElementName, StringDt theStringDt) {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theStringDt.getValue()))) {
            theEventWriter.write(theElementName, (String)theStringDt.getValue());
        }
    }

    static {
        ourLog = LoggerFactory.getLogger(HeldExtension.class);
        HashSet<String> hashSetDstu1 = new HashSet<String>();
        hashSetDstu1.add("title");
        hashSetDstu1.add("id");
        hashSetDstu1.add("updated");
        hashSetDstu1.add("published");
        hashSetDstu1.add("totalResults");
        BUNDLE_TEXTNODE_CHILDREN_DSTU1 = Collections.unmodifiableSet(hashSetDstu1);
        HashSet<String> hashSetDstu2 = new HashSet<String>();
        hashSetDstu2.add("type");
        hashSetDstu2.add("base");
        hashSetDstu2.add("total");
        BUNDLE_TEXTNODE_CHILDREN_DSTU2 = Collections.unmodifiableSet(hashSetDstu2);
    }

    private class HeldExtension
    implements Comparable<HeldExtension> {
        private RuntimeChildDeclaredExtensionDefinition myDef;
        private boolean myModifier;
        private IBaseExtension<?, ?> myUndeclaredExtension;
        private IBase myValue;

        public HeldExtension(IBaseExtension<?, ?> theUndeclaredExtension, boolean theModifier) {
            assert (theUndeclaredExtension != null);
            this.myUndeclaredExtension = theUndeclaredExtension;
            this.myModifier = theModifier;
        }

        public HeldExtension(RuntimeChildDeclaredExtensionDefinition theDef, IBase theValue) {
            assert (theDef != null);
            assert (theValue != null);
            this.myDef = theDef;
            this.myValue = theValue;
        }

        @Override
        public int compareTo(HeldExtension theArg0) {
            String url1 = this.myDef != null ? this.myDef.getExtensionUrl() : this.myUndeclaredExtension.getUrl();
            String url2 = theArg0.myDef != null ? theArg0.myDef.getExtensionUrl() : theArg0.myUndeclaredExtension.getUrl();
            url1 = StringUtils.defaultString((String)url1);
            url2 = StringUtils.defaultString((String)url2);
            return url1.compareTo(url2);
        }

        public void write(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonGenerator theEventWriter) throws IOException {
            if (this.myUndeclaredExtension != null) {
                this.writeUndeclaredExtInDstu1Format(theResDef, theResource, theEventWriter, this.myUndeclaredExtension);
            } else {
                theEventWriter.writeStartObject();
                theEventWriter.write("url", this.myDef.getExtensionUrl());
                BaseRuntimeElementDefinition<?> def = this.myDef.getChildElementDefinitionByDatatype(this.myValue.getClass());
                if (def.getChildType() == BaseRuntimeElementDefinition.ChildTypeEnum.RESOURCE_BLOCK) {
                    JsonParser.this.extractAndWriteExtensionsAsDirectChild(this.myValue, theEventWriter, def, theResDef, theResource, this.myDef.getExtensionUrl());
                } else {
                    String childName = this.myDef.getChildNameByDatatype(this.myValue.getClass());
                    JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, this.myValue, def, childName, false, null);
                }
                theEventWriter.writeEnd();
            }
        }

        private void writeUndeclaredExtInDstu1Format(RuntimeResourceDefinition theResDef, IBaseResource theResource, JsonGenerator theEventWriter, IBaseExtension<?, ?> ext) throws IOException {
            boolean noValue;
            IBaseDatatype value = ext.getValue();
            String extensionUrl = ext.getUrl();
            theEventWriter.writeStartObject();
            theEventWriter.write("url", extensionUrl);
            boolean bl = noValue = value == null || value.isEmpty();
            if (noValue && ext.getExtension().isEmpty()) {
                ourLog.debug("Extension with URL[{}] has no value", (Object)extensionUrl);
            } else if (noValue) {
                if (this.myModifier) {
                    theEventWriter.writeStartArray("modifierExtension");
                } else {
                    theEventWriter.writeStartArray("extension");
                }
                for (Object next : ext.getExtension()) {
                    this.writeUndeclaredExtInDstu1Format(theResDef, theResource, theEventWriter, (IBaseExtension)next);
                }
                theEventWriter.writeEnd();
            } else {
                BaseRuntimeElementDefinition<?> childDef;
                RuntimeChildUndeclaredExtensionDefinition extDef = JsonParser.this.myContext.getRuntimeChildUndeclaredExtensionDefinition();
                String childName = extDef.getChildNameByDatatype(value.getClass());
                if (childName == null) {
                    childName = "value" + JsonParser.this.myContext.getElementDefinition(value.getClass()).getName();
                }
                if ((childDef = JsonParser.this.myContext.getElementDefinition(value.getClass())) == null) {
                    throw new ConfigurationException("Unable to encode extension, unregognized child element type: " + value.getClass().getCanonicalName());
                }
                JsonParser.this.encodeChildElementToStreamWriter(theResDef, theResource, theEventWriter, value, childDef, childName, true, null);
            }
            theEventWriter.writeEnd();
        }
    }
}

