/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.parser.IParserErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LenientErrorHandler
implements IParserErrorHandler {
    private static final Logger ourLog = LoggerFactory.getLogger(LenientErrorHandler.class);
    private boolean myLogErrors;

    public LenientErrorHandler() {
        this.myLogErrors = true;
    }

    public LenientErrorHandler(boolean theLogErrors) {
        this.myLogErrors = theLogErrors;
    }

    @Override
    public void unknownElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Unknown element '{}' found while parsing", (Object)theElementName);
        }
    }

    @Override
    public void unknownAttribute(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Unknown attribute '{}' found while parsing", (Object)theElementName);
        }
    }

    @Override
    public void unexpectedRepeatingElement(IParserErrorHandler.IParseLocation theLocation, String theElementName) {
        if (this.myLogErrors) {
            ourLog.warn("Multiple repetitions of non-repeatable element '{}' found while parsing", (Object)theElementName);
        }
    }
}

