/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeNarrativeDefinition;
import ca.uhn.fhir.context.RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition;
import ca.uhn.fhir.context.RuntimeResourceBlockDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.BaseBundle;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.ExtensionDt;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IFhirVersion;
import ca.uhn.fhir.model.api.IIdentifiableElement;
import ca.uhn.fhir.model.api.IPrimitiveDatatype;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseResourceReferenceDt;
import ca.uhn.fhir.model.base.resource.ResourceMetadataMap;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.util.FhirTerser;
import ca.uhn.fhir.util.IModelVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseElement;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.ICompositeType;
import org.hl7.fhir.instance.model.api.IDomainResource;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ParserState<T> {
    private static final Logger ourLog = LoggerFactory.getLogger(ParserState.class);
    private FhirContext myContext;
    private boolean myJsonMode;
    private T myObject;
    private BaseState myState;
    private IParserErrorHandler myErrorHandler;

    private ParserState(FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        this.myContext = theContext;
        this.myJsonMode = theJsonMode;
        this.myErrorHandler = theErrorHandler;
    }

    public void attributeValue(String theName, String theValue) throws DataFormatException {
        this.myState.attributeValue(theName, theValue);
    }

    public void endingElement() throws DataFormatException {
        this.myState.endingElement();
    }

    public void enteringNewElement(String theNamespaceUri, String theName) throws DataFormatException {
        this.myState.enteringNewElement(theNamespaceUri, theName);
    }

    public void enteringNewElementExtension(StartElement theElem, String theUrlAttr, boolean theIsModifier) {
        this.myState.enteringNewElementExtension(theElem, theUrlAttr, theIsModifier);
    }

    public T getObject() {
        return (T)this.myState.getCurrentElement();
    }

    public boolean isComplete() {
        return this.myObject != null;
    }

    public boolean isPreResource() {
        return this.myState.isPreResource();
    }

    private Object newContainedDt(IResource theTarget) {
        Object newChildInstance;
        try {
            newChildInstance = theTarget.getStructureFhirVersionEnum().getVersionImplementation().getContainedType().newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate " + this.myContext.getVersion().getResourceReferenceType(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate " + this.myContext.getVersion().getResourceReferenceType(), e);
        }
        return newChildInstance;
    }

    private IBase newResourceReferenceDt(IBaseResource theTarget) {
        IBase newChildInstance;
        try {
            IFhirVersion version = theTarget instanceof IResource ? ((IResource)theTarget).getStructureFhirVersionEnum().getVersionImplementation() : FhirVersionEnum.DSTU2_HL7ORG.getVersionImplementation();
            newChildInstance = version.getResourceReferenceType().newInstance();
        }
        catch (InstantiationException e) {
            throw new ConfigurationException("Failed to instantiate " + this.myContext.getVersion().getResourceReferenceType(), e);
        }
        catch (IllegalAccessException e) {
            throw new ConfigurationException("Failed to instantiate " + this.myContext.getVersion().getResourceReferenceType(), e);
        }
        return newChildInstance;
    }

    private void pop() {
        this.myState = this.myState.myStack;
        this.myState.wereBack();
    }

    private void push(BaseState theState) {
        theState.setStack(this.myState);
        this.myState = theState;
    }

    private void putPlacerResourceInDeletedEntry(BundleEntry entry) {
        IdDt id = null;
        id = entry.getLinkSelf() != null && !entry.getLinkSelf().isEmpty() ? new IdDt((String)entry.getLinkSelf().getValue()) : entry.getId();
        IResource resource = entry.getResource();
        if (resource == null && id != null && StringUtils.isNotBlank((CharSequence)id.getResourceType())) {
            String resourceType = id.getResourceType();
            RuntimeResourceDefinition def = this.myContext.getResourceDefinition(resourceType);
            if (def == null) {
                throw new DataFormatException("Entry references unknown resource type: " + resourceType);
            }
            resource = (IResource)((IBaseResource)def.newInstance());
            resource.setId(id);
            entry.setResource(resource);
        }
        if (resource != null) {
            resource.getResourceMetadata().put(ResourceMetadataKeyEnum.DELETED_AT, entry.getDeletedAt());
            resource.getResourceMetadata().put(ResourceMetadataKeyEnum.VERSION_ID, id);
        }
    }

    public void string(String theData) {
        this.myState.string(theData);
    }

    public boolean verifyNamespace(String theExpect, String theActual) {
        if (this.myJsonMode) {
            return true;
        }
        return StringUtils.equals((CharSequence)theExpect, (CharSequence)theActual);
    }

    public void xmlEvent(XMLEvent theNextEvent) {
        this.myState.xmlEvent(theNextEvent);
    }

    static ParserState<Bundle> getPreAtomInstance(FhirContext theContext, Class<? extends IBaseResource> theResourceType, boolean theJsonMode, IParserErrorHandler theErrorHandler) throws DataFormatException {
        ParserState<Bundle> retVal = new ParserState<Bundle>(theContext, theJsonMode, theErrorHandler);
        if (theContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
            ParserState<Bundle> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreAtomState(theResourceType));
        } else {
            ParserState<Bundle> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreBundleState(theResourceType));
        }
        return retVal;
    }

    static <T extends IBaseResource> ParserState<T> getPreResourceInstance(Class<T> theResourceType, FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) throws DataFormatException {
        ParserState<T> retVal = new ParserState<T>(theContext, theJsonMode, theErrorHandler);
        if (theResourceType == null) {
            if (theContext.getVersion().getVersion() != FhirVersionEnum.DSTU2_HL7ORG) {
                ParserState<T> parserState = retVal;
                parserState.getClass();
                super.push(parserState.new PreResourceStateHapi(theResourceType));
            } else {
                ParserState<T> parserState = retVal;
                parserState.getClass();
                super.push(parserState.new PreResourceStateHl7Org(theResourceType));
            }
        } else if (IResource.class.isAssignableFrom(theResourceType)) {
            ParserState<T> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreResourceStateHapi(theResourceType));
        } else {
            ParserState<T> parserState = retVal;
            parserState.getClass();
            super.push(parserState.new PreResourceStateHl7Org(theResourceType));
        }
        return retVal;
    }

    static ParserState<TagList> getPreTagListInstance(FhirContext theContext, boolean theJsonMode, IParserErrorHandler theErrorHandler) {
        ParserState<TagList> retVal = new ParserState<TagList>(theContext, theJsonMode, theErrorHandler);
        super.push(retVal.new PreTagListState());
        return retVal;
    }

    private BaseState createResourceReferenceState(PreResourceState thePreResourceState, IBase newChildInstance) {
        BaseState newState = newChildInstance instanceof IBaseReference ? new ResourceReferenceStateHl7Org(thePreResourceState, (IBaseReference)newChildInstance) : new ResourceReferenceStateHapi(thePreResourceState, (BaseResourceReferenceDt)newChildInstance);
        return newState;
    }

    private class XhtmlState
    extends BaseState {
        private int myDepth;
        private XhtmlDt myDt;
        private List<XMLEvent> myEvents;
        private boolean myIncludeOuterEvent;

        private XhtmlState(PreResourceState thePreResourceState, XhtmlDt theXhtmlDt, boolean theIncludeOuterEvent) throws DataFormatException {
            super(thePreResourceState);
            this.myEvents = new ArrayList<XMLEvent>();
            this.myDepth = 0;
            this.myDt = theXhtmlDt;
            this.myIncludeOuterEvent = theIncludeOuterEvent;
        }

        public XhtmlDt getDt() {
            return this.myDt;
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.myDt.setValueAsString(theValue);
                return;
            }
        }

        protected void doPop() {
            ParserState.this.pop();
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.doPop();
                return;
            }
            super.endingElement();
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myDt;
        }

        @Override
        public void xmlEvent(XMLEvent theEvent) {
            if (theEvent.isEndElement()) {
                --this.myDepth;
            }
            if (this.myIncludeOuterEvent || this.myDepth > 0) {
                this.myEvents.add(theEvent);
            }
            if (theEvent.isStartElement()) {
                ++this.myDepth;
            }
            if (theEvent.isEndElement() && this.myDepth == 0) {
                this.myDt.setValue(this.myEvents);
                this.doPop();
            }
        }
    }

    private class XhtmlStateHl7Org
    extends XhtmlState {
        private IBaseXhtml myHl7OrgDatatype;

        private XhtmlStateHl7Org(PreResourceState thePreResourceState, IBaseXhtml theHl7OrgDatatype) {
            super(thePreResourceState, new XhtmlDt(), true);
            this.myHl7OrgDatatype = theHl7OrgDatatype;
        }

        @Override
        public void doPop() {
            String value = this.getDt().getValueAsString();
            this.myHl7OrgDatatype.setValueAsString(value);
            super.doPop();
        }
    }

    private class TagState
    extends BaseState {
        private static final int LABEL = 2;
        private static final int NONE = 0;
        private static final int SCHEME = 3;
        private static final int TERM = 1;
        private String myLabel;
        private String myScheme;
        private int mySubState;
        private TagList myTagList;
        private String myTerm;

        public TagState(TagList theTagList) {
            super(null);
            this.mySubState = 0;
            this.myTagList = theTagList;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            String value = (String)StringUtils.defaultIfBlank((CharSequence)theValue, null);
            switch (this.mySubState) {
                case 1: {
                    this.myTerm = value;
                    break;
                }
                case 2: {
                    this.myLabel = value;
                    break;
                }
                case 3: {
                    this.myScheme = value;
                    break;
                }
                case 0: {
                    this.enteringNewElement(null, theName);
                    this.attributeValue(null, value);
                    this.endingElement();
                }
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.mySubState != 0) {
                this.mySubState = 0;
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.myScheme) || StringUtils.isNotBlank((CharSequence)this.myTerm) || StringUtils.isNotBlank((CharSequence)this.myLabel)) {
                    this.myTagList.addTag(this.myScheme, this.myTerm, this.myLabel);
                }
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("term".equals(theLocalPart) || "code".equals(theLocalPart)) {
                this.mySubState = 1;
            } else if ("scheme".equals(theLocalPart) || "system".equals(theLocalPart)) {
                this.mySubState = 3;
            } else if ("label".equals(theLocalPart) || "display".equals(theLocalPart)) {
                this.mySubState = 2;
            } else {
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
        }
    }

    private class TagListState
    extends BaseState {
        private TagList myTagList;

        public TagListState(TagList theTagList) {
            super(null);
            this.myTagList = theTagList;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!"category".equals(theLocalPart)) {
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
            ParserState.this.push(new TagState(this.myTagList));
        }
    }

    private class SwallowChildrenWholeState
    extends BaseState {
        private int myDepth;

        public SwallowChildrenWholeState(PreResourceState thePreResourceState) {
            super(thePreResourceState);
        }

        @Override
        public void endingElement() throws DataFormatException {
            --this.myDepth;
            if (this.myDepth < 0) {
                ParserState.this.pop();
            }
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ++this.myDepth;
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier) {
            ++this.myDepth;
        }
    }

    private class ResourceStateHl7Org
    extends ElementCompositeState {
        public ResourceStateHl7Org(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBaseResource theInstance) {
            super(thePreResourceState, theDef, theInstance);
        }
    }

    private class ResourceStateHapi
    extends ElementCompositeState {
        private IResource myInstance;

        public ResourceStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IResource theInstance) {
            super(thePreResourceState, theDef, theInstance);
            this.myInstance = theInstance;
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            if ("id".equals(theChildName)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getId()));
            } else if ("meta".equals(theChildName)) {
                ParserState.this.push(new MetaElementState(this.getPreResourceState(), this.myInstance.getResourceMetadata()));
            } else {
                super.enteringNewElement(theNamespace, theChildName);
            }
        }
    }

    private static enum ResourceReferenceSubState {
        DISPLAY,
        INITIAL,
        REFERENCE;

    }

    private class ResourceReferenceStateHapi
    extends BaseState {
        private BaseResourceReferenceDt myInstance;
        private ResourceReferenceSubState mySubState;

        public ResourceReferenceStateHapi(PreResourceState thePreResourceState, BaseResourceReferenceDt theInstance) {
            super(thePreResourceState);
            this.myInstance = theInstance;
            this.mySubState = ResourceReferenceSubState.INITIAL;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (!"value".equals(theName)) {
                return;
            }
            switch (this.mySubState) {
                case DISPLAY: {
                    this.myInstance.getDisplayElement().setValue(theValue);
                    break;
                }
                case INITIAL: {
                    throw new DataFormatException("Unexpected attribute: " + theValue);
                }
                case REFERENCE: {
                    this.myInstance.getReference().setValue(theValue);
                }
            }
        }

        @Override
        public void endingElement() {
            switch (this.mySubState) {
                case INITIAL: {
                    ParserState.this.pop();
                    break;
                }
                case DISPLAY: 
                case REFERENCE: {
                    this.mySubState = ResourceReferenceSubState.INITIAL;
                }
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            switch (this.mySubState) {
                case INITIAL: {
                    if ("display".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.DISPLAY;
                        break;
                    }
                    if ("reference".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.REFERENCE;
                        break;
                    }
                    if ("resource".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.REFERENCE;
                        break;
                    }
                }
                case DISPLAY: 
                case REFERENCE: {
                    throw new DataFormatException("Unexpected element: " + theLocalPart);
                }
            }
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myInstance;
        }
    }

    private class ResourceReferenceStateHl7Org
    extends BaseState {
        private IBaseReference myInstance;
        private ResourceReferenceSubState mySubState;

        public ResourceReferenceStateHl7Org(PreResourceState thePreResourceState, IBaseReference theInstance) {
            super(thePreResourceState);
            this.myInstance = theInstance;
            this.mySubState = ResourceReferenceSubState.INITIAL;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (!"value".equals(theName)) {
                return;
            }
            switch (this.mySubState) {
                case DISPLAY: {
                    this.myInstance.setDisplay(theValue);
                    break;
                }
                case INITIAL: {
                    throw new DataFormatException("Unexpected attribute: " + theValue);
                }
                case REFERENCE: {
                    this.myInstance.setReference(theValue);
                }
            }
        }

        @Override
        public void endingElement() {
            switch (this.mySubState) {
                case INITIAL: {
                    ParserState.this.pop();
                    break;
                }
                case DISPLAY: 
                case REFERENCE: {
                    this.mySubState = ResourceReferenceSubState.INITIAL;
                }
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            switch (this.mySubState) {
                case INITIAL: {
                    if ("display".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.DISPLAY;
                        break;
                    }
                    if ("reference".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.REFERENCE;
                        break;
                    }
                    if ("resource".equals(theLocalPart)) {
                        this.mySubState = ResourceReferenceSubState.REFERENCE;
                        break;
                    }
                    this.logAndSwallowUnexpectedElement(theLocalPart);
                    break;
                }
                case DISPLAY: 
                case REFERENCE: {
                    this.logAndSwallowUnexpectedElement(theLocalPart);
                }
            }
        }

        @Override
        protected IBaseReference getCurrentElement() {
            return this.myInstance;
        }
    }

    private class PrimitiveState
    extends BaseState {
        private IPrimitiveType<?> myInstance;

        public PrimitiveState(PreResourceState thePreResourceState, IPrimitiveType<?> theInstance) {
            super(thePreResourceState);
            this.myInstance = theInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("value".equals(theName)) {
                this.myInstance.setValueAsString(theValue);
            } else if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)((Object)this.myInstance)).setElementSpecificId(theValue);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId(theValue);
                } else if (this.myInstance instanceof IBaseResource) {
                    new IdDt(theValue).applyTo((IBaseResource)((Object)this.myInstance));
                } else {
                    ParserState.this.myErrorHandler.unknownAttribute(null, theName);
                }
            } else {
                ParserState.this.myErrorHandler.unknownAttribute(null, theName);
            }
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class PreTagListState
    extends BaseState {
        private TagList myTagList;

        public PreTagListState() {
            super(null);
            this.myTagList = new TagList();
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!TagList.ELEMENT_NAME_LC.equals(theLocalPart.toLowerCase())) {
                throw new DataFormatException("resourceType does not appear to be 'TagList', found: " + theLocalPart);
            }
            ParserState.this.push(new TagListState(this.myTagList));
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myTagList;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }

        @Override
        public void wereBack() {
            ParserState.this.myObject = this.myTagList;
        }
    }

    private abstract class PreResourceState
    extends BaseState {
        private Map<String, IBaseResource> myContainedResources;
        private IBaseResource myInstance;
        private FhirVersionEnum myParentVersion;
        private Class<? extends IBaseResource> myResourceType;
        private boolean myRequireResourceType;

        public PreResourceState setRequireResourceType(boolean theRequireResourceType) {
            this.myRequireResourceType = theRequireResourceType;
            return this;
        }

        public PreResourceState(Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myContainedResources = new HashMap<String, IBaseResource>();
            this.myRequireResourceType = true;
            this.myResourceType = theResourceType;
            this.myParentVersion = theResourceType != null ? ParserState.this.myContext.getResourceDefinition(theResourceType).getStructureVersion() : ParserState.this.myContext.getVersion().getVersion();
        }

        public PreResourceState(PreResourceState thePreResourcesState, FhirVersionEnum theParentVersion) {
            super(thePreResourcesState);
            this.myContainedResources = new HashMap<String, IBaseResource>();
            this.myRequireResourceType = true;
            Validate.notNull((Object)((Object)theParentVersion));
            this.myParentVersion = theParentVersion;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            RuntimeResourceDefinition definition;
            if (this.myResourceType == null) {
                definition = ParserState.this.myContext.getResourceDefinition(this.myParentVersion, theLocalPart);
                if (definition == null) {
                    throw new DataFormatException("Element '" + theLocalPart + "' is not a known resource type, expected a resource at this position");
                }
            } else {
                definition = ParserState.this.myContext.getResourceDefinition(this.myResourceType);
                if (!StringUtils.equals((CharSequence)theLocalPart, (CharSequence)definition.getName())) {
                    if (this.myRequireResourceType) {
                        throw new DataFormatException(ParserState.this.myContext.getLocalizer().getMessage(ParserState.class, "wrongResourceTypeFound", definition.getName(), theLocalPart));
                    }
                    definition = ParserState.this.myContext.getResourceDefinition(theLocalPart);
                    if (!(definition instanceof RuntimeResourceDefinition)) {
                        throw new DataFormatException("Element '" + theLocalPart + "' is not a resource, expected a resource at this position");
                    }
                }
            }
            RuntimeResourceDefinition def = definition;
            this.myInstance = (IBaseResource)def.newInstance();
            String resourceName = def.getName();
            if ("Binary".equals(resourceName) && ParserState.this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                ParserState.this.push(new BinaryResourceStateForDstu1(this.getRootPreResourceState(), (IBaseBinary)this.myInstance));
            } else if (this.myInstance instanceof IResource) {
                ParserState.this.push(new ResourceStateHapi(this.getRootPreResourceState(), def, (IResource)this.myInstance));
            } else {
                ParserState.this.push(new ResourceStateHl7Org(this.getRootPreResourceState(), def, this.myInstance));
            }
        }

        public Map<String, IBaseResource> getContainedResources() {
            return this.myContainedResources;
        }

        @Override
        protected IBaseResource getCurrentElement() {
            return this.myInstance;
        }

        private PreResourceState getRootPreResourceState() {
            if (this.getPreResourceState() != null) {
                return this.getPreResourceState();
            }
            return this;
        }

        @Override
        public boolean isPreResource() {
            return true;
        }

        @Override
        public void wereBack() {
            boolean bundle = "Bundle".equals(ParserState.this.myContext.getResourceDefinition(this.myInstance).getName());
            FhirTerser terser = ParserState.this.myContext.newTerser();
            terser.visit(this.myInstance, new IModelVisitor(){

                @Override
                public void acceptElement(IBase theElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition) {
                    IBaseReference nextRef;
                    String ref;
                    if (theElement instanceof BaseResourceReferenceDt) {
                        BaseResourceReferenceDt nextRef2 = (BaseResourceReferenceDt)theElement;
                        String ref2 = nextRef2.getReference().getValue();
                        if (StringUtils.isNotBlank((CharSequence)ref2) && ref2.startsWith("#")) {
                            IResource target = (IResource)((IBaseResource)PreResourceState.this.myContainedResources.get(ref2.substring(1)));
                            if (target != null) {
                                nextRef2.setResource(target);
                            } else {
                                ourLog.warn("Resource contains unknown local ref: " + ref2);
                            }
                        }
                    } else if (theElement instanceof IBaseReference && StringUtils.isNotBlank((CharSequence)(ref = (nextRef = (IBaseReference)theElement).getReferenceElement().getValue())) && ref.startsWith("#")) {
                        IBaseResource target = (IBaseResource)PreResourceState.this.myContainedResources.get(ref.substring(1));
                        if (target != null) {
                            nextRef.setResource(target);
                        } else {
                            ourLog.warn("Resource contains unknown local ref: " + ref);
                        }
                    }
                }

                @Override
                public void acceptUndeclaredExtension(ISupportsUndeclaredExtensions theContainingElement, List<String> thePathToElement, BaseRuntimeChildDefinition theChildDefinition, BaseRuntimeElementDefinition<?> theDefinition, ExtensionDt theNextExt) {
                    this.acceptElement(theNextExt.getValue(), null, null, null);
                }
            });
            if (bundle) {
                HashMap<IdDt, IResource> idToResource = new HashMap<IdDt, IResource>();
                FhirTerser t = ParserState.this.myContext.newTerser();
                List<IResource> resources = t.getAllPopulatedChildElementsOfType(this.myInstance, IResource.class);
                for (IResource next : resources) {
                    IdDt id = next.getId();
                    if (id == null || id.isEmpty()) continue;
                    String resName = ParserState.this.myContext.getResourceDefinition(next).getName();
                    idToResource.put(id.withResourceType(resName).toUnqualifiedVersionless(), next);
                }
                for (IResource next : resources) {
                    List<BaseResourceReferenceDt> refs = ParserState.this.myContext.newTerser().getAllPopulatedChildElementsOfType(next, BaseResourceReferenceDt.class);
                    for (BaseResourceReferenceDt nextRef : refs) {
                        IResource target;
                        if (nextRef.isEmpty() || nextRef.getReference() == null || (target = (IResource)idToResource.get(nextRef.getReference().toUnqualifiedVersionless())) == null) continue;
                        nextRef.setResource(target);
                    }
                }
            }
        }
    }

    private class PreResourceStateHl7Org
    extends PreResourceState {
        private BaseRuntimeChildDefinition.IMutator myMutator;
        private Object myTarget;

        public PreResourceStateHl7Org(Object theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myMutator = theMutator;
            this.myTarget = theTarget;
        }

        public PreResourceStateHl7Org(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        @Override
        public void wereBack() {
            super.wereBack();
            if (this.myTarget == null) {
                ParserState.this.myObject = this.getCurrentElement();
            }
            if (this.getCurrentElement() instanceof IDomainResource) {
                IDomainResource elem = (IDomainResource)this.getCurrentElement();
                String resourceName = ParserState.this.myContext.getResourceDefinition(elem).getName();
                String versionId = elem.getMeta().getVersionId();
                if (!StringUtils.isBlank((CharSequence)elem.getIdElement().getIdPart())) {
                    if (StringUtils.isNotBlank((CharSequence)versionId)) {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart() + "/_history/" + versionId);
                    } else {
                        elem.getIdElement().setValue(resourceName + "/" + elem.getIdElement().getIdPart());
                    }
                }
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            super.enteringNewElement(theNamespaceUri, theLocalPart);
            if (this.myMutator != null) {
                this.myMutator.addValue(this.myTarget, this.getCurrentElement());
            }
        }
    }

    private class PreResourceStateHapi
    extends PreResourceState {
        private BundleEntry myEntry;
        private Object myTarget;
        private BaseRuntimeChildDefinition.IMutator myMutator;

        public PreResourceStateHapi(BundleEntry theEntry, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myEntry = theEntry;
        }

        public PreResourceStateHapi(Object theTarget, BaseRuntimeChildDefinition.IMutator theMutator, Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
            this.myTarget = theTarget;
            this.myMutator = theMutator;
        }

        public PreResourceStateHapi(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        @Override
        public void wereBack() {
            super.wereBack();
            if (this.myEntry == null && this.myMutator == null) {
                ParserState.this.myObject = this.getCurrentElement();
            }
            IResource nextResource = (IResource)this.getCurrentElement();
            String version = ResourceMetadataKeyEnum.VERSION.get(nextResource);
            String resourceName = ParserState.this.myContext.getResourceDefinition(nextResource).getName();
            String bundleIdPart = nextResource.getId().getIdPart();
            if (StringUtils.isNotBlank((CharSequence)bundleIdPart)) {
                nextResource.setId(new IdDt(null, resourceName, bundleIdPart, version));
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            super.enteringNewElement(theNamespaceUri, theLocalPart);
            if (this.myEntry != null) {
                this.myEntry.setResource((IResource)this.getCurrentElement());
            }
            if (this.myMutator != null) {
                this.myMutator.addValue(this.myTarget, this.getCurrentElement());
            }
        }
    }

    private class PreBundleState
    extends BasePreAtomOrBundleState {
        public PreBundleState(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        @Override
        public void endingElement() throws DataFormatException {
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!"Bundle".equals(theLocalPart)) {
                throw new DataFormatException("Expecting outer element called 'Bundle', found: " + theLocalPart);
            }
            this.setInstance(new Bundle());
            ParserState.this.push(new BundleState(this.getInstance(), this.getResourceType()));
        }
    }

    private class PreAtomState
    extends BasePreAtomOrBundleState {
        public PreAtomState(Class<? extends IBaseResource> theResourceType) {
            super(theResourceType);
        }

        @Override
        public void endingElement() throws DataFormatException {
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (!"feed".equals(theLocalPart)) {
                throw new DataFormatException("Expecting outer element called 'feed', found: " + theLocalPart);
            }
            this.setInstance(new Bundle());
            ParserState.this.push(new AtomState(this.getInstance(), this.getResourceType()));
        }
    }

    private class MetaVersionElementState
    extends BaseState {
        private ResourceMetadataMap myMap;

        public MetaVersionElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myMap.put(ResourceMetadataKeyEnum.VERSION, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }
    }

    private class MetaElementState
    extends BaseState {
        private ResourceMetadataMap myMap;

        public MetaElementState(PreResourceState thePreResourceState, ResourceMetadataMap theMap) {
            super(thePreResourceState);
            this.myMap = theMap;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (theLocalPart.equals("versionId")) {
                ParserState.this.push(new MetaVersionElementState(this.getPreResourceState(), this.myMap));
            } else if (theLocalPart.equals("lastUpdated")) {
                InstantDt updated = new InstantDt();
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), updated));
                this.myMap.put(ResourceMetadataKeyEnum.UPDATED, updated);
            } else if (theLocalPart.equals("security")) {
                ArrayList<BaseCodingDt> securityLabels = (ArrayList<BaseCodingDt>)this.myMap.get(ResourceMetadataKeyEnum.SECURITY_LABELS);
                if (securityLabels == null) {
                    securityLabels = new ArrayList<BaseCodingDt>();
                    this.myMap.put(ResourceMetadataKeyEnum.SECURITY_LABELS, securityLabels);
                }
                BaseCodingDt securityLabel = ParserState.this.myContext.getVersion().newCodingDt();
                BaseRuntimeElementCompositeDefinition codinfDef = (BaseRuntimeElementCompositeDefinition)ParserState.this.myContext.getElementDefinition(securityLabel.getClass());
                ParserState.this.push(new SecurityLabelElementStateHapi(this.getPreResourceState(), codinfDef, securityLabel));
                securityLabels.add(securityLabel);
            } else if (theLocalPart.equals("profile")) {
                ArrayList<IdDt> profiles = (ArrayList<IdDt>)this.myMap.get(ResourceMetadataKeyEnum.PROFILES);
                if (profiles == null) {
                    profiles = new ArrayList<IdDt>();
                    this.myMap.put(ResourceMetadataKeyEnum.PROFILES, profiles);
                }
                IdDt profile = new IdDt();
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), profile));
                profiles.add(profile);
            } else if (theLocalPart.equals("tag")) {
                TagList tagList = (TagList)this.myMap.get(ResourceMetadataKeyEnum.TAG_LIST);
                if (tagList == null) {
                    tagList = new TagList();
                    this.myMap.put(ResourceMetadataKeyEnum.TAG_LIST, tagList);
                }
                ParserState.this.push(new TagState(tagList));
            } else {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
        }
    }

    private class SecurityLabelElementStateHapi
    extends ElementCompositeState {
        public SecurityLabelElementStateHapi(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, BaseCodingDt codingDt) {
            super(thePreResourceState, theDef, codingDt);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }
    }

    private class ExtensionState
    extends BaseState {
        private IBaseExtension<?, ?> myExtension;

        public ExtensionState(PreResourceState thePreResourceState, IBaseExtension<?, ?> theExtension) {
            super(thePreResourceState);
            this.myExtension = theExtension;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("url".equals(theName)) {
                return;
            }
            super.attributeValue(theName, theValue);
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.myExtension.getValue() != null && this.myExtension.getExtension().size() > 0) {
                throw new DataFormatException("Extension (URL='" + this.myExtension.getUrl() + "') must not have both a value and other contained extensions");
            }
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target = ParserState.this.myContext.getRuntimeChildUndeclaredExtensionDefinition().getChildByName(theLocalPart);
            if (target == null) {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance();
                    this.myExtension.setValue(newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance();
                    this.myExtension.setValue(newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_REF: {
                    ICompositeType newChildInstance = (ICompositeType)ParserState.this.newResourceReferenceDt(this.getPreResourceState().myInstance);
                    this.myExtension.setValue(newChildInstance);
                    if (ParserState.this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU2_HL7ORG)) {
                        ResourceReferenceStateHl7Org newState = new ResourceReferenceStateHl7Org(this.getPreResourceState(), (IBaseReference)newChildInstance);
                        ParserState.this.push(newState);
                    } else {
                        ResourceReferenceStateHapi newState = new ResourceReferenceStateHapi(this.getPreResourceState(), (BaseResourceReferenceDt)newChildInstance);
                        ParserState.this.push(newState);
                    }
                    return;
                }
            }
        }

        @Override
        protected IBaseExtension<?, ?> getCurrentElement() {
            return this.myExtension;
        }
    }

    private class ElementCompositeState
    extends BaseState {
        private BaseRuntimeElementCompositeDefinition<?> myDefinition;
        private IBase myInstance;
        private Set<String> myParsedNonRepeatableNames;

        public ElementCompositeState(PreResourceState thePreResourceState, BaseRuntimeElementCompositeDefinition<?> theDef, IBase theInstance) {
            super(thePreResourceState);
            this.myParsedNonRepeatableNames = new HashSet<String>();
            this.myDefinition = theDef;
            this.myInstance = theInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)this.myInstance).setElementSpecificId(theValue);
                } else if (this.myInstance instanceof IBaseElement) {
                    ((IBaseElement)((Object)this.myInstance)).setId(theValue);
                } else if (this.myInstance instanceof IBaseResource) {
                    new IdDt(theValue).applyTo((IBaseResource)this.myInstance);
                }
            } else if ("url".equals(theName) && this.myInstance instanceof ExtensionDt) {
                ((ExtensionDt)this.myInstance).setUrl(theValue);
            } else {
                super.attributeValue(theName, theValue);
            }
        }

        @Override
        public void endingElement() {
            ParserState.this.pop();
            if (ParserState.this.myState == null) {
                ParserState.this.myObject = this.myInstance;
            }
        }

        @Override
        public void enteringNewElement(String theNamespace, String theChildName) throws DataFormatException {
            BaseRuntimeChildDefinition child;
            try {
                child = this.myDefinition.getChildByNameOrThrowDataFormatException(theChildName);
            }
            catch (DataFormatException e) {
                ParserState.this.myErrorHandler.unknownElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            if (!(child.getMax() != 0 && child.getMax() != 1 || this.myParsedNonRepeatableNames.add(theChildName))) {
                ParserState.this.myErrorHandler.unexpectedRepeatingElement(null, theChildName);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            BaseRuntimeElementDefinition<?> target = child.getChildByName(theChildName);
            if (target == null) {
                throw new DataFormatException("Found unexpected element '" + theChildName + "' in parent element '" + this.myDefinition.getName() + "'. Valid names are: " + child.getValidChildNames());
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance(child.getInstanceConstructorArguments());
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_DATATYPE: 
                case ID_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance(child.getInstanceConstructorArguments());
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_REF: {
                    IBase newChildInstance = ParserState.this.newResourceReferenceDt(this.getPreResourceState().myInstance);
                    child.getMutator().addValue(this.myInstance, newChildInstance);
                    BaseState newState = ParserState.this.createResourceReferenceState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_BLOCK: {
                    RuntimeResourceBlockDefinition blockTarget = (RuntimeResourceBlockDefinition)target;
                    Object newBlockInstance = blockTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, (IBase)newBlockInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.getPreResourceState(), blockTarget, (IBase)newBlockInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_XHTML: {
                    RuntimePrimitiveDatatypeNarrativeDefinition xhtmlTarget = (RuntimePrimitiveDatatypeNarrativeDefinition)target;
                    XhtmlDt newDt = (XhtmlDt)xhtmlTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlState state = new XhtmlState(this.getPreResourceState(), newDt, true);
                    ParserState.this.push(state);
                    return;
                }
                case PRIMITIVE_XHTML_HL7ORG: {
                    RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition xhtmlTarget = (RuntimePrimitiveDatatypeXhtmlHl7OrgDefinition)target;
                    IBaseXhtml newDt = (IBaseXhtml)xhtmlTarget.newInstance();
                    child.getMutator().addValue(this.myInstance, newDt);
                    XhtmlStateHl7Org state = new XhtmlStateHl7Org(this.getPreResourceState(), newDt);
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCES: {
                    List<IBase> values = child.getAccessor().getValues(this.myInstance);
                    if (values == null || values.isEmpty() || values.get(0) == null) {
                        Object newDt = ParserState.this.newContainedDt((IResource)this.getPreResourceState().myInstance);
                        child.getMutator().addValue(this.myInstance, (IBase)newDt);
                    } else {
                        IBase newDt = values.get(0);
                    }
                    ContainedResourcesStateHapi state = new ContainedResourcesStateHapi(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case CONTAINED_RESOURCE_LIST: {
                    ContainedResourcesStateHl7Org state = new ContainedResourcesStateHl7Org(this.getPreResourceState());
                    ParserState.this.push(state);
                    return;
                }
                case RESOURCE: {
                    if (this.myInstance instanceof IResource || this.myInstance instanceof IElement) {
                        PreResourceStateHapi state = new PreResourceStateHapi(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    } else {
                        PreResourceStateHl7Org state = new PreResourceStateHl7Org(this.myInstance, child.getMutator(), null);
                        ParserState.this.push(state);
                    }
                    return;
                }
            }
            throw new DataFormatException("Illegal resource position: " + (Object)((Object)target.getChildType()));
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getDeclaredExtension(theUrlAttr);
            if (declaredExtension != null) {
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myInstance;
        }
    }

    private class DeclaredExtensionState
    extends BaseState {
        private IBase myChildInstance;
        private RuntimeChildDeclaredExtensionDefinition myDefinition;
        private IBase myParentInstance;
        private PreResourceState myPreResourceState;

        public DeclaredExtensionState(PreResourceState thePreResourceState, RuntimeChildDeclaredExtensionDefinition theDefinition, IBase theParentInstance) {
            super(thePreResourceState);
            this.myPreResourceState = thePreResourceState;
            this.myDefinition = theDefinition;
            this.myParentInstance = theParentInstance;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            BaseRuntimeElementDefinition<?> target = this.myDefinition.getChildByName(theLocalPart);
            if (target == null) {
                ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
                return;
            }
            switch (target.getChildType()) {
                case COMPOSITE_DATATYPE: {
                    BaseRuntimeElementCompositeDefinition compositeTarget = (BaseRuntimeElementCompositeDefinition)target;
                    ICompositeType newChildInstance = (ICompositeType)compositeTarget.newInstance(this.myDefinition.getInstanceConstructorArguments());
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    ElementCompositeState newState = new ElementCompositeState(this.myPreResourceState, compositeTarget, newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case PRIMITIVE_DATATYPE: {
                    RuntimePrimitiveDatatypeDefinition primitiveTarget = (RuntimePrimitiveDatatypeDefinition)target;
                    IPrimitiveType newChildInstance = (IPrimitiveType)primitiveTarget.newInstance(this.myDefinition.getInstanceConstructorArguments());
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    PrimitiveState newState = new PrimitiveState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
                case RESOURCE_REF: {
                    IBase newChildInstance = ParserState.this.newResourceReferenceDt(this.myPreResourceState.myInstance);
                    this.myDefinition.getMutator().addValue(this.myParentInstance, newChildInstance);
                    BaseState newState = ParserState.this.createResourceReferenceState(this.getPreResourceState(), newChildInstance);
                    ParserState.this.push(newState);
                    return;
                }
            }
        }

        @Override
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier) {
            RuntimeChildDeclaredExtensionDefinition declaredExtension = this.myDefinition.getChildExtensionForUrl(theUrlAttr);
            if (declaredExtension != null) {
                if (this.myChildInstance == null) {
                    this.myChildInstance = this.myDefinition.newInstance();
                    this.myDefinition.getMutator().addValue(this.myParentInstance, this.myChildInstance);
                }
                DeclaredExtensionState newState = new DeclaredExtensionState(this.getPreResourceState(), declaredExtension, this.myChildInstance);
                ParserState.this.push(newState);
            } else {
                super.enteringNewElementExtension(theElement, theUrlAttr, theIsModifier);
            }
        }

        @Override
        protected IBase getCurrentElement() {
            return this.myParentInstance;
        }
    }

    private class ContainedResourcesStateHl7Org
    extends PreResourceState {
        public ContainedResourcesStateHl7Org(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, FhirVersionEnum.DSTU2_HL7ORG);
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void wereBack() {
            IBaseResource res = this.getCurrentElement();
            assert (res != null);
            if (res.getIdElement() == null || res.getIdElement().isEmpty()) {
                ourLog.debug("Discarding contained resource with no ID!");
            } else {
                this.getPreResourceState().getContainedResources().put(res.getIdElement().getValue(), res);
                if (!res.getIdElement().isLocal()) {
                    res.getIdElement().setValue('#' + res.getIdElement().getIdPart());
                }
            }
            IBaseResource preResCurrentElement = this.getPreResourceState().getCurrentElement();
            RuntimeResourceDefinition def = ParserState.this.myContext.getResourceDefinition(preResCurrentElement);
            def.getChildByName("contained").getMutator().addValue(preResCurrentElement, res);
        }
    }

    private class ContainedResourcesStateHapi
    extends PreResourceState {
        public ContainedResourcesStateHapi(PreResourceState thePreResourcesState) {
            super(thePreResourcesState, ((IResource)thePreResourcesState.myInstance).getStructureFhirVersionEnum());
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void wereBack() {
            IResource res = (IResource)this.getCurrentElement();
            assert (res != null);
            if (res.getId() == null || res.getId().isEmpty()) {
                ourLog.debug("Discarding contained resource with no ID!");
            } else {
                this.getPreResourceState().getContainedResources().put(res.getId().getValueAsString(), res);
                if (!res.getId().isLocal()) {
                    res.setId(new IdDt('#' + res.getId().getIdPart()));
                }
            }
            IResource preResCurrentElement = (IResource)this.getPreResourceState().getCurrentElement();
            List<? extends IResource> containedResources = preResCurrentElement.getContained().getContainedResources();
            containedResources.add(res);
        }
    }

    private class BundleState
    extends BaseState {
        private Bundle myInstance;
        private Class<? extends IBaseResource> myResourceType;

        public BundleState(Bundle theInstance, Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myInstance = theInstance;
            this.myResourceType = theResourceType;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("id".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(null, this.myInstance.getId()));
            } else if ("meta".equals(theLocalPart)) {
                ParserState.this.push(new MetaElementState(null, this.myInstance.getResourceMetadata()));
            } else if ("type".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getType()));
            } else if ("base".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getLinkBase()));
            } else if ("total".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myInstance.getTotalResults()));
            } else if ("link".equals(theLocalPart)) {
                ParserState.this.push(new BundleLinkState(this.myInstance));
            } else if ("entry".equals(theLocalPart)) {
                ParserState.this.push(new BundleEntryState(this.myInstance, this.myResourceType));
            } else if ("text".equals(theLocalPart)) {
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
            } else {
                throw new DataFormatException("Unxpected element '" + theLocalPart + "' in element 'Bundle'");
            }
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myInstance;
        }

        @Override
        public void wereBack() {
            for (BundleEntry nextEntry : this.myInstance.getEntries()) {
                String baseUrl;
                IResource nextResource = nextEntry.getResource();
                if (nextResource == null) continue;
                String bundleBaseUrl = (String)this.myInstance.getLinkBase().getValue();
                String entryBaseUrl = (String)nextEntry.getLinkBase().getValue();
                String version = ResourceMetadataKeyEnum.VERSION.get(nextResource);
                String resourceName = ParserState.this.myContext.getResourceDefinition(nextResource).getName();
                String bundleIdPart = nextResource.getId().getIdPart();
                if (!StringUtils.isNotBlank((CharSequence)bundleIdPart) || (baseUrl = StringUtils.isNotBlank((CharSequence)entryBaseUrl) ? entryBaseUrl : bundleBaseUrl) == null) continue;
                if (!baseUrl.startsWith("cid:") && !baseUrl.startsWith("urn:")) {
                    nextResource.setId(new IdDt(baseUrl, resourceName, bundleIdPart, version));
                    continue;
                }
                if (baseUrl.endsWith(":")) {
                    nextResource.setId(new IdDt(baseUrl + bundleIdPart));
                    continue;
                }
                nextResource.setId(new IdDt(baseUrl + ':' + bundleIdPart));
            }
            String bundleVersion = (String)this.myInstance.getResourceMetadata().get(ResourceMetadataKeyEnum.VERSION);
            String baseUrl = (String)this.myInstance.getLinkBase().getValue();
            String id = this.myInstance.getId().getIdPart();
            if (StringUtils.isNotBlank((CharSequence)id)) {
                this.myInstance.setId(new IdDt(baseUrl, "Bundle", id, bundleVersion));
            }
        }
    }

    private class BundleLinkState
    extends BaseState {
        private BundleEntry myEntry;
        private String myHref;
        private boolean myInRelation;
        private Bundle myInstance;
        private boolean myInUrl;
        private String myRel;

        public BundleLinkState(Bundle theInstance) {
            super(null);
            this.myInRelation = false;
            this.myInUrl = false;
            this.myInstance = theInstance;
        }

        public BundleLinkState(BundleEntry theEntry) {
            super(null);
            this.myInRelation = false;
            this.myInUrl = false;
            this.myEntry = theEntry;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (this.myInRelation) {
                this.myRel = theValue;
            } else if (this.myInUrl) {
                this.myHref = theValue;
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (!this.myInRelation && !this.myInUrl) {
                if (this.myInstance != null) {
                    if ("self".equals(this.myRel)) {
                        this.myInstance.getLinkSelf().setValueAsString(this.myHref);
                    } else if ("first".equals(this.myRel)) {
                        this.myInstance.getLinkFirst().setValueAsString(this.myHref);
                    } else if ("previous".equals(this.myRel)) {
                        this.myInstance.getLinkPrevious().setValueAsString(this.myHref);
                    } else if ("next".equals(this.myRel)) {
                        this.myInstance.getLinkNext().setValueAsString(this.myHref);
                    } else if ("last".equals(this.myRel)) {
                        this.myInstance.getLinkLast().setValueAsString(this.myHref);
                    } else if ("fhir-base".equals(this.myRel)) {
                        this.myInstance.getLinkBase().setValueAsString(this.myHref);
                    }
                } else if ("self".equals(this.myRel)) {
                    this.myEntry.getLinkSelf().setValueAsString(this.myHref);
                } else if ("search".equals(this.myRel)) {
                    this.myEntry.getLinkSearch().setValueAsString(this.myHref);
                } else if ("alternate".equals(this.myRel)) {
                    this.myEntry.getLinkAlternate().setValueAsString(this.myHref);
                }
                ParserState.this.pop();
            } else {
                this.myInRelation = false;
                this.myInUrl = false;
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (this.myInRelation || this.myInUrl) {
                throw new DataFormatException("Unexpected element '" + theLocalPart + "' in element 'link'");
            }
            if ("relation".equals(theLocalPart)) {
                this.myInRelation = true;
            } else if ("url".equals(theLocalPart)) {
                this.myInUrl = true;
            } else {
                throw new DataFormatException("Unexpected element '" + theLocalPart + "' in element 'link'");
            }
        }
    }

    private class BundleEntryTransactionState
    extends BaseState {
        private BundleEntry myEntry;

        public BundleEntryTransactionState(BundleEntry theEntry) {
            super(null);
            this.myEntry = theEntry;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("method".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getTransactionMethod()));
            } else if ("url".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getLinkSearch()));
            } else {
                this.logAndSwallowUnexpectedElement(theLocalPart);
            }
        }
    }

    private class BundleEntryState
    extends BaseState {
        private BundleEntry myEntry;
        private Class<? extends IBaseResource> myResourceType;
        private IdDt myFullUrl;

        public BundleEntryState(Bundle theInstance, Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myEntry = new BundleEntry();
            this.myResourceType = theResourceType;
            theInstance.getEntries().add(this.myEntry);
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.populateResourceMetadata();
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("base".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getLinkBase()));
            } else if ("request".equals(theLocalPart)) {
                ParserState.this.push(new BundleEntryTransactionState(this.myEntry));
            } else if ("search".equals(theLocalPart)) {
                ParserState.this.push(new BundleEntrySearchState(this.myEntry));
            } else if ("score".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getScore()));
            } else if ("resource".equals(theLocalPart)) {
                ParserState.this.push(new PreResourceStateHapi(this.myEntry, this.myResourceType).setRequireResourceType(false));
            } else if ("deleted".equals(theLocalPart)) {
                ParserState.this.push(new BundleEntryDeletedState(this.getPreResourceState(), this.myEntry));
            } else if ("link".equals(theLocalPart)) {
                ParserState.this.push(new BundleLinkState(this.myEntry));
            } else if ("fullUrl".equals(theLocalPart)) {
                this.myFullUrl = new IdDt();
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myFullUrl));
            } else if ("fhir_comments".equals(theLocalPart) && ParserState.this.myJsonMode) {
                ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
            } else {
                throw new DataFormatException("Unexpected element in entry: " + theLocalPart);
            }
        }

        protected BundleEntry getEntry() {
            return this.myEntry;
        }

        private void populateResourceMetadata() {
            if (this.myEntry.getResource() == null) {
                return;
            }
            IdDt id = this.myEntry.getId();
            if (id != null && !id.isEmpty()) {
                this.myEntry.getResource().setId(id);
            }
            if (this.myFullUrl != null && !this.myFullUrl.isEmpty()) {
                this.myEntry.getResource().setId(this.myFullUrl);
            }
            ResourceMetadataMap metadata = this.myEntry.getResource().getResourceMetadata();
            if (!this.myEntry.getPublished().isEmpty()) {
                ResourceMetadataKeyEnum.PUBLISHED.put(this.myEntry.getResource(), this.myEntry.getPublished());
            }
            if (!this.myEntry.getUpdated().isEmpty()) {
                ResourceMetadataKeyEnum.UPDATED.put(this.myEntry.getResource(), this.myEntry.getUpdated());
            }
            ResourceMetadataKeyEnum.TITLE.put(this.myEntry.getResource(), (String)this.myEntry.getTitle().getValue());
            if (!this.myEntry.getCategories().isEmpty()) {
                TagList tagList = new TagList();
                for (Tag next : this.myEntry.getCategories()) {
                    tagList.add(next);
                }
                ResourceMetadataKeyEnum.TAG_LIST.put(this.myEntry.getResource(), tagList);
            }
            if (!this.myEntry.getLinkSelf().isEmpty()) {
                String linkSelfValue = (String)this.myEntry.getLinkSelf().getValue();
                IdDt linkSelf = new IdDt(linkSelfValue);
                this.myEntry.getResource().setId(linkSelf);
                if (StringUtils.isNotBlank((CharSequence)linkSelf.getVersionIdPart())) {
                    metadata.put(ResourceMetadataKeyEnum.VERSION_ID, linkSelf);
                }
            }
            if (!this.myEntry.getLinkAlternate().isEmpty()) {
                ResourceMetadataKeyEnum.LINK_ALTERNATE.put(this.myEntry.getResource(), (String)this.myEntry.getLinkAlternate().getValue());
            }
            if (!this.myEntry.getLinkSearch().isEmpty()) {
                ResourceMetadataKeyEnum.LINK_SEARCH.put(this.myEntry.getResource(), (String)this.myEntry.getLinkSearch().getValue());
            }
            if (!this.myEntry.getSearchMode().isEmpty()) {
                ResourceMetadataKeyEnum.ENTRY_SEARCH_MODE.put(this.myEntry.getResource(), this.myEntry.getSearchMode().getValueAsEnum());
            }
            if (!this.myEntry.getTransactionMethod().isEmpty()) {
                ResourceMetadataKeyEnum.ENTRY_TRANSACTION_METHOD.put(this.myEntry.getResource(), this.myEntry.getTransactionMethod().getValueAsEnum());
            }
            if (!this.myEntry.getScore().isEmpty()) {
                ResourceMetadataKeyEnum.ENTRY_SCORE.put(this.myEntry.getResource(), this.myEntry.getScore());
            }
        }
    }

    private class BundleEntrySearchState
    extends BaseState {
        private BundleEntry myEntry;

        public BundleEntrySearchState(BundleEntry theEntry) {
            super(null);
            this.myEntry = theEntry;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("mode".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getSearchMode()));
            } else if ("score".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getScore()));
            } else {
                throw new DataFormatException("Unexpected element in Bundle.entry.search: " + theLocalPart);
            }
        }
    }

    private class BundleEntryDeletedState
    extends BaseState {
        private BundleEntry myEntry;

        public BundleEntryDeletedState(PreResourceState thePreResourceState, BundleEntry theEntry) {
            super(thePreResourceState);
            this.myEntry = theEntry;
        }

        @Override
        public void endingElement() throws DataFormatException {
            String resType = (String)this.myEntry.getDeletedResourceType().getValue();
            String id = this.myEntry.getDeletedResourceId().getValue();
            String version = (String)this.myEntry.getDeletedResourceVersion().getValue();
            this.myEntry.setLinkSelf(new StringDt(new IdDt(resType, id, version).getValue()));
            ParserState.this.putPlacerResourceInDeletedEntry(this.myEntry);
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("type".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedResourceType()));
            } else if ("id".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedResourceId()));
            } else if ("resourceId".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedResourceId()));
            } else if ("version".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedResourceVersion()));
            } else if ("versionId".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedResourceVersion()));
            } else if ("instant".equals(theLocalPart)) {
                ParserState.this.push(new PrimitiveState(this.getPreResourceState(), this.myEntry.getDeletedAt()));
            } else {
                throw new DataFormatException("Unexpected element '" + theLocalPart + "' in element 'deleted'");
            }
        }
    }

    private class BinaryResourceStateForDstu1
    extends BaseState {
        private static final int SUBSTATE_CONTENT = 2;
        private static final int SUBSTATE_CT = 1;
        private String myData;
        private IBaseBinary myInstance;
        private int mySubState;

        public BinaryResourceStateForDstu1(PreResourceState thePreResourceState, IBaseBinary theInstance) {
            super(thePreResourceState);
            this.mySubState = 0;
            this.myInstance = theInstance;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("id".equals(theName)) {
                if (this.myInstance instanceof IIdentifiableElement) {
                    ((IIdentifiableElement)((Object)this.myInstance)).setElementSpecificId(theValue);
                } else {
                    ((IResource)((Object)this.myInstance)).setId(new IdDt(theValue));
                }
            } else if ("contentType".equals(theName)) {
                this.myInstance.setContentType(theValue);
            } else if (ParserState.this.myJsonMode && "value".equals(theName)) {
                this.string(theValue);
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.mySubState == 1) {
                this.myInstance.setContentType(this.myData);
                this.mySubState = 0;
                this.myData = null;
                return;
            }
            if (this.mySubState == 2) {
                this.myInstance.setContentAsBase64(this.myData);
                this.mySubState = 0;
                this.myData = null;
                return;
            }
            if (!ParserState.this.myJsonMode) {
                this.myInstance.setContentAsBase64(this.myData);
            }
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if (ParserState.this.myJsonMode && "contentType".equals(theLocalPart) && this.mySubState == 0) {
                this.mySubState = 1;
            } else if (ParserState.this.myJsonMode && "content".equals(theLocalPart) && this.mySubState == 0) {
                this.mySubState = 2;
            } else {
                throw new DataFormatException("Unexpected nested element in atom tag: " + theLocalPart);
            }
        }

        @Override
        protected IElement getCurrentElement() {
            return null;
        }

        @Override
        public void string(String theData) {
            this.myData = this.myData == null ? theData : this.myData + theData;
        }
    }

    private abstract class BaseState {
        private PreResourceState myPreResourceState;
        private BaseState myStack;

        public BaseState(PreResourceState thePreResourceState) {
            this.myPreResourceState = thePreResourceState;
        }

        public void attributeValue(String theName, String theValue) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownAttribute(null, theName);
        }

        public void endingElement() throws DataFormatException {
        }

        protected void logAndSwallowUnexpectedElement(String theLocalPart) {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
            ParserState.this.push(new SwallowChildrenWholeState(this.getPreResourceState()));
        }

        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            ParserState.this.myErrorHandler.unknownElement(null, theLocalPart);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void enteringNewElementExtension(StartElement theElement, String theUrlAttr, boolean theIsModifier) {
            if (this.myPreResourceState != null && this.getCurrentElement() instanceof ISupportsUndeclaredExtensions) {
                ExtensionDt newExtension = new ExtensionDt(theIsModifier, theUrlAttr);
                ISupportsUndeclaredExtensions elem = (ISupportsUndeclaredExtensions)this.getCurrentElement();
                elem.addUndeclaredExtension(newExtension);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, newExtension);
                ParserState.this.push(newState);
                return;
            } else if (!theIsModifier) {
                if (!(this.getCurrentElement() instanceof IBaseHasExtensions)) throw new DataFormatException("Type " + this.getCurrentElement() + " does not support undeclared extentions, and found an extension with URL: " + theUrlAttr);
                IBaseExtension<?, ?> ext = ((IBaseHasExtensions)((Object)this.getCurrentElement())).addExtension();
                ext.setUrl(theUrlAttr);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                ParserState.this.push(newState);
                return;
            } else {
                if (!(this.getCurrentElement() instanceof IBaseHasModifierExtensions)) throw new DataFormatException("Type " + this.getCurrentElement() + " does not support undeclared extentions, and found an extension with URL: " + theUrlAttr);
                IBaseExtension<?, ?> ext = ((IBaseHasModifierExtensions)((Object)this.getCurrentElement())).addModifierExtension();
                ext.setUrl(theUrlAttr);
                ExtensionState newState = new ExtensionState(this.myPreResourceState, ext);
                ParserState.this.push(newState);
            }
        }

        protected IBase getCurrentElement() {
            return null;
        }

        public PreResourceState getPreResourceState() {
            return this.myPreResourceState;
        }

        public boolean isPreResource() {
            return false;
        }

        public void setStack(BaseState theState) {
            this.myStack = theState;
        }

        public void string(String theData) {
        }

        public void wereBack() {
        }

        public void xmlEvent(XMLEvent theNextEvent) {
        }
    }

    private class BasePreAtomOrBundleState
    extends BaseState {
        private Bundle myInstance;
        private Class<? extends IBaseResource> myResourceType;

        public BasePreAtomOrBundleState(Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myResourceType = theResourceType;
        }

        @Override
        public void endingElement() throws DataFormatException {
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myInstance;
        }

        public Bundle getInstance() {
            return this.myInstance;
        }

        protected Class<? extends IBaseResource> getResourceType() {
            return this.myResourceType;
        }

        public void setInstance(Bundle theInstance) {
            this.myInstance = theInstance;
        }

        @Override
        public void wereBack() {
            ParserState.this.myObject = this.myInstance;
            HashMap<String, IResource> idToResource = new HashMap<String, IResource>();
            List<IResource> resources = this.myInstance.toListOfResources();
            for (IResource next : resources) {
                if (next.getId() == null || next.getId().isEmpty()) continue;
                idToResource.put(next.getId().toUnqualifiedVersionless().getValue(), next);
            }
            for (IResource next : resources) {
                List<BaseResourceReferenceDt> refs = ParserState.this.myContext.newTerser().getAllPopulatedChildElementsOfType(next, BaseResourceReferenceDt.class);
                for (BaseResourceReferenceDt nextRef : refs) {
                    IResource target;
                    if (nextRef.isEmpty() || nextRef.getReference() == null || (target = (IResource)idToResource.get(nextRef.getReference().getValue())) == null) continue;
                    nextRef.setResource(target);
                }
            }
        }
    }

    private class AtomState
    extends BaseState {
        private Bundle myInstance;
        private Class<? extends IBaseResource> myResourceType;

        public AtomState(Bundle theInstance, Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myInstance = theInstance;
            this.myResourceType = theResourceType;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("entry".equals(theLocalPart) && ParserState.this.verifyNamespace("http://www.w3.org/2005/Atom", theNamespaceUri)) {
                ParserState.this.push(new AtomEntryState(this.myInstance, this.myResourceType));
            } else if (theLocalPart.equals("title")) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getTitle()));
            } else if ("id".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getBundleId()));
            } else if ("link".equals(theLocalPart)) {
                ParserState.this.push(new AtomLinkState(this.myInstance));
            } else if ("totalResults".equals(theLocalPart) && (ParserState.this.verifyNamespace("http://a9.com/-/spec/opensearch/1.1/", theNamespaceUri) || ParserState.this.verifyNamespace("http://purl.org/atompub/tombstones/1.0", theNamespaceUri))) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getTotalResults()));
            } else if ("updated".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getUpdated()));
            } else if ("author".equals(theLocalPart)) {
                ParserState.this.push(new AtomAuthorState(this.myInstance));
            } else if ("category".equals(theLocalPart)) {
                ParserState.this.push(new AtomCategoryState(this.myInstance.getCategories()));
            } else if ("deleted-entry".equals(theLocalPart) && ParserState.this.verifyNamespace("http://purl.org/atompub/tombstones/1.0", theNamespaceUri)) {
                ParserState.this.push(new AtomDeletedEntryState(this.myInstance, this.myResourceType));
            } else {
                if (theNamespaceUri != null) {
                    throw new DataFormatException("Unexpected element: {" + theNamespaceUri + "}" + theLocalPart);
                }
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
        }

        @Override
        protected IElement getCurrentElement() {
            return this.myInstance;
        }
    }

    private class AtomPrimitiveState
    extends BaseState {
        private String myData;
        private IPrimitiveDatatype<?> myPrimitive;

        public AtomPrimitiveState(IPrimitiveDatatype<?> thePrimitive) {
            super(null);
            Validate.notNull(thePrimitive, (String)"thePrimitive", (Object[])new Object[0]);
            this.myPrimitive = thePrimitive;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if (ParserState.this.myJsonMode) {
                this.string(theValue);
            } else {
                super.attributeValue(theName, theValue);
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.myPrimitive.setValueAsString(this.myData);
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            throw new DataFormatException("Unexpected nested element in atom tag: " + theLocalPart);
        }

        @Override
        protected IElement getCurrentElement() {
            return null;
        }

        @Override
        public void string(String theData) {
            this.myData = this.myData == null ? theData : this.myData + theData;
        }
    }

    private class AtomLinkState
    extends BaseState {
        private BundleEntry myEntry;
        private String myHref;
        private Bundle myInstance;
        private String myRel;

        public AtomLinkState(Bundle theInstance) {
            super(null);
            this.myInstance = theInstance;
        }

        public AtomLinkState(BundleEntry theEntry) {
            super(null);
            this.myEntry = theEntry;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("rel".equals(theName)) {
                this.myRel = theValue;
            } else if ("href".equals(theName)) {
                this.myHref = theValue;
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.myInstance != null) {
                if ("self".equals(this.myRel)) {
                    this.myInstance.getLinkSelf().setValueAsString(this.myHref);
                } else if ("first".equals(this.myRel)) {
                    this.myInstance.getLinkFirst().setValueAsString(this.myHref);
                } else if ("previous".equals(this.myRel)) {
                    this.myInstance.getLinkPrevious().setValueAsString(this.myHref);
                } else if ("next".equals(this.myRel)) {
                    this.myInstance.getLinkNext().setValueAsString(this.myHref);
                } else if ("last".equals(this.myRel)) {
                    this.myInstance.getLinkLast().setValueAsString(this.myHref);
                } else if ("fhir-base".equals(this.myRel)) {
                    this.myInstance.getLinkBase().setValueAsString(this.myHref);
                }
            } else if ("self".equals(this.myRel)) {
                this.myEntry.getLinkSelf().setValueAsString(this.myHref);
            } else if ("search".equals(this.myRel)) {
                this.myEntry.getLinkSearch().setValueAsString(this.myHref);
            } else if ("alternate".equals(this.myRel)) {
                this.myEntry.getLinkAlternate().setValueAsString(this.myHref);
            }
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            throw new DataFormatException("Found unexpected element content '" + theLocalPart + "' within <link>");
        }
    }

    private class AtomEntryState
    extends BaseState {
        private boolean myDeleted;
        private BundleEntry myEntry;
        private Class<? extends IBaseResource> myResourceType;

        public AtomEntryState(Bundle theInstance, Class<? extends IBaseResource> theResourceType) {
            super(null);
            this.myEntry = new BundleEntry();
            this.myResourceType = theResourceType;
            theInstance.getEntries().add(this.myEntry);
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.populateResourceMetadata();
            ParserState.this.pop();
            if (this.myDeleted) {
                ParserState.this.putPlacerResourceInDeletedEntry(this.myEntry);
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("title".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getTitle()));
            } else if ("id".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getId()));
            } else if ("link".equals(theLocalPart)) {
                ParserState.this.push(new AtomLinkState(this.myEntry));
            } else if ("updated".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getUpdated()));
            } else if ("published".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getPublished()));
            } else if ("author".equals(theLocalPart)) {
                ParserState.this.push(new AtomAuthorState(this.myEntry));
            } else if ("content".equals(theLocalPart)) {
                ParserState.this.push(new PreResourceStateHapi(this.myEntry, this.myResourceType).setRequireResourceType(false));
            } else if ("summary".equals(theLocalPart)) {
                ParserState.this.push(new XhtmlState(this.getPreResourceState(), this.myEntry.getSummary(), false));
            } else if ("category".equals(theLocalPart)) {
                ParserState.this.push(new AtomCategoryState(this.myEntry.getCategories()));
            } else if ("deleted".equals(theLocalPart) && ParserState.this.myJsonMode) {
                this.myDeleted = true;
                ParserState.this.push(new AtomDeletedJsonWhenState(this.myEntry.getDeletedAt()));
            } else {
                throw new DataFormatException("Unexpected element in entry: " + theLocalPart);
            }
        }

        protected BundleEntry getEntry() {
            return this.myEntry;
        }

        private void populateResourceMetadata() {
            if (this.myEntry.getResource() == null) {
                return;
            }
            IdDt id = this.myEntry.getId();
            if (id != null && !id.isEmpty()) {
                this.myEntry.getResource().setId(id);
            }
            ResourceMetadataMap metadata = this.myEntry.getResource().getResourceMetadata();
            if (!this.myEntry.getPublished().isEmpty()) {
                ResourceMetadataKeyEnum.PUBLISHED.put(this.myEntry.getResource(), this.myEntry.getPublished());
            }
            if (!this.myEntry.getUpdated().isEmpty()) {
                ResourceMetadataKeyEnum.UPDATED.put(this.myEntry.getResource(), this.myEntry.getUpdated());
            }
            ResourceMetadataKeyEnum.TITLE.put(this.myEntry.getResource(), (String)this.myEntry.getTitle().getValue());
            if (!this.myEntry.getCategories().isEmpty()) {
                TagList tagList = new TagList();
                for (Tag next : this.myEntry.getCategories()) {
                    tagList.add(next);
                }
                ResourceMetadataKeyEnum.TAG_LIST.put(this.myEntry.getResource(), tagList);
            }
            if (!this.myEntry.getLinkSelf().isEmpty()) {
                String linkSelfValue = (String)this.myEntry.getLinkSelf().getValue();
                IdDt linkSelf = new IdDt(linkSelfValue);
                this.myEntry.getResource().setId(linkSelf);
                if (StringUtils.isNotBlank((CharSequence)linkSelf.getVersionIdPart())) {
                    metadata.put(ResourceMetadataKeyEnum.VERSION_ID, linkSelf);
                }
            }
            if (!this.myEntry.getLinkAlternate().isEmpty()) {
                ResourceMetadataKeyEnum.LINK_ALTERNATE.put(this.myEntry.getResource(), (String)this.myEntry.getLinkAlternate().getValue());
            }
            if (!this.myEntry.getLinkSearch().isEmpty()) {
                ResourceMetadataKeyEnum.LINK_SEARCH.put(this.myEntry.getResource(), (String)this.myEntry.getLinkSearch().getValue());
            }
        }
    }

    private class AtomDeletedJsonWhenState
    extends BaseState {
        private String myData;
        private IPrimitiveDatatype<?> myPrimitive;

        public AtomDeletedJsonWhenState(IPrimitiveDatatype<?> thePrimitive) {
            super(null);
            Validate.notNull(thePrimitive, (String)"thePrimitive", (Object[])new Object[0]);
            this.myPrimitive = thePrimitive;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            this.myData = theValue;
        }

        @Override
        public void endingElement() throws DataFormatException {
            this.myPrimitive.setValueAsString(this.myData);
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            throw new DataFormatException("Unexpected nested element in atom tag: " + theLocalPart);
        }

        @Override
        protected IElement getCurrentElement() {
            return null;
        }
    }

    private class AtomDeletedEntryState
    extends AtomEntryState {
        public AtomDeletedEntryState(Bundle theInstance, Class<? extends IBaseResource> theResourceType) {
            super(theInstance, theResourceType);
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("ref".equals(theName)) {
                this.getEntry().setId(new IdDt(theValue));
            } else if ("when".equals(theName)) {
                this.getEntry().setDeleted(new InstantDt(theValue));
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.putPlacerResourceInDeletedEntry(this.getEntry());
            super.endingElement();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("by".equals(theLocalPart) && ParserState.this.verifyNamespace("http://purl.org/atompub/tombstones/1.0", theNamespaceUri)) {
                ParserState.this.push(new AtomDeletedEntryByState(this.getEntry()));
            } else if ("comment".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.getEntry().getDeletedComment()));
            } else {
                super.enteringNewElement(theNamespaceUri, theLocalPart);
            }
        }
    }

    private class AtomDeletedEntryByState
    extends BaseState {
        private BundleEntry myEntry;

        public AtomDeletedEntryByState(BundleEntry theEntry) {
            super(null);
            this.myEntry = theEntry;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("name".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getDeletedByName()));
            } else if ("email".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myEntry.getDeletedByEmail()));
            } else {
                throw new DataFormatException("Unexpected element in entry: " + theLocalPart);
            }
        }
    }

    public class AtomCategoryState
    extends BaseState {
        private static final int STATE_LABEL = 2;
        private static final int STATE_NONE = 0;
        private static final int STATE_SCHEME = 3;
        private static final int STATE_TERM = 1;
        private int myCatState;
        private String myLabel;
        private String myScheme;
        private TagList myTagList;
        private String myTerm;

        public AtomCategoryState(TagList theTagList) {
            super(null);
            this.myCatState = 0;
            this.myTagList = theTagList;
        }

        @Override
        public void attributeValue(String theName, String theValue) throws DataFormatException {
            if ("term".equals(theName)) {
                this.myTerm = theValue;
            } else if ("label".equals(theName)) {
                this.myLabel = theValue;
            } else if ("scheme".equals(theName)) {
                this.myScheme = theValue;
            } else if ("value".equals(theName)) {
                switch (this.myCatState) {
                    case 2: {
                        this.myLabel = theValue;
                        break;
                    }
                    case 1: {
                        this.myTerm = theValue;
                        break;
                    }
                    case 3: {
                        this.myScheme = theValue;
                        break;
                    }
                    default: {
                        super.string(theValue);
                    }
                }
            }
        }

        @Override
        public void endingElement() throws DataFormatException {
            if (this.myCatState != 0) {
                this.myCatState = 0;
            } else {
                if (StringUtils.isNotEmpty((CharSequence)this.myScheme) || StringUtils.isNotBlank((CharSequence)this.myTerm) || StringUtils.isNotBlank((CharSequence)this.myLabel)) {
                    this.myTagList.addTag(this.myScheme, this.myTerm, this.myLabel);
                }
                ParserState.this.pop();
            }
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theName) throws DataFormatException {
            if (this.myCatState != 0) {
                throw new DataFormatException("Unexpected element in entry: " + theName);
            }
            if ("term".equals(theName)) {
                this.myCatState = 1;
            } else if ("label".equals(theName)) {
                this.myCatState = 2;
            } else if ("scheme".equals(theName)) {
                this.myCatState = 3;
            }
        }
    }

    private class AtomAuthorState
    extends BaseState {
        private BaseBundle myInstance;

        public AtomAuthorState(BaseBundle theEntry) {
            super(null);
            this.myInstance = theEntry;
        }

        @Override
        public void endingElement() throws DataFormatException {
            ParserState.this.pop();
        }

        @Override
        public void enteringNewElement(String theNamespaceUri, String theLocalPart) throws DataFormatException {
            if ("name".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getAuthorName()));
            } else if ("uri".equals(theLocalPart)) {
                ParserState.this.push(new AtomPrimitiveState(this.myInstance.getAuthorUri()));
            } else {
                throw new DataFormatException("Unexpected element: " + theLocalPart);
            }
        }
    }
}

