/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.parser;

import ca.uhn.fhir.context.BaseRuntimeChildDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementCompositeDefinition;
import ca.uhn.fhir.context.BaseRuntimeElementDefinition;
import ca.uhn.fhir.context.ConfigurationException;
import ca.uhn.fhir.context.FhirContext;
import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.context.RuntimeChildContainedResources;
import ca.uhn.fhir.context.RuntimeChildDeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeChildNarrativeDefinition;
import ca.uhn.fhir.context.RuntimeChildUndeclaredExtensionDefinition;
import ca.uhn.fhir.context.RuntimeResourceDefinition;
import ca.uhn.fhir.model.api.Bundle;
import ca.uhn.fhir.model.api.BundleEntry;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.ISupportsUndeclaredExtensions;
import ca.uhn.fhir.model.api.ResourceMetadataKeyEnum;
import ca.uhn.fhir.model.api.Tag;
import ca.uhn.fhir.model.api.TagList;
import ca.uhn.fhir.model.base.composite.BaseCodingDt;
import ca.uhn.fhir.model.base.composite.BaseNarrativeDt;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import ca.uhn.fhir.narrative.INarrativeGenerator;
import ca.uhn.fhir.parser.BaseParser;
import ca.uhn.fhir.parser.DataFormatException;
import ca.uhn.fhir.parser.IParser;
import ca.uhn.fhir.parser.IParserErrorHandler;
import ca.uhn.fhir.parser.ParserState;
import ca.uhn.fhir.rest.server.EncodingEnum;
import ca.uhn.fhir.rest.server.exceptions.InternalErrorException;
import ca.uhn.fhir.util.ElementUtil;
import ca.uhn.fhir.util.NonPrettyPrintWriterWrapper;
import ca.uhn.fhir.util.PrettyPrintWriterWrapper;
import ca.uhn.fhir.util.XmlUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.instance.model.api.IAnyResource;
import org.hl7.fhir.instance.model.api.IBase;
import org.hl7.fhir.instance.model.api.IBaseBinary;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.instance.model.api.IBaseExtension;
import org.hl7.fhir.instance.model.api.IBaseHasExtensions;
import org.hl7.fhir.instance.model.api.IBaseHasModifierExtensions;
import org.hl7.fhir.instance.model.api.IBaseReference;
import org.hl7.fhir.instance.model.api.IBaseResource;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.instance.model.api.IPrimitiveType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XmlParser
extends BaseParser
implements IParser {
    static final String ATOM_NS = "http://www.w3.org/2005/Atom";
    static final String FHIR_NS = "http://hl7.org/fhir";
    static final String OPENSEARCH_NS = "http://a9.com/-/spec/opensearch/1.1/";
    private static final Logger ourLog = LoggerFactory.getLogger(XmlParser.class);
    static final String RESREF_DISPLAY = "display";
    static final String RESREF_REFERENCE = "reference";
    static final String TOMBSTONES_NS = "http://purl.org/atompub/tombstones/1.0";
    static final String XHTML_NS = "http://www.w3.org/1999/xhtml";
    private FhirContext myContext;
    private boolean myPrettyPrint;

    public XmlParser(FhirContext theContext, IParserErrorHandler theParserErrorHandler) {
        super(theContext, theParserErrorHandler);
        this.myContext = theContext;
    }

    private XMLEventReader createStreamReader(Reader theReader) {
        try {
            return XmlUtil.createXmlReader(theReader);
        }
        catch (FactoryConfigurationError e1) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e1);
        }
        catch (XMLStreamException e1) {
            throw new DataFormatException(e1);
        }
    }

    private XMLStreamWriter createXmlWriter(Writer theWriter) throws XMLStreamException {
        XMLStreamWriter eventWriter = XmlUtil.createXmlStreamWriter(theWriter);
        eventWriter = this.decorateStreamWriter(eventWriter);
        return eventWriter;
    }

    private XMLStreamWriter decorateStreamWriter(XMLStreamWriter eventWriter) {
        if (this.myPrettyPrint) {
            PrettyPrintWriterWrapper retVal = new PrettyPrintWriterWrapper(eventWriter);
            return retVal;
        }
        NonPrettyPrintWriterWrapper retVal = new NonPrettyPrintWriterWrapper(eventWriter);
        return retVal;
    }

    @Override
    public void doEncodeBundleToWriter(Bundle theBundle, Writer theWriter) throws DataFormatException {
        try {
            XMLStreamWriter eventWriter = this.createXmlWriter(theWriter);
            if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
                this.encodeBundleToWriterDstu2(theBundle, eventWriter);
            } else {
                this.encodeBundleToWriterDstu1(theBundle, eventWriter);
            }
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e);
        }
    }

    @Override
    public void doEncodeResourceToWriter(IBaseResource theResource, Writer theWriter) throws DataFormatException {
        try {
            XMLStreamWriter eventWriter = this.createXmlWriter(theWriter);
            this.encodeResourceToXmlStreamWriter(theResource, eventWriter, false);
            eventWriter.flush();
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e);
        }
    }

    @Override
    public <T extends IBaseResource> T doParseResource(Class<T> theResourceType, Reader theReader) {
        XMLEventReader streamReader = this.createStreamReader(theReader);
        return this.parseResource(theResourceType, streamReader);
    }

    private <T> T doXmlLoop(XMLEventReader streamReader, ParserState<T> parserState) {
        ourLog.trace("Entering XML parsing loop with state: {}", parserState);
        try {
            while (streamReader.hasNext()) {
                XMLEvent nextEvent = streamReader.nextEvent();
                try {
                    XMLEvent elem;
                    if (nextEvent.isStartElement()) {
                        Iterator<Attribute> attributes;
                        Attribute urlAttr;
                        elem = nextEvent.asStartElement();
                        String namespaceURI = elem.getName().getNamespaceURI();
                        if ("extension".equals(elem.getName().getLocalPart())) {
                            urlAttr = elem.getAttributeByName(new QName("url"));
                            if (urlAttr == null || StringUtils.isBlank((CharSequence)urlAttr.getValue())) {
                                throw new DataFormatException("Extension element has no 'url' attribute");
                            }
                            parserState.enteringNewElementExtension((StartElement)elem, urlAttr.getValue(), false);
                        } else if ("modifierExtension".equals(elem.getName().getLocalPart())) {
                            urlAttr = elem.getAttributeByName(new QName("url"));
                            if (urlAttr == null || StringUtils.isBlank((CharSequence)urlAttr.getValue())) {
                                throw new DataFormatException("Extension element has no 'url' attribute");
                            }
                            parserState.enteringNewElementExtension((StartElement)elem, urlAttr.getValue(), true);
                        } else {
                            String elementName = elem.getName().getLocalPart();
                            parserState.enteringNewElement(namespaceURI, elementName);
                        }
                        Iterator<Attribute> iter = attributes = elem.getAttributes();
                        while (iter.hasNext()) {
                            Attribute next = iter.next();
                            parserState.attributeValue(next.getName().getLocalPart(), next.getValue());
                        }
                    } else if (nextEvent.isAttribute()) {
                        elem = (Attribute)nextEvent;
                        String name = elem.getName().getLocalPart();
                        parserState.attributeValue(name, elem.getValue());
                    } else if (nextEvent.isEndElement()) {
                        parserState.endingElement();
                        if (parserState.isComplete()) {
                            return parserState.getObject();
                        }
                    } else if (nextEvent.isCharacters()) {
                        parserState.string(nextEvent.asCharacters().getData());
                    }
                    parserState.xmlEvent(nextEvent);
                }
                catch (DataFormatException e) {
                    throw new DataFormatException("DataFormatException at [" + nextEvent.getLocation().toString() + "]: " + e.getMessage(), e);
                }
            }
            return null;
        }
        catch (XMLStreamException e) {
            throw new DataFormatException(e);
        }
    }

    @Override
    public String encodeBundleToString(Bundle theBundle) throws DataFormatException {
        StringWriter stringWriter = new StringWriter();
        try {
            this.encodeBundleToWriter(theBundle, stringWriter);
        }
        catch (IOException e) {
            throw new InternalErrorException("IOException writing to StringWriter - Should not happen", (Throwable)e);
        }
        return stringWriter.toString();
    }

    private void encodeBundleToWriterDstu1(Bundle theBundle, XMLStreamWriter eventWriter) throws XMLStreamException {
        eventWriter.writeStartElement("feed");
        eventWriter.writeDefaultNamespace(ATOM_NS);
        this.writeTagWithTextNode(eventWriter, "title", theBundle.getTitle());
        this.writeTagWithTextNode(eventWriter, "id", theBundle.getBundleId());
        this.writeAtomLink(eventWriter, "self", theBundle.getLinkSelf());
        this.writeAtomLink(eventWriter, "first", theBundle.getLinkFirst());
        this.writeAtomLink(eventWriter, "previous", theBundle.getLinkPrevious());
        this.writeAtomLink(eventWriter, "next", theBundle.getLinkNext());
        this.writeAtomLink(eventWriter, "last", theBundle.getLinkLast());
        this.writeAtomLink(eventWriter, "fhir-base", theBundle.getLinkBase());
        if (theBundle.getTotalResults().getValue() != null) {
            eventWriter.writeStartElement("os", "totalResults", OPENSEARCH_NS);
            eventWriter.writeNamespace("os", OPENSEARCH_NS);
            eventWriter.writeCharacters(((Integer)theBundle.getTotalResults().getValue()).toString());
            eventWriter.writeEndElement();
        }
        this.writeOptionalTagWithTextNode(eventWriter, "updated", theBundle.getUpdated());
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theBundle.getAuthorName().getValue()))) {
            eventWriter.writeStartElement("author");
            this.writeTagWithTextNode(eventWriter, "name", theBundle.getAuthorName());
            this.writeOptionalTagWithTextNode(eventWriter, "uri", theBundle.getAuthorUri());
            eventWriter.writeEndElement();
        }
        this.writeCategories(eventWriter, theBundle.getCategories());
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            IResource resource;
            boolean deleted = false;
            if (nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty()) {
                deleted = true;
                eventWriter.writeStartElement("at", "deleted-entry", TOMBSTONES_NS);
                eventWriter.writeNamespace("at", TOMBSTONES_NS);
                if (nextEntry.getDeletedResourceId().isEmpty()) {
                    this.writeOptionalAttribute(eventWriter, "ref", nextEntry.getId().getValueAsString());
                } else {
                    this.writeOptionalAttribute(eventWriter, "ref", nextEntry.getDeletedResourceId().getValueAsString());
                }
                this.writeOptionalAttribute(eventWriter, "when", nextEntry.getDeletedAt().getValueAsString());
                if (!nextEntry.getDeletedByEmail().isEmpty() || !nextEntry.getDeletedByName().isEmpty()) {
                    eventWriter.writeStartElement(TOMBSTONES_NS, "by");
                    if (!nextEntry.getDeletedByName().isEmpty()) {
                        eventWriter.writeStartElement(TOMBSTONES_NS, "name");
                        eventWriter.writeCharacters((String)nextEntry.getDeletedByName().getValue());
                        eventWriter.writeEndElement();
                    }
                    if (!nextEntry.getDeletedByEmail().isEmpty()) {
                        eventWriter.writeStartElement(TOMBSTONES_NS, "email");
                        eventWriter.writeCharacters((String)nextEntry.getDeletedByEmail().getValue());
                        eventWriter.writeEndElement();
                    }
                    eventWriter.writeEndElement();
                }
                if (!nextEntry.getDeletedComment().isEmpty()) {
                    eventWriter.writeStartElement(TOMBSTONES_NS, "comment");
                    eventWriter.writeCharacters((String)nextEntry.getDeletedComment().getValue());
                    eventWriter.writeEndElement();
                }
            } else {
                eventWriter.writeStartElement("entry");
            }
            this.writeOptionalTagWithTextNode(eventWriter, "title", nextEntry.getTitle());
            if (!deleted) {
                if (!nextEntry.getId().isEmpty()) {
                    this.writeTagWithTextNode(eventWriter, "id", nextEntry.getId());
                } else {
                    this.writeTagWithTextNode(eventWriter, "id", nextEntry.getResource().getId());
                }
            }
            this.writeOptionalTagWithTextNode(eventWriter, "updated", nextEntry.getUpdated());
            this.writeOptionalTagWithTextNode(eventWriter, "published", nextEntry.getPublished());
            this.writeCategories(eventWriter, nextEntry.getCategories());
            if (!nextEntry.getLinkSelf().isEmpty()) {
                this.writeAtomLink(eventWriter, "self", nextEntry.getLinkSelf());
            }
            if (!nextEntry.getLinkAlternate().isEmpty()) {
                this.writeAtomLink(eventWriter, "alternate", nextEntry.getLinkAlternate());
            }
            if (!nextEntry.getLinkSearch().isEmpty()) {
                this.writeAtomLink(eventWriter, "search", nextEntry.getLinkSearch());
            }
            if ((resource = nextEntry.getResource()) != null && !resource.isEmpty() && !deleted) {
                eventWriter.writeStartElement("content");
                eventWriter.writeAttribute("type", "text/xml");
                this.encodeResourceToXmlStreamWriter(resource, eventWriter, false);
                eventWriter.writeEndElement();
            } else {
                ourLog.debug("Bundle entry contains null resource");
            }
            if (!nextEntry.getSummary().isEmpty()) {
                eventWriter.writeStartElement("summary");
                eventWriter.writeAttribute("type", "xhtml");
                this.encodeXhtml(nextEntry.getSummary(), eventWriter);
                eventWriter.writeEndElement();
            }
            eventWriter.writeEndElement();
        }
        eventWriter.writeEndElement();
        eventWriter.close();
    }

    private void encodeBundleToWriterDstu2(Bundle theBundle, XMLStreamWriter theEventWriter) throws XMLStreamException {
        theEventWriter.writeStartElement("Bundle");
        theEventWriter.writeDefaultNamespace(FHIR_NS);
        this.writeOptionalTagWithValue(theEventWriter, "id", theBundle.getId().getIdPart());
        InstantDt updated = (InstantDt)theBundle.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
        IdDt bundleId = theBundle.getId();
        if (bundleId != null && StringUtils.isNotBlank((CharSequence)bundleId.getVersionIdPart()) || updated != null && !updated.isEmpty()) {
            theEventWriter.writeStartElement("meta");
            this.writeOptionalTagWithValue(theEventWriter, "versionId", bundleId.getVersionIdPart());
            if (updated != null) {
                this.writeOptionalTagWithValue(theEventWriter, "lastUpdated", updated.getValueAsString());
            }
            theEventWriter.writeEndElement();
        }
        String bundleBaseUrl = (String)theBundle.getLinkBase().getValue();
        this.writeOptionalTagWithValue(theEventWriter, "type", (String)theBundle.getType().getValue());
        this.writeOptionalTagWithValue(theEventWriter, "total", theBundle.getTotalResults().getValueAsString());
        this.writeBundleResourceLink(theEventWriter, "first", theBundle.getLinkFirst());
        this.writeBundleResourceLink(theEventWriter, "previous", theBundle.getLinkPrevious());
        this.writeBundleResourceLink(theEventWriter, "next", theBundle.getLinkNext());
        this.writeBundleResourceLink(theEventWriter, "last", theBundle.getLinkLast());
        this.writeBundleResourceLink(theEventWriter, "self", theBundle.getLinkSelf());
        for (BundleEntry nextEntry : theBundle.getEntries()) {
            IResource resource;
            theEventWriter.writeStartElement("entry");
            boolean deleted = false;
            if (nextEntry.getDeletedAt() != null && !nextEntry.getDeletedAt().isEmpty()) {
                deleted = true;
            }
            this.writeBundleResourceLink(theEventWriter, "alternate", nextEntry.getLinkAlternate());
            if (nextEntry.getResource() != null && nextEntry.getResource().getId().getBaseUrl() != null) {
                this.writeOptionalTagWithValue(theEventWriter, "fullUrl", nextEntry.getResource().getId().getValue());
            }
            if ((resource = nextEntry.getResource()) != null && !resource.isEmpty() && !deleted) {
                theEventWriter.writeStartElement("resource");
                this.encodeResourceToXmlStreamWriter(resource, theEventWriter, false);
                theEventWriter.writeEndElement();
            } else {
                ourLog.debug("Bundle entry contains null resource");
            }
            if (!nextEntry.getSearchMode().isEmpty() || !nextEntry.getScore().isEmpty()) {
                theEventWriter.writeStartElement("search");
                this.writeOptionalTagWithValue(theEventWriter, "mode", nextEntry.getSearchMode().getValueAsString());
                this.writeOptionalTagWithValue(theEventWriter, "score", nextEntry.getScore().getValueAsString());
                theEventWriter.writeEndElement();
            }
            if (!nextEntry.getTransactionMethod().isEmpty() || !nextEntry.getLinkSearch().isEmpty()) {
                theEventWriter.writeStartElement("request");
                this.writeOptionalTagWithValue(theEventWriter, "method", (String)nextEntry.getTransactionMethod().getValue());
                this.writeOptionalTagWithValue(theEventWriter, "url", (String)nextEntry.getLinkSearch().getValue());
                theEventWriter.writeEndElement();
            }
            if (deleted) {
                theEventWriter.writeStartElement("deleted");
                this.writeOptionalTagWithValue(theEventWriter, "type", nextEntry.getId().getResourceType());
                this.writeOptionalTagWithValue(theEventWriter, "id", nextEntry.getId().getIdPart());
                this.writeOptionalTagWithValue(theEventWriter, "versionId", nextEntry.getId().getVersionIdPart());
                this.writeOptionalTagWithValue(theEventWriter, "instant", nextEntry.getDeletedAt().getValueAsString());
                theEventWriter.writeEndElement();
            }
            theEventWriter.writeEndElement();
        }
        theEventWriter.writeEndElement();
        theEventWriter.close();
    }

    private void encodeChildElementToStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, IBase nextValue, String childName, BaseRuntimeElementDefinition<?> childDef, String theExtensionUrl, boolean theIncludedResource, BaseParser.CompositeChildElement theParent) throws XMLStreamException, DataFormatException {
        if ((nextValue == null || nextValue.isEmpty()) && !this.isChildContained(childDef, theIncludedResource)) {
            return;
        }
        switch (childDef.getChildType()) {
            case ID_DATATYPE: {
                String encodedValue;
                IIdType value = (IIdType)((Object)nextValue);
                String string = encodedValue = "id".equals(childName) ? value.getIdPart() : value.getValue();
                if (value == null) break;
                theEventWriter.writeStartElement(childName);
                theEventWriter.writeAttribute("value", encodedValue);
                this.encodeExtensionsIfPresent(theResource, theEventWriter, nextValue, theIncludedResource);
                theEventWriter.writeEndElement();
                break;
            }
            case PRIMITIVE_DATATYPE: {
                IPrimitiveType pd = (IPrimitiveType)nextValue;
                String value = pd.getValueAsString();
                if (value == null) break;
                theEventWriter.writeStartElement(childName);
                theEventWriter.writeAttribute("value", value);
                this.encodeExtensionsIfPresent(theResource, theEventWriter, nextValue, theIncludedResource);
                theEventWriter.writeEndElement();
                break;
            }
            case RESOURCE_BLOCK: 
            case COMPOSITE_DATATYPE: {
                theEventWriter.writeStartElement(childName);
                if (StringUtils.isNotBlank((CharSequence)theExtensionUrl)) {
                    theEventWriter.writeAttribute("url", theExtensionUrl);
                }
                BaseRuntimeElementCompositeDefinition childCompositeDef = (BaseRuntimeElementCompositeDefinition)childDef;
                this.encodeCompositeElementToStreamWriter(theResource, nextValue, theEventWriter, childCompositeDef, theIncludedResource, theParent);
                theEventWriter.writeEndElement();
                break;
            }
            case RESOURCE_REF: {
                IBaseReference ref = (IBaseReference)nextValue;
                if (ref.isEmpty()) break;
                theEventWriter.writeStartElement(childName);
                this.encodeResourceReferenceToStreamWriter(theEventWriter, ref, theResource, theIncludedResource);
                theEventWriter.writeEndElement();
                break;
            }
            case CONTAINED_RESOURCE_LIST: 
            case CONTAINED_RESOURCES: {
                for (IBaseResource next : this.getContainedResources().getContainedResources()) {
                    IIdType resourceId = this.getContainedResources().getResourceId(next);
                    theEventWriter.writeStartElement("contained");
                    this.encodeResourceToXmlStreamWriter(next, theEventWriter, true, this.fixContainedResourceId(resourceId.getValue()));
                    theEventWriter.writeEndElement();
                }
                break;
            }
            case RESOURCE: {
                theEventWriter.writeStartElement(childName);
                IBaseResource resource = (IBaseResource)nextValue;
                this.encodeResourceToXmlStreamWriter(resource, theEventWriter, false);
                theEventWriter.writeEndElement();
                break;
            }
            case PRIMITIVE_XHTML: {
                XhtmlDt dt = (XhtmlDt)nextValue;
                if (!dt.hasContent()) break;
                this.encodeXhtml(dt, theEventWriter);
                break;
            }
            case PRIMITIVE_XHTML_HL7ORG: {
                IBaseXhtml dt = (IBaseXhtml)nextValue;
                if (dt.isEmpty()) break;
                XhtmlDt hdt = new XhtmlDt();
                hdt.setValueAsString(dt.getValueAsString());
                this.encodeXhtml(hdt, theEventWriter);
                break;
            }
            case EXTENSION_DECLARED: 
            case UNDECL_EXT: {
                throw new IllegalStateException("state should not happen: " + childDef.getName());
            }
        }
    }

    private void encodeCompositeElementChildrenToStreamWriter(IBaseResource theResource, IBase theElement, XMLStreamWriter theEventWriter, List<? extends BaseRuntimeChildDefinition> theChildren, boolean theContainedResource, BaseParser.CompositeChildElement theParent) throws XMLStreamException, DataFormatException {
        for (BaseParser.CompositeChildElement nextChildElem : super.compositeChildIterator(theChildren, theContainedResource, theParent)) {
            BaseRuntimeChildDefinition nextChild = nextChildElem.getDef();
            if (nextChild instanceof RuntimeChildNarrativeDefinition) {
                INarrativeGenerator gen = this.myContext.getNarrativeGenerator();
                if (theResource instanceof IResource) {
                    BaseNarrativeDt narr = ((IResource)theResource).getText();
                    if (gen != null && narr.isEmpty()) {
                        String resourceProfile = this.myContext.getResourceDefinition(theResource).getResourceProfile();
                        gen.generateNarrative(resourceProfile, theResource, narr);
                    }
                    if (!narr.isEmpty()) {
                        RuntimeChildNarrativeDefinition child = (RuntimeChildNarrativeDefinition)nextChild;
                        String childName = nextChild.getChildNameByDatatype(child.getDatatype());
                        BaseRuntimeElementDefinition<?> type = child.getChildByName(childName);
                        this.encodeChildElementToStreamWriter(theResource, theEventWriter, narr, childName, type, null, theContainedResource, nextChildElem);
                        continue;
                    }
                }
            }
            if (nextChild instanceof RuntimeChildContainedResources) {
                this.encodeChildElementToStreamWriter(theResource, theEventWriter, null, nextChild.getChildNameByDatatype(null), nextChild.getChildElementDefinitionByDatatype(null), null, theContainedResource, nextChildElem);
                continue;
            }
            List<IBase> values = nextChild.getAccessor().getValues(theElement);
            if ((values = super.preProcessValues(nextChild, values)) == null || values.isEmpty()) continue;
            for (IBase nextValue : values) {
                if (nextValue == null || nextValue.isEmpty()) continue;
                Class<?> type = nextValue.getClass();
                String childName = nextChild.getChildNameByDatatype(type);
                String extensionUrl = nextChild.getExtensionUrl();
                BaseRuntimeElementDefinition<?> childDef = nextChild.getChildElementDefinitionByDatatype(type);
                if (childDef == null) {
                    super.throwExceptionForUnknownChildType(nextChild, type);
                }
                if (nextValue instanceof IBaseExtension && this.myContext.getVersion().getVersion() == FhirVersionEnum.DSTU1) {
                    extensionUrl = ((IBaseExtension)nextValue).getUrl();
                    this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, extensionUrl, theContainedResource, nextChildElem);
                    continue;
                }
                if (extensionUrl != null && !childName.equals("extension")) {
                    RuntimeChildDeclaredExtensionDefinition extDef = (RuntimeChildDeclaredExtensionDefinition)nextChild;
                    if (extDef.isModifier()) {
                        theEventWriter.writeStartElement("modifierExtension");
                    } else {
                        theEventWriter.writeStartElement("extension");
                    }
                    theEventWriter.writeAttribute("url", extensionUrl);
                    this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, null, theContainedResource, nextChildElem);
                    theEventWriter.writeEndElement();
                    continue;
                }
                if (nextChild instanceof RuntimeChildNarrativeDefinition && theContainedResource) continue;
                this.encodeChildElementToStreamWriter(theResource, theEventWriter, nextValue, childName, childDef, extensionUrl, theContainedResource, nextChildElem);
            }
        }
    }

    private void encodeCompositeElementToStreamWriter(IBaseResource theResource, IBase theElement, XMLStreamWriter theEventWriter, BaseRuntimeElementCompositeDefinition<?> theElementDefinition, boolean theIncludedResource, BaseParser.CompositeChildElement theParent) throws XMLStreamException, DataFormatException {
        this.encodeExtensionsIfPresent(theResource, theEventWriter, theElement, theIncludedResource);
        this.encodeCompositeElementChildrenToStreamWriter(theResource, theElement, theEventWriter, theElementDefinition.getExtensions(), theIncludedResource, theParent);
        this.encodeCompositeElementChildrenToStreamWriter(theResource, theElement, theEventWriter, theElementDefinition.getChildren(), theIncludedResource, theParent);
    }

    private void encodeExtensionsIfPresent(IBaseResource theResource, XMLStreamWriter theWriter, IBase theElement, boolean theIncludedResource) throws XMLStreamException, DataFormatException {
        Object res;
        if (theElement instanceof ISupportsUndeclaredExtensions) {
            res = (ISupportsUndeclaredExtensions)theElement;
            this.encodeUndeclaredExtensions(theResource, theWriter, this.toBaseExtensionList(res.getUndeclaredExtensions()), "extension", theIncludedResource);
            this.encodeUndeclaredExtensions(theResource, theWriter, this.toBaseExtensionList(res.getUndeclaredModifierExtensions()), "modifierExtension", theIncludedResource);
        }
        if (theElement instanceof IBaseHasExtensions) {
            res = (IBaseHasExtensions)((Object)theElement);
            this.encodeUndeclaredExtensions(theResource, theWriter, res.getExtension(), "extension", theIncludedResource);
        }
        if (theElement instanceof IBaseHasModifierExtensions) {
            res = (IBaseHasModifierExtensions)((Object)theElement);
            this.encodeUndeclaredExtensions(theResource, theWriter, res.getModifierExtension(), "modifierExtension", theIncludedResource);
        }
    }

    private void encodeResourceReferenceToStreamWriter(XMLStreamWriter theEventWriter, IBaseReference theRef, IBaseResource theResource, boolean theIncludedResource) throws XMLStreamException {
        String reference = this.determineReferenceText(theRef);
        this.encodeExtensionsIfPresent(theResource, theEventWriter, theRef, theIncludedResource);
        if (StringUtils.isNotBlank((CharSequence)reference)) {
            theEventWriter.writeStartElement(RESREF_REFERENCE);
            theEventWriter.writeAttribute("value", reference);
            theEventWriter.writeEndElement();
        }
        if (!theRef.getDisplayElement().isEmpty()) {
            theEventWriter.writeStartElement(RESREF_DISPLAY);
            theEventWriter.writeAttribute("value", theRef.getDisplayElement().getValue());
            theEventWriter.writeEndElement();
        }
    }

    private void encodeResourceToStreamWriterInDstu2Format(RuntimeResourceDefinition theResDef, IBaseResource theResource, IBase theElement, XMLStreamWriter theEventWriter, BaseRuntimeElementCompositeDefinition<?> resDef, boolean theIncludedResource) throws XMLStreamException, DataFormatException {
        ArrayList<BaseRuntimeChildDefinition> preExtensionChildren = new ArrayList<BaseRuntimeChildDefinition>();
        ArrayList<BaseRuntimeChildDefinition> postExtensionChildren = new ArrayList<BaseRuntimeChildDefinition>();
        List<BaseRuntimeChildDefinition> children = resDef.getChildren();
        for (BaseRuntimeChildDefinition next : children) {
            if (next.getElementName().equals("text")) {
                preExtensionChildren.add(next);
                continue;
            }
            if (next.getElementName().equals("contained")) {
                preExtensionChildren.add(next);
                continue;
            }
            postExtensionChildren.add(next);
        }
        BaseParser.CompositeChildElement parent = new BaseParser.CompositeChildElement(theResDef);
        this.encodeCompositeElementChildrenToStreamWriter(theResource, theElement, theEventWriter, preExtensionChildren, theIncludedResource, parent);
        this.encodeExtensionsIfPresent(theResource, theEventWriter, theElement, theIncludedResource);
        this.encodeCompositeElementChildrenToStreamWriter(theResource, theElement, theEventWriter, resDef.getExtensions(), theIncludedResource, parent);
        this.encodeCompositeElementChildrenToStreamWriter(theResource, theElement, theEventWriter, postExtensionChildren, theIncludedResource, parent);
    }

    private void encodeResourceToXmlStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, boolean theIncludedResource) throws XMLStreamException, DataFormatException {
        String resourceId = null;
        if (StringUtils.isNotBlank((CharSequence)theResource.getIdElement().getIdPart())) {
            resourceId = theResource.getIdElement().getIdPart();
            if (theResource.getIdElement().getValue().startsWith("urn:")) {
                resourceId = null;
            }
            if (this.myContext.getVersion().getVersion().equals((Object)FhirVersionEnum.DSTU1)) {
                resourceId = null;
            }
        }
        if (this.isOmitResourceId() && !theIncludedResource) {
            resourceId = null;
        }
        this.encodeResourceToXmlStreamWriter(theResource, theEventWriter, theIncludedResource, resourceId);
    }

    private void encodeResourceToXmlStreamWriter(IBaseResource theResource, XMLStreamWriter theEventWriter, boolean theContainedResource, String theResourceId) throws XMLStreamException {
        RuntimeResourceDefinition resDef;
        if (!theContainedResource) {
            super.containResourcesForEncoding(theResource);
        }
        if ((resDef = this.myContext.getResourceDefinition(theResource)) == null) {
            throw new ConfigurationException("Unknown resource type: " + theResource.getClass());
        }
        theEventWriter.writeStartElement(resDef.getName());
        theEventWriter.writeDefaultNamespace(FHIR_NS);
        if (theResource instanceof IAnyResource) {
            this.writeOptionalTagWithValue(theEventWriter, "id", theResourceId);
            this.encodeCompositeElementToStreamWriter(theResource, theResource, theEventWriter, resDef, theContainedResource, new BaseParser.CompositeChildElement(resDef));
        } else if (this.myContext.getVersion().getVersion().isNewerThan(FhirVersionEnum.DSTU1)) {
            IResource resource = (IResource)theResource;
            this.writeOptionalTagWithValue(theEventWriter, "id", theResourceId);
            InstantDt updated = (InstantDt)resource.getResourceMetadata().get(ResourceMetadataKeyEnum.UPDATED);
            IdDt resourceId = resource.getId();
            String versionIdPart = resourceId.getVersionIdPart();
            if (StringUtils.isBlank((CharSequence)versionIdPart)) {
                versionIdPart = ResourceMetadataKeyEnum.VERSION.get(resource);
            }
            List<BaseCodingDt> securityLabels = XmlParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.SECURITY_LABELS);
            List<IdDt> profiles = XmlParser.extractMetadataListNotNull(resource, ResourceMetadataKeyEnum.PROFILES);
            TagList tags = this.getMetaTagsForEncoding(resource);
            if (!ElementUtil.isEmpty(versionIdPart, updated, securityLabels, tags, profiles)) {
                theEventWriter.writeStartElement("meta");
                this.writeOptionalTagWithValue(theEventWriter, "versionId", versionIdPart);
                if (updated != null) {
                    this.writeOptionalTagWithValue(theEventWriter, "lastUpdated", updated.getValueAsString());
                }
                for (IdDt profile : profiles) {
                    theEventWriter.writeStartElement("profile");
                    theEventWriter.writeAttribute("value", profile.getValue());
                    theEventWriter.writeEndElement();
                }
                for (BaseCodingDt securityLabel : securityLabels) {
                    theEventWriter.writeStartElement("security");
                    BaseRuntimeElementCompositeDefinition def = (BaseRuntimeElementCompositeDefinition)this.myContext.getElementDefinition(securityLabel.getClass());
                    this.encodeCompositeElementChildrenToStreamWriter(resource, securityLabel, theEventWriter, def.getChildren(), theContainedResource, null);
                    theEventWriter.writeEndElement();
                }
                if (tags != null) {
                    for (Tag tag : tags) {
                        if (tag.isEmpty()) continue;
                        theEventWriter.writeStartElement("tag");
                        this.writeOptionalTagWithValue(theEventWriter, "system", tag.getScheme());
                        this.writeOptionalTagWithValue(theEventWriter, "code", tag.getTerm());
                        this.writeOptionalTagWithValue(theEventWriter, RESREF_DISPLAY, tag.getLabel());
                        theEventWriter.writeEndElement();
                    }
                }
                theEventWriter.writeEndElement();
            }
            if (theResource instanceof IBaseBinary) {
                IBaseBinary bin = (IBaseBinary)theResource;
                this.writeOptionalTagWithValue(theEventWriter, "contentType", bin.getContentType());
                this.writeOptionalTagWithValue(theEventWriter, "content", bin.getContentAsBase64());
            } else {
                this.encodeResourceToStreamWriterInDstu2Format(resDef, theResource, theResource, theEventWriter, resDef, theContainedResource);
            }
        } else {
            if (theResourceId != null && theContainedResource) {
                theEventWriter.writeAttribute("id", theResourceId);
            }
            if (theResource instanceof IBaseBinary) {
                IBaseBinary bin = (IBaseBinary)theResource;
                if (bin.getContentType() != null) {
                    theEventWriter.writeAttribute("contentType", bin.getContentType());
                }
                theEventWriter.writeCharacters(bin.getContentAsBase64());
            } else {
                this.encodeCompositeElementToStreamWriter(theResource, theResource, theEventWriter, resDef, theContainedResource, new BaseParser.CompositeChildElement(resDef));
            }
        }
        theEventWriter.writeEndElement();
    }

    @Override
    public void encodeTagListToWriter(TagList theTagList, Writer theWriter) throws IOException {
        try {
            XMLStreamWriter eventWriter = this.createXmlWriter(theWriter);
            eventWriter.writeStartElement(TagList.ELEMENT_NAME_LC);
            eventWriter.writeDefaultNamespace(FHIR_NS);
            for (Tag next : theTagList) {
                eventWriter.writeStartElement("category");
                if (StringUtils.isNotBlank((CharSequence)next.getTerm())) {
                    eventWriter.writeAttribute("term", next.getTerm());
                }
                if (StringUtils.isNotBlank((CharSequence)next.getLabel())) {
                    eventWriter.writeAttribute("label", next.getLabel());
                }
                if (StringUtils.isNotBlank((CharSequence)next.getScheme())) {
                    eventWriter.writeAttribute("scheme", next.getScheme());
                }
                eventWriter.writeEndElement();
            }
            eventWriter.writeEndElement();
            eventWriter.close();
        }
        catch (XMLStreamException e) {
            throw new ConfigurationException("Failed to initialize STaX event factory", e);
        }
    }

    private void encodeUndeclaredExtensions(IBaseResource theResource, XMLStreamWriter theWriter, List<? extends IBaseExtension<?, ?>> theExtensions, String tagName, boolean theIncludedResource) throws XMLStreamException, DataFormatException {
        for (IBaseExtension<?, ?> next : theExtensions) {
            if (next == null || ElementUtil.isEmpty(next.getValue()) && next.getExtension().isEmpty()) continue;
            theWriter.writeStartElement(tagName);
            String url = next.getUrl();
            theWriter.writeAttribute("url", url);
            if (next.getValue() != null) {
                BaseRuntimeElementDefinition<?> childDef;
                IBaseDatatype value = next.getValue();
                RuntimeChildUndeclaredExtensionDefinition extDef = this.myContext.getRuntimeChildUndeclaredExtensionDefinition();
                String childName = extDef.getChildNameByDatatype(value.getClass());
                if (childName == null) {
                    childDef = this.myContext.getElementDefinition(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                    childName = RuntimeChildUndeclaredExtensionDefinition.createExtensionChildName(childDef);
                } else {
                    childDef = extDef.getChildElementDefinitionByDatatype(value.getClass());
                    if (childDef == null) {
                        throw new ConfigurationException("Unable to encode extension, unrecognized child element type: " + value.getClass().getCanonicalName());
                    }
                }
                this.encodeChildElementToStreamWriter(theResource, theWriter, value, childName, childDef, null, theIncludedResource, null);
            }
            this.encodeExtensionsIfPresent(theResource, theWriter, next, theIncludedResource);
            theWriter.writeEndElement();
        }
    }

    private void encodeXhtml(XhtmlDt theDt, XMLStreamWriter theEventWriter) throws XMLStreamException {
        if (theDt == null || theDt.getValue() == null) {
            return;
        }
        boolean firstElement = true;
        block10: for (XMLEvent event : (List)theDt.getValue()) {
            switch (event.getEventType()) {
                case 10: {
                    Attribute attr = (Attribute)event;
                    if (StringUtils.isBlank((CharSequence)attr.getName().getPrefix())) {
                        if (StringUtils.isBlank((CharSequence)attr.getName().getNamespaceURI())) {
                            theEventWriter.writeAttribute(attr.getName().getLocalPart(), attr.getValue());
                            break;
                        }
                        theEventWriter.writeAttribute(attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                        break;
                    }
                    theEventWriter.writeAttribute(attr.getName().getPrefix(), attr.getName().getNamespaceURI(), attr.getName().getLocalPart(), attr.getValue());
                    break;
                }
                case 12: {
                    theEventWriter.writeCData(((Characters)event).getData());
                    break;
                }
                case 4: 
                case 6: {
                    String data = ((Characters)event).getData();
                    theEventWriter.writeCharacters(data);
                    break;
                }
                case 5: {
                    theEventWriter.writeComment(((Comment)event).getText());
                    break;
                }
                case 2: {
                    theEventWriter.writeEndElement();
                    break;
                }
                case 9: {
                    EntityReference er = (EntityReference)event;
                    theEventWriter.writeEntityRef(er.getName());
                    break;
                }
                case 13: {
                    Namespace ns = (Namespace)event;
                    theEventWriter.writeNamespace(ns.getPrefix(), ns.getNamespaceURI());
                    break;
                }
                case 1: {
                    StartElement se = event.asStartElement();
                    if (firstElement) {
                        if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                            String namespaceURI = se.getName().getNamespaceURI();
                            if (StringUtils.isBlank((CharSequence)namespaceURI)) {
                                namespaceURI = XHTML_NS;
                            }
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                            theEventWriter.writeDefaultNamespace(namespaceURI);
                        } else {
                            String prefix = se.getName().getPrefix();
                            String namespaceURI = se.getName().getNamespaceURI();
                            theEventWriter.writeStartElement(prefix, se.getName().getLocalPart(), namespaceURI);
                            theEventWriter.writeNamespace(prefix, namespaceURI);
                        }
                        firstElement = false;
                        break;
                    }
                    if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                        if (StringUtils.isBlank((CharSequence)se.getName().getNamespaceURI())) {
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                        } else if (StringUtils.isBlank((CharSequence)se.getName().getPrefix())) {
                            theEventWriter.writeStartElement(se.getName().getLocalPart());
                        } else {
                            theEventWriter.writeStartElement(se.getName().getNamespaceURI(), se.getName().getLocalPart());
                        }
                    } else {
                        theEventWriter.writeStartElement(se.getName().getPrefix(), se.getName().getLocalPart(), se.getName().getNamespaceURI());
                    }
                    Iterator<Attribute> attrIter = se.getAttributes();
                    while (attrIter.hasNext()) {
                        Attribute next = attrIter.next();
                        theEventWriter.writeAttribute(next.getName().getLocalPart(), next.getValue());
                    }
                    continue block10;
                }
            }
        }
    }

    @Override
    public EncodingEnum getEncoding() {
        return EncodingEnum.XML;
    }

    @Override
    public <T extends IBaseResource> Bundle parseBundle(Class<T> theResourceType, Reader theReader) {
        XMLEventReader streamReader = this.createStreamReader(theReader);
        return this.parseBundle(streamReader, theResourceType);
    }

    private Bundle parseBundle(XMLEventReader theStreamReader, Class<? extends IBaseResource> theResourceType) {
        ParserState<Bundle> parserState = ParserState.getPreAtomInstance(this.myContext, theResourceType, false, this.getErrorHandler());
        return this.doXmlLoop(theStreamReader, parserState);
    }

    private <T extends IBaseResource> T parseResource(Class<T> theResourceType, XMLEventReader theStreamReader) {
        ParserState<T> parserState = ParserState.getPreResourceInstance(theResourceType, this.myContext, false, this.getErrorHandler());
        return (T)((IBaseResource)this.doXmlLoop(theStreamReader, parserState));
    }

    @Override
    public TagList parseTagList(Reader theReader) {
        XMLEventReader streamReader = this.createStreamReader(theReader);
        ParserState<TagList> parserState = ParserState.getPreTagListInstance(this.myContext, false, this.getErrorHandler());
        return this.doXmlLoop(streamReader, parserState);
    }

    @Override
    public IParser setPrettyPrint(boolean thePrettyPrint) {
        this.myPrettyPrint = thePrettyPrint;
        return this;
    }

    private <Q extends IBaseExtension<?, ?>> List<IBaseExtension<?, ?>> toBaseExtensionList(List<Q> theList) {
        ArrayList retVal = new ArrayList(theList.size());
        retVal.addAll(theList);
        return retVal;
    }

    private void writeAtomLink(XMLStreamWriter theEventWriter, String theRel, StringDt theStringDt) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theStringDt.getValue()))) {
            theEventWriter.writeStartElement("link");
            theEventWriter.writeAttribute("rel", theRel);
            theEventWriter.writeAttribute("href", (String)theStringDt.getValue());
            theEventWriter.writeEndElement();
        }
    }

    private void writeBundleResourceLink(XMLStreamWriter theEventWriter, String theRel, StringDt theUrl) throws XMLStreamException {
        if (!theUrl.isEmpty()) {
            theEventWriter.writeStartElement("link");
            theEventWriter.writeStartElement("relation");
            theEventWriter.writeAttribute("value", theRel);
            theEventWriter.writeEndElement();
            theEventWriter.writeStartElement("url");
            theEventWriter.writeAttribute("value", (String)theUrl.getValue());
            theEventWriter.writeEndElement();
            theEventWriter.writeEndElement();
        }
    }

    private void writeCategories(XMLStreamWriter eventWriter, TagList categories) throws XMLStreamException {
        if (categories != null) {
            for (Tag next : categories) {
                eventWriter.writeStartElement("category");
                eventWriter.writeAttribute("term", StringUtils.defaultString((String)next.getTerm()));
                eventWriter.writeAttribute("label", StringUtils.defaultString((String)next.getLabel()));
                eventWriter.writeAttribute("scheme", StringUtils.defaultString((String)next.getScheme()));
                eventWriter.writeEndElement();
            }
        }
    }

    private void writeOptionalAttribute(XMLStreamWriter theEventWriter, String theName, String theValue) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            theEventWriter.writeAttribute(theName, theValue);
        }
    }

    private void writeOptionalTagWithTextNode(XMLStreamWriter theEventWriter, String theTagName, InstantDt theInstantDt) throws XMLStreamException {
        if (theInstantDt.getValue() != null) {
            theEventWriter.writeStartElement(theTagName);
            theEventWriter.writeCharacters(theInstantDt.getValueAsString());
            theEventWriter.writeEndElement();
        }
    }

    private void writeOptionalTagWithTextNode(XMLStreamWriter theEventWriter, String theElementName, StringDt theTextValue) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theTextValue.getValue()))) {
            theEventWriter.writeStartElement(theElementName);
            theEventWriter.writeCharacters((String)theTextValue.getValue());
            theEventWriter.writeEndElement();
        }
    }

    private void writeOptionalTagWithValue(XMLStreamWriter theEventWriter, String theName, String theValue) throws XMLStreamException {
        if (StringUtils.isNotBlank((CharSequence)theValue)) {
            theEventWriter.writeStartElement(theName);
            theEventWriter.writeAttribute("value", theValue);
            theEventWriter.writeEndElement();
        }
    }

    private void writeTagWithTextNode(XMLStreamWriter theEventWriter, String theElementName, IdDt theIdDt) throws XMLStreamException {
        theEventWriter.writeStartElement(theElementName);
        if (StringUtils.isNotBlank((CharSequence)theIdDt.getValue())) {
            theEventWriter.writeCharacters(theIdDt.getValue());
        }
        theEventWriter.writeEndElement();
    }

    private void writeTagWithTextNode(XMLStreamWriter theEventWriter, String theElementName, StringDt theStringDt) throws XMLStreamException {
        theEventWriter.writeStartElement(theElementName);
        if (StringUtils.isNotBlank((CharSequence)((CharSequence)theStringDt.getValue()))) {
            theEventWriter.writeCharacters((String)theStringDt.getValue());
        }
        theEventWriter.writeEndElement();
    }
}

